/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_aui.h"

        #include <wx/aui/auibar.h>

        #include <wx/gdicmn.h>
        #include <wx/bitmap.h>
        #include <wx/sizer.h>
        #include <wx/window.h>


PyDoc_STRVAR(doc_wxAuiToolBarItem_Assign, "Assign(c)\n"
"\n"
"Assigns the properties of the wxAuiToolBarItem \"c\" to this.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_Assign(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_Assign(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem* c;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxAuiToolBarItem, &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Assign(*c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_Assign, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetWindow, "SetWindow(w)\n"
"\n"
"Assigns a window to the toolbar item.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* w;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_w,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxWindow, &w))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWindow(w);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetWindow, "GetWindow() -> wx.Window\n"
"\n"
"Returns the wxWindow* associated to the toolbar item.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetWindow(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetId, "SetId(new_id)\n"
"\n"
"Sets the toolbar item identifier.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int new_id;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_new_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &new_id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetId(new_id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetId, "GetId() -> int\n"
"\n"
"Returns the toolbar item identifier.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetId(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetKind, "SetKind(new_kind)\n"
"\n"
"Sets the wxAuiToolBarItem kind.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetKind(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetKind(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int new_kind;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_new_kind,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &new_kind))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetKind(new_kind);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetKind, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetKind, "GetKind() -> int\n"
"\n"
"Returns the toolbar item kind.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetKind(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetKind(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetKind();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetKind, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetState, "SetState(new_state)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int new_state;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_new_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &new_state))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetState(new_state);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetState, "GetState() -> int");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetState(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetState();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetSizerItem, "SetSizerItem(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetSizerItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetSizerItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerItem* s;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxSizerItem, &s))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSizerItem(s);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetSizerItem, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetSizerItem, "GetSizerItem() -> wx.SizerItem");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetSizerItem(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetSizerItem(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxSizerItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSizerItem();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerItem,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetSizerItem, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetLabel, "SetLabel(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* s;
        int sState = 0;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxString,&s, &sState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLabel(*s);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(s),sipType_wxString,sState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetLabel, "GetLabel() -> String");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetLabel(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetBitmap, "SetBitmap(bmp)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bmp;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBitmap(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetBitmap, "GetBitmap() -> wx.Bitmap");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetDisabledBitmap, "SetDisabledBitmap(bmp)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetDisabledBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bmp;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDisabledBitmap(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetDisabledBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetDisabledBitmap, "GetDisabledBitmap() -> wx.Bitmap");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetDisabledBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetDisabledBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetDisabledBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetHoverBitmap, "SetHoverBitmap(bmp)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetHoverBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetHoverBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bmp;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHoverBitmap(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetHoverBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetHoverBitmap, "GetHoverBitmap() -> wx.Bitmap");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetHoverBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetHoverBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetHoverBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetHoverBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetShortHelp, "SetShortHelp(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetShortHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetShortHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* s;
        int sState = 0;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxString,&s, &sState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShortHelp(*s);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(s),sipType_wxString,sState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetShortHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetShortHelp, "GetShortHelp() -> String");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetShortHelp(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetShortHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetShortHelp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetShortHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetLongHelp, "SetLongHelp(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetLongHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetLongHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* s;
        int sState = 0;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxString,&s, &sState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLongHelp(*s);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(s),sipType_wxString,sState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetLongHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetLongHelp, "GetLongHelp() -> String");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetLongHelp(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetLongHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLongHelp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetLongHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetMinSize, "SetMinSize(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetMinSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetMinSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* s;
        int sState = 0;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, sipType_wxSize, &s, &sState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMinSize(*s);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(s),sipType_wxSize,sState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetMinSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetMinSize, "GetMinSize() -> wx.Size");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetMinSize(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetMinSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetMinSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetMinSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetSpacerPixels, "SetSpacerPixels(s)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetSpacerPixels(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetSpacerPixels(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int s;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &s))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSpacerPixels(s);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetSpacerPixels, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetSpacerPixels, "GetSpacerPixels() -> int");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetSpacerPixels(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetSpacerPixels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSpacerPixels();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetSpacerPixels, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetProportion, "SetProportion(p)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetProportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetProportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int p;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &p))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProportion(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetProportion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetProportion, "GetProportion() -> int");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetProportion(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetProportion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProportion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetProportion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetActive, "SetActive(b)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetActive(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetActive(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool b;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetActive(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_IsActive, "IsActive() -> bool");

extern "C" {static PyObject *meth_wxAuiToolBarItem_IsActive(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_IsActive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsActive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_IsActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetHasDropDown, "SetHasDropDown(b)\n"
"\n"
"Set whether this tool has a drop down button.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetHasDropDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetHasDropDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool b;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHasDropDown(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetHasDropDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_HasDropDown, "HasDropDown() -> bool\n"
"\n"
"Returns whether the toolbar item has an associated drop down button.");

extern "C" {static PyObject *meth_wxAuiToolBarItem_HasDropDown(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_HasDropDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDropDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_HasDropDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetSticky, "SetSticky(b)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetSticky(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetSticky(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool b;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSticky(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetSticky, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_IsSticky, "IsSticky() -> bool");

extern "C" {static PyObject *meth_wxAuiToolBarItem_IsSticky(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_IsSticky(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSticky();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_IsSticky, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetUserData, "SetUserData(l)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetUserData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetUserData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long l;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_l,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &l))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUserData(l);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetUserData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetUserData, "GetUserData() -> long");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetUserData(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetUserData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUserData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetUserData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_SetAlignment, "SetAlignment(l)");

extern "C" {static PyObject *meth_wxAuiToolBarItem_SetAlignment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_SetAlignment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int l;
         ::wxAuiToolBarItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_l,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp, &l))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAlignment(l);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_SetAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAuiToolBarItem_GetAlignment, "GetAlignment() -> int");

extern "C" {static PyObject *meth_wxAuiToolBarItem_GetAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxAuiToolBarItem_GetAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAuiToolBarItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiToolBarItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AuiToolBarItem, sipName_GetAlignment, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAuiToolBarItem(void *, int);}
static void release_wxAuiToolBarItem(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAuiToolBarItem *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxAuiToolBarItem(void *, SIP_SSIZE_T, void *);}
static void assign_wxAuiToolBarItem(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAuiToolBarItem *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAuiToolBarItem *>(sipSrc);
}


extern "C" {static void *array_wxAuiToolBarItem(SIP_SSIZE_T);}
static void *array_wxAuiToolBarItem(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxAuiToolBarItem[sipNrElem];
}


extern "C" {static void *copy_wxAuiToolBarItem(const void *, SIP_SSIZE_T);}
static void *copy_wxAuiToolBarItem(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAuiToolBarItem(reinterpret_cast<const  ::wxAuiToolBarItem *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAuiToolBarItem(sipSimpleWrapper *);}
static void dealloc_wxAuiToolBarItem(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAuiToolBarItem(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAuiToolBarItem(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAuiToolBarItem(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAuiToolBarItem *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAuiToolBarItem();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxAuiToolBarItem* c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxAuiToolBarItem, &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAuiToolBarItem(*c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxAuiToolBarItem[] = {
    {SIP_MLNAME_CAST(sipName_Assign), (PyCFunction)meth_wxAuiToolBarItem_Assign, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_Assign)},
    {SIP_MLNAME_CAST(sipName_GetAlignment), meth_wxAuiToolBarItem_GetAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetAlignment)},
    {SIP_MLNAME_CAST(sipName_GetBitmap), meth_wxAuiToolBarItem_GetBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetBitmap)},
    {SIP_MLNAME_CAST(sipName_GetDisabledBitmap), meth_wxAuiToolBarItem_GetDisabledBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetDisabledBitmap)},
    {SIP_MLNAME_CAST(sipName_GetHoverBitmap), meth_wxAuiToolBarItem_GetHoverBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetHoverBitmap)},
    {SIP_MLNAME_CAST(sipName_GetId), meth_wxAuiToolBarItem_GetId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetId)},
    {SIP_MLNAME_CAST(sipName_GetKind), meth_wxAuiToolBarItem_GetKind, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetKind)},
    {SIP_MLNAME_CAST(sipName_GetLabel), meth_wxAuiToolBarItem_GetLabel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetLabel)},
    {SIP_MLNAME_CAST(sipName_GetLongHelp), meth_wxAuiToolBarItem_GetLongHelp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetLongHelp)},
    {SIP_MLNAME_CAST(sipName_GetMinSize), meth_wxAuiToolBarItem_GetMinSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetMinSize)},
    {SIP_MLNAME_CAST(sipName_GetProportion), meth_wxAuiToolBarItem_GetProportion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetProportion)},
    {SIP_MLNAME_CAST(sipName_GetShortHelp), meth_wxAuiToolBarItem_GetShortHelp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetShortHelp)},
    {SIP_MLNAME_CAST(sipName_GetSizerItem), meth_wxAuiToolBarItem_GetSizerItem, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetSizerItem)},
    {SIP_MLNAME_CAST(sipName_GetSpacerPixels), meth_wxAuiToolBarItem_GetSpacerPixels, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetSpacerPixels)},
    {SIP_MLNAME_CAST(sipName_GetState), meth_wxAuiToolBarItem_GetState, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetState)},
    {SIP_MLNAME_CAST(sipName_GetUserData), meth_wxAuiToolBarItem_GetUserData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetUserData)},
    {SIP_MLNAME_CAST(sipName_GetWindow), meth_wxAuiToolBarItem_GetWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_GetWindow)},
    {SIP_MLNAME_CAST(sipName_HasDropDown), meth_wxAuiToolBarItem_HasDropDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_HasDropDown)},
    {SIP_MLNAME_CAST(sipName_IsActive), meth_wxAuiToolBarItem_IsActive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_IsActive)},
    {SIP_MLNAME_CAST(sipName_IsSticky), meth_wxAuiToolBarItem_IsSticky, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_IsSticky)},
    {SIP_MLNAME_CAST(sipName_SetActive), (PyCFunction)meth_wxAuiToolBarItem_SetActive, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetActive)},
    {SIP_MLNAME_CAST(sipName_SetAlignment), (PyCFunction)meth_wxAuiToolBarItem_SetAlignment, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetAlignment)},
    {SIP_MLNAME_CAST(sipName_SetBitmap), (PyCFunction)meth_wxAuiToolBarItem_SetBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetBitmap)},
    {SIP_MLNAME_CAST(sipName_SetDisabledBitmap), (PyCFunction)meth_wxAuiToolBarItem_SetDisabledBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetDisabledBitmap)},
    {SIP_MLNAME_CAST(sipName_SetHasDropDown), (PyCFunction)meth_wxAuiToolBarItem_SetHasDropDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetHasDropDown)},
    {SIP_MLNAME_CAST(sipName_SetHoverBitmap), (PyCFunction)meth_wxAuiToolBarItem_SetHoverBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetHoverBitmap)},
    {SIP_MLNAME_CAST(sipName_SetId), (PyCFunction)meth_wxAuiToolBarItem_SetId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetId)},
    {SIP_MLNAME_CAST(sipName_SetKind), (PyCFunction)meth_wxAuiToolBarItem_SetKind, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetKind)},
    {SIP_MLNAME_CAST(sipName_SetLabel), (PyCFunction)meth_wxAuiToolBarItem_SetLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetLabel)},
    {SIP_MLNAME_CAST(sipName_SetLongHelp), (PyCFunction)meth_wxAuiToolBarItem_SetLongHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetLongHelp)},
    {SIP_MLNAME_CAST(sipName_SetMinSize), (PyCFunction)meth_wxAuiToolBarItem_SetMinSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetMinSize)},
    {SIP_MLNAME_CAST(sipName_SetProportion), (PyCFunction)meth_wxAuiToolBarItem_SetProportion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetProportion)},
    {SIP_MLNAME_CAST(sipName_SetShortHelp), (PyCFunction)meth_wxAuiToolBarItem_SetShortHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetShortHelp)},
    {SIP_MLNAME_CAST(sipName_SetSizerItem), (PyCFunction)meth_wxAuiToolBarItem_SetSizerItem, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetSizerItem)},
    {SIP_MLNAME_CAST(sipName_SetSpacerPixels), (PyCFunction)meth_wxAuiToolBarItem_SetSpacerPixels, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetSpacerPixels)},
    {SIP_MLNAME_CAST(sipName_SetState), (PyCFunction)meth_wxAuiToolBarItem_SetState, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetState)},
    {SIP_MLNAME_CAST(sipName_SetSticky), (PyCFunction)meth_wxAuiToolBarItem_SetSticky, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetSticky)},
    {SIP_MLNAME_CAST(sipName_SetUserData), (PyCFunction)meth_wxAuiToolBarItem_SetUserData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetUserData)},
    {SIP_MLNAME_CAST(sipName_SetWindow), (PyCFunction)meth_wxAuiToolBarItem_SetWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiToolBarItem_SetWindow)}
};

sipVariableDef variables_wxAuiToolBarItem[] = {
    {PropertyVariable, sipName_Window, &methods_wxAuiToolBarItem[16], &methods_wxAuiToolBarItem[38], NULL, NULL},
    {PropertyVariable, sipName_UserData, &methods_wxAuiToolBarItem[15], &methods_wxAuiToolBarItem[37], NULL, NULL},
    {PropertyVariable, sipName_State, &methods_wxAuiToolBarItem[14], &methods_wxAuiToolBarItem[35], NULL, NULL},
    {PropertyVariable, sipName_SpacerPixels, &methods_wxAuiToolBarItem[13], &methods_wxAuiToolBarItem[34], NULL, NULL},
    {PropertyVariable, sipName_SizerItem, &methods_wxAuiToolBarItem[12], &methods_wxAuiToolBarItem[33], NULL, NULL},
    {PropertyVariable, sipName_ShortHelp, &methods_wxAuiToolBarItem[11], &methods_wxAuiToolBarItem[32], NULL, NULL},
    {PropertyVariable, sipName_Proportion, &methods_wxAuiToolBarItem[10], &methods_wxAuiToolBarItem[31], NULL, NULL},
    {PropertyVariable, sipName_MinSize, &methods_wxAuiToolBarItem[9], &methods_wxAuiToolBarItem[30], NULL, NULL},
    {PropertyVariable, sipName_LongHelp, &methods_wxAuiToolBarItem[8], &methods_wxAuiToolBarItem[29], NULL, NULL},
    {PropertyVariable, sipName_Label, &methods_wxAuiToolBarItem[7], &methods_wxAuiToolBarItem[28], NULL, NULL},
    {PropertyVariable, sipName_Kind, &methods_wxAuiToolBarItem[6], &methods_wxAuiToolBarItem[27], NULL, NULL},
    {PropertyVariable, sipName_Id, &methods_wxAuiToolBarItem[5], &methods_wxAuiToolBarItem[26], NULL, NULL},
    {PropertyVariable, sipName_HoverBitmap, &methods_wxAuiToolBarItem[4], &methods_wxAuiToolBarItem[25], NULL, NULL},
    {PropertyVariable, sipName_DisabledBitmap, &methods_wxAuiToolBarItem[3], &methods_wxAuiToolBarItem[23], NULL, NULL},
    {PropertyVariable, sipName_Bitmap, &methods_wxAuiToolBarItem[2], &methods_wxAuiToolBarItem[22], NULL, NULL},
    {PropertyVariable, sipName_Alignment, &methods_wxAuiToolBarItem[1], &methods_wxAuiToolBarItem[21], NULL, NULL},
};

PyDoc_STRVAR(doc_wxAuiToolBarItem, "AuiToolBarItem()\n"
"AuiToolBarItem(c)\n"
"\n"
"wxAuiToolBarItem is part of the wxAUI class framework, representing a\n"
"toolbar element.");


sipClassTypeDef sipTypeDef__aui_wxAuiToolBarItem = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxAuiToolBarItem,
        {0},
        0
    },
    {
        sipNameNr_AuiToolBarItem,
        {0, 0, 1},
        39, methods_wxAuiToolBarItem,
        0, 0,
        16, variables_wxAuiToolBarItem,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxAuiToolBarItem,
    -1,
    -1,
    0,
    0,
    init_type_wxAuiToolBarItem,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxAuiToolBarItem,
    assign_wxAuiToolBarItem,
    array_wxAuiToolBarItem,
    copy_wxAuiToolBarItem,
    release_wxAuiToolBarItem,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
