/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/cmdproc.h>

        #include <wx/cmdproc.h>
        #include <wx/menu.h>
        typedef wxList wxCommandList;
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxCommandProcessor : public  ::wxCommandProcessor
{
public:
    sipwxCommandProcessor(int);
    virtual ~sipwxCommandProcessor();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool Undo();
    void Store( ::wxCommand*);
    bool Submit( ::wxCommand*,bool);
    void SetMenuStrings();
    bool Redo();
    bool IsDirty() const;
    void Initialize();
    void ClearCommands();
    bool CanRedo() const;
    bool CanUndo() const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxCommandProcessor(const sipwxCommandProcessor &);
    sipwxCommandProcessor &operator = (const sipwxCommandProcessor &);

    char sipPyMethods[10];
};

sipwxCommandProcessor::sipwxCommandProcessor(int maxCommands):  ::wxCommandProcessor(maxCommands), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCommandProcessor::~sipwxCommandProcessor()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxCommandProcessor::Undo()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_Undo);

    if (!sipMeth)
        return  ::wxCommandProcessor::Undo();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::Store( ::wxCommand*command)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_Store);

    if (!sipMeth)
    {
         ::wxCommandProcessor::Store(command);
        return;
    }

    extern void sipVH__core_215(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxCommand*);

    sipVH__core_215(sipGILState, 0, sipPySelf, sipMeth, command);
}

bool sipwxCommandProcessor::Submit( ::wxCommand*command,bool storeIt)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_Submit);

    if (!sipMeth)
        return  ::wxCommandProcessor::Submit(command,storeIt);

    extern bool sipVH__core_214(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxCommand*,bool);

    return sipVH__core_214(sipGILState, 0, sipPySelf, sipMeth, command, storeIt);
}

void sipwxCommandProcessor::SetMenuStrings()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_SetMenuStrings);

    if (!sipMeth)
    {
         ::wxCommandProcessor::SetMenuStrings();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::Redo()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_Redo);

    if (!sipMeth)
        return  ::wxCommandProcessor::Redo();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::IsDirty() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[5]),sipPySelf,NULL,sipName_IsDirty);

    if (!sipMeth)
        return  ::wxCommandProcessor::IsDirty();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::Initialize()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_Initialize);

    if (!sipMeth)
    {
         ::wxCommandProcessor::Initialize();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::ClearCommands()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_ClearCommands);

    if (!sipMeth)
    {
         ::wxCommandProcessor::ClearCommands();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::CanRedo() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[8]),sipPySelf,NULL,sipName_CanRedo);

    if (!sipMeth)
        return  ::wxCommandProcessor::CanRedo();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::CanUndo() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[9]),sipPySelf,NULL,sipName_CanUndo);

    if (!sipMeth)
        return  ::wxCommandProcessor::CanUndo();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxCommandProcessor_CanUndo, "CanUndo() -> bool\n"
"\n"
"Returns true if the currently-active command can be undone, false\n"
"otherwise.");

extern "C" {static PyObject *meth_wxCommandProcessor_CanUndo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_CanUndo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::CanUndo() : sipCpp->CanUndo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_CanUndo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_CanRedo, "CanRedo() -> bool\n"
"\n"
"Returns true if the currently-active command can be redone, false\n"
"otherwise.");

extern "C" {static PyObject *meth_wxCommandProcessor_CanRedo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_CanRedo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::CanRedo() : sipCpp->CanRedo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_CanRedo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_ClearCommands, "ClearCommands()\n"
"\n"
"Deletes all commands in the list and sets the current command pointer\n"
"to NULL.");

extern "C" {static PyObject *meth_wxCommandProcessor_ClearCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_ClearCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::ClearCommands() : sipCpp->ClearCommands());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_ClearCommands, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetCommands, "GetCommands() -> CommandList\n"
"\n"
"Returns the list of commands.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxCommandList*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetCommands();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxCommandList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetCommands, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetCurrentCommand, "GetCurrentCommand() -> Command\n"
"\n"
"Returns the current command.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetCurrentCommand(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetCurrentCommand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxCommand*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCurrentCommand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxCommand,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetCurrentCommand, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetEditMenu, "GetEditMenu() -> Menu\n"
"\n"
"Returns the edit menu associated with the command processor.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetEditMenu(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetEditMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEditMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetEditMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetMaxCommands, "GetMaxCommands() -> int\n"
"\n"
"Returns the maximum number of commands that the command processor\n"
"stores.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetMaxCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetMaxCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaxCommands();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetMaxCommands, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetRedoAccelerator, "GetRedoAccelerator() -> String\n"
"\n"
"Returns the string that will be appended to the Redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetRedoAccelerator(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetRedoAccelerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRedoAccelerator());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetRedoAccelerator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetRedoMenuLabel, "GetRedoMenuLabel() -> String\n"
"\n"
"Returns the string that will be shown for the redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetRedoMenuLabel(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetRedoMenuLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRedoMenuLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetRedoMenuLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetUndoAccelerator, "GetUndoAccelerator() -> String\n"
"\n"
"Returns the string that will be appended to the Undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetUndoAccelerator(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetUndoAccelerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetUndoAccelerator());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetUndoAccelerator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetUndoMenuLabel, "GetUndoMenuLabel() -> String\n"
"\n"
"Returns the string that will be shown for the undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetUndoMenuLabel(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetUndoMenuLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetUndoMenuLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetUndoMenuLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Initialize, "Initialize()\n"
"\n"
"Initializes the command processor, setting the current command to the\n"
"last in the list (if any), and updating the edit menu (if one has been\n"
"specified).");

extern "C" {static PyObject *meth_wxCommandProcessor_Initialize(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Initialize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Initialize() : sipCpp->Initialize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Initialize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_IsDirty, "IsDirty() -> bool\n"
"\n"
"Returns a boolean value that indicates if changes have been made since\n"
"the last save operation.");

extern "C" {static PyObject *meth_wxCommandProcessor_IsDirty(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_IsDirty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::IsDirty() : sipCpp->IsDirty());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_IsDirty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_MarkAsSaved, "MarkAsSaved()\n"
"\n"
"You must call this method whenever the project is saved if you plan to\n"
"use IsDirty().");

extern "C" {static PyObject *meth_wxCommandProcessor_MarkAsSaved(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_MarkAsSaved(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MarkAsSaved();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_MarkAsSaved, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Redo, "Redo() -> bool\n"
"\n"
"Executes (redoes) the current command (the command that has just been\n"
"undone if any).");

extern "C" {static PyObject *meth_wxCommandProcessor_Redo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Redo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Redo() : sipCpp->Redo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Redo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetEditMenu, "SetEditMenu(menu)\n"
"\n"
"Tells the command processor to update the Undo and Redo items on this\n"
"menu as appropriate.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetEditMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetEditMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMenu* menu;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEditMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetEditMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetMenuStrings, "SetMenuStrings()\n"
"\n"
"Sets the menu labels according to the currently set menu and the\n"
"current command state.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetMenuStrings(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetMenuStrings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::SetMenuStrings() : sipCpp->SetMenuStrings());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetMenuStrings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetRedoAccelerator, "SetRedoAccelerator(accel)\n"
"\n"
"Sets the string that will be appended to the Redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetRedoAccelerator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetRedoAccelerator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* accel;
        int accelState = 0;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxString,&accel, &accelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRedoAccelerator(*accel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(accel),sipType_wxString,accelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetRedoAccelerator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetUndoAccelerator, "SetUndoAccelerator(accel)\n"
"\n"
"Sets the string that will be appended to the Undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetUndoAccelerator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetUndoAccelerator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* accel;
        int accelState = 0;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxString,&accel, &accelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUndoAccelerator(*accel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(accel),sipType_wxString,accelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetUndoAccelerator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Submit, "Submit(command, storeIt=True) -> bool\n"
"\n"
"Submits a new command to the command processor.");

extern "C" {static PyObject *meth_wxCommandProcessor_Submit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Submit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommand* command;
        bool storeIt = 1;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
            sipName_storeIt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:|b", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxCommand, &command, &storeIt))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Submit(command,storeIt) : sipCpp->Submit(command,storeIt));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Submit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Store, "Store(command)\n"
"\n"
"Just store the command without executing it.");

extern "C" {static PyObject *meth_wxCommandProcessor_Store(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Store(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommand* command;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxCommand, &command))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Store(command) : sipCpp->Store(command));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Store, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Undo, "Undo() -> bool\n"
"\n"
"Undoes the last command executed.");

extern "C" {static PyObject *meth_wxCommandProcessor_Undo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Undo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Undo() : sipCpp->Undo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Undo, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxCommandProcessor(void *, const sipTypeDef *);}
static void *cast_wxCommandProcessor(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxCommandProcessor *sipCpp = reinterpret_cast< ::wxCommandProcessor *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxCommandProcessor(void *, int);}
static void release_wxCommandProcessor(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxCommandProcessor *>(sipCppV);
    else
        delete reinterpret_cast< ::wxCommandProcessor *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxCommandProcessor(sipSimpleWrapper *);}
static void dealloc_wxCommandProcessor(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxCommandProcessor *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxCommandProcessor(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxCommandProcessor(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxCommandProcessor(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxCommandProcessor *sipCpp = 0;

    {
        int maxCommands = -1;

        static const char *sipKwdList[] = {
            sipName_maxCommands,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &maxCommands))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCommandProcessor(maxCommands);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxCommandProcessor[] = {{352, 255, 1}};


static PyMethodDef methods_wxCommandProcessor[] = {
    {SIP_MLNAME_CAST(sipName_CanRedo), meth_wxCommandProcessor_CanRedo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_CanRedo)},
    {SIP_MLNAME_CAST(sipName_CanUndo), meth_wxCommandProcessor_CanUndo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_CanUndo)},
    {SIP_MLNAME_CAST(sipName_ClearCommands), meth_wxCommandProcessor_ClearCommands, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_ClearCommands)},
    {SIP_MLNAME_CAST(sipName_GetCommands), meth_wxCommandProcessor_GetCommands, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetCommands)},
    {SIP_MLNAME_CAST(sipName_GetCurrentCommand), meth_wxCommandProcessor_GetCurrentCommand, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetCurrentCommand)},
    {SIP_MLNAME_CAST(sipName_GetEditMenu), meth_wxCommandProcessor_GetEditMenu, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetEditMenu)},
    {SIP_MLNAME_CAST(sipName_GetMaxCommands), meth_wxCommandProcessor_GetMaxCommands, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetMaxCommands)},
    {SIP_MLNAME_CAST(sipName_GetRedoAccelerator), meth_wxCommandProcessor_GetRedoAccelerator, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetRedoAccelerator)},
    {SIP_MLNAME_CAST(sipName_GetRedoMenuLabel), meth_wxCommandProcessor_GetRedoMenuLabel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetRedoMenuLabel)},
    {SIP_MLNAME_CAST(sipName_GetUndoAccelerator), meth_wxCommandProcessor_GetUndoAccelerator, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetUndoAccelerator)},
    {SIP_MLNAME_CAST(sipName_GetUndoMenuLabel), meth_wxCommandProcessor_GetUndoMenuLabel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_GetUndoMenuLabel)},
    {SIP_MLNAME_CAST(sipName_Initialize), meth_wxCommandProcessor_Initialize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_Initialize)},
    {SIP_MLNAME_CAST(sipName_IsDirty), meth_wxCommandProcessor_IsDirty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_IsDirty)},
    {SIP_MLNAME_CAST(sipName_MarkAsSaved), meth_wxCommandProcessor_MarkAsSaved, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_MarkAsSaved)},
    {SIP_MLNAME_CAST(sipName_Redo), meth_wxCommandProcessor_Redo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_Redo)},
    {SIP_MLNAME_CAST(sipName_SetEditMenu), (PyCFunction)meth_wxCommandProcessor_SetEditMenu, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxCommandProcessor_SetEditMenu)},
    {SIP_MLNAME_CAST(sipName_SetMenuStrings), meth_wxCommandProcessor_SetMenuStrings, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_SetMenuStrings)},
    {SIP_MLNAME_CAST(sipName_SetRedoAccelerator), (PyCFunction)meth_wxCommandProcessor_SetRedoAccelerator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxCommandProcessor_SetRedoAccelerator)},
    {SIP_MLNAME_CAST(sipName_SetUndoAccelerator), (PyCFunction)meth_wxCommandProcessor_SetUndoAccelerator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxCommandProcessor_SetUndoAccelerator)},
    {SIP_MLNAME_CAST(sipName_Store), (PyCFunction)meth_wxCommandProcessor_Store, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxCommandProcessor_Store)},
    {SIP_MLNAME_CAST(sipName_Submit), (PyCFunction)meth_wxCommandProcessor_Submit, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxCommandProcessor_Submit)},
    {SIP_MLNAME_CAST(sipName_Undo), meth_wxCommandProcessor_Undo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxCommandProcessor_Undo)}
};

sipVariableDef variables_wxCommandProcessor[] = {
    {PropertyVariable, sipName_UndoMenuLabel, &methods_wxCommandProcessor[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_UndoAccelerator, &methods_wxCommandProcessor[9], &methods_wxCommandProcessor[18], NULL, NULL},
    {PropertyVariable, sipName_RedoMenuLabel, &methods_wxCommandProcessor[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_RedoAccelerator, &methods_wxCommandProcessor[7], &methods_wxCommandProcessor[17], NULL, NULL},
    {PropertyVariable, sipName_MaxCommands, &methods_wxCommandProcessor[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_EditMenu, &methods_wxCommandProcessor[5], &methods_wxCommandProcessor[15], NULL, NULL},
    {PropertyVariable, sipName_CurrentCommand, &methods_wxCommandProcessor[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_Commands, &methods_wxCommandProcessor[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxCommandProcessor, "CommandProcessor(maxCommands=-1)\n"
"\n"
"wxCommandProcessor is a class that maintains a history of wxCommands,\n"
"with undo/redo functionality built-in.");


sipClassTypeDef sipTypeDef__core_wxCommandProcessor = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxCommandProcessor,
        {0},
        0
    },
    {
        sipNameNr_CommandProcessor,
        {0, 0, 1},
        22, methods_wxCommandProcessor,
        0, 0,
        8, variables_wxCommandProcessor,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxCommandProcessor,
    -1,
    -1,
    supers_wxCommandProcessor,
    0,
    init_type_wxCommandProcessor,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxCommandProcessor,
    0,
    0,
    0,
    release_wxCommandProcessor,
    cast_wxCommandProcessor,
    0,
    0,
    0,
    0,
    0,
    0
};
