/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/dc.h>

    #include <wx/setup.h>
    #include <wxpy_api.h>
        #include <wx/gdicmn.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/palette.h>
        #include <wx/colour.h>
        #include <wx/gdicmn.h>
        #include <wx/affinematrix2d.h>
        #include <wx/pen.h>
        #include "arrayholder.h"
        #include <wx/brush.h>
        #include <wx/font.h>
        #include <wx/dc.h>
        #include <wx/region.h>
        
        #include <wx/icon.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        //--------------------------------------------------------------------------
        // Name:        src/dc_ex.h
        // Purpose:     Functions that can quickly draw lists of items on a DC
        //
        // Author:      Robin Dunn
        //
        // Created:     18-Aug-2012
        // Copyright:   (c) 2012-2018 by Total Control Software
        // Licence:     wxWindows license
        //--------------------------------------------------------------------------
        
        
        typedef bool (*wxPyDrawListOp_t)(wxDC& dc, PyObject* coords);
        
        PyObject* wxPyDrawXXXList(wxDC& dc, wxPyDrawListOp_t doDraw,
                                  PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes);
        
        bool wxPyDrawXXXPoint(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXLine(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXRectangle(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXEllipse(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXPolygon(wxDC& dc, PyObject* coords);
        
        PyObject* wxPyDrawTextList(wxDC& dc, PyObject* textList, PyObject* pyPoints,
                                   PyObject* foregroundList, PyObject* backgroundList);
        
        //--------------------------------------------------------------------------
        
        
        PyObject* wxPyDrawXXXList(wxDC& dc, wxPyDrawListOp_t doDraw,
                                  PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
        {
            wxPyBlock_t blocked = wxPyBeginBlockThreads();
        
            bool      isFastSeq  = PyList_Check(pyCoords) || PyTuple_Check(pyCoords);
            bool      isFastPens = PyList_Check(pyPens) || PyTuple_Check(pyPens);
            bool      isFastBrushes = PyList_Check(pyBrushes) || PyTuple_Check(pyBrushes);
            int       numObjs = 0;
            int       numPens = 0;
            int       numBrushes = 0;
            wxPen*    pen;
            wxBrush*  brush;
            PyObject* obj;
            PyObject* coords;
            int       i = 0;
            PyObject* retval;
        
            if (!PySequence_Check(pyCoords)) {
                goto err0;
            }
            if (!PySequence_Check(pyPens)) {
                goto err1;
            }
            if (!PySequence_Check(pyBrushes)) {
                goto err2;
            }
            numObjs = PySequence_Length(pyCoords);
            numPens = PySequence_Length(pyPens);
            numBrushes = PySequence_Length(pyBrushes);
            for (i = 0; i < numObjs; i++) {
                // Use a new pen?
                if (i < numPens) {
                    if (isFastPens) {
                        obj = PySequence_Fast_GET_ITEM(pyPens, i);
                    }
                    else {
                        obj = PySequence_GetItem(pyPens, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &pen, "wxPen")) {
                        if (!isFastPens)
                            Py_DECREF(obj);
                        goto err1;
                    }
        
                    dc.SetPen(*pen);
                    if (!isFastPens)
                        Py_DECREF(obj);
                }
                // Use a new brush?
                if (i < numBrushes) {
                    if (isFastBrushes) {
                        obj = PySequence_Fast_GET_ITEM(pyBrushes, i);
                    }
                    else {
                        obj = PySequence_GetItem(pyBrushes, i);
                    }
                    if (!wxPyConvertWrappedPtr(obj, (void **) &brush, "wxBrush")) {
                        if (!isFastBrushes)
                            Py_DECREF(obj);
                        goto err2;
                    }
        
                    dc.SetBrush(*brush);
                    if (!isFastBrushes)
                        Py_DECREF(obj);
                }
        
                // Get the Coordinates
                if (isFastSeq) {
                    coords = PySequence_Fast_GET_ITEM(pyCoords, i);
                }
                else {
                    coords = PySequence_GetItem(pyCoords, i);
                }
        
        
                // call the drawOp
                bool success = doDraw(dc, coords);
                if (!isFastSeq)
                    Py_DECREF(coords);
        
                if (! success) {
                    retval = NULL;
                    goto exit;
                }
        
            } // end of main for loop
        
            Py_INCREF(Py_None);
            retval = Py_None;
            goto exit;
        
        
         err0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of coordinates");
            retval = NULL;
            goto exit;
        
         err1:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxPens");
            retval = NULL;
            goto exit;
        
         err2:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxBrushes");
            retval = NULL;
            goto exit;
        
        
         exit:
            wxPyEndBlockThreads(blocked);
            return retval;
        }
        
        
        
        bool wxPyDrawXXXPoint(wxDC& dc, PyObject* coords)
        {
            int x, y;
        
            if (! wxPy2int_seq_helper(coords, &x, &y)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y) sequences.");
                return false;
            }
            dc.DrawPoint(x, y);
            return true;
        }
        
        bool wxPyDrawXXXLine(wxDC& dc, PyObject* coords)
        {
            int x1, y1, x2, y2;
        
            if (! wxPy4int_seq_helper(coords, &x1, &y1, &x2, &y2)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x1,y1, x1,y2) sequences.");
                return false;
            }
            dc.DrawLine(x1,y1, x2,y2);
            return true;
        }
        
        bool wxPyDrawXXXRectangle(wxDC& dc, PyObject* coords)
        {
            int x, y, w, h;
        
            if (! wxPy4int_seq_helper(coords, &x, &y, &w, &h)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y, w,h) sequences.");
                return false;
            }
            dc.DrawRectangle(x, y, w, h);
            return true;
        }
        
        bool wxPyDrawXXXEllipse(wxDC& dc, PyObject* coords)
        {
            int x, y, w, h;
        
            if (! wxPy4int_seq_helper(coords, &x, &y, &w, &h)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y, w,h) sequences.");
                return false;
            }
            dc.DrawEllipse(x, y, w, h);
            return true;
        }
        
        
        wxPoint* wxPoint_LIST_helper(PyObject* source, int *count);
        
        bool wxPyDrawXXXPolygon(wxDC& dc, PyObject* coords)
        {
            wxPoint* points;
            int numPoints;
        
            points = wxPoint_LIST_helper(coords, &numPoints);
            if (! points) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of sequences of (x,y) sequences.");
                return false;
            }
            dc.DrawPolygon(numPoints, points);
            delete [] points;
            return true;
        }
        
        
        //---------------------------------------------------------------------------
        
        
        
        PyObject* wxPyDrawTextList(wxDC& dc, PyObject* textList, PyObject* pyPoints, PyObject* foregroundList, PyObject* backgroundList)
        {
            wxPyBlock_t blocked = wxPyBeginBlockThreads();
        
            bool      isFastSeq  = PyList_Check(pyPoints) || PyTuple_Check(pyPoints);
            bool      isFastText = PyList_Check(textList) || PyTuple_Check(textList);
            bool      isFastForeground = PyList_Check(foregroundList) || PyTuple_Check(foregroundList);
            bool      isFastBackground = PyList_Check(backgroundList) || PyTuple_Check(backgroundList);
            int       numText = 0;
            int       numPoints = 0;
            int       numForeground = 0;
            int       numBackground = 0;
            PyObject* obj;
            int       x1, y1;
            int       i = 0;
            wxColor*    color;
            PyObject* retval;
            wxString  string;
        
            if (!PySequence_Check(pyPoints)) {
                goto err0;
            }
            if (!PySequence_Check(textList)) {
                goto err1;
            }
            if (!PySequence_Check(foregroundList)) {
                goto err2;
            }
            if (!PySequence_Check(backgroundList)) {
                goto err3;
            }
            numPoints = PySequence_Length(pyPoints);
            numText = PySequence_Length(textList);
            numForeground = PySequence_Length(foregroundList);
            numBackground = PySequence_Length(backgroundList);
        
            for (i = 0; i < numPoints; i++) {
                // Use a new string ?
                if (i < numText) {
                    if ( isFastText ) {
                        obj = PySequence_Fast_GET_ITEM(textList, i);
                    }
                    else {
                        obj = PySequence_GetItem(textList, i);
                    }
                    if (! PyBytes_Check(obj) && !PyUnicode_Check(obj) ) {
                        Py_DECREF(obj);
                        goto err1;
                    }
                    string = Py2wxString(obj);
                    if ( !isFastText )
                        Py_DECREF(obj);
                }
        
                if (i < numForeground) {
                    // Use a new foreground ?
                    if ( isFastForeground ) {
                        obj = PySequence_Fast_GET_ITEM(foregroundList, i);
                    }
                    else {
                        obj = PySequence_GetItem(foregroundList, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &color, "wxColour")) {
                        if (!isFastForeground)
                            Py_DECREF(obj);
                        goto err2;
                    }
                    dc.SetTextForeground(*color);
                    if ( !isFastForeground )
                        Py_DECREF(obj);
                }
        
                if (i < numBackground) {
                    // Use a new background ?
                    if ( isFastBackground ) {
                        obj = PySequence_Fast_GET_ITEM(backgroundList, i);
                    }
                    else {
                        obj = PySequence_GetItem(backgroundList, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &color, "wxColour")) {
                        if (!isFastBackground)
                            Py_DECREF(obj);
                        goto err3;
                    }
                    dc.SetTextBackground(*color);
                    if ( !isFastBackground )
                        Py_DECREF(obj);
                }
        
                // Get the point coordinates
                if (isFastSeq) {
                    obj = PySequence_Fast_GET_ITEM(pyPoints, i);
                }
                else {
                    obj = PySequence_GetItem(pyPoints, i);
                }
                if (! wxPy2int_seq_helper(obj, &x1, &y1)) {
                    if (! isFastSeq)
                        Py_DECREF(obj);
                    goto err0;
                }
                if (!isFastText)
                    Py_DECREF(obj);
        
                if (PyErr_Occurred()) {
                    retval = NULL;
                    goto exit;
                }
        
                // Now draw the text
                dc.DrawText(string, x1, y1);
            }
        
            Py_INCREF(Py_None);
            retval = Py_None;
            goto exit;
        
         err0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y) sequences.");
            retval = NULL;
            goto exit;
         err1:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of strings");
            retval = NULL;
            goto exit;
        
         err2:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxColours for foregrounds");
            retval = NULL;
            goto exit;
        
         err3:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxColours for backgrounds");
            retval = NULL;
            goto exit;
        
         exit:
            wxPyEndBlockThreads(blocked);
            return retval;
        }
        
        //---------------------------------------------------------------------------
        
        
        bool wxPointFromObjects(PyObject* o1, PyObject* o2, wxPoint* point)
        {
            // get the x value
            if (wxPyInt_Check(o1))
                point->x = (int)wxPyInt_AS_LONG(o1);
            else if (PyFloat_Check(o1))
                point->x = (int)PyFloat_AS_DOUBLE(o1);
            else if (PyNumber_Check(o1))
                point->x = (int)wxPyInt_AsLong(o1);
            else
                return false;
        
            // get the y value
            if (wxPyInt_Check(o2))
                point->y = (int)wxPyInt_AS_LONG(o2);
            else if (PyFloat_Check(o2))
                point->y = (int)PyFloat_AS_DOUBLE(o2);
            else if (PyNumber_Check(o2))
                point->y = (int)wxPyInt_AsLong(o2);
            else
                return false;
        
            return true;
        }
        
        
        wxPoint* wxPoint_LIST_helper(PyObject* source, int *count)
        {
            int idx;
            wxPoint* temp;
            PyObject *o, *o1, *o2;
            bool isFast = PyList_Check(source) || PyTuple_Check(source);
        
            if (!PySequence_Check(source)) {
                goto error0;
            }
        
            // The length of the sequence is returned in count.
            *count = PySequence_Length(source);
            if (*count < 0) {
                goto error0;
            }
        
            temp = new wxPoint[*count];
            if (!temp) {
                PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
                return NULL;
            }
            for (idx=0; idx<*count; idx++) {
                // Get an item: try fast way first.
                if (isFast) {
                    o = PySequence_Fast_GET_ITEM(source, idx);
                }
                else {
                    o = PySequence_GetItem(source, idx);
                    if (o == NULL) {
                        goto error1;
                    }
                }
        
                // Convert o to wxPoint.
                if ((PyTuple_Check(o) && PyTuple_GET_SIZE(o) == 2) ||
                    (PyList_Check(o) && PyList_GET_SIZE(o) == 2)) {
                    o1 = PySequence_Fast_GET_ITEM(o, 0);
                    o2 = PySequence_Fast_GET_ITEM(o, 1);
                    if (!wxPointFromObjects(o1, o2, &temp[idx])) {
                        goto error2;
                    }
                }
                else if (wxPyWrappedPtr_Check(o)) {
                    wxPoint* pt;
                    if (! wxPyConvertWrappedPtr(o, (void **)&pt, "wxPoint")) {
                        goto error2;
                    }
                    temp[idx] = *pt;
                }
                else if (PySequence_Check(o) && PySequence_Length(o) == 2) {
                    o1 = PySequence_GetItem(o, 0);
                    o2 = PySequence_GetItem(o, 1);
                    if (!wxPointFromObjects(o1, o2, &temp[idx])) {
                        goto error3;
                    }
                    Py_DECREF(o1);
                    Py_DECREF(o2);
                }
                else {
                    goto error2;
                }
                // Clean up.
                if (!isFast)
                    Py_DECREF(o);
            }
            return temp;
        
        error3:
            Py_DECREF(o1);
            Py_DECREF(o2);
        error2:
            if (!isFast)
                Py_DECREF(o);
        error1:
            delete [] temp;
        error0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of length-2 sequences or wx.Points.");
            return NULL;
        }
    wxRect* _wxDC_DrawLabel(wxDC* self, const wxString *text, const wxBitmap *bitmap, const wxRect *rect, int alignment, int indexAccel)
    {
        wxRect rv;
        self->DrawLabel(*text, *bitmap, *rect, alignment, indexAccel, &rv);
        return new wxRect(rv);
    }
    wxArrayInt* _wxDC_GetPartialTextExtents(const wxDC* self, const wxString *text)
    {
        wxArrayInt rval;
        self->GetPartialTextExtents(*text, rval);
        return new wxArrayInt(rval);
    }
    wxColour* _wxDC_GetPixel(wxDC* self, wxCoord x, wxCoord y)
    {
        wxColour* col = new wxColour;
        self->GetPixel(x, y, col);
        return col;
    }
    wxUIntPtr* _wxDC_GetHandle(const wxDC* self)
    {
        return new wxUIntPtr((wxUIntPtr)self->GetHandle());
    }
    wxSize* _wxDC_GetTextExtent(const wxDC* self, const wxString* st)
    {
        return new wxSize(self->GetTextExtent(*st));
    }
    wxSize* _wxDC_GetMultiLineTextExtent(const wxDC* self, const wxString* st)
    {
        return new wxSize(self->GetMultiLineTextExtent(*st));
    }
    int _wxDC___nonzero__(wxDC* self)
    {
        return self->IsOk();
    }
    long _wxDC_GetHDC(wxDC* self)
    {
        #ifdef __WXMSW__
            return (long)self->GetHandle();
        #else
            wxPyRaiseNotImplemented();
            return 0;
        #endif
    }
    wxUIntPtr* _wxDC_GetCGContext(wxDC* self)
    {
        #ifdef __WXMAC__
            return new wxUIntPtr((wxUIntPtr)self->GetHandle());
        #else
            wxPyRaiseNotImplemented();
            return NULL;
        #endif
    }
    wxUIntPtr* _wxDC_GetGdkDrawable(wxDC* self)
    {
        #ifdef __WXGTK__
            return new wxUIntPtr((wxUIntPtr)self->GetHandle());
        #else
            wxPyRaiseNotImplemented();
            return NULL;
        #endif
    }
    PyObject* _wxDC__DrawPointList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXPoint, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawLineList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXLine, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawRectangleList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXRectangle, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawEllipseList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXEllipse, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawPolygonList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXPolygon, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawTextList(wxDC* self, PyObject* textList, PyObject* pyPoints, PyObject* foregroundList, PyObject* backgroundList)
    {
        return wxPyDrawTextList(*self, textList, pyPoints, foregroundList, backgroundList);
    }


PyDoc_STRVAR(doc_wxDC_DeviceToLogicalX, "DeviceToLogicalX(x) -> Coord\n"
"\n"
"Convert device X coordinate to logical coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxDC_DeviceToLogicalX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DeviceToLogicalX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &x))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalX(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DeviceToLogicalX, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DeviceToLogicalXRel, "DeviceToLogicalXRel(x) -> Coord\n"
"\n"
"Convert device X coordinate to relative logical coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxDC_DeviceToLogicalXRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DeviceToLogicalXRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &x))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalXRel(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DeviceToLogicalXRel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DeviceToLogicalY, "DeviceToLogicalY(y) -> Coord\n"
"\n"
"Converts device Y coordinate to logical coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxDC_DeviceToLogicalY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DeviceToLogicalY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord y;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &y))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalY(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DeviceToLogicalY, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DeviceToLogicalYRel, "DeviceToLogicalYRel(y) -> Coord\n"
"\n"
"Convert device Y coordinate to relative logical coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxDC_DeviceToLogicalYRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DeviceToLogicalYRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord y;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &y))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeviceToLogicalYRel(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DeviceToLogicalYRel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_LogicalToDeviceX, "LogicalToDeviceX(x) -> Coord\n"
"\n"
"Converts logical X coordinate to device coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxDC_LogicalToDeviceX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_LogicalToDeviceX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &x))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceX(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_LogicalToDeviceX, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_LogicalToDeviceXRel, "LogicalToDeviceXRel(x) -> Coord\n"
"\n"
"Converts logical X coordinate to relative device coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxDC_LogicalToDeviceXRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_LogicalToDeviceXRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &x))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceXRel(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_LogicalToDeviceXRel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_LogicalToDeviceY, "LogicalToDeviceY(y) -> Coord\n"
"\n"
"Converts logical Y coordinate to device coordinate, using the current\n"
"mapping mode, user scale factor, device origin and axis orientation.");

extern "C" {static PyObject *meth_wxDC_LogicalToDeviceY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_LogicalToDeviceY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord y;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &y))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceY(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_LogicalToDeviceY, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_LogicalToDeviceYRel, "LogicalToDeviceYRel(y) -> Coord\n"
"\n"
"Converts logical Y coordinate to relative device coordinate, using the\n"
"current mapping mode and user scale factor but ignoring the axis\n"
"orientation.");

extern "C" {static PyObject *meth_wxDC_LogicalToDeviceYRel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_LogicalToDeviceYRel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord y;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &y))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LogicalToDeviceYRel(y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_LogicalToDeviceYRel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_Clear, "Clear()\n"
"\n"
"Clears the device context using the current background brush.");

extern "C" {static PyObject *meth_wxDC_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxDC_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawArc, "DrawArc(xStart, yStart, xEnd, yEnd, xc, yc)\n"
"DrawArc(ptStart, ptEnd, centre)\n"
"\n"
"Draws an arc from the given start to the given end point.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord xStart;
         ::wxCoord yStart;
         ::wxCoord xEnd;
         ::wxCoord yEnd;
         ::wxCoord xc;
         ::wxCoord yc;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xStart,
            sipName_yStart,
            sipName_xEnd,
            sipName_yEnd,
            sipName_xc,
            sipName_yc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiiiii", &sipSelf, sipType_wxDC, &sipCpp, &xStart, &yStart, &xEnd, &yEnd, &xc, &yc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawArc(xStart,yStart,xEnd,yEnd,xc,yc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* ptStart;
        int ptStartState = 0;
        const  ::wxPoint* ptEnd;
        int ptEndState = 0;
        const  ::wxPoint* centre;
        int centreState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ptStart,
            sipName_ptEnd,
            sipName_centre,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &ptStart, &ptStartState, sipType_wxPoint, &ptEnd, &ptEndState, sipType_wxPoint, &centre, &centreState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawArc(*ptStart,*ptEnd,*centre);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(ptStart),sipType_wxPoint,ptStartState);
            sipReleaseType(const_cast< ::wxPoint *>(ptEnd),sipType_wxPoint,ptEndState);
            sipReleaseType(const_cast< ::wxPoint *>(centre),sipType_wxPoint,centreState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawArc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawBitmap, "DrawBitmap(bitmap, x, y, useMask=False)\n"
"DrawBitmap(bmp, pt, useMask=False)\n"
"\n"
"Draw a bitmap on the device context at the specified point.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bitmap;
         ::wxCoord x;
         ::wxCoord y;
        bool useMask = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_x,
            sipName_y,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9ii|b", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBitmap, &bitmap, &x, &y, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bitmap,x,y,useMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxBitmap* bmp;
        const  ::wxPoint* pt;
        int ptState = 0;
        bool useMask = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_pt,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1|b", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBitmap, &bmp, sipType_wxPoint, &pt, &ptState, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp,*pt,useMask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawCheckMark, "DrawCheckMark(x, y, width, height)\n"
"DrawCheckMark(rect)\n"
"\n"
"Draws a check mark inside the given rectangle.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawCheckMark(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawCheckMark(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawCheckMark, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawCircle, "DrawCircle(x, y, radius)\n"
"DrawCircle(pt, radius)\n"
"\n"
"Draws a circle with the given centre and radius.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawCircle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawCircle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord radius;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(x,y,radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxCoord radius;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(*pt,radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawCircle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawEllipse, "DrawEllipse(x, y, width, height)\n"
"DrawEllipse(pt, size)\n"
"DrawEllipse(rect)\n"
"\n"
"Draws an ellipse contained in the rectangle specified either with the\n"
"given top left corner and the given size or directly.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*pt,*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawEllipse, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawEllipticArc, "DrawEllipticArc(x, y, width, height, start, end)\n"
"DrawEllipticArc(pt, sz, sa, ea)\n"
"\n"
"Draws an arc of an ellipse.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawEllipticArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawEllipticArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
        double start;
        double end;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiiidd", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height, &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(x,y,width,height,start,end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxSize* sz;
        int szState = 0;
        double sa;
        double ea;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_sa,
            sipName_ea,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1dd", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &sa, &ea))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(*pt,*sz,sa,ea);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawEllipticArc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawIcon, "DrawIcon(icon, x, y)\n"
"DrawIcon(icon, pt)\n"
"\n"
"Draw an icon on the display (does nothing if the device context is\n"
"PostScript).\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxIcon* icon;
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxIcon, &icon, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxIcon* icon;
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxIcon, &icon, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon,*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawLabel, "DrawLabel(text, bitmap, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> Rect\n"
"DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1)\n"
"\n"
"Draw optional bitmap and the text into the given rectangle and aligns\n"
"it as specified by alignment parameter; it also will emphasize the\n"
"character with the given index if it is != -1 and return the bounding\n"
"rectangle if required.\n"
"DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1)\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxDC_DrawLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxBitmap* bitmap;
        const  ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_bitmap,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9J1|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, sipType_wxBitmap, &bitmap, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
             ::wxRect*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_DrawLabel(sipCpp, text, bitmap, rect, alignment, indexAccel);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,NULL);
        }
    }

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLabel(*text,*rect,alignment,indexAccel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawLine, "DrawLine(x1, y1, x2, y2)\n"
"DrawLine(pt1, pt2)\n"
"\n"
"Draws a line from the first point to the second.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawLine(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLine(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x1;
         ::wxCoord y1;
         ::wxCoord x2;
         ::wxCoord y2;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x1, &y1, &x2, &y2))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(x1,y1,x2,y2);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt1;
        int pt1State = 0;
        const  ::wxPoint* pt2;
        int pt2State = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt1,
            sipName_pt2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt1, &pt1State, sipType_wxPoint, &pt2, &pt2State))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(*pt1,*pt2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt1),sipType_wxPoint,pt1State);
            sipReleaseType(const_cast< ::wxPoint *>(pt2),sipType_wxPoint,pt2State);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLine, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawLines, "DrawLines(points, xoffset=0, yoffset=0)\n"
"\n"
"This method uses a list of wxPoints, adding the optional offset\n"
"coordinate.");

extern "C" {static PyObject *meth_wxDC_DrawLines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPointList* points;
        int pointsState = 0;
         ::wxCoord xoffset = 0;
         ::wxCoord yoffset = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLines(points,xoffset,yoffset);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points),sipType_wxPointList,pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLines, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawPoint, "DrawPoint(x, y)\n"
"DrawPoint(pt)\n"
"\n"
"Draws a point using the color of the current pen.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawPolygon, "DrawPolygon(points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE)\n"
"\n"
"This method draws a filled polygon using a list of wxPoints, adding\n"
"the optional offset coordinate.");

extern "C" {static PyObject *meth_wxDC_DrawPolygon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawPolygon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPointList* points;
        int pointsState = 0;
         ::wxCoord xoffset = 0;
         ::wxCoord yoffset = 0;
         ::wxPolygonFillMode fill_style = wxODDEVEN_RULE;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
            sipName_fill_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0|iiE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset, sipType_wxPolygonFillMode, &fill_style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPolygon(points,xoffset,yoffset,fill_style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points),sipType_wxPointList,pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawPolygon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawRectangle, "DrawRectangle(x, y, width, height)\n"
"DrawRectangle(pt, sz)\n"
"DrawRectangle(rect)\n"
"\n"
"Draws a rectangle with the given top left corner, and with the given\n"
"size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxSize* sz;
        int szState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*pt,*sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawRotatedText, "DrawRotatedText(text, x, y, angle)\n"
"DrawRotatedText(text, point, angle)\n"
"\n"
"Draws the text rotated by angle degrees (positive angles are\n"
"counterclockwise; the full angle is 360 degrees).\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRotatedText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRotatedText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxCoord x;
         ::wxCoord y;
        double angle;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1iid", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, &x, &y, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text,x,y,angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxPoint* point;
        int pointState = 0;
        double angle;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_point,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, sipType_wxPoint, &point, &pointState, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text,*point,angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxPoint *>(point),sipType_wxPoint,pointState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRotatedText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawRoundedRectangle, "DrawRoundedRectangle(x, y, width, height, radius)\n"
"DrawRoundedRectangle(pt, sz, radius)\n"
"DrawRoundedRectangle(rect, radius)\n"
"\n"
"Draws a rectangle with the given top left corner, and with the given\n"
"size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
        double radius;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiiid", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(x,y,width,height,radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxSize* sz;
        int szState = 0;
        double radius;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*pt,*sz,radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
        double radius;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*rect,radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRoundedRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawSpline, "DrawSpline(points)\n"
"DrawSpline(x1, y1, x2, y2, x3, y3)\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawSpline(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawSpline(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPointList* points;
        int pointsState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawSpline(points);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points),sipType_wxPointList,pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxCoord x1;
         ::wxCoord y1;
         ::wxCoord x2;
         ::wxCoord y2;
         ::wxCoord x3;
         ::wxCoord y3;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_x3,
            sipName_y3,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiiiii", &sipSelf, sipType_wxDC, &sipCpp, &x1, &y1, &x2, &y2, &x3, &y3))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawSpline(x1,y1,x2,y2,x3,y3);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawSpline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DrawText, "DrawText(text, x, y)\n"
"DrawText(text, pt)\n"
"\n"
"Draws a text string at the specified point, using the current text\n"
"font, and the current text foreground and background colours.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text,x,y);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text,*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GradientFillConcentric, "GradientFillConcentric(rect, initialColour, destColour)\n"
"GradientFillConcentric(rect, initialColour, destColour, circleCenter)\n"
"\n"
"Fill the area specified by rect with a radial gradient, starting from\n"
"initialColour at the centre of the circle and fading to destColour on\n"
"the circle outside.\n"
"");

extern "C" {static PyObject *meth_wxDC_GradientFillConcentric(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GradientFillConcentric(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxColour* initialColour;
        int initialColourState = 0;
        const  ::wxColour* destColour;
        int destColourState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillConcentric(*rect,*initialColour,*destColour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour),sipType_wxColour,initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour),sipType_wxColour,destColourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxColour* initialColour;
        int initialColourState = 0;
        const  ::wxColour* destColour;
        int destColourState = 0;
        const  ::wxPoint* circleCenter;
        int circleCenterState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
            sipName_circleCenter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState, sipType_wxPoint, &circleCenter, &circleCenterState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillConcentric(*rect,*initialColour,*destColour,*circleCenter);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour),sipType_wxColour,initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour),sipType_wxColour,destColourState);
            sipReleaseType(const_cast< ::wxPoint *>(circleCenter),sipType_wxPoint,circleCenterState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GradientFillConcentric, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GradientFillLinear, "GradientFillLinear(rect, initialColour, destColour, nDirection=RIGHT)\n"
"\n"
"Fill the area specified by rect with a linear gradient, starting from\n"
"initialColour and eventually fading to destColour.");

extern "C" {static PyObject *meth_wxDC_GradientFillLinear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GradientFillLinear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxColour* initialColour;
        int initialColourState = 0;
        const  ::wxColour* destColour;
        int destColourState = 0;
         ::wxDirection nDirection = wxRIGHT;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
            sipName_nDirection,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1|E", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState, sipType_wxDirection, &nDirection))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillLinear(*rect,*initialColour,*destColour,nDirection);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour),sipType_wxColour,initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour),sipType_wxColour,destColourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GradientFillLinear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_FloodFill, "FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool\n"
"FloodFill(pt, col, style=FLOOD_SURFACE) -> bool\n"
"\n"
"Flood fills the device context starting from the given point, using\n"
"the current brush colour, and using a style:\n"
"");

extern "C" {static PyObject *meth_wxDC_FloodFill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_FloodFill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxFloodFillStyle style = wxFLOOD_SURFACE;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_colour,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiJ1|E", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, sipType_wxColour, &colour, &colourState, sipType_wxFloodFillStyle, &style))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FloodFill(x,y,*colour,style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxColour* col;
        int colState = 0;
         ::wxFloodFillStyle style = wxFLOOD_SURFACE;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_col,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|E", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxColour, &col, &colState, sipType_wxFloodFillStyle, &style))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FloodFill(*pt,*col,style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxColour *>(col),sipType_wxColour,colState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_FloodFill, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CrossHair, "CrossHair(x, y)\n"
"CrossHair(pt)\n"
"\n"
"Displays a cross hair using the current pen.\n"
"");

extern "C" {static PyObject *meth_wxDC_CrossHair(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CrossHair(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CrossHair, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_DestroyClippingRegion, "DestroyClippingRegion()\n"
"\n"
"Destroys the current clipping region so that none of the DC is\n"
"clipped.");

extern "C" {static PyObject *meth_wxDC_DestroyClippingRegion(PyObject *, PyObject *);}
static PyObject *meth_wxDC_DestroyClippingRegion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DestroyClippingRegion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_DestroyClippingRegion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetClippingBox, "GetClippingBox() -> (x, y, width, height)\n"
"\n"
"Gets the rectangle surrounding the current clipping region.");

extern "C" {static PyObject *meth_wxDC_GetClippingBox(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetClippingBox(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
        const  ::wxDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetClippingBox(&x,&y,&width,&height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(iiii)",x,y,width,height);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetClippingBox, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetClippingRegion, "SetClippingRegion(x, y, width, height)\n"
"SetClippingRegion(pt, sz)\n"
"SetClippingRegion(rect)\n"
"\n"
"Sets the clipping region for this device context to the intersection\n"
"of the given region described by the parameters of this method and the\n"
"previously set clipping region.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_SetClippingRegion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetClippingRegion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxSize* sz;
        int szState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(*pt,*sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetClippingRegion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetDeviceClippingRegion, "SetDeviceClippingRegion(region)\n"
"\n"
"Sets the clipping region for this device context.");

extern "C" {static PyObject *meth_wxDC_SetDeviceClippingRegion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetDeviceClippingRegion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion* region;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRegion, &region))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDeviceClippingRegion(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetDeviceClippingRegion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetCharHeight, "GetCharHeight() -> Coord\n"
"\n"
"Gets the character height of the currently set font.");

extern "C" {static PyObject *meth_wxDC_GetCharHeight(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetCharHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetCharHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetCharWidth, "GetCharWidth() -> Coord\n"
"\n"
"Gets the average character width of the currently set font.");

extern "C" {static PyObject *meth_wxDC_GetCharWidth(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetCharWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetCharWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetFontMetrics, "GetFontMetrics() -> FontMetrics\n"
"\n"
"Returns the various font characteristics.");

extern "C" {static PyObject *meth_wxDC_GetFontMetrics(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetFontMetrics(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxFontMetrics*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFontMetrics(sipCpp->GetFontMetrics());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFontMetrics,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetFontMetrics, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetFullMultiLineTextExtent, "GetFullMultiLineTextExtent(string, font=None) -> (w, h, heightLine)\n"
"\n"
"Gets the dimensions of the string as it would be drawn.");

extern "C" {static PyObject *meth_wxDC_GetFullMultiLineTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetFullMultiLineTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* string;
        int stringState = 0;
         ::wxCoord w;
         ::wxCoord h;
         ::wxCoord heightLine;
        const  ::wxFont* font = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J8", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&string, &stringState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetMultiLineTextExtent(*string,&w,&h,&heightLine,font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string),sipType_wxString,stringState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(iii)",w,h,heightLine);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetFullMultiLineTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetPartialTextExtents, "GetPartialTextExtents(text) -> ArrayInt\n"
"\n"
"Fills the widths array with the widths from the beginning of text to\n"
"the corresponding character of text.");

extern "C" {static PyObject *meth_wxDC_GetPartialTextExtents(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPartialTextExtents(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&text, &textState))
        {
             ::wxArrayInt*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetPartialTextExtents(sipCpp, text);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayInt,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPartialTextExtents, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetFullTextExtent, "GetFullTextExtent(string, font=None) -> (w, h, descent, externalLeading)\n"
"\n"
"Gets the dimensions of the string as it would be drawn.");

extern "C" {static PyObject *meth_wxDC_GetFullTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetFullTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* string;
        int stringState = 0;
         ::wxCoord w;
         ::wxCoord h;
         ::wxCoord descent;
         ::wxCoord externalLeading;
        const  ::wxFont* font = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J8", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&string, &stringState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetTextExtent(*string,&w,&h,&descent,&externalLeading,font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string),sipType_wxString,stringState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(iiii)",w,h,descent,externalLeading);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetFullTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetBackgroundMode, "GetBackgroundMode() -> int\n"
"\n"
"Returns the current background mode: wxSOLID or wxTRANSPARENT.");

extern "C" {static PyObject *meth_wxDC_GetBackgroundMode(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBackgroundMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBackgroundMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBackgroundMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetFont, "GetFont() -> Font\n"
"\n"
"Gets the current font.");

extern "C" {static PyObject *meth_wxDC_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetLayoutDirection, "GetLayoutDirection() -> LayoutDirection\n"
"\n"
"Gets the current layout direction of the device context.");

extern "C" {static PyObject *meth_wxDC_GetLayoutDirection(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxLayoutDirection sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLayoutDirection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxLayoutDirection);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetLayoutDirection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetTextBackground, "GetTextBackground() -> Colour\n"
"\n"
"Gets the current text background colour.");

extern "C" {static PyObject *meth_wxDC_GetTextBackground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextBackground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextBackground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextBackground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetTextForeground, "GetTextForeground() -> Colour\n"
"\n"
"Gets the current text foreground colour.");

extern "C" {static PyObject *meth_wxDC_GetTextForeground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextForeground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextForeground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextForeground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetBackgroundMode, "SetBackgroundMode(mode)\n"
"\n"
"mode may be one of wxSOLID and wxTRANSPARENT.");

extern "C" {static PyObject *meth_wxDC_SetBackgroundMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBackgroundMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int mode;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBackgroundMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetFont, "SetFont(font)\n"
"\n"
"Sets the current font for the DC.");

extern "C" {static PyObject *meth_wxDC_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetTextBackground, "SetTextBackground(colour)\n"
"\n"
"Sets the current text background colour for the DC.");

extern "C" {static PyObject *meth_wxDC_SetTextBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetTextBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextBackground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetTextBackground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetTextForeground, "SetTextForeground(colour)\n"
"\n"
"Sets the current text foreground colour for the DC.");

extern "C" {static PyObject *meth_wxDC_SetTextForeground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetTextForeground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextForeground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetTextForeground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetLayoutDirection, "SetLayoutDirection(dir)\n"
"\n"
"Sets the current layout direction for the device context.");

extern "C" {static PyObject *meth_wxDC_SetLayoutDirection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLayoutDirection dir;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxLayoutDirection, &dir))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLayoutDirection(dir);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetLayoutDirection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CalcBoundingBox, "CalcBoundingBox(x, y)\n"
"\n"
"Adds the specified point to the bounding box which can be retrieved\n"
"with MinX(), MaxX() and MinY(), MaxY() functions.");

extern "C" {static PyObject *meth_wxDC_CalcBoundingBox(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CalcBoundingBox(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CalcBoundingBox(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CalcBoundingBox, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_MaxX, "MaxX() -> Coord\n"
"\n"
"Gets the maximum horizontal extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MaxX(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MaxX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MaxX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_MaxX, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_MaxY, "MaxY() -> Coord\n"
"\n"
"Gets the maximum vertical extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MaxY(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MaxY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MaxY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_MaxY, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_MinX, "MinX() -> Coord\n"
"\n"
"Gets the minimum horizontal extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MinX(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MinX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MinX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_MinX, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_MinY, "MinY() -> Coord\n"
"\n"
"Gets the minimum vertical extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MinY(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MinY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MinY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_MinY, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_ResetBoundingBox, "ResetBoundingBox()\n"
"\n"
"Resets the bounding box: after a call to this function, the bounding\n"
"box doesn't contain anything.");

extern "C" {static PyObject *meth_wxDC_ResetBoundingBox(PyObject *, PyObject *);}
static PyObject *meth_wxDC_ResetBoundingBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetBoundingBox();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_ResetBoundingBox, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_StartDoc, "StartDoc(message) -> bool\n"
"\n"
"Starts a document (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_StartDoc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_StartDoc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* message;
        int messageState = 0;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&message, &messageState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StartDoc(*message);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(message),sipType_wxString,messageState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_StartDoc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_StartPage, "StartPage()\n"
"\n"
"Starts a document page (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_StartPage(PyObject *, PyObject *);}
static PyObject *meth_wxDC_StartPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StartPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_StartPage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_EndDoc, "EndDoc()\n"
"\n"
"Ends a document (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_EndDoc(PyObject *, PyObject *);}
static PyObject *meth_wxDC_EndDoc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndDoc();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_EndDoc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_EndPage, "EndPage()\n"
"\n"
"Ends a document page (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_EndPage(PyObject *, PyObject *);}
static PyObject *meth_wxDC_EndPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_EndPage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_Blit, "Blit(xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool\n"
"\n"
"Copy from a source DC to this DC.");

extern "C" {static PyObject *meth_wxDC_Blit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_Blit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord xdest;
         ::wxCoord ydest;
         ::wxCoord width;
         ::wxCoord height;
         ::wxDC* source;
         ::wxCoord xsrc;
         ::wxCoord ysrc;
         ::wxRasterOperationMode logicalFunc = wxCOPY;
        bool useMask = 0;
         ::wxCoord xsrcMask = wxDefaultCoord;
         ::wxCoord ysrcMask = wxDefaultCoord;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xdest,
            sipName_ydest,
            sipName_width,
            sipName_height,
            sipName_source,
            sipName_xsrc,
            sipName_ysrc,
            sipName_logicalFunc,
            sipName_useMask,
            sipName_xsrcMask,
            sipName_ysrcMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiiiJ8ii|Ebii", &sipSelf, sipType_wxDC, &sipCpp, &xdest, &ydest, &width, &height, sipType_wxDC, &source, &xsrc, &ysrc, sipType_wxRasterOperationMode, &logicalFunc, &useMask, &xsrcMask, &ysrcMask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Blit(xdest,ydest,width,height,source,xsrc,ysrc,logicalFunc,useMask,xsrcMask,ysrcMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_Blit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_StretchBlit, "StretchBlit(xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool\n"
"\n"
"Copy from a source DC to this DC possibly changing the scale.");

extern "C" {static PyObject *meth_wxDC_StretchBlit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_StretchBlit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord xdest;
         ::wxCoord ydest;
         ::wxCoord dstWidth;
         ::wxCoord dstHeight;
         ::wxDC* source;
         ::wxCoord xsrc;
         ::wxCoord ysrc;
         ::wxCoord srcWidth;
         ::wxCoord srcHeight;
         ::wxRasterOperationMode logicalFunc = wxCOPY;
        bool useMask = 0;
         ::wxCoord xsrcMask = wxDefaultCoord;
         ::wxCoord ysrcMask = wxDefaultCoord;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xdest,
            sipName_ydest,
            sipName_dstWidth,
            sipName_dstHeight,
            sipName_source,
            sipName_xsrc,
            sipName_ysrc,
            sipName_srcWidth,
            sipName_srcHeight,
            sipName_logicalFunc,
            sipName_useMask,
            sipName_xsrcMask,
            sipName_ysrcMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiiiJ8iiii|Ebii", &sipSelf, sipType_wxDC, &sipCpp, &xdest, &ydest, &dstWidth, &dstHeight, sipType_wxDC, &source, &xsrc, &ysrc, &srcWidth, &srcHeight, sipType_wxRasterOperationMode, &logicalFunc, &useMask, &xsrcMask, &ysrcMask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StretchBlit(xdest,ydest,dstWidth,dstHeight,source,xsrc,ysrc,srcWidth,srcHeight,logicalFunc,useMask,xsrcMask,ysrcMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_StretchBlit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetBackground, "GetBackground() -> Brush\n"
"\n"
"Gets the brush used for painting the background.");

extern "C" {static PyObject *meth_wxDC_GetBackground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBackground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBrush(sipCpp->GetBackground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBackground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetBrush, "GetBrush() -> Brush\n"
"\n"
"Gets the current brush.");

extern "C" {static PyObject *meth_wxDC_GetBrush(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBrush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBrush(sipCpp->GetBrush());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetPen, "GetPen() -> Pen\n"
"\n"
"Gets the current pen.");

extern "C" {static PyObject *meth_wxDC_GetPen(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxPen*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPen(sipCpp->GetPen());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPen,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetBackground, "SetBackground(brush)\n"
"\n"
"Sets the current background brush for the DC.");

extern "C" {static PyObject *meth_wxDC_SetBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackground(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBackground, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetBrush, "SetBrush(brush)\n"
"\n"
"Sets the current brush for the DC.");

extern "C" {static PyObject *meth_wxDC_SetBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetPen, "SetPen(pen)\n"
"\n"
"Sets the current pen for the DC.");

extern "C" {static PyObject *meth_wxDC_SetPen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetPen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPen* pen;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPen, &pen))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPen(*pen);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetPen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CanUseTransformMatrix, "CanUseTransformMatrix() -> bool\n"
"\n"
"Check if the use of transformation matrix is supported by the current\n"
"system.");

extern "C" {static PyObject *meth_wxDC_CanUseTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxDC_CanUseTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanUseTransformMatrix();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CanUseTransformMatrix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetTransformMatrix, "SetTransformMatrix(matrix) -> bool\n"
"\n"
"Set the transformation matrix.");

extern "C" {static PyObject *meth_wxDC_SetTransformMatrix(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAffineMatrix2D* matrix;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxAffineMatrix2D, &matrix))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetTransformMatrix(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetTransformMatrix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetTransformMatrix, "GetTransformMatrix() -> AffineMatrix2D\n"
"\n"
"Return the transformation matrix used by this device context.");

extern "C" {static PyObject *meth_wxDC_GetTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxAffineMatrix2D*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxAffineMatrix2D(sipCpp->GetTransformMatrix());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxAffineMatrix2D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTransformMatrix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_ResetTransformMatrix, "ResetTransformMatrix()\n"
"\n"
"Revert the transformation matrix to identity matrix.");

extern "C" {static PyObject *meth_wxDC_ResetTransformMatrix(PyObject *, PyObject *);}
static PyObject *meth_wxDC_ResetTransformMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetTransformMatrix();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_ResetTransformMatrix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CanDrawBitmap, "CanDrawBitmap() -> bool\n"
"\n"
"Does the DC support drawing bitmaps?");

extern "C" {static PyObject *meth_wxDC_CanDrawBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxDC_CanDrawBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanDrawBitmap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CanDrawBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CanGetTextExtent, "CanGetTextExtent() -> bool\n"
"\n"
"Does the DC support calculating the size required to draw text?");

extern "C" {static PyObject *meth_wxDC_CanGetTextExtent(PyObject *, PyObject *);}
static PyObject *meth_wxDC_CanGetTextExtent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanGetTextExtent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CanGetTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetLogicalOrigin, "GetLogicalOrigin() -> (x, y)\n"
"\n"
"Return the coordinates of the logical point (0, 0).");

extern "C" {static PyObject *meth_wxDC_GetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
        const  ::wxDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetLogicalOrigin(&x,&y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",x,y);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetLogicalOrigin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_CopyAttributes, "CopyAttributes(dc)\n"
"\n"
"Copy attributes from another DC.");

extern "C" {static PyObject *meth_wxDC_CopyAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CopyAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC* dc;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxDC, &dc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CopyAttributes(*dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_CopyAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetDepth, "GetDepth() -> int\n"
"\n"
"Returns the depth (number of bits/pixel) of this DC.");

extern "C" {static PyObject *meth_wxDC_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetDepth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetDeviceOrigin, "GetDeviceOrigin() -> Point\n"
"\n"
"Returns the current device origin.");

extern "C" {static PyObject *meth_wxDC_GetDeviceOrigin(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetDeviceOrigin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetDeviceOrigin());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetDeviceOrigin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetLogicalFunction, "GetLogicalFunction() -> RasterOperationMode\n"
"\n"
"Gets the current logical function.");

extern "C" {static PyObject *meth_wxDC_GetLogicalFunction(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetLogicalFunction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxRasterOperationMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalFunction();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRasterOperationMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetLogicalFunction, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetMapMode, "GetMapMode() -> MappingMode\n"
"\n"
"Gets the current mapping mode for the device context.");

extern "C" {static PyObject *meth_wxDC_GetMapMode(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetMapMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxMappingMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMapMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxMappingMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetMapMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetPixel, "GetPixel(x, y) -> Colour\n"
"\n"
"Gets the colour at the specified location on the DC.");

extern "C" {static PyObject *meth_wxDC_GetPixel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPixel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
             ::wxColour*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetPixel(sipCpp, x, y);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPixel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetPPI, "GetPPI() -> Size\n"
"\n"
"Returns the resolution of the device in pixels per inch.");

extern "C" {static PyObject *meth_wxDC_GetPPI(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPPI(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetPPI());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPPI, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetSize, "GetSize() -> Size\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxDC_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetSizeMM, "GetSizeMM() -> Size\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxDC_GetSizeMM(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetSizeMM(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetSizeMM());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetSizeMM, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetUserScale, "GetUserScale() -> (x, y)\n"
"\n"
"Gets the current user scale factor.");

extern "C" {static PyObject *meth_wxDC_GetUserScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetUserScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double x;
        double y;
        const  ::wxDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetUserScale(&x,&y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",x,y);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetUserScale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the DC is ok to use.");

extern "C" {static PyObject *meth_wxDC_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxDC_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetAxisOrientation, "SetAxisOrientation(xLeftRight, yBottomUp)\n"
"\n"
"Sets the x and y axis orientation (i.e. the direction from lowest to\n"
"highest values on the axis).");

extern "C" {static PyObject *meth_wxDC_SetAxisOrientation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetAxisOrientation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool xLeftRight;
        bool yBottomUp;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xLeftRight,
            sipName_yBottomUp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bbb", &sipSelf, sipType_wxDC, &sipCpp, &xLeftRight, &yBottomUp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAxisOrientation(xLeftRight,yBottomUp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetAxisOrientation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetDeviceOrigin, "SetDeviceOrigin(x, y)\n"
"\n"
"Sets the device origin (i.e. the origin in pixels after scaling has\n"
"been applied).");

extern "C" {static PyObject *meth_wxDC_SetDeviceOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetDeviceOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDeviceOrigin(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetDeviceOrigin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetLogicalFunction, "SetLogicalFunction(function)\n"
"\n"
"Sets the current logical function for the device context.");

extern "C" {static PyObject *meth_wxDC_SetLogicalFunction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetLogicalFunction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRasterOperationMode function;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_function,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRasterOperationMode, &function))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalFunction(function);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetLogicalFunction, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetMapMode, "SetMapMode(mode)\n"
"\n"
"The mapping mode of the device context defines the unit of measurement\n"
"used to convert logical units to device units.");

extern "C" {static PyObject *meth_wxDC_SetMapMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetMapMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMappingMode mode;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxMappingMode, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMapMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetMapMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetPalette, "SetPalette(palette)\n"
"\n"
"If this is a window DC or memory DC, assigns the given palette to the\n"
"window or bitmap associated with the DC.");

extern "C" {static PyObject *meth_wxDC_SetPalette(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetPalette(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPalette* palette;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_palette,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPalette, &palette))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPalette(*palette);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetPalette, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetUserScale, "SetUserScale(xScale, yScale)\n"
"\n"
"Sets the user scaling factor, useful for applications which require\n"
"'zooming'.");

extern "C" {static PyObject *meth_wxDC_SetUserScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetUserScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double xScale;
        double yScale;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxDC, &sipCpp, &xScale, &yScale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUserScale(xScale,yScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetUserScale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetHandle, "GetHandle() -> UIntPtr\n"
"\n"
"Returns a value that can be used as a handle to the native drawing\n"
"context, if this wxDC has something that could be thought of in that\n"
"way.");

extern "C" {static PyObject *meth_wxDC_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxUIntPtr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetHandle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetAsBitmap, "GetAsBitmap(subrect=None) -> Bitmap\n"
"\n"
"If supported by the platform and the type of DC, fetch the contents of\n"
"the DC, or a subset of it, as a bitmap.");

extern "C" {static PyObject *meth_wxDC_GetAsBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetAsBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRect* subrect = 0;
        int subrectState = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_subrect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J0", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &subrect, &subrectState))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetAsBitmap(subrect));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(subrect),sipType_wxRect,subrectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetAsBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetLogicalScale, "SetLogicalScale(x, y)\n"
"\n"
"Set the scale to use for translating wxDC coordinates to the physical\n"
"pixels.");

extern "C" {static PyObject *meth_wxDC_SetLogicalScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetLogicalScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double x;
        double y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalScale(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetLogicalScale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetLogicalScale, "GetLogicalScale() -> (x, y)\n"
"\n"
"Return the scale set by the last call to SetLogicalScale().");

extern "C" {static PyObject *meth_wxDC_GetLogicalScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetLogicalScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double x;
        double y;
        const  ::wxDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetLogicalScale(&x,&y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",x,y);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetLogicalScale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_SetLogicalOrigin, "SetLogicalOrigin(x, y)\n"
"\n"
"Change the offset used for translating wxDC coordinates.");

extern "C" {static PyObject *meth_wxDC_SetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalOrigin(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_SetLogicalOrigin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetTextExtent, "GetTextExtent(st) -> Size\n"
"\n"
"Return the dimensions of the given string's text extent using the\n"
"currently selected font.\n"
"\n"
":param st: The string to be measured\n"
"\n"
".. seealso:: :meth:`~wx.DC.GetFullTextExtent`");

extern "C" {static PyObject *meth_wxDC_GetTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* st;
        int stState = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_st,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&st, &stState))
        {
             ::wxSize*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetTextExtent(sipCpp, st);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(st),sipType_wxString,stState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetMultiLineTextExtent, "GetMultiLineTextExtent(st) -> Size\n"
"\n"
"Return the dimensions of the given string's text extent using the\n"
"currently selected font, taking into account multiple lines if\n"
"present in the string.\n"
"\n"
":param st: The string to be measured\n"
"\n"
".. seealso:: :meth:`~wx.DC.GetFullMultiLineTextExtent`");

extern "C" {static PyObject *meth_wxDC_GetMultiLineTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetMultiLineTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* st;
        int stState = 0;
        const  ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_st,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString,&st, &stState))
        {
             ::wxSize*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetMultiLineTextExtent(sipCpp, st);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(st),sipType_wxString,stState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetMultiLineTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetHDC, "GetHDC() -> long");

extern "C" {static PyObject *meth_wxDC_GetHDC(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetHDC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetHDC(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetHDC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetCGContext, "GetCGContext() -> UIntPtr");

extern "C" {static PyObject *meth_wxDC_GetCGContext(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetCGContext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetCGContext(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxUIntPtr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetCGContext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC_GetGdkDrawable, "GetGdkDrawable() -> UIntPtr");

extern "C" {static PyObject *meth_wxDC_GetGdkDrawable(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetGdkDrawable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
             ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetGdkDrawable(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxUIntPtr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName_GetGdkDrawable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawPointList, "_DrawPointList(pyCoords, pyPens, pyBrushes) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawPointList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawPointList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawPointList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawPointList, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawLineList, "_DrawLineList(pyCoords, pyPens, pyBrushes) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawLineList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawLineList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawLineList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawLineList, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawRectangleList, "_DrawRectangleList(pyCoords, pyPens, pyBrushes) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawRectangleList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawRectangleList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawRectangleList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawRectangleList, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawEllipseList, "_DrawEllipseList(pyCoords, pyPens, pyBrushes) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawEllipseList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawEllipseList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawEllipseList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawEllipseList, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawPolygonList, "_DrawPolygonList(pyCoords, pyPens, pyBrushes) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawPolygonList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawPolygonList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawPolygonList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawPolygonList, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDC__DrawTextList, "_DrawTextList(textList, pyPoints, foregroundList, backgroundList) -> PyObject");

extern "C" {static PyObject *meth_wxDC__DrawTextList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawTextList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * textList;
        PyObject * pyPoints;
        PyObject * foregroundList;
        PyObject * backgroundList;
         ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_textList,
            sipName_pyPoints,
            sipName_foregroundList,
            sipName_backgroundList,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &textList, &pyPoints, &foregroundList, &backgroundList))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawTextList(sipCpp, textList, pyPoints, foregroundList, backgroundList);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawTextList, NULL);

    return NULL;
}


extern "C" {static int slot_wxDC___nonzero__(PyObject *);}
static int slot_wxDC___nonzero__(PyObject *sipSelf)
{
     ::wxDC *sipCpp = reinterpret_cast< ::wxDC *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDC));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxDC(void *, const sipTypeDef *);}
static void *cast_wxDC(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxDC *sipCpp = reinterpret_cast< ::wxDC *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDC(void *, int);}
static void release_wxDC(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDC *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDC(sipSimpleWrapper *);}
static void dealloc_wxDC(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDC(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxDC[] = {{352, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxDC[] = {
    {(void *)slot_wxDC___nonzero__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxDC[] = {
    {SIP_MLNAME_CAST(sipName_Blit), (PyCFunction)meth_wxDC_Blit, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_Blit)},
    {SIP_MLNAME_CAST(sipName_CalcBoundingBox), (PyCFunction)meth_wxDC_CalcBoundingBox, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_CalcBoundingBox)},
    {SIP_MLNAME_CAST(sipName_CanDrawBitmap), meth_wxDC_CanDrawBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_CanDrawBitmap)},
    {SIP_MLNAME_CAST(sipName_CanGetTextExtent), meth_wxDC_CanGetTextExtent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_CanGetTextExtent)},
    {SIP_MLNAME_CAST(sipName_CanUseTransformMatrix), meth_wxDC_CanUseTransformMatrix, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_CanUseTransformMatrix)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxDC_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_Clear)},
    {SIP_MLNAME_CAST(sipName_CopyAttributes), (PyCFunction)meth_wxDC_CopyAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_CopyAttributes)},
    {SIP_MLNAME_CAST(sipName_CrossHair), (PyCFunction)meth_wxDC_CrossHair, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_CrossHair)},
    {SIP_MLNAME_CAST(sipName_DestroyClippingRegion), meth_wxDC_DestroyClippingRegion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_DestroyClippingRegion)},
    {SIP_MLNAME_CAST(sipName_DeviceToLogicalX), (PyCFunction)meth_wxDC_DeviceToLogicalX, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DeviceToLogicalX)},
    {SIP_MLNAME_CAST(sipName_DeviceToLogicalXRel), (PyCFunction)meth_wxDC_DeviceToLogicalXRel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DeviceToLogicalXRel)},
    {SIP_MLNAME_CAST(sipName_DeviceToLogicalY), (PyCFunction)meth_wxDC_DeviceToLogicalY, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DeviceToLogicalY)},
    {SIP_MLNAME_CAST(sipName_DeviceToLogicalYRel), (PyCFunction)meth_wxDC_DeviceToLogicalYRel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DeviceToLogicalYRel)},
    {SIP_MLNAME_CAST(sipName_DrawArc), (PyCFunction)meth_wxDC_DrawArc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawArc)},
    {SIP_MLNAME_CAST(sipName_DrawBitmap), (PyCFunction)meth_wxDC_DrawBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawBitmap)},
    {SIP_MLNAME_CAST(sipName_DrawCheckMark), (PyCFunction)meth_wxDC_DrawCheckMark, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawCheckMark)},
    {SIP_MLNAME_CAST(sipName_DrawCircle), (PyCFunction)meth_wxDC_DrawCircle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawCircle)},
    {SIP_MLNAME_CAST(sipName_DrawEllipse), (PyCFunction)meth_wxDC_DrawEllipse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawEllipse)},
    {SIP_MLNAME_CAST(sipName_DrawEllipticArc), (PyCFunction)meth_wxDC_DrawEllipticArc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawEllipticArc)},
    {SIP_MLNAME_CAST(sipName_DrawIcon), (PyCFunction)meth_wxDC_DrawIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawIcon)},
    {SIP_MLNAME_CAST(sipName_DrawLabel), (PyCFunction)meth_wxDC_DrawLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawLabel)},
    {SIP_MLNAME_CAST(sipName_DrawLine), (PyCFunction)meth_wxDC_DrawLine, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawLine)},
    {SIP_MLNAME_CAST(sipName_DrawLines), (PyCFunction)meth_wxDC_DrawLines, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawLines)},
    {SIP_MLNAME_CAST(sipName_DrawPoint), (PyCFunction)meth_wxDC_DrawPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawPoint)},
    {SIP_MLNAME_CAST(sipName_DrawPolygon), (PyCFunction)meth_wxDC_DrawPolygon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawPolygon)},
    {SIP_MLNAME_CAST(sipName_DrawRectangle), (PyCFunction)meth_wxDC_DrawRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawRectangle)},
    {SIP_MLNAME_CAST(sipName_DrawRotatedText), (PyCFunction)meth_wxDC_DrawRotatedText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawRotatedText)},
    {SIP_MLNAME_CAST(sipName_DrawRoundedRectangle), (PyCFunction)meth_wxDC_DrawRoundedRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawRoundedRectangle)},
    {SIP_MLNAME_CAST(sipName_DrawSpline), (PyCFunction)meth_wxDC_DrawSpline, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawSpline)},
    {SIP_MLNAME_CAST(sipName_DrawText), (PyCFunction)meth_wxDC_DrawText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_DrawText)},
    {SIP_MLNAME_CAST(sipName_EndDoc), meth_wxDC_EndDoc, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_EndDoc)},
    {SIP_MLNAME_CAST(sipName_EndPage), meth_wxDC_EndPage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_EndPage)},
    {SIP_MLNAME_CAST(sipName_FloodFill), (PyCFunction)meth_wxDC_FloodFill, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_FloodFill)},
    {SIP_MLNAME_CAST(sipName_GetAsBitmap), (PyCFunction)meth_wxDC_GetAsBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetAsBitmap)},
    {SIP_MLNAME_CAST(sipName_GetBackground), meth_wxDC_GetBackground, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetBackground)},
    {SIP_MLNAME_CAST(sipName_GetBackgroundMode), meth_wxDC_GetBackgroundMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetBackgroundMode)},
    {SIP_MLNAME_CAST(sipName_GetBrush), meth_wxDC_GetBrush, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetBrush)},
    {SIP_MLNAME_CAST(sipName_GetCGContext), meth_wxDC_GetCGContext, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetCGContext)},
    {SIP_MLNAME_CAST(sipName_GetCharHeight), meth_wxDC_GetCharHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetCharHeight)},
    {SIP_MLNAME_CAST(sipName_GetCharWidth), meth_wxDC_GetCharWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetCharWidth)},
    {SIP_MLNAME_CAST(sipName_GetClippingBox), (PyCFunction)meth_wxDC_GetClippingBox, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetClippingBox)},
    {SIP_MLNAME_CAST(sipName_GetDepth), meth_wxDC_GetDepth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetDepth)},
    {SIP_MLNAME_CAST(sipName_GetDeviceOrigin), meth_wxDC_GetDeviceOrigin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetDeviceOrigin)},
    {SIP_MLNAME_CAST(sipName_GetFont), meth_wxDC_GetFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetFontMetrics), meth_wxDC_GetFontMetrics, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetFontMetrics)},
    {SIP_MLNAME_CAST(sipName_GetFullMultiLineTextExtent), (PyCFunction)meth_wxDC_GetFullMultiLineTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetFullMultiLineTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetFullTextExtent), (PyCFunction)meth_wxDC_GetFullTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetFullTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetGdkDrawable), meth_wxDC_GetGdkDrawable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetGdkDrawable)},
    {SIP_MLNAME_CAST(sipName_GetHDC), meth_wxDC_GetHDC, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetHDC)},
    {SIP_MLNAME_CAST(sipName_GetHandle), meth_wxDC_GetHandle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetHandle)},
    {SIP_MLNAME_CAST(sipName_GetLayoutDirection), meth_wxDC_GetLayoutDirection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetLayoutDirection)},
    {SIP_MLNAME_CAST(sipName_GetLogicalFunction), meth_wxDC_GetLogicalFunction, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetLogicalFunction)},
    {SIP_MLNAME_CAST(sipName_GetLogicalOrigin), (PyCFunction)meth_wxDC_GetLogicalOrigin, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetLogicalOrigin)},
    {SIP_MLNAME_CAST(sipName_GetLogicalScale), (PyCFunction)meth_wxDC_GetLogicalScale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetLogicalScale)},
    {SIP_MLNAME_CAST(sipName_GetMapMode), meth_wxDC_GetMapMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetMapMode)},
    {SIP_MLNAME_CAST(sipName_GetMultiLineTextExtent), (PyCFunction)meth_wxDC_GetMultiLineTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetMultiLineTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetPPI), meth_wxDC_GetPPI, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetPPI)},
    {SIP_MLNAME_CAST(sipName_GetPartialTextExtents), (PyCFunction)meth_wxDC_GetPartialTextExtents, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetPartialTextExtents)},
    {SIP_MLNAME_CAST(sipName_GetPen), meth_wxDC_GetPen, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetPen)},
    {SIP_MLNAME_CAST(sipName_GetPixel), (PyCFunction)meth_wxDC_GetPixel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetPixel)},
    {SIP_MLNAME_CAST(sipName_GetSize), meth_wxDC_GetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetSize)},
    {SIP_MLNAME_CAST(sipName_GetSizeMM), meth_wxDC_GetSizeMM, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetSizeMM)},
    {SIP_MLNAME_CAST(sipName_GetTextBackground), meth_wxDC_GetTextBackground, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetTextBackground)},
    {SIP_MLNAME_CAST(sipName_GetTextExtent), (PyCFunction)meth_wxDC_GetTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetTextForeground), meth_wxDC_GetTextForeground, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetTextForeground)},
    {SIP_MLNAME_CAST(sipName_GetTransformMatrix), meth_wxDC_GetTransformMatrix, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_GetTransformMatrix)},
    {SIP_MLNAME_CAST(sipName_GetUserScale), (PyCFunction)meth_wxDC_GetUserScale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GetUserScale)},
    {SIP_MLNAME_CAST(sipName_GradientFillConcentric), (PyCFunction)meth_wxDC_GradientFillConcentric, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GradientFillConcentric)},
    {SIP_MLNAME_CAST(sipName_GradientFillLinear), (PyCFunction)meth_wxDC_GradientFillLinear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_GradientFillLinear)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxDC_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_IsOk)},
    {SIP_MLNAME_CAST(sipName_LogicalToDeviceX), (PyCFunction)meth_wxDC_LogicalToDeviceX, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_LogicalToDeviceX)},
    {SIP_MLNAME_CAST(sipName_LogicalToDeviceXRel), (PyCFunction)meth_wxDC_LogicalToDeviceXRel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_LogicalToDeviceXRel)},
    {SIP_MLNAME_CAST(sipName_LogicalToDeviceY), (PyCFunction)meth_wxDC_LogicalToDeviceY, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_LogicalToDeviceY)},
    {SIP_MLNAME_CAST(sipName_LogicalToDeviceYRel), (PyCFunction)meth_wxDC_LogicalToDeviceYRel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_LogicalToDeviceYRel)},
    {SIP_MLNAME_CAST(sipName_MaxX), meth_wxDC_MaxX, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_MaxX)},
    {SIP_MLNAME_CAST(sipName_MaxY), meth_wxDC_MaxY, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_MaxY)},
    {SIP_MLNAME_CAST(sipName_MinX), meth_wxDC_MinX, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_MinX)},
    {SIP_MLNAME_CAST(sipName_MinY), meth_wxDC_MinY, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_MinY)},
    {SIP_MLNAME_CAST(sipName_ResetBoundingBox), meth_wxDC_ResetBoundingBox, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_ResetBoundingBox)},
    {SIP_MLNAME_CAST(sipName_ResetTransformMatrix), meth_wxDC_ResetTransformMatrix, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_ResetTransformMatrix)},
    {SIP_MLNAME_CAST(sipName_SetAxisOrientation), (PyCFunction)meth_wxDC_SetAxisOrientation, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetAxisOrientation)},
    {SIP_MLNAME_CAST(sipName_SetBackground), (PyCFunction)meth_wxDC_SetBackground, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetBackground)},
    {SIP_MLNAME_CAST(sipName_SetBackgroundMode), (PyCFunction)meth_wxDC_SetBackgroundMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetBackgroundMode)},
    {SIP_MLNAME_CAST(sipName_SetBrush), (PyCFunction)meth_wxDC_SetBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetBrush)},
    {SIP_MLNAME_CAST(sipName_SetClippingRegion), (PyCFunction)meth_wxDC_SetClippingRegion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetClippingRegion)},
    {SIP_MLNAME_CAST(sipName_SetDeviceClippingRegion), (PyCFunction)meth_wxDC_SetDeviceClippingRegion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetDeviceClippingRegion)},
    {SIP_MLNAME_CAST(sipName_SetDeviceOrigin), (PyCFunction)meth_wxDC_SetDeviceOrigin, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetDeviceOrigin)},
    {SIP_MLNAME_CAST(sipName_SetFont), (PyCFunction)meth_wxDC_SetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetLayoutDirection), (PyCFunction)meth_wxDC_SetLayoutDirection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetLayoutDirection)},
    {SIP_MLNAME_CAST(sipName_SetLogicalFunction), (PyCFunction)meth_wxDC_SetLogicalFunction, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetLogicalFunction)},
    {SIP_MLNAME_CAST(sipName_SetLogicalOrigin), (PyCFunction)meth_wxDC_SetLogicalOrigin, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetLogicalOrigin)},
    {SIP_MLNAME_CAST(sipName_SetLogicalScale), (PyCFunction)meth_wxDC_SetLogicalScale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetLogicalScale)},
    {SIP_MLNAME_CAST(sipName_SetMapMode), (PyCFunction)meth_wxDC_SetMapMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetMapMode)},
    {SIP_MLNAME_CAST(sipName_SetPalette), (PyCFunction)meth_wxDC_SetPalette, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetPalette)},
    {SIP_MLNAME_CAST(sipName_SetPen), (PyCFunction)meth_wxDC_SetPen, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetPen)},
    {SIP_MLNAME_CAST(sipName_SetTextBackground), (PyCFunction)meth_wxDC_SetTextBackground, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetTextBackground)},
    {SIP_MLNAME_CAST(sipName_SetTextForeground), (PyCFunction)meth_wxDC_SetTextForeground, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetTextForeground)},
    {SIP_MLNAME_CAST(sipName_SetTransformMatrix), (PyCFunction)meth_wxDC_SetTransformMatrix, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetTransformMatrix)},
    {SIP_MLNAME_CAST(sipName_SetUserScale), (PyCFunction)meth_wxDC_SetUserScale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_SetUserScale)},
    {SIP_MLNAME_CAST(sipName_StartDoc), (PyCFunction)meth_wxDC_StartDoc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_StartDoc)},
    {SIP_MLNAME_CAST(sipName_StartPage), meth_wxDC_StartPage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDC_StartPage)},
    {SIP_MLNAME_CAST(sipName_StretchBlit), (PyCFunction)meth_wxDC_StretchBlit, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC_StretchBlit)},
    {SIP_MLNAME_CAST(sipName__DrawEllipseList), (PyCFunction)meth_wxDC__DrawEllipseList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawEllipseList)},
    {SIP_MLNAME_CAST(sipName__DrawLineList), (PyCFunction)meth_wxDC__DrawLineList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawLineList)},
    {SIP_MLNAME_CAST(sipName__DrawPointList), (PyCFunction)meth_wxDC__DrawPointList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawPointList)},
    {SIP_MLNAME_CAST(sipName__DrawPolygonList), (PyCFunction)meth_wxDC__DrawPolygonList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawPolygonList)},
    {SIP_MLNAME_CAST(sipName__DrawRectangleList), (PyCFunction)meth_wxDC__DrawRectangleList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawRectangleList)},
    {SIP_MLNAME_CAST(sipName__DrawTextList), (PyCFunction)meth_wxDC__DrawTextList, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDC__DrawTextList)}
};

sipVariableDef variables_wxDC[] = {
    {PropertyVariable, sipName_TransformMatrix, &methods_wxDC[65], &methods_wxDC[97], NULL, NULL},
    {PropertyVariable, sipName_TextForeground, &methods_wxDC[64], &methods_wxDC[96], NULL, NULL},
    {PropertyVariable, sipName_TextExtent, &methods_wxDC[63], NULL, NULL, NULL},
    {PropertyVariable, sipName_TextBackground, &methods_wxDC[62], &methods_wxDC[95], NULL, NULL},
    {PropertyVariable, sipName_SizeMM, &methods_wxDC[61], NULL, NULL, NULL},
    {PropertyVariable, sipName_Size, &methods_wxDC[60], NULL, NULL, NULL},
    {PropertyVariable, sipName_Pixel, &methods_wxDC[59], NULL, NULL, NULL},
    {PropertyVariable, sipName_Pen, &methods_wxDC[58], &methods_wxDC[94], NULL, NULL},
    {PropertyVariable, sipName_PPI, &methods_wxDC[56], NULL, NULL, NULL},
    {PropertyVariable, sipName_MultiLineTextExtent, &methods_wxDC[55], NULL, NULL, NULL},
    {PropertyVariable, sipName_MapMode, &methods_wxDC[54], &methods_wxDC[92], NULL, NULL},
    {PropertyVariable, sipName_LogicalFunction, &methods_wxDC[51], &methods_wxDC[89], NULL, NULL},
    {PropertyVariable, sipName_LayoutDirection, &methods_wxDC[50], &methods_wxDC[88], NULL, NULL},
    {PropertyVariable, sipName_Handle, &methods_wxDC[49], NULL, NULL, NULL},
    {PropertyVariable, sipName_HDC, &methods_wxDC[48], NULL, NULL, NULL},
    {PropertyVariable, sipName_GdkDrawable, &methods_wxDC[47], NULL, NULL, NULL},
    {PropertyVariable, sipName_FontMetrics, &methods_wxDC[44], NULL, NULL, NULL},
    {PropertyVariable, sipName_Font, &methods_wxDC[43], &methods_wxDC[87], NULL, NULL},
    {PropertyVariable, sipName_DeviceOrigin, &methods_wxDC[42], &methods_wxDC[86], NULL, NULL},
    {PropertyVariable, sipName_Depth, &methods_wxDC[41], NULL, NULL, NULL},
    {PropertyVariable, sipName_CharWidth, &methods_wxDC[39], NULL, NULL, NULL},
    {PropertyVariable, sipName_CharHeight, &methods_wxDC[38], NULL, NULL, NULL},
    {PropertyVariable, sipName_CGContext, &methods_wxDC[37], NULL, NULL, NULL},
    {PropertyVariable, sipName_Brush, &methods_wxDC[36], &methods_wxDC[83], NULL, NULL},
    {PropertyVariable, sipName_BackgroundMode, &methods_wxDC[35], &methods_wxDC[82], NULL, NULL},
    {PropertyVariable, sipName_Background, &methods_wxDC[34], &methods_wxDC[81], NULL, NULL},
    {PropertyVariable, sipName_AsBitmap, &methods_wxDC[33], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxDC, "A wxDC is a \"device context\" onto which graphics and text can be\n"
"drawn.");


sipClassTypeDef sipTypeDef__core_wxDC = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxDC,
        {0},
        0
    },
    {
        sipNameNr_DC,
        {0, 0, 1},
        108, methods_wxDC,
        0, 0,
        27, variables_wxDC,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxDC,
    -1,
    -1,
    supers_wxDC,
    slots_wxDC,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxDC,
    0,
    0,
    0,
    release_wxDC,
    cast_wxDC,
    0,
    0,
    0,
    0,
    0,
    0
};
