/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/datetime.h>

        #include <wx/datetime.h>
        #include <wx/datetime.h>
        #include <wx/datetime.h>
            #include <wx/datetime.h>
        #include <wx/datetime.h>
            #include <wx/datetime.h>
    int _wxDateTime_ParseDate(wxDateTime* self, const wxString *date)
    {
        wxString::const_iterator begin = date->begin();
        wxString::const_iterator end;
        if (! self->ParseDate(*date, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseDateTime(wxDateTime* self, const wxString *datetime)
    {
        wxString::const_iterator begin = datetime->begin();
        wxString::const_iterator end;
        if (! self->ParseDateTime(*datetime, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseFormat(wxDateTime* self, const wxString *date, const wxString *format, const wxDateTime *dateDef)
    {
        wxString::const_iterator begin = date->begin();
        wxString::const_iterator end;
        if (! self->ParseFormat(*date, *format, *dateDef, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseFormat(wxDateTime* self, const wxString *date, const wxString *format)
    {
        wxString::const_iterator begin = date->begin();
        wxString::const_iterator end;
        if (! self->ParseFormat(*date, *format, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseFormat(wxDateTime* self, const wxString *date)
    {
        wxString::const_iterator begin = date->begin();
        wxString::const_iterator end;
        if (! self->ParseFormat(*date, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseRfc822Date(wxDateTime* self, const wxString *date)
    {
        wxString::const_iterator begin = date->begin();
        wxString::const_iterator end;
        if (! self->ParseRfc822Date(*date, &end))
            return -1;
        return end - begin;
    }
    int _wxDateTime_ParseTime(wxDateTime* self, const wxString *time)
    {
        wxString::const_iterator begin = time->begin();
        wxString::const_iterator end;
        if (! self->ParseTime(*time, &end))
            return -1;
        return end - begin;
    }
    wxDateTime* _wxDateTime_FromTimeT(time_t timet)
    {
        return new wxDateTime(timet);
    }
    wxDateTime* _wxDateTime_FromJDN(double jdn)
    {
        return new wxDateTime(jdn);
    }
    wxDateTime* _wxDateTime_FromHMS(unsigned short hour, unsigned short minute, unsigned short second, unsigned short millisecond)
    {
        return new wxDateTime(hour, minute, second, millisecond);
    }
    wxDateTime* _wxDateTime_FromDMY(unsigned short day, wxDateTime::Month month, int year, unsigned short hour, unsigned short minute, unsigned short second, unsigned short millisecond)
    {
        return new wxDateTime(day, month, year, hour, minute, second, millisecond);
    }


PyDoc_STRVAR(doc_wxDateTime_ResetTime, "ResetTime() -> DateTime\n"
"\n"
"Reset time to midnight (00:00:00) without changing the date.");

extern "C" {static PyObject *meth_wxDateTime_ResetTime(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ResetTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ResetTime();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ResetTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Set, "Set(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> DateTime\n"
"\n"
"Sets the date and time from the parameters.");

extern "C" {static PyObject *meth_wxDateTime_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short day;
         ::wxDateTime::Month month;
        int year =  ::wxDateTime::Inv_Year;
        unsigned short hour = 0;
        unsigned short minute = 0;
        unsigned short second = 0;
        unsigned short millisec = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_day,
            sipName_month,
            sipName_year,
            sipName_hour,
            sipName_minute,
            sipName_second,
            sipName_millisec,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BtE|itttt", &sipSelf, sipType_wxDateTime, &sipCpp, &day, sipType_wxDateTime_Month, &month, &year, &hour, &minute, &second, &millisec))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Set(day,month,year,hour,minute,second,millisec);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetHMS, "SetHMS(hour, minute=0, second=0, millisec=0) -> DateTime\n"
"\n"
"Sets the date to be equal to Today() and the time from supplied\n"
"parameters.");

extern "C" {static PyObject *meth_wxDateTime_SetHMS(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetHMS(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short hour;
        unsigned short minute = 0;
        unsigned short second = 0;
        unsigned short millisec = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hour,
            sipName_minute,
            sipName_second,
            sipName_millisec,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt|ttt", &sipSelf, sipType_wxDateTime, &sipCpp, &hour, &minute, &second, &millisec))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Set(hour,minute,second,millisec);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetHMS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetJDN, "SetJDN(jdn) -> DateTime\n"
"\n"
"Sets the date from the so-called Julian Day Number.");

extern "C" {static PyObject *meth_wxDateTime_SetJDN(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetJDN(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double jdn;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_jdn,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bd", &sipSelf, sipType_wxDateTime, &sipCpp, &jdn))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Set(jdn);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetJDN, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetTimeT, "SetTimeT(timet) -> DateTime\n"
"\n"
"Constructs the object from timet value holding the number of seconds\n"
"since Jan 1, 1970 UTC.");

extern "C" {static PyObject *meth_wxDateTime_SetTimeT(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetTimeT(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::time_t timet;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_timet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxDateTime, &sipCpp, &timet))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Set(timet);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetTimeT, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetTm, "SetTm(tm) -> DateTime\n"
"\n"
"Sets the date and time from the broken down representation in the\n"
"wxDateTime::Tm structure.");

extern "C" {static PyObject *meth_wxDateTime_SetTm(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetTm(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::Tm* tm;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tm,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Tm, &tm))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Set(*tm);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetTm, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetDay, "SetDay(day) -> DateTime\n"
"\n"
"Sets the day without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short day;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_day,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &day))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetDay(day);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetFromDOS, "SetFromDOS(ddt) -> DateTime\n"
"\n"
"Sets the date from the date and time in DOS format.");

extern "C" {static PyObject *meth_wxDateTime_SetFromDOS(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetFromDOS(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned long ddt;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ddt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bm", &sipSelf, sipType_wxDateTime, &sipCpp, &ddt))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetFromDOS(ddt);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetFromDOS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetHour, "SetHour(hour) -> DateTime\n"
"\n"
"Sets the hour without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetHour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetHour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short hour;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &hour))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetHour(hour);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetHour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetMillisecond, "SetMillisecond(millisecond) -> DateTime\n"
"\n"
"Sets the millisecond without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetMillisecond(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetMillisecond(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short millisecond;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_millisecond,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &millisecond))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetMillisecond(millisecond);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetMillisecond, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetMinute, "SetMinute(minute) -> DateTime\n"
"\n"
"Sets the minute without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetMinute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetMinute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short minute;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_minute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &minute))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetMinute(minute);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetMinute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetMonth, "SetMonth(month) -> DateTime\n"
"\n"
"Sets the month without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetMonth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetMonth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_month,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Month, &month))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetMonth(month);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetMonth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetSecond, "SetSecond(second) -> DateTime\n"
"\n"
"Sets the second without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetSecond(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetSecond(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short second;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_second,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &second))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetSecond(second);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetSecond, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToCurrent, "SetToCurrent() -> DateTime\n"
"\n"
"Sets the date and time of to the current values.");

extern "C" {static PyObject *meth_wxDateTime_SetToCurrent(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToCurrent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToCurrent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToCurrent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetYear, "SetYear(year) -> DateTime\n"
"\n"
"Sets the year without changing other date components.");

extern "C" {static PyObject *meth_wxDateTime_SetYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetYear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxDateTime, &sipCpp, &year))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetYear(year);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetAsDOS, "GetAsDOS() -> unsignedlong\n"
"\n"
"Returns the date and time in DOS format.");

extern "C" {static PyObject *meth_wxDateTime_GetAsDOS(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetAsDOS(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAsDOS();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetAsDOS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetCentury, "GetCentury(tz=Local) -> int\n"
"\n"
"Returns the century of this date.");

extern "C" {static PyObject *meth_wxDateTime_GetCentury(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetCentury(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCentury(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetCentury, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetDateOnly, "GetDateOnly() -> DateTime\n"
"\n"
"Returns the object having the same date component as this one but time\n"
"of 00:00:00.");

extern "C" {static PyObject *meth_wxDateTime_GetDateOnly(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetDateOnly(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetDateOnly());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetDateOnly, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetDay, "GetDay(tz=Local) -> unsignedshort\n"
"\n"
"Returns the day in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDay(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetDayOfYear, "GetDayOfYear(tz=Local) -> unsignedshort\n"
"\n"
"Returns the day of the year (in 1-366 range) in the given timezone\n"
"(local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetDayOfYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetDayOfYear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDayOfYear(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetDayOfYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetHour, "GetHour(tz=Local) -> unsignedshort\n"
"\n"
"Returns the hour in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetHour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetHour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHour(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetHour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetMillisecond, "GetMillisecond(tz=Local) -> unsignedshort\n"
"\n"
"Returns the milliseconds in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetMillisecond(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetMillisecond(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMillisecond(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetMillisecond, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetMinute, "GetMinute(tz=Local) -> unsignedshort\n"
"\n"
"Returns the minute in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetMinute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetMinute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMinute(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetMinute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetMonth, "GetMonth(tz=Local) -> DateTime.Month\n"
"\n"
"Returns the month in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetMonth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetMonth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
             ::wxDateTime::Month sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMonth(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDateTime_Month);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetMonth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetSecond, "GetSecond(tz=Local) -> unsignedshort\n"
"\n"
"Returns the seconds in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetSecond(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetSecond(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSecond(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetSecond, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetTicks, "GetTicks() -> time_t\n"
"\n"
"Returns the number of seconds since Jan 1, 1970 UTC.");

extern "C" {static PyObject *meth_wxDateTime_GetTicks(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetTicks(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::time_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTicks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetTicks, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetTm, "GetTm(tz=Local) -> DateTime.Tm\n"
"\n"
"Returns broken down representation of the date and time.");

extern "C" {static PyObject *meth_wxDateTime_GetTm(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetTm(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
             ::wxDateTime::Tm*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime::Tm(sipCpp->GetTm(*tz));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime_Tm,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetTm, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetWeekDay, "GetWeekDay(tz=Local) -> DateTime.WeekDay\n"
"GetWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> DateTime\n"
"\n"
"Returns the week day in the given timezone (local one by default).\n"
"");

extern "C" {static PyObject *meth_wxDateTime_GetWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
             ::wxDateTime::WeekDay sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeekDay(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDateTime_WeekDay);
        }
    }

    {
         ::wxDateTime::WeekDay weekday;
        int n = 1;
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_n,
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|iEi", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, &n, sipType_wxDateTime_Month, &month, &year))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetWeekDay(weekday,n,month,year));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetWeekOfMonth, "GetWeekOfMonth(flags=Monday_First, tz=Local) -> unsignedshort\n"
"\n"
"Returns the ordinal number of the week in the month (in 1-5 range).");

extern "C" {static PyObject *meth_wxDateTime_GetWeekOfMonth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetWeekOfMonth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekFlags flags =  ::wxDateTime::Monday_First;
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|EJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekFlags, &flags, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeekOfMonth(flags,*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetWeekOfMonth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetWeekOfYear, "GetWeekOfYear(flags=Monday_First, tz=Local) -> unsignedshort\n"
"\n"
"Returns the number of the week of the year this date is in.");

extern "C" {static PyObject *meth_wxDateTime_GetWeekOfYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetWeekOfYear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekFlags flags =  ::wxDateTime::Monday_First;
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|EJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekFlags, &flags, sipType_wxDateTime_TimeZone, &tz))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeekOfYear(flags,*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetWeekOfYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetYear, "GetYear(tz=Local) -> int\n"
"\n"
"Returns the year in the given timezone (local one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetYear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetYear(*tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the object represents a valid time moment.");

extern "C" {static PyObject *meth_wxDateTime_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsValid, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsWorkDay, "IsWorkDay(country=Country_Default) -> bool\n"
"\n"
"Returns true is this day is not a holiday in the given country.");

extern "C" {static PyObject *meth_wxDateTime_IsWorkDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsWorkDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Country, &country))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsWorkDay(country);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsWorkDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsEarlierThan, "IsEarlierThan(datetime) -> bool\n"
"\n"
"Returns true if this date precedes the given one.");

extern "C" {static PyObject *meth_wxDateTime_IsEarlierThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsEarlierThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* datetime;
        int datetimeState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_datetime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &datetime, &datetimeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEarlierThan(*datetime);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(datetime),sipType_wxDateTime,datetimeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsEarlierThan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsEqualTo, "IsEqualTo(datetime) -> bool\n"
"\n"
"Returns true if the two dates are strictly identical.");

extern "C" {static PyObject *meth_wxDateTime_IsEqualTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsEqualTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* datetime;
        int datetimeState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_datetime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &datetime, &datetimeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqualTo(*datetime);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(datetime),sipType_wxDateTime,datetimeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsEqualTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsEqualUpTo, "IsEqualUpTo(dt, ts) -> bool\n"
"\n"
"Returns true if the date is equal to another one up to the given time\n"
"interval, i.e. if the absolute difference between the two dates is\n"
"less than this interval.");

extern "C" {static PyObject *meth_wxDateTime_IsEqualUpTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsEqualUpTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;
        const  ::wxTimeSpan* ts;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dt,
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &dt, &dtState, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqualUpTo(*dt,*ts);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsEqualUpTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsLaterThan, "IsLaterThan(datetime) -> bool\n"
"\n"
"Returns true if this date is later than the given one.");

extern "C" {static PyObject *meth_wxDateTime_IsLaterThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsLaterThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* datetime;
        int datetimeState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_datetime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &datetime, &datetimeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLaterThan(*datetime);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(datetime),sipType_wxDateTime,datetimeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsLaterThan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsSameDate, "IsSameDate(dt) -> bool\n"
"\n"
"Returns true if the date is the same without comparing the time parts.");

extern "C" {static PyObject *meth_wxDateTime_IsSameDate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsSameDate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSameDate(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsSameDate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsSameTime, "IsSameTime(dt) -> bool\n"
"\n"
"Returns true if the time is the same (although dates may differ).");

extern "C" {static PyObject *meth_wxDateTime_IsSameTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsSameTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSameTime(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsSameTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsStrictlyBetween, "IsStrictlyBetween(t1, t2) -> bool\n"
"\n"
"Returns true if this date lies strictly between the two given dates.");

extern "C" {static PyObject *meth_wxDateTime_IsStrictlyBetween(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsStrictlyBetween(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* t1;
        int t1State = 0;
        const  ::wxDateTime* t2;
        int t2State = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t1,
            sipName_t2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &t1, &t1State, sipType_wxDateTime, &t2, &t2State))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsStrictlyBetween(*t1,*t2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(t1),sipType_wxDateTime,t1State);
            sipReleaseType(const_cast< ::wxDateTime *>(t2),sipType_wxDateTime,t2State);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsStrictlyBetween, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsBetween, "IsBetween(t1, t2) -> bool\n"
"\n"
"Returns true if IsStrictlyBetween() is true or if the date is equal to\n"
"one of the limit values.");

extern "C" {static PyObject *meth_wxDateTime_IsBetween(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsBetween(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* t1;
        int t1State = 0;
        const  ::wxDateTime* t2;
        int t2State = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t1,
            sipName_t2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &t1, &t1State, sipType_wxDateTime, &t2, &t2State))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsBetween(*t1,*t2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(t1),sipType_wxDateTime,t1State);
            sipReleaseType(const_cast< ::wxDateTime *>(t2),sipType_wxDateTime,t2State);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsBetween, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Add, "Add(diff) -> DateTime\n"
"Add(diff) -> DateTime\n"
"\n"
"Adds the given date span to this object.\n"
"");

extern "C" {static PyObject *meth_wxDateTime_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateSpan* diff;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateSpan, &diff))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
        const  ::wxTimeSpan* diff;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxTimeSpan, &diff))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Add, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Subtract, "Subtract(diff) -> DateTime\n"
"Subtract(diff) -> DateTime\n"
"Subtract(dt) -> TimeSpan\n"
"\n"
"Subtracts the given time span from this object.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDateTime_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxTimeSpan, &diff))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Subtract(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
        const  ::wxDateSpan* diff;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateSpan, &diff))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Subtract(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
        const  ::wxDateTime* dt;
        int dtState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &dt, &dtState))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan(sipCpp->Subtract(*dt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Subtract, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_DiffAsDateSpan, "DiffAsDateSpan(dt) -> DateSpan\n"
"\n"
"Returns the difference between this object and dt as a wxDateSpan.");

extern "C" {static PyObject *meth_wxDateTime_DiffAsDateSpan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_DiffAsDateSpan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime, &dt, &dtState))
        {
             ::wxDateSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateSpan(sipCpp->DiffAsDateSpan(*dt));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_DiffAsDateSpan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Format, "Format(format=DefaultDateTimeFormat, tz=Local) -> String\n"
"\n"
"This function does the same as the standard ANSI C strftime(3)\n"
"function\n"
"(http://www.cplusplus.com/reference/clibrary/ctime/strftime.html).");

extern "C" {static PyObject *meth_wxDateTime_Format(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Format(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString& formatdef = wxDefaultDateTimeFormat;
        const  ::wxString* format = &formatdef;
        int formatState = 0;
        const  ::wxDateTime::TimeZone& tzdef =  ::wxDateTime::Local;
        const  ::wxDateTime::TimeZone* tz = &tzdef;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
            sipName_tz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J1J9", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&format, &formatState, sipType_wxDateTime_TimeZone, &tz))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->Format(*format,*tz));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(format),sipType_wxString,formatState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Format, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FormatDate, "FormatDate() -> String\n"
"\n"
"Identical to calling Format() with \"%x\" argument (which means\n"
"\"preferred date representation for the current locale\").");

extern "C" {static PyObject *meth_wxDateTime_FormatDate(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FormatDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FormatDate());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FormatDate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FormatISOCombined, "FormatISOCombined(sep='T') -> String\n"
"\n"
"Returns the combined date-time representation in the ISO 8601 format\n"
"\"YYYY-MM-DDTHH:MM:SS\".");

extern "C" {static PyObject *meth_wxDateTime_FormatISOCombined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FormatISOCombined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        char sep = 'T';
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sep,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|c", &sipSelf, sipType_wxDateTime, &sipCpp, &sep))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FormatISOCombined(sep));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FormatISOCombined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FormatISODate, "FormatISODate() -> String\n"
"\n"
"This function returns the date representation in the ISO 8601 format\n"
"\"YYYY-MM-DD\".");

extern "C" {static PyObject *meth_wxDateTime_FormatISODate(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FormatISODate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FormatISODate());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FormatISODate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FormatISOTime, "FormatISOTime() -> String\n"
"\n"
"This function returns the time representation in the ISO 8601 format\n"
"\"HH:MM:SS\".");

extern "C" {static PyObject *meth_wxDateTime_FormatISOTime(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FormatISOTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FormatISOTime());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FormatISOTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FormatTime, "FormatTime() -> String\n"
"\n"
"Identical to calling Format() with \"%X\" argument (which means\n"
"\"preferred time representation for the current locale\").");

extern "C" {static PyObject *meth_wxDateTime_FormatTime(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FormatTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FormatTime());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FormatTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseDate, "ParseDate(date) -> int\n"
"\n"
"This function is like ParseDateTime(), but it only allows the date to\n"
"be specified.");

extern "C" {static PyObject *meth_wxDateTime_ParseDate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseDate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseDate(sipCpp, date);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseDate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseDateTime, "ParseDateTime(datetime) -> int\n"
"\n"
"Parses the string datetime containing the date and time in free\n"
"format.");

extern "C" {static PyObject *meth_wxDateTime_ParseDateTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseDateTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* datetime;
        int datetimeState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_datetime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&datetime, &datetimeState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseDateTime(sipCpp, datetime);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(datetime),sipType_wxString,datetimeState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseDateTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseFormat, "ParseFormat(date, format, dateDef) -> int\n"
"ParseFormat(date, format) -> int\n"
"ParseFormat(date) -> int\n"
"\n"
"This function parses the string date according to the given format.\n"
"ParseFormat(date, format) -> int\n"
"\n"
"This version of the :meth:`ParseFormat` method works the same, but\n"
"with missing values filled in from :meth:`Today`.\n"
"ParseFormat(date) -> int\n"
"\n"
"This version uses \"%c\" as the format code, which is the same default\n"
"used by :meth:`Format`.");

extern "C" {static PyObject *meth_wxDateTime_ParseFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
        const  ::wxString* format;
        int formatState = 0;
        const  ::wxDateTime* dateDef;
        int dateDefState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
            sipName_format,
            sipName_dateDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState, sipType_wxString,&format, &formatState, sipType_wxDateTime, &dateDef, &dateDefState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseFormat(sipCpp, date, format, dateDef);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);
            sipReleaseType(const_cast< ::wxString *>(format),sipType_wxString,formatState);
            sipReleaseType(const_cast< ::wxDateTime *>(dateDef),sipType_wxDateTime,dateDefState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* date;
        int dateState = 0;
        const  ::wxString* format;
        int formatState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState, sipType_wxString,&format, &formatState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseFormat(sipCpp, date, format);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);
            sipReleaseType(const_cast< ::wxString *>(format),sipType_wxString,formatState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* date;
        int dateState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseFormat(sipCpp, date);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseFormat, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseISOCombined, "ParseISOCombined(date, sep='T') -> bool\n"
"\n"
"This function parses the string containing the date and time in ISO\n"
"8601 combined format \"YYYY-MM-DDTHH:MM:SS\".");

extern "C" {static PyObject *meth_wxDateTime_ParseISOCombined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseISOCombined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
        char sep = 'T';
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
            sipName_sep,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|c", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState, &sep))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ParseISOCombined(*date,sep);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseISOCombined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseISODate, "ParseISODate(date) -> bool\n"
"\n"
"This function parses the date in ISO 8601 format \"YYYY-MM-DD\".");

extern "C" {static PyObject *meth_wxDateTime_ParseISODate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseISODate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ParseISODate(*date);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseISODate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseISOTime, "ParseISOTime(date) -> bool\n"
"\n"
"This function parses the time in ISO 8601 format \"HH:MM:SS\".");

extern "C" {static PyObject *meth_wxDateTime_ParseISOTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseISOTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ParseISOTime(*date);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseISOTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseRfc822Date, "ParseRfc822Date(date) -> int\n"
"\n"
"Parses the string date looking for a date formatted according to the\n"
"RFC 822 in it.");

extern "C" {static PyObject *meth_wxDateTime_ParseRfc822Date(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseRfc822Date(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* date;
        int dateState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&date, &dateState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseRfc822Date(sipCpp, date);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(date),sipType_wxString,dateState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseRfc822Date, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ParseTime, "ParseTime(time) -> int\n"
"\n"
"This functions is like ParseDateTime(), but only allows the time to be\n"
"specified in the input string.");

extern "C" {static PyObject *meth_wxDateTime_ParseTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ParseTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* time;
        int timeState = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_time,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxString,&time, &timeState))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_ParseTime(sipCpp, time);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(time),sipType_wxString,timeState);

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ParseTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetLastMonthDay, "GetLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToLastMonthDay() was\n"
"applied.");

extern "C" {static PyObject *meth_wxDateTime_GetLastMonthDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetLastMonthDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|Ei", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Month, &month, &year))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetLastMonthDay(month,year));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetLastMonthDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetLastWeekDay, "GetLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToLastWeekDay() was\n"
"applied.");

extern "C" {static PyObject *meth_wxDateTime_GetLastWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetLastWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|Ei", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_Month, &month, &year))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetLastWeekDay(weekday,month,year));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetLastWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetNextWeekDay, "GetNextWeekDay(weekday) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToNextWeekDay() was\n"
"applied.");

extern "C" {static PyObject *meth_wxDateTime_GetNextWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetNextWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetNextWeekDay(weekday));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetNextWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetPrevWeekDay, "GetPrevWeekDay(weekday) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToPrevWeekDay() was\n"
"applied.");

extern "C" {static PyObject *meth_wxDateTime_GetPrevWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetPrevWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetPrevWeekDay(weekday));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetPrevWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetWeekDayInSameWeek, "GetWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToWeekDayInSameWeek() was\n"
"applied.");

extern "C" {static PyObject *meth_wxDateTime_GetWeekDayInSameWeek(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetWeekDayInSameWeek(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::WeekFlags flags =  ::wxDateTime::Monday_First;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|E", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_WeekFlags, &flags))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetWeekDayInSameWeek(weekday,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetWeekDayInSameWeek, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetYearDay, "GetYearDay(yday) -> DateTime\n"
"\n"
"Returns the copy of this object to which SetToYearDay() was applied.");

extern "C" {static PyObject *meth_wxDateTime_GetYearDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetYearDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short yday;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_yday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &yday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetYearDay(yday));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetYearDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToLastMonthDay, "SetToLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime\n"
"\n"
"Sets the date to the last day in the specified month (the current one\n"
"by default).");

extern "C" {static PyObject *meth_wxDateTime_SetToLastMonthDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToLastMonthDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|Ei", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Month, &month, &year))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToLastMonthDay(month,year);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToLastMonthDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToLastWeekDay, "SetToLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> bool\n"
"\n"
"The effect of calling this function is the same as of calling\n"
"SetToWeekDay(-1, weekday, month, year).");

extern "C" {static PyObject *meth_wxDateTime_SetToLastWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToLastWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|Ei", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_Month, &month, &year))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetToLastWeekDay(weekday,month,year);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToLastWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToNextWeekDay, "SetToNextWeekDay(weekday) -> DateTime\n"
"\n"
"Sets the date so that it will be the first weekday following the\n"
"current date.");

extern "C" {static PyObject *meth_wxDateTime_SetToNextWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToNextWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToNextWeekDay(weekday);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToNextWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToPrevWeekDay, "SetToPrevWeekDay(weekday) -> DateTime\n"
"\n"
"Sets the date so that it will be the last weekday before the current\n"
"date.");

extern "C" {static PyObject *meth_wxDateTime_SetToPrevWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToPrevWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToPrevWeekDay(weekday);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToPrevWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToWeekDay, "SetToWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> bool\n"
"\n"
"Sets the date to the n-th weekday in the given month of the given year\n"
"(the current month and year are used by default).");

extern "C" {static PyObject *meth_wxDateTime_SetToWeekDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToWeekDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
        int n = 1;
         ::wxDateTime::Month month =  ::wxDateTime::Inv_Month;
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_n,
            sipName_month,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|iEi", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, &n, sipType_wxDateTime_Month, &month, &year))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetToWeekDay(weekday,n,month,year);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToWeekDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToWeekDayInSameWeek, "SetToWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime\n"
"\n"
"Adjusts the date so that it will still lie in the same week as before,\n"
"but its week day will be the given one.");

extern "C" {static PyObject *meth_wxDateTime_SetToWeekDayInSameWeek(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToWeekDayInSameWeek(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::WeekFlags flags =  ::wxDateTime::Monday_First;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE|E", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_WeekFlags, &flags))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToWeekDayInSameWeek(weekday,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToWeekDayInSameWeek, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToYearDay, "SetToYearDay(yday) -> DateTime\n"
"\n"
"Sets the date to the day number yday in the same year (i.e. unlike the\n"
"other functions, this one does not use the current year).");

extern "C" {static PyObject *meth_wxDateTime_SetToYearDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToYearDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short yday;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_yday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxDateTime, &sipCpp, &yday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetToYearDay(yday);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToYearDay, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetJDN, "GetJDN() -> double\n"
"\n"
"Synonym for GetJulianDayNumber().");

extern "C" {static PyObject *meth_wxDateTime_GetJDN(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetJDN(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetJDN();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetJDN, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetJulianDayNumber, "GetJulianDayNumber() -> double\n"
"\n"
"Returns the JDN corresponding to this date.");

extern "C" {static PyObject *meth_wxDateTime_GetJulianDayNumber(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetJulianDayNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetJulianDayNumber();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetJulianDayNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetMJD, "GetMJD() -> double\n"
"\n"
"Synonym for GetModifiedJulianDayNumber().");

extern "C" {static PyObject *meth_wxDateTime_GetMJD(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetMJD(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMJD();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetMJD, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetModifiedJulianDayNumber, "GetModifiedJulianDayNumber() -> double\n"
"\n"
"Returns the \"Modified Julian Day Number\" (MJD) which is, by\n"
"definition, is equal to JDN - 2400000.5.");

extern "C" {static PyObject *meth_wxDateTime_GetModifiedJulianDayNumber(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetModifiedJulianDayNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetModifiedJulianDayNumber();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetModifiedJulianDayNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetRataDie, "GetRataDie() -> double\n"
"\n"
"Return the Rata Die number of this date.");

extern "C" {static PyObject *meth_wxDateTime_GetRataDie(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetRataDie(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRataDie();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetRataDie, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FromTimezone, "FromTimezone(tz, noDST=False) -> DateTime\n"
"\n"
"Transform the date from the given time zone to the local one.");

extern "C" {static PyObject *meth_wxDateTime_FromTimezone(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FromTimezone(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone* tz;
        bool noDST = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->FromTimezone(*tz,noDST));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FromTimezone, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsDST, "IsDST(country=Country_Default) -> int\n"
"\n"
"Returns true if the DST is applied for this date in the given country.");

extern "C" {static PyObject *meth_wxDateTime_IsDST(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsDST(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_Country, &country))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDST(country);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsDST, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_MakeFromTimezone, "MakeFromTimezone(tz, noDST=False) -> DateTime\n"
"\n"
"Same as FromTimezone() but modifies the object in place.");

extern "C" {static PyObject *meth_wxDateTime_MakeFromTimezone(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_MakeFromTimezone(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone* tz;
        bool noDST = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeFromTimezone(*tz,noDST);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_MakeFromTimezone, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_MakeTimezone, "MakeTimezone(tz, noDST=False) -> DateTime\n"
"\n"
"Modifies the object in place to represent the date in another time\n"
"zone.");

extern "C" {static PyObject *meth_wxDateTime_MakeTimezone(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_MakeTimezone(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone* tz;
        bool noDST = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeTimezone(*tz,noDST);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_MakeTimezone, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_MakeUTC, "MakeUTC(noDST=False) -> DateTime\n"
"\n"
"This is the same as calling MakeTimezone() with the argument GMT0.");

extern "C" {static PyObject *meth_wxDateTime_MakeUTC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_MakeUTC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool noDST = 0;
         ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxDateTime, &sipCpp, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MakeUTC(noDST);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_MakeUTC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ToTimezone, "ToTimezone(tz, noDST=False) -> DateTime\n"
"\n"
"Transform the date to the given time zone.");

extern "C" {static PyObject *meth_wxDateTime_ToTimezone(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ToTimezone(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime::TimeZone* tz;
        bool noDST = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tz,
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxDateTime, &sipCpp, sipType_wxDateTime_TimeZone, &tz, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->ToTimezone(*tz,noDST));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ToTimezone, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ToUTC, "ToUTC(noDST=False) -> DateTime\n"
"\n"
"This is the same as calling ToTimezone() with the argument GMT0.");

extern "C" {static PyObject *meth_wxDateTime_ToUTC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ToUTC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool noDST = 0;
        const  ::wxDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_noDST,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxDateTime, &sipCpp, &noDST))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->ToUTC(noDST));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ToUTC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_ConvertYearToBC, "ConvertYearToBC(year) -> int\n"
"\n"
"Converts the year in absolute notation (i.e. a number which can be\n"
"negative, positive or zero) to the year in BC/AD notation.");

extern "C" {static PyObject *meth_wxDateTime_ConvertYearToBC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_ConvertYearToBC(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year;

        static const char *sipKwdList[] = {
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &year))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::ConvertYearToBC(year);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_ConvertYearToBC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetAmPmStrings, "GetAmPmStrings() -> (am, pm)\n"
"\n"
"Returns the translations of the strings AM and PM used for time\n"
"formatting for the current locale.");

extern "C" {static PyObject *meth_wxDateTime_GetAmPmStrings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetAmPmStrings(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxString* am;
         ::wxString* pm;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, ""))
        {
            am = new  ::wxString();
            pm = new  ::wxString();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxDateTime::GetAmPmStrings(am,pm);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(NN)",am,sipType_wxString,NULL,pm,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetAmPmStrings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetBeginDST, "GetBeginDST(year=Inv_Year, country=Country_Default) -> DateTime\n"
"\n"
"Get the beginning of DST for the given country in the given year\n"
"(current one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetBeginDST(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetBeginDST(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;

        static const char *sipKwdList[] = {
            sipName_year,
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|iE", &year, sipType_wxDateTime_Country, &country))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::GetBeginDST(year,country));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetBeginDST, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetEndDST, "GetEndDST(year=Inv_Year, country=Country_Default) -> DateTime\n"
"\n"
"Returns the end of DST for the given country in the given year\n"
"(current one by default).");

extern "C" {static PyObject *meth_wxDateTime_GetEndDST(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetEndDST(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;

        static const char *sipKwdList[] = {
            sipName_year,
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|iE", &year, sipType_wxDateTime_Country, &country))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::GetEndDST(year,country));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetEndDST, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetCountry, "GetCountry() -> Country\n"
"\n"
"Returns the current default country.");

extern "C" {static PyObject *meth_wxDateTime_GetCountry(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetCountry(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxDateTime::Country sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::GetCountry();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDateTime_Country);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetCountry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetCurrentMonth, "GetCurrentMonth(cal=Gregorian) -> DateTime.Month\n"
"\n"
"Get the current month in given calendar (only Gregorian is currently\n"
"supported).");

extern "C" {static PyObject *meth_wxDateTime_GetCurrentMonth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetCurrentMonth(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Calendar cal =  ::wxDateTime::Gregorian;

        static const char *sipKwdList[] = {
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|E", sipType_wxDateTime_Calendar, &cal))
        {
             ::wxDateTime::Month sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::GetCurrentMonth(cal);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDateTime_Month);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetCurrentMonth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetCurrentYear, "GetCurrentYear(cal=Gregorian) -> int\n"
"\n"
"Get the current year in given calendar (only Gregorian is currently\n"
"supported).");

extern "C" {static PyObject *meth_wxDateTime_GetCurrentYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetCurrentYear(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Calendar cal =  ::wxDateTime::Gregorian;

        static const char *sipKwdList[] = {
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|E", sipType_wxDateTime_Calendar, &cal))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::GetCurrentYear(cal);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetCurrentYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetEnglishMonthName, "GetEnglishMonthName(month, flags=Name_Full) -> String\n"
"\n"
"Return the standard English name of the given month.");

extern "C" {static PyObject *meth_wxDateTime_GetEnglishMonthName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetEnglishMonthName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month;
         ::wxDateTime::NameFlags flags =  ::wxDateTime::Name_Full;

        static const char *sipKwdList[] = {
            sipName_month,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|E", sipType_wxDateTime_Month, &month, sipType_wxDateTime_NameFlags, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxDateTime::GetEnglishMonthName(month,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetEnglishMonthName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetEnglishWeekDayName, "GetEnglishWeekDayName(weekday, flags=Name_Full) -> String\n"
"\n"
"Return the standard English name of the given week day.");

extern "C" {static PyObject *meth_wxDateTime_GetEnglishWeekDayName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetEnglishWeekDayName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::NameFlags flags =  ::wxDateTime::Name_Full;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|E", sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_NameFlags, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxDateTime::GetEnglishWeekDayName(weekday,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetEnglishWeekDayName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetMonthName, "GetMonthName(month, flags=Name_Full) -> String\n"
"\n"
"Gets the full (default) or abbreviated name of the given month.");

extern "C" {static PyObject *meth_wxDateTime_GetMonthName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetMonthName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month;
         ::wxDateTime::NameFlags flags =  ::wxDateTime::Name_Full;

        static const char *sipKwdList[] = {
            sipName_month,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|E", sipType_wxDateTime_Month, &month, sipType_wxDateTime_NameFlags, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxDateTime::GetMonthName(month,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetMonthName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetNumberOfDays, "GetNumberOfDays(month, year=Inv_Year, cal=Gregorian) -> unsignedshort\n"
"\n"
"Returns the number of days in the given month of the given year.");

extern "C" {static PyObject *meth_wxDateTime_GetNumberOfDays(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetNumberOfDays(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Month month;
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime::Calendar cal =  ::wxDateTime::Gregorian;

        static const char *sipKwdList[] = {
            sipName_month,
            sipName_year,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|iE", sipType_wxDateTime_Month, &month, &year, sipType_wxDateTime_Calendar, &cal))
        {
            unsigned short sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::GetNumberOfDays(month,year,cal);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetNumberOfDays, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetTimeNow, "GetTimeNow() -> time_t\n"
"\n"
"Returns the current time.");

extern "C" {static PyObject *meth_wxDateTime_GetTimeNow(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetTimeNow(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::time_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::GetTimeNow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetTimeNow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_GetWeekDayName, "GetWeekDayName(weekday, flags=Name_Full) -> String\n"
"\n"
"Gets the full (default) or abbreviated name of the given week day.");

extern "C" {static PyObject *meth_wxDateTime_GetWeekDayName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_GetWeekDayName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::WeekDay weekday;
         ::wxDateTime::NameFlags flags =  ::wxDateTime::Name_Full;

        static const char *sipKwdList[] = {
            sipName_weekday,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|E", sipType_wxDateTime_WeekDay, &weekday, sipType_wxDateTime_NameFlags, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxDateTime::GetWeekDayName(weekday,flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_GetWeekDayName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsDSTApplicable, "IsDSTApplicable(year=Inv_Year, country=Country_Default) -> bool\n"
"\n"
"Returns true if DST was used in the given year (the current one by\n"
"default) in the given country.");

extern "C" {static PyObject *meth_wxDateTime_IsDSTApplicable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsDSTApplicable(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;

        static const char *sipKwdList[] = {
            sipName_year,
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|iE", &year, sipType_wxDateTime_Country, &country))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::IsDSTApplicable(year,country);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsDSTApplicable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsLeapYear, "IsLeapYear(year=Inv_Year, cal=Gregorian) -> bool\n"
"\n"
"Returns true if the year is a leap one in the specified calendar.");

extern "C" {static PyObject *meth_wxDateTime_IsLeapYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsLeapYear(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year =  ::wxDateTime::Inv_Year;
         ::wxDateTime::Calendar cal =  ::wxDateTime::Gregorian;

        static const char *sipKwdList[] = {
            sipName_year,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|iE", &year, sipType_wxDateTime_Calendar, &cal))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::IsLeapYear(year,cal);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsLeapYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_IsWestEuropeanCountry, "IsWestEuropeanCountry(country=Country_Default) -> bool\n"
"\n"
"This function returns true if the specified (or default) country is\n"
"one of Western European ones.");

extern "C" {static PyObject *meth_wxDateTime_IsWestEuropeanCountry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_IsWestEuropeanCountry(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Country country =  ::wxDateTime::Country_Default;

        static const char *sipKwdList[] = {
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|E", sipType_wxDateTime_Country, &country))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDateTime::IsWestEuropeanCountry(country);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_IsWestEuropeanCountry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Now, "Now() -> DateTime\n"
"\n"
"Returns the object corresponding to the current time.");

extern "C" {static PyObject *meth_wxDateTime_Now(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Now(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::Now());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Now, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetCountry, "SetCountry(country)\n"
"\n"
"Sets the country to use by default.");

extern "C" {static PyObject *meth_wxDateTime_SetCountry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetCountry(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime::Country country;

        static const char *sipKwdList[] = {
            sipName_country,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxDateTime_Country, &country))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxDateTime::SetCountry(country);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetCountry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_SetToWeekOfYear, "SetToWeekOfYear(year, numWeek, weekday=Mon) -> DateTime\n"
"\n"
"Set the date to the given weekday in the week number numWeek of the\n"
"given year .");

extern "C" {static PyObject *meth_wxDateTime_SetToWeekOfYear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_SetToWeekOfYear(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int year;
        unsigned short numWeek;
         ::wxDateTime::WeekDay weekday =  ::wxDateTime::Mon;

        static const char *sipKwdList[] = {
            sipName_year,
            sipName_numWeek,
            sipName_weekday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "it|E", &year, &numWeek, sipType_wxDateTime_WeekDay, &weekday))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::SetToWeekOfYear(year,numWeek,weekday));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_SetToWeekOfYear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_Today, "Today() -> DateTime\n"
"\n"
"Returns the object corresponding to the midnight of the current day\n"
"(i.e. the same as Now(), but the time part is set to 0).");

extern "C" {static PyObject *meth_wxDateTime_Today(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_Today(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::Today());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_Today, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_UNow, "UNow() -> DateTime\n"
"\n"
"Returns the object corresponding to the current UTC time including the\n"
"milliseconds.");

extern "C" {static PyObject *meth_wxDateTime_UNow(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_UNow(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime( ::wxDateTime::UNow());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_UNow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FromTimeT, "FromTimeT(timet) -> DateTime\n"
"\n"
"Construct a :class:`DateTime` from a C ``time_t`` value, the number of\n"
"seconds since the epoch.");

extern "C" {static PyObject *meth_wxDateTime_FromTimeT(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FromTimeT(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::time_t timet;

        static const char *sipKwdList[] = {
            sipName_timet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &timet))
        {
             ::wxDateTime*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_FromTimeT(timet);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FromTimeT, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FromJDN, "FromJDN(jdn) -> DateTime\n"
"\n"
"Construct a :class:`DateTime` from a Julian Day Number.\n"
"\n"
"By definition, the Julian Day Number, usually abbreviated as JDN, of a\n"
"particular instant is the fractional number of days since 12 hours\n"
"Universal Coordinated Time (Greenwich mean noon) on January 1 of the\n"
"year -4712 in the Julian proleptic calendar.");

extern "C" {static PyObject *meth_wxDateTime_FromJDN(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FromJDN(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double jdn;

        static const char *sipKwdList[] = {
            sipName_jdn,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "d", &jdn))
        {
             ::wxDateTime*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_FromJDN(jdn);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FromJDN, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FromHMS, "FromHMS(hour, minute=0, second=0, millisecond=0) -> DateTime\n"
"\n"
"Construct a :class:`DateTime` equal to :meth:`Today` () with the time\n"
"set to the supplied parameters.");

extern "C" {static PyObject *meth_wxDateTime_FromHMS(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FromHMS(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short hour;
        unsigned short minute = 0;
        unsigned short second = 0;
        unsigned short millisecond = 0;

        static const char *sipKwdList[] = {
            sipName_hour,
            sipName_minute,
            sipName_second,
            sipName_millisecond,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "t|ttt", &hour, &minute, &second, &millisecond))
        {
             ::wxDateTime*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_FromHMS(hour, minute, second, millisecond);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FromHMS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDateTime_FromDMY, "FromDMY(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisecond=0) -> DateTime\n"
"\n"
"Construct a :class:`DateTime` using the supplied parameters.");

extern "C" {static PyObject *meth_wxDateTime_FromDMY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_FromDMY(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned short day;
         ::wxDateTime::Month month;
        int year =  ::wxDateTime::Inv_Year;
        unsigned short hour = 0;
        unsigned short minute = 0;
        unsigned short second = 0;
        unsigned short millisecond = 0;

        static const char *sipKwdList[] = {
            sipName_day,
            sipName_month,
            sipName_year,
            sipName_hour,
            sipName_minute,
            sipName_second,
            sipName_millisecond,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "tE|itttt", &day, sipType_wxDateTime_Month, &month, &year, &hour, &minute, &second, &millisecond))
        {
             ::wxDateTime*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDateTime_FromDMY(day, month, year, hour, minute, second, millisecond);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DateTime, sipName_FromDMY, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxDateTime___sub__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime* a0;
        int a0State = 0;
        const  ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J9", sipType_wxDateTime, &a0, &a0State, sipType_wxTimeSpan, &ts))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime((*a0 - *ts));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxDateTime,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
         ::wxDateTime* a0;
        int a0State = 0;
        const  ::wxDateSpan* ds;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J9", sipType_wxDateTime, &a0, &a0State, sipType_wxDateSpan, &ds))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime((*a0 - *ds));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxDateTime,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
         ::wxDateTime* a0;
        int a0State = 0;
        const  ::wxDateTime* dt2;
        int dt2State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxDateTime, &a0, &a0State, sipType_wxDateTime, &dt2, &dt2State))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan((*a0 - *dt2));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxDateTime,a0State);
            sipReleaseType(const_cast< ::wxDateTime *>(dt2),sipType_wxDateTime,dt2State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxDateTime___isub__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxDateTime)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxDateTime::operator-=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::wxDateSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxDateTime::operator-=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxDateTime___add__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDateTime* a0;
        int a0State = 0;
        const  ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J9", sipType_wxDateTime, &a0, &a0State, sipType_wxTimeSpan, &ts))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime((*a0 + *ts));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxDateTime,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    {
         ::wxDateTime* a0;
        int a0State = 0;
        const  ::wxDateSpan* ds;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J9", sipType_wxDateTime, &a0, &a0State, sipType_wxDateSpan, &ds))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime((*a0 + *ds));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxDateTime,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxDateTime___iadd__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxDateTime)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxDateTime::operator+=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::wxDateSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxDateSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxDateTime::operator+=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxDateTime___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator!=(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateTime___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator==(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateTime___ge__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___ge__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator>=(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ge_slot, sipType_wxDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateTime___gt__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___gt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator>(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, gt_slot, sipType_wxDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateTime___le__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___le__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator<=(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, le_slot, sipType_wxDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxDateTime___lt__(PyObject *,PyObject *);}
static PyObject *slot_wxDateTime___lt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxDateTime *sipCpp = reinterpret_cast< ::wxDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxDateTime));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxDateTime* dt;
        int dtState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxDateTime, &dt, &dtState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxDateTime::operator<(*dt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(dt),sipType_wxDateTime,dtState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, lt_slot, sipType_wxDateTime, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDateTime(void *, int);}
static void release_wxDateTime(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDateTime *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxDateTime(void *, SIP_SSIZE_T, void *);}
static void assign_wxDateTime(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDateTime *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDateTime *>(sipSrc);
}


extern "C" {static void *array_wxDateTime(SIP_SSIZE_T);}
static void *array_wxDateTime(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxDateTime[sipNrElem];
}


extern "C" {static void *copy_wxDateTime(const void *, SIP_SSIZE_T);}
static void *copy_wxDateTime(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxDateTime(reinterpret_cast<const  ::wxDateTime *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDateTime(sipSimpleWrapper *);}
static void dealloc_wxDateTime(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDateTime(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDateTime(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDateTime(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxDateTime *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxDateTime* date;
        int dateState = 0;

        static const char *sipKwdList[] = {
            sipName_date,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxDateTime, &date, &dateState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime(*date);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDateTime *>(date),sipType_wxDateTime,dateState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        unsigned short day;
         ::wxDateTime::Month month;
        int year =  ::wxDateTime::Inv_Year;
        unsigned short hour = 0;
        unsigned short minute = 0;
        unsigned short second = 0;
        unsigned short millisec = 0;

        static const char *sipKwdList[] = {
            sipName_day,
            sipName_month,
            sipName_year,
            sipName_hour,
            sipName_minute,
            sipName_second,
            sipName_millisec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "tE|itttt", &day, sipType_wxDateTime_Month, &month, &year, &hour, &minute, &second, &millisec))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime(day,month,year,hour,minute,second,millisec);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_wxDateTime(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxDateTime(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxDateTime **sipCppPtr = reinterpret_cast< ::wxDateTime **>(sipCppPtrV);

        // Code to test a PyObject for compatibility with wxDateTime
        if (!sipIsErr) {
            if (sipCanConvertToType(sipPy, sipType_wxDateTime, SIP_NO_CONVERTORS))
                    return TRUE;
            if (wxPyDateTime_Check(sipPy) || wxPyDate_Check(sipPy))
                return TRUE;
            return FALSE;
        }
        
        // Code to convert a compatible PyObject to a wxDateTime
        if (wxPyDateTime_Check(sipPy)) {
            *sipCppPtr = wxPyDateTime_ToWxDateTime(sipPy);
            return sipGetState(sipTransferObj);
        }
        if (wxPyDate_Check(sipPy)) {
            *sipCppPtr = wxPyDate_ToWxDateTime(sipPy);
            return sipGetState(sipTransferObj);
        }
        // if we get this far then it must already be a wxDateTime instance
        *sipCppPtr = reinterpret_cast<wxDateTime*>(sipConvertToType(
                sipPy, sipType_wxDateTime, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
        
        return 0;  // Not a new instance
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxDateTime[] = {
    {(void *)slot_wxDateTime___sub__, sub_slot},
    {(void *)slot_wxDateTime___isub__, isub_slot},
    {(void *)slot_wxDateTime___add__, add_slot},
    {(void *)slot_wxDateTime___iadd__, iadd_slot},
    {(void *)slot_wxDateTime___ne__, ne_slot},
    {(void *)slot_wxDateTime___eq__, eq_slot},
    {(void *)slot_wxDateTime___ge__, ge_slot},
    {(void *)slot_wxDateTime___gt__, gt_slot},
    {(void *)slot_wxDateTime___le__, le_slot},
    {(void *)slot_wxDateTime___lt__, lt_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxDateTime[] = {
    {SIP_MLNAME_CAST(sipName_Add), (PyCFunction)meth_wxDateTime_Add, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_Add)},
    {SIP_MLNAME_CAST(sipName_ConvertYearToBC), (PyCFunction)meth_wxDateTime_ConvertYearToBC, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ConvertYearToBC)},
    {SIP_MLNAME_CAST(sipName_DiffAsDateSpan), (PyCFunction)meth_wxDateTime_DiffAsDateSpan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_DiffAsDateSpan)},
    {SIP_MLNAME_CAST(sipName_Format), (PyCFunction)meth_wxDateTime_Format, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_Format)},
    {SIP_MLNAME_CAST(sipName_FormatDate), meth_wxDateTime_FormatDate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_FormatDate)},
    {SIP_MLNAME_CAST(sipName_FormatISOCombined), (PyCFunction)meth_wxDateTime_FormatISOCombined, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FormatISOCombined)},
    {SIP_MLNAME_CAST(sipName_FormatISODate), meth_wxDateTime_FormatISODate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_FormatISODate)},
    {SIP_MLNAME_CAST(sipName_FormatISOTime), meth_wxDateTime_FormatISOTime, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_FormatISOTime)},
    {SIP_MLNAME_CAST(sipName_FormatTime), meth_wxDateTime_FormatTime, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_FormatTime)},
    {SIP_MLNAME_CAST(sipName_FromDMY), (PyCFunction)meth_wxDateTime_FromDMY, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FromDMY)},
    {SIP_MLNAME_CAST(sipName_FromHMS), (PyCFunction)meth_wxDateTime_FromHMS, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FromHMS)},
    {SIP_MLNAME_CAST(sipName_FromJDN), (PyCFunction)meth_wxDateTime_FromJDN, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FromJDN)},
    {SIP_MLNAME_CAST(sipName_FromTimeT), (PyCFunction)meth_wxDateTime_FromTimeT, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FromTimeT)},
    {SIP_MLNAME_CAST(sipName_FromTimezone), (PyCFunction)meth_wxDateTime_FromTimezone, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_FromTimezone)},
    {SIP_MLNAME_CAST(sipName_GetAmPmStrings), (PyCFunction)meth_wxDateTime_GetAmPmStrings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetAmPmStrings)},
    {SIP_MLNAME_CAST(sipName_GetAsDOS), meth_wxDateTime_GetAsDOS, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetAsDOS)},
    {SIP_MLNAME_CAST(sipName_GetBeginDST), (PyCFunction)meth_wxDateTime_GetBeginDST, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetBeginDST)},
    {SIP_MLNAME_CAST(sipName_GetCentury), (PyCFunction)meth_wxDateTime_GetCentury, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetCentury)},
    {SIP_MLNAME_CAST(sipName_GetCountry), meth_wxDateTime_GetCountry, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetCountry)},
    {SIP_MLNAME_CAST(sipName_GetCurrentMonth), (PyCFunction)meth_wxDateTime_GetCurrentMonth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetCurrentMonth)},
    {SIP_MLNAME_CAST(sipName_GetCurrentYear), (PyCFunction)meth_wxDateTime_GetCurrentYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetCurrentYear)},
    {SIP_MLNAME_CAST(sipName_GetDateOnly), meth_wxDateTime_GetDateOnly, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetDateOnly)},
    {SIP_MLNAME_CAST(sipName_GetDay), (PyCFunction)meth_wxDateTime_GetDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetDay)},
    {SIP_MLNAME_CAST(sipName_GetDayOfYear), (PyCFunction)meth_wxDateTime_GetDayOfYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetDayOfYear)},
    {SIP_MLNAME_CAST(sipName_GetEndDST), (PyCFunction)meth_wxDateTime_GetEndDST, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetEndDST)},
    {SIP_MLNAME_CAST(sipName_GetEnglishMonthName), (PyCFunction)meth_wxDateTime_GetEnglishMonthName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetEnglishMonthName)},
    {SIP_MLNAME_CAST(sipName_GetEnglishWeekDayName), (PyCFunction)meth_wxDateTime_GetEnglishWeekDayName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetEnglishWeekDayName)},
    {SIP_MLNAME_CAST(sipName_GetHour), (PyCFunction)meth_wxDateTime_GetHour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetHour)},
    {SIP_MLNAME_CAST(sipName_GetJDN), meth_wxDateTime_GetJDN, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetJDN)},
    {SIP_MLNAME_CAST(sipName_GetJulianDayNumber), meth_wxDateTime_GetJulianDayNumber, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetJulianDayNumber)},
    {SIP_MLNAME_CAST(sipName_GetLastMonthDay), (PyCFunction)meth_wxDateTime_GetLastMonthDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetLastMonthDay)},
    {SIP_MLNAME_CAST(sipName_GetLastWeekDay), (PyCFunction)meth_wxDateTime_GetLastWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetLastWeekDay)},
    {SIP_MLNAME_CAST(sipName_GetMJD), meth_wxDateTime_GetMJD, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetMJD)},
    {SIP_MLNAME_CAST(sipName_GetMillisecond), (PyCFunction)meth_wxDateTime_GetMillisecond, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetMillisecond)},
    {SIP_MLNAME_CAST(sipName_GetMinute), (PyCFunction)meth_wxDateTime_GetMinute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetMinute)},
    {SIP_MLNAME_CAST(sipName_GetModifiedJulianDayNumber), meth_wxDateTime_GetModifiedJulianDayNumber, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetModifiedJulianDayNumber)},
    {SIP_MLNAME_CAST(sipName_GetMonth), (PyCFunction)meth_wxDateTime_GetMonth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetMonth)},
    {SIP_MLNAME_CAST(sipName_GetMonthName), (PyCFunction)meth_wxDateTime_GetMonthName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetMonthName)},
    {SIP_MLNAME_CAST(sipName_GetNextWeekDay), (PyCFunction)meth_wxDateTime_GetNextWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetNextWeekDay)},
    {SIP_MLNAME_CAST(sipName_GetNumberOfDays), (PyCFunction)meth_wxDateTime_GetNumberOfDays, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetNumberOfDays)},
    {SIP_MLNAME_CAST(sipName_GetPrevWeekDay), (PyCFunction)meth_wxDateTime_GetPrevWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetPrevWeekDay)},
    {SIP_MLNAME_CAST(sipName_GetRataDie), meth_wxDateTime_GetRataDie, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetRataDie)},
    {SIP_MLNAME_CAST(sipName_GetSecond), (PyCFunction)meth_wxDateTime_GetSecond, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetSecond)},
    {SIP_MLNAME_CAST(sipName_GetTicks), meth_wxDateTime_GetTicks, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetTicks)},
    {SIP_MLNAME_CAST(sipName_GetTimeNow), meth_wxDateTime_GetTimeNow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_GetTimeNow)},
    {SIP_MLNAME_CAST(sipName_GetTm), (PyCFunction)meth_wxDateTime_GetTm, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetTm)},
    {SIP_MLNAME_CAST(sipName_GetWeekDay), (PyCFunction)meth_wxDateTime_GetWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetWeekDay)},
    {SIP_MLNAME_CAST(sipName_GetWeekDayInSameWeek), (PyCFunction)meth_wxDateTime_GetWeekDayInSameWeek, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetWeekDayInSameWeek)},
    {SIP_MLNAME_CAST(sipName_GetWeekDayName), (PyCFunction)meth_wxDateTime_GetWeekDayName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetWeekDayName)},
    {SIP_MLNAME_CAST(sipName_GetWeekOfMonth), (PyCFunction)meth_wxDateTime_GetWeekOfMonth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetWeekOfMonth)},
    {SIP_MLNAME_CAST(sipName_GetWeekOfYear), (PyCFunction)meth_wxDateTime_GetWeekOfYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetWeekOfYear)},
    {SIP_MLNAME_CAST(sipName_GetYear), (PyCFunction)meth_wxDateTime_GetYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetYear)},
    {SIP_MLNAME_CAST(sipName_GetYearDay), (PyCFunction)meth_wxDateTime_GetYearDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_GetYearDay)},
    {SIP_MLNAME_CAST(sipName_IsBetween), (PyCFunction)meth_wxDateTime_IsBetween, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsBetween)},
    {SIP_MLNAME_CAST(sipName_IsDST), (PyCFunction)meth_wxDateTime_IsDST, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsDST)},
    {SIP_MLNAME_CAST(sipName_IsDSTApplicable), (PyCFunction)meth_wxDateTime_IsDSTApplicable, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsDSTApplicable)},
    {SIP_MLNAME_CAST(sipName_IsEarlierThan), (PyCFunction)meth_wxDateTime_IsEarlierThan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsEarlierThan)},
    {SIP_MLNAME_CAST(sipName_IsEqualTo), (PyCFunction)meth_wxDateTime_IsEqualTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsEqualTo)},
    {SIP_MLNAME_CAST(sipName_IsEqualUpTo), (PyCFunction)meth_wxDateTime_IsEqualUpTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsEqualUpTo)},
    {SIP_MLNAME_CAST(sipName_IsLaterThan), (PyCFunction)meth_wxDateTime_IsLaterThan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsLaterThan)},
    {SIP_MLNAME_CAST(sipName_IsLeapYear), (PyCFunction)meth_wxDateTime_IsLeapYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsLeapYear)},
    {SIP_MLNAME_CAST(sipName_IsSameDate), (PyCFunction)meth_wxDateTime_IsSameDate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsSameDate)},
    {SIP_MLNAME_CAST(sipName_IsSameTime), (PyCFunction)meth_wxDateTime_IsSameTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsSameTime)},
    {SIP_MLNAME_CAST(sipName_IsStrictlyBetween), (PyCFunction)meth_wxDateTime_IsStrictlyBetween, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsStrictlyBetween)},
    {SIP_MLNAME_CAST(sipName_IsValid), meth_wxDateTime_IsValid, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_IsValid)},
    {SIP_MLNAME_CAST(sipName_IsWestEuropeanCountry), (PyCFunction)meth_wxDateTime_IsWestEuropeanCountry, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsWestEuropeanCountry)},
    {SIP_MLNAME_CAST(sipName_IsWorkDay), (PyCFunction)meth_wxDateTime_IsWorkDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_IsWorkDay)},
    {SIP_MLNAME_CAST(sipName_MakeFromTimezone), (PyCFunction)meth_wxDateTime_MakeFromTimezone, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_MakeFromTimezone)},
    {SIP_MLNAME_CAST(sipName_MakeTimezone), (PyCFunction)meth_wxDateTime_MakeTimezone, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_MakeTimezone)},
    {SIP_MLNAME_CAST(sipName_MakeUTC), (PyCFunction)meth_wxDateTime_MakeUTC, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_MakeUTC)},
    {SIP_MLNAME_CAST(sipName_Now), meth_wxDateTime_Now, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_Now)},
    {SIP_MLNAME_CAST(sipName_ParseDate), (PyCFunction)meth_wxDateTime_ParseDate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseDate)},
    {SIP_MLNAME_CAST(sipName_ParseDateTime), (PyCFunction)meth_wxDateTime_ParseDateTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseDateTime)},
    {SIP_MLNAME_CAST(sipName_ParseFormat), (PyCFunction)meth_wxDateTime_ParseFormat, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseFormat)},
    {SIP_MLNAME_CAST(sipName_ParseISOCombined), (PyCFunction)meth_wxDateTime_ParseISOCombined, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseISOCombined)},
    {SIP_MLNAME_CAST(sipName_ParseISODate), (PyCFunction)meth_wxDateTime_ParseISODate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseISODate)},
    {SIP_MLNAME_CAST(sipName_ParseISOTime), (PyCFunction)meth_wxDateTime_ParseISOTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseISOTime)},
    {SIP_MLNAME_CAST(sipName_ParseRfc822Date), (PyCFunction)meth_wxDateTime_ParseRfc822Date, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseRfc822Date)},
    {SIP_MLNAME_CAST(sipName_ParseTime), (PyCFunction)meth_wxDateTime_ParseTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ParseTime)},
    {SIP_MLNAME_CAST(sipName_ResetTime), meth_wxDateTime_ResetTime, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_ResetTime)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxDateTime_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_Set)},
    {SIP_MLNAME_CAST(sipName_SetCountry), (PyCFunction)meth_wxDateTime_SetCountry, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetCountry)},
    {SIP_MLNAME_CAST(sipName_SetDay), (PyCFunction)meth_wxDateTime_SetDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetDay)},
    {SIP_MLNAME_CAST(sipName_SetFromDOS), (PyCFunction)meth_wxDateTime_SetFromDOS, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetFromDOS)},
    {SIP_MLNAME_CAST(sipName_SetHMS), (PyCFunction)meth_wxDateTime_SetHMS, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetHMS)},
    {SIP_MLNAME_CAST(sipName_SetHour), (PyCFunction)meth_wxDateTime_SetHour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetHour)},
    {SIP_MLNAME_CAST(sipName_SetJDN), (PyCFunction)meth_wxDateTime_SetJDN, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetJDN)},
    {SIP_MLNAME_CAST(sipName_SetMillisecond), (PyCFunction)meth_wxDateTime_SetMillisecond, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetMillisecond)},
    {SIP_MLNAME_CAST(sipName_SetMinute), (PyCFunction)meth_wxDateTime_SetMinute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetMinute)},
    {SIP_MLNAME_CAST(sipName_SetMonth), (PyCFunction)meth_wxDateTime_SetMonth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetMonth)},
    {SIP_MLNAME_CAST(sipName_SetSecond), (PyCFunction)meth_wxDateTime_SetSecond, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetSecond)},
    {SIP_MLNAME_CAST(sipName_SetTimeT), (PyCFunction)meth_wxDateTime_SetTimeT, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetTimeT)},
    {SIP_MLNAME_CAST(sipName_SetTm), (PyCFunction)meth_wxDateTime_SetTm, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetTm)},
    {SIP_MLNAME_CAST(sipName_SetToCurrent), meth_wxDateTime_SetToCurrent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_SetToCurrent)},
    {SIP_MLNAME_CAST(sipName_SetToLastMonthDay), (PyCFunction)meth_wxDateTime_SetToLastMonthDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToLastMonthDay)},
    {SIP_MLNAME_CAST(sipName_SetToLastWeekDay), (PyCFunction)meth_wxDateTime_SetToLastWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToLastWeekDay)},
    {SIP_MLNAME_CAST(sipName_SetToNextWeekDay), (PyCFunction)meth_wxDateTime_SetToNextWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToNextWeekDay)},
    {SIP_MLNAME_CAST(sipName_SetToPrevWeekDay), (PyCFunction)meth_wxDateTime_SetToPrevWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToPrevWeekDay)},
    {SIP_MLNAME_CAST(sipName_SetToWeekDay), (PyCFunction)meth_wxDateTime_SetToWeekDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToWeekDay)},
    {SIP_MLNAME_CAST(sipName_SetToWeekDayInSameWeek), (PyCFunction)meth_wxDateTime_SetToWeekDayInSameWeek, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToWeekDayInSameWeek)},
    {SIP_MLNAME_CAST(sipName_SetToWeekOfYear), (PyCFunction)meth_wxDateTime_SetToWeekOfYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToWeekOfYear)},
    {SIP_MLNAME_CAST(sipName_SetToYearDay), (PyCFunction)meth_wxDateTime_SetToYearDay, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetToYearDay)},
    {SIP_MLNAME_CAST(sipName_SetYear), (PyCFunction)meth_wxDateTime_SetYear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_SetYear)},
    {SIP_MLNAME_CAST(sipName_Subtract), (PyCFunction)meth_wxDateTime_Subtract, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_Subtract)},
    {SIP_MLNAME_CAST(sipName_ToTimezone), (PyCFunction)meth_wxDateTime_ToTimezone, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ToTimezone)},
    {SIP_MLNAME_CAST(sipName_ToUTC), (PyCFunction)meth_wxDateTime_ToUTC, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDateTime_ToUTC)},
    {SIP_MLNAME_CAST(sipName_Today), meth_wxDateTime_Today, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_Today)},
    {SIP_MLNAME_CAST(sipName_UNow), meth_wxDateTime_UNow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDateTime_UNow)}
};

static sipEnumMemberDef enummembers_wxDateTime[] = {
    {sipName_ADT, static_cast<int>( ::wxDateTime::ADT), 109},
    {sipName_AKDT, static_cast<int>( ::wxDateTime::AKDT), 109},
    {sipName_AKST, static_cast<int>( ::wxDateTime::AKST), 109},
    {sipName_AST, static_cast<int>( ::wxDateTime::AST), 109},
    {sipName_A_CST, static_cast<int>( ::wxDateTime::A_CST), 109},
    {sipName_A_ESST, static_cast<int>( ::wxDateTime::A_ESST), 109},
    {sipName_A_EST, static_cast<int>( ::wxDateTime::A_EST), 109},
    {sipName_A_WST, static_cast<int>( ::wxDateTime::A_WST), 109},
    {sipName_Apr, static_cast<int>( ::wxDateTime::Apr), 107},
    {sipName_Aug, static_cast<int>( ::wxDateTime::Aug), 107},
    {sipName_CDT, static_cast<int>( ::wxDateTime::CDT), 109},
    {sipName_CEST, static_cast<int>( ::wxDateTime::CEST), 109},
    {sipName_CET, static_cast<int>( ::wxDateTime::CET), 109},
    {sipName_CST, static_cast<int>( ::wxDateTime::CST), 109},
    {sipName_Country_Default, static_cast<int>( ::wxDateTime::Country_Default), 106},
    {sipName_Country_EEC, static_cast<int>( ::wxDateTime::Country_EEC), 106},
    {sipName_Country_Unknown, static_cast<int>( ::wxDateTime::Country_Unknown), 106},
    {sipName_Country_WesternEurope_End, static_cast<int>( ::wxDateTime::Country_WesternEurope_End), 106},
    {sipName_Country_WesternEurope_Start, static_cast<int>( ::wxDateTime::Country_WesternEurope_Start), 106},
    {sipName_Dec, static_cast<int>( ::wxDateTime::Dec), 107},
    {sipName_Default_First, static_cast<int>( ::wxDateTime::Default_First), 113},
    {sipName_EDT, static_cast<int>( ::wxDateTime::EDT), 109},
    {sipName_EEST, static_cast<int>( ::wxDateTime::EEST), 109},
    {sipName_EET, static_cast<int>( ::wxDateTime::EET), 109},
    {sipName_EST, static_cast<int>( ::wxDateTime::EST), 109},
    {sipName_Feb, static_cast<int>( ::wxDateTime::Feb), 107},
    {sipName_France, static_cast<int>( ::wxDateTime::France), 106},
    {sipName_Fri, static_cast<int>( ::wxDateTime::Fri), 112},
    {sipName_GMT0, static_cast<int>( ::wxDateTime::GMT0), 109},
    {sipName_GMT1, static_cast<int>( ::wxDateTime::GMT1), 109},
    {sipName_GMT10, static_cast<int>( ::wxDateTime::GMT10), 109},
    {sipName_GMT11, static_cast<int>( ::wxDateTime::GMT11), 109},
    {sipName_GMT12, static_cast<int>( ::wxDateTime::GMT12), 109},
    {sipName_GMT13, static_cast<int>( ::wxDateTime::GMT13), 109},
    {sipName_GMT2, static_cast<int>( ::wxDateTime::GMT2), 109},
    {sipName_GMT3, static_cast<int>( ::wxDateTime::GMT3), 109},
    {sipName_GMT4, static_cast<int>( ::wxDateTime::GMT4), 109},
    {sipName_GMT5, static_cast<int>( ::wxDateTime::GMT5), 109},
    {sipName_GMT6, static_cast<int>( ::wxDateTime::GMT6), 109},
    {sipName_GMT7, static_cast<int>( ::wxDateTime::GMT7), 109},
    {sipName_GMT8, static_cast<int>( ::wxDateTime::GMT8), 109},
    {sipName_GMT9, static_cast<int>( ::wxDateTime::GMT9), 109},
    {sipName_GMT_1, static_cast<int>( ::wxDateTime::GMT_1), 109},
    {sipName_GMT_10, static_cast<int>( ::wxDateTime::GMT_10), 109},
    {sipName_GMT_11, static_cast<int>( ::wxDateTime::GMT_11), 109},
    {sipName_GMT_12, static_cast<int>( ::wxDateTime::GMT_12), 109},
    {sipName_GMT_2, static_cast<int>( ::wxDateTime::GMT_2), 109},
    {sipName_GMT_3, static_cast<int>( ::wxDateTime::GMT_3), 109},
    {sipName_GMT_4, static_cast<int>( ::wxDateTime::GMT_4), 109},
    {sipName_GMT_5, static_cast<int>( ::wxDateTime::GMT_5), 109},
    {sipName_GMT_6, static_cast<int>( ::wxDateTime::GMT_6), 109},
    {sipName_GMT_7, static_cast<int>( ::wxDateTime::GMT_7), 109},
    {sipName_GMT_8, static_cast<int>( ::wxDateTime::GMT_8), 109},
    {sipName_GMT_9, static_cast<int>( ::wxDateTime::GMT_9), 109},
    {sipName_Germany, static_cast<int>( ::wxDateTime::Germany), 106},
    {sipName_Gregorian, static_cast<int>( ::wxDateTime::Gregorian), 105},
    {sipName_HST, static_cast<int>( ::wxDateTime::HST), 109},
    {sipName_Inv_Month, static_cast<int>( ::wxDateTime::Inv_Month), 107},
    {sipName_Inv_WeekDay, static_cast<int>( ::wxDateTime::Inv_WeekDay), 112},
    {sipName_Inv_Year, static_cast<int>( ::wxDateTime::Inv_Year), 114},
    {sipName_Jan, static_cast<int>( ::wxDateTime::Jan), 107},
    {sipName_Jul, static_cast<int>( ::wxDateTime::Jul), 107},
    {sipName_Julian, static_cast<int>( ::wxDateTime::Julian), 105},
    {sipName_Jun, static_cast<int>( ::wxDateTime::Jun), 107},
    {sipName_Local, static_cast<int>( ::wxDateTime::Local), 109},
    {sipName_MDT, static_cast<int>( ::wxDateTime::MDT), 109},
    {sipName_MSD, static_cast<int>( ::wxDateTime::MSD), 109},
    {sipName_MSK, static_cast<int>( ::wxDateTime::MSK), 109},
    {sipName_MST, static_cast<int>( ::wxDateTime::MST), 109},
    {sipName_Mar, static_cast<int>( ::wxDateTime::Mar), 107},
    {sipName_May, static_cast<int>( ::wxDateTime::May), 107},
    {sipName_Mon, static_cast<int>( ::wxDateTime::Mon), 112},
    {sipName_Monday_First, static_cast<int>( ::wxDateTime::Monday_First), 113},
    {sipName_NZDT, static_cast<int>( ::wxDateTime::NZDT), 109},
    {sipName_NZST, static_cast<int>( ::wxDateTime::NZST), 109},
    {sipName_Name_Abbr, static_cast<int>( ::wxDateTime::Name_Abbr), 108},
    {sipName_Name_Full, static_cast<int>( ::wxDateTime::Name_Full), 108},
    {sipName_Nov, static_cast<int>( ::wxDateTime::Nov), 107},
    {sipName_Oct, static_cast<int>( ::wxDateTime::Oct), 107},
    {sipName_PDT, static_cast<int>( ::wxDateTime::PDT), 109},
    {sipName_PST, static_cast<int>( ::wxDateTime::PST), 109},
    {sipName_Russia, static_cast<int>( ::wxDateTime::Russia), 106},
    {sipName_Sat, static_cast<int>( ::wxDateTime::Sat), 112},
    {sipName_Sep, static_cast<int>( ::wxDateTime::Sep), 107},
    {sipName_Sun, static_cast<int>( ::wxDateTime::Sun), 112},
    {sipName_Sunday_First, static_cast<int>( ::wxDateTime::Sunday_First), 113},
    {sipName_Thu, static_cast<int>( ::wxDateTime::Thu), 112},
    {sipName_Tue, static_cast<int>( ::wxDateTime::Tue), 112},
    {sipName_UK, static_cast<int>( ::wxDateTime::UK), 106},
    {sipName_USA, static_cast<int>( ::wxDateTime::USA), 106},
    {sipName_UTC, static_cast<int>( ::wxDateTime::UTC), 109},
    {sipName_WEST, static_cast<int>( ::wxDateTime::WEST), 109},
    {sipName_WET, static_cast<int>( ::wxDateTime::WET), 109},
    {sipName_Wed, static_cast<int>( ::wxDateTime::Wed), 112},
};

sipVariableDef variables_wxDateTime[] = {
    {PropertyVariable, sipName_WeekOfYear, &methods_wxDateTime[50], NULL, NULL, NULL},
    {PropertyVariable, sipName_WeekOfMonth, &methods_wxDateTime[49], NULL, NULL, NULL},
    {PropertyVariable, sipName_Ticks, &methods_wxDateTime[43], NULL, NULL, NULL},
    {PropertyVariable, sipName_RataDie, &methods_wxDateTime[41], NULL, NULL, NULL},
    {PropertyVariable, sipName_ModifiedJulianDayNumber, &methods_wxDateTime[35], NULL, NULL, NULL},
    {PropertyVariable, sipName_MJD, &methods_wxDateTime[32], NULL, NULL, NULL},
    {PropertyVariable, sipName_LastMonthDay, &methods_wxDateTime[30], NULL, NULL, NULL},
    {PropertyVariable, sipName_JulianDayNumber, &methods_wxDateTime[29], NULL, NULL, NULL},
    {PropertyVariable, sipName_DayOfYear, &methods_wxDateTime[23], NULL, NULL, NULL},
    {PropertyVariable, sipName_JDN, &methods_wxDateTime[28], &methods_wxDateTime[86], NULL, NULL},
    {PropertyVariable, sipName_millisecond, &methods_wxDateTime[33], &methods_wxDateTime[87], NULL, NULL},
    {PropertyVariable, sipName_second, &methods_wxDateTime[42], &methods_wxDateTime[90], NULL, NULL},
    {PropertyVariable, sipName_minute, &methods_wxDateTime[34], &methods_wxDateTime[88], NULL, NULL},
    {PropertyVariable, sipName_hour, &methods_wxDateTime[27], &methods_wxDateTime[85], NULL, NULL},
    {PropertyVariable, sipName_year, &methods_wxDateTime[51], &methods_wxDateTime[102], NULL, NULL},
    {PropertyVariable, sipName_month, &methods_wxDateTime[36], &methods_wxDateTime[89], NULL, NULL},
    {PropertyVariable, sipName_day, &methods_wxDateTime[22], &methods_wxDateTime[82], NULL, NULL},
};

PyDoc_STRVAR(doc_wxDateTime, "DateTime()\n"
"DateTime(date)\n"
"DateTime(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0)\n"
"\n"
"wxDateTime class represents an absolute moment in time.");


sipClassTypeDef sipTypeDef__core_wxDateTime = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxDateTime,
        {0},
        0
    },
    {
        sipNameNr_DateTime,
        {0, 0, 1},
        108, methods_wxDateTime,
        94, enummembers_wxDateTime,
        17, variables_wxDateTime,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxDateTime,
    -1,
    -1,
    0,
    slots_wxDateTime,
    init_type_wxDateTime,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxDateTime,
    assign_wxDateTime,
    array_wxDateTime,
    copy_wxDateTime,
    release_wxDateTime,
    0,
    convertTo_wxDateTime,
    0,
    0,
    0,
    0,
    0
};
