/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/evtloop.h>



PyDoc_STRVAR(doc_wxEventLoopBase_Run, "Run() -> int\n"
"\n"
"Start the event loop, return the exit code when it is finished.");

extern "C" {static PyObject *meth_wxEventLoopBase_Run(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_Run(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_Run);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Run();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_Run, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_IsRunning, "IsRunning() -> bool\n"
"\n"
"Return true if this event loop is currently running.");

extern "C" {static PyObject *meth_wxEventLoopBase_IsRunning(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_IsRunning(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRunning();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_IsRunning, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_IsOk, "IsOk() -> bool\n"
"\n"
"Use this to check whether the event loop was successfully created\n"
"before using it.");

extern "C" {static PyObject *meth_wxEventLoopBase_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::IsOk() : sipCpp->IsOk());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_Exit, "Exit(rc=0)\n"
"\n"
"Exit the currently running loop with the given exit code.");

extern "C" {static PyObject *meth_wxEventLoopBase_Exit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_Exit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int rc = 0;
         ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxEventLoopBase, &sipCpp, &rc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::Exit(rc) : sipCpp->Exit(rc));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_Exit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_ScheduleExit, "ScheduleExit(rc=0)\n"
"\n"
"Schedule an exit from the loop with the given exit code.");

extern "C" {static PyObject *meth_wxEventLoopBase_ScheduleExit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_ScheduleExit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        int rc = 0;
         ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxEventLoopBase, &sipCpp, &rc))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_ScheduleExit);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ScheduleExit(rc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_ScheduleExit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_Pending, "Pending() -> bool\n"
"\n"
"Return true if any events are available.");

extern "C" {static PyObject *meth_wxEventLoopBase_Pending(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_Pending(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_Pending);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Pending();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_Pending, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_Dispatch, "Dispatch() -> bool\n"
"\n"
"Dispatches the next event in the windowing system event queue.");

extern "C" {static PyObject *meth_wxEventLoopBase_Dispatch(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_Dispatch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_Dispatch);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Dispatch();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_Dispatch, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_DispatchTimeout, "DispatchTimeout(timeout) -> int\n"
"\n"
"Dispatch an event but not wait longer than the specified timeout for\n"
"it.");

extern "C" {static PyObject *meth_wxEventLoopBase_DispatchTimeout(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_DispatchTimeout(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        unsigned long timeout;
         ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bm", &sipSelf, sipType_wxEventLoopBase, &sipCpp, &timeout))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_DispatchTimeout);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DispatchTimeout(timeout);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_DispatchTimeout, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_WakeUp, "WakeUp()\n"
"\n"
"Called by wxWidgets to wake up the event loop even if it is currently\n"
"blocked inside Dispatch().");

extern "C" {static PyObject *meth_wxEventLoopBase_WakeUp(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_WakeUp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_EventLoopBase, sipName_WakeUp);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->WakeUp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_WakeUp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_WakeUpIdle, "WakeUpIdle()\n"
"\n"
"Makes sure that idle events are sent again.");

extern "C" {static PyObject *meth_wxEventLoopBase_WakeUpIdle(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_WakeUpIdle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::WakeUpIdle() : sipCpp->WakeUpIdle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_WakeUpIdle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_ProcessIdle, "ProcessIdle() -> bool\n"
"\n"
"This virtual function is called when the application becomes idle and\n"
"normally just sends wxIdleEvent to all interested parties.");

extern "C" {static PyObject *meth_wxEventLoopBase_ProcessIdle(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_ProcessIdle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::ProcessIdle() : sipCpp->ProcessIdle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_ProcessIdle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_IsYielding, "IsYielding() -> bool\n"
"\n"
"Returns true if called from inside Yield() or from inside YieldFor().");

extern "C" {static PyObject *meth_wxEventLoopBase_IsYielding(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_IsYielding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::IsYielding() : sipCpp->IsYielding());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_IsYielding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_Yield, "Yield(onlyIfNeeded=False) -> bool\n"
"\n"
"Yields control to pending messages in the windowing system.");

extern "C" {static PyObject *meth_wxEventLoopBase_Yield(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_Yield(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool onlyIfNeeded = 0;
         ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_onlyIfNeeded,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxEventLoopBase, &sipCpp, &onlyIfNeeded))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Yield(onlyIfNeeded);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_Yield, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_YieldFor, "YieldFor(eventsToProcess) -> bool\n"
"\n"
"Works like Yield() with onlyIfNeeded == true, except that it allows\n"
"the caller to specify a mask of the wxEventCategory values which\n"
"indicates which events should be processed and which should instead be\n"
"\"delayed\" (i.e.");

extern "C" {static PyObject *meth_wxEventLoopBase_YieldFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_YieldFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long eventsToProcess;
         ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_eventsToProcess,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxEventLoopBase, &sipCpp, &eventsToProcess))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->YieldFor(eventsToProcess);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_YieldFor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_IsEventAllowedInsideYield, "IsEventAllowedInsideYield(cat) -> bool\n"
"\n"
"Returns true if the given event category is allowed inside a\n"
"YieldFor() call (i.e.");

extern "C" {static PyObject *meth_wxEventLoopBase_IsEventAllowedInsideYield(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_IsEventAllowedInsideYield(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEventCategory cat;
        const  ::wxEventLoopBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cat,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxEventLoopBase, &sipCpp, sipType_wxEventCategory, &cat))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxEventLoopBase::IsEventAllowedInsideYield(cat) : sipCpp->IsEventAllowedInsideYield(cat));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_IsEventAllowedInsideYield, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_GetActive, "GetActive() -> EventLoopBase\n"
"\n"
"Return the currently active (running) event loop.");

extern "C" {static PyObject *meth_wxEventLoopBase_GetActive(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_GetActive(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxEventLoopBase*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxEventLoopBase::GetActive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxEventLoopBase,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_GetActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_SetActive, "SetActive(loop)\n"
"\n"
"Set currently active (running) event loop.");

extern "C" {static PyObject *meth_wxEventLoopBase_SetActive(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_SetActive(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxEventLoopBase* loop;

        static const char *sipKwdList[] = {
            sipName_loop,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxEventLoopBase, &loop))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxEventLoopBase::SetActive(loop);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_SetActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxEventLoopBase_IsMain, "IsMain() -> bool\n"
"\n"
"Returns true if this is the main loop executed by wxApp::OnRun().");

extern "C" {static PyObject *meth_wxEventLoopBase_IsMain(PyObject *, PyObject *);}
static PyObject *meth_wxEventLoopBase_IsMain(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxEventLoopBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEventLoopBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsMain();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_EventLoopBase, sipName_IsMain, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxEventLoopBase(void *, int);}
static void release_wxEventLoopBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxEventLoopBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxEventLoopBase(sipSimpleWrapper *);}
static void dealloc_wxEventLoopBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxEventLoopBase(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxEventLoopBase[] = {
    {SIP_MLNAME_CAST(sipName_Dispatch), meth_wxEventLoopBase_Dispatch, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_Dispatch)},
    {SIP_MLNAME_CAST(sipName_DispatchTimeout), (PyCFunction)meth_wxEventLoopBase_DispatchTimeout, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_DispatchTimeout)},
    {SIP_MLNAME_CAST(sipName_Exit), (PyCFunction)meth_wxEventLoopBase_Exit, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_Exit)},
    {SIP_MLNAME_CAST(sipName_GetActive), meth_wxEventLoopBase_GetActive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_GetActive)},
    {SIP_MLNAME_CAST(sipName_IsEventAllowedInsideYield), (PyCFunction)meth_wxEventLoopBase_IsEventAllowedInsideYield, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_IsEventAllowedInsideYield)},
    {SIP_MLNAME_CAST(sipName_IsMain), meth_wxEventLoopBase_IsMain, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_IsMain)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxEventLoopBase_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_IsOk)},
    {SIP_MLNAME_CAST(sipName_IsRunning), meth_wxEventLoopBase_IsRunning, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_IsRunning)},
    {SIP_MLNAME_CAST(sipName_IsYielding), meth_wxEventLoopBase_IsYielding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_IsYielding)},
    {SIP_MLNAME_CAST(sipName_Pending), meth_wxEventLoopBase_Pending, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_Pending)},
    {SIP_MLNAME_CAST(sipName_ProcessIdle), meth_wxEventLoopBase_ProcessIdle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_ProcessIdle)},
    {SIP_MLNAME_CAST(sipName_Run), meth_wxEventLoopBase_Run, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_Run)},
    {SIP_MLNAME_CAST(sipName_ScheduleExit), (PyCFunction)meth_wxEventLoopBase_ScheduleExit, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_ScheduleExit)},
    {SIP_MLNAME_CAST(sipName_SetActive), (PyCFunction)meth_wxEventLoopBase_SetActive, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_SetActive)},
    {SIP_MLNAME_CAST(sipName_WakeUp), meth_wxEventLoopBase_WakeUp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_WakeUp)},
    {SIP_MLNAME_CAST(sipName_WakeUpIdle), meth_wxEventLoopBase_WakeUpIdle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEventLoopBase_WakeUpIdle)},
    {SIP_MLNAME_CAST(sipName_Yield), (PyCFunction)meth_wxEventLoopBase_Yield, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_Yield)},
    {SIP_MLNAME_CAST(sipName_YieldFor), (PyCFunction)meth_wxEventLoopBase_YieldFor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEventLoopBase_YieldFor)}
};

PyDoc_STRVAR(doc_wxEventLoopBase, "Base class for all event loop implementations.");


sipClassTypeDef sipTypeDef__core_wxEventLoopBase = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxEventLoopBase,
        {0},
        0
    },
    {
        sipNameNr_EventLoopBase,
        {0, 0, 1},
        18, methods_wxEventLoopBase,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxEventLoopBase,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxEventLoopBase,
    0,
    0,
    0,
    release_wxEventLoopBase,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
