/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/filesys.h>

        #include <wx/filesys.h>
        #include <wx/filesys.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxFileSystemHandler : public  ::wxFileSystemHandler
{
public:
    sipwxFileSystemHandler();
    sipwxFileSystemHandler(const  ::wxFileSystemHandler&);
    virtual ~sipwxFileSystemHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    static  ::wxString sipProtect_GetAnchor(const  ::wxString&);
    static  ::wxString sipProtect_GetLeftLocation(const  ::wxString&);
    static  ::wxString sipProtect_GetProtocol(const  ::wxString&);
    static  ::wxString sipProtect_GetRightLocation(const  ::wxString&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxFSFile* OpenFile( ::wxFileSystem&,const  ::wxString&);
     ::wxString FindNext();
     ::wxString FindFirst(const  ::wxString&,int);
    bool CanOpen(const  ::wxString&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFileSystemHandler(const sipwxFileSystemHandler &);
    sipwxFileSystemHandler &operator = (const sipwxFileSystemHandler &);

    char sipPyMethods[4];
};

sipwxFileSystemHandler::sipwxFileSystemHandler():  ::wxFileSystemHandler(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemHandler::sipwxFileSystemHandler(const  ::wxFileSystemHandler& a0):  ::wxFileSystemHandler(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemHandler::~sipwxFileSystemHandler()
{
    sipInstanceDestroyed(sipPySelf);
}

 ::wxFSFile* sipwxFileSystemHandler::OpenFile( ::wxFileSystem& fs,const  ::wxString& location)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,sipName_FileSystemHandler,sipName_OpenFile);

    if (!sipMeth)
        return 0;

    extern  ::wxFSFile* sipVH__core_14(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxFileSystem&,const  ::wxString&);

    return sipVH__core_14(sipGILState, 0, sipPySelf, sipMeth, fs, location);
}

 ::wxString sipwxFileSystemHandler::FindNext()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_FindNext);

    if (!sipMeth)
        return  ::wxFileSystemHandler::FindNext();

    extern  ::wxString sipVH__core_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_13(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxString sipwxFileSystemHandler::FindFirst(const  ::wxString& wildcard,int flags)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_FindFirst);

    if (!sipMeth)
        return  ::wxFileSystemHandler::FindFirst(wildcard,flags);

    extern  ::wxString sipVH__core_12(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,int);

    return sipVH__core_12(sipGILState, 0, sipPySelf, sipMeth, wildcard, flags);
}

bool sipwxFileSystemHandler::CanOpen(const  ::wxString& location)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,sipName_FileSystemHandler,sipName_CanOpen);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, location);
}

 ::wxString sipwxFileSystemHandler::sipProtect_GetAnchor(const  ::wxString& location)
{
    return  ::wxFileSystemHandler::GetAnchor(location);
}

 ::wxString sipwxFileSystemHandler::sipProtect_GetLeftLocation(const  ::wxString& location)
{
    return  ::wxFileSystemHandler::GetLeftLocation(location);
}

 ::wxString sipwxFileSystemHandler::sipProtect_GetProtocol(const  ::wxString& location)
{
    return  ::wxFileSystemHandler::GetProtocol(location);
}

 ::wxString sipwxFileSystemHandler::sipProtect_GetRightLocation(const  ::wxString& location)
{
    return  ::wxFileSystemHandler::GetRightLocation(location);
}


PyDoc_STRVAR(doc_wxFileSystemHandler_CanOpen, "CanOpen(location) -> bool\n"
"\n"
"Returns true if the handler is able to open this file.");

extern "C" {static PyObject *meth_wxFileSystemHandler_CanOpen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_CanOpen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* location;
        int locationState = 0;
         ::wxFileSystemHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileSystemHandler, &sipCpp, sipType_wxString,&location, &locationState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_FileSystemHandler, sipName_CanOpen);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanOpen(*location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_CanOpen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_FindFirst, "FindFirst(wildcard, flags=0) -> String\n"
"\n"
"Works like wxFindFirstFile().");

extern "C" {static PyObject *meth_wxFileSystemHandler_FindFirst(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_FindFirst(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* wildcard;
        int wildcardState = 0;
        int flags = 0;
         ::wxFileSystemHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wildcard,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxFileSystemHandler, &sipCpp, sipType_wxString,&wildcard, &wildcardState, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxFileSystemHandler::FindFirst(*wildcard,flags) : sipCpp->FindFirst(*wildcard,flags)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(wildcard),sipType_wxString,wildcardState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_FindFirst, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_FindNext, "FindNext() -> String\n"
"\n"
"Returns next filename that matches parameters passed to\n"
"wxFileSystem::FindFirst.");

extern "C" {static PyObject *meth_wxFileSystemHandler_FindNext(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_FindNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxFileSystemHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxFileSystemHandler::FindNext() : sipCpp->FindNext()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_FindNext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_OpenFile, "OpenFile(fs, location) -> FSFile\n"
"\n"
"Opens the file and returns wxFSFile pointer or NULL if failed.");

extern "C" {static PyObject *meth_wxFileSystemHandler_OpenFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_OpenFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxFileSystem* fs;
        const  ::wxString* location;
        int locationState = 0;
         ::wxFileSystemHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fs,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxFileSystemHandler, &sipCpp, sipType_wxFileSystem, &fs, sipType_wxString,&location, &locationState))
        {
             ::wxFSFile*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_FileSystemHandler, sipName_OpenFile);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OpenFile(*fs,*location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFSFile,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_OpenFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_GetMimeTypeFromExt, "GetMimeTypeFromExt(location) -> String\n"
"\n"
"Returns the MIME type based on extension of location.");

extern "C" {static PyObject *meth_wxFileSystemHandler_GetMimeTypeFromExt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_GetMimeTypeFromExt(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxFileSystemHandler::GetMimeTypeFromExt(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_GetMimeTypeFromExt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_GetAnchor, "GetAnchor(location) -> String\n"
"\n"
"Returns the anchor if present in the location.");

extern "C" {static PyObject *meth_wxFileSystemHandler_GetAnchor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_GetAnchor(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipwxFileSystemHandler::sipProtect_GetAnchor(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_GetAnchor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_GetLeftLocation, "GetLeftLocation(location) -> String\n"
"\n"
"Returns the left location string extracted from location.");

extern "C" {static PyObject *meth_wxFileSystemHandler_GetLeftLocation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_GetLeftLocation(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipwxFileSystemHandler::sipProtect_GetLeftLocation(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_GetLeftLocation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_GetProtocol, "GetProtocol(location) -> String\n"
"\n"
"Returns the protocol string extracted from location.");

extern "C" {static PyObject *meth_wxFileSystemHandler_GetProtocol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_GetProtocol(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipwxFileSystemHandler::sipProtect_GetProtocol(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_GetProtocol, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemHandler_GetRightLocation, "GetRightLocation(location) -> String\n"
"\n"
"Returns the right location string extracted from location.");

extern "C" {static PyObject *meth_wxFileSystemHandler_GetRightLocation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemHandler_GetRightLocation(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipwxFileSystemHandler::sipProtect_GetRightLocation(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemHandler, sipName_GetRightLocation, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileSystemHandler(void *, const sipTypeDef *);}
static void *cast_wxFileSystemHandler(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileSystemHandler *sipCpp = reinterpret_cast< ::wxFileSystemHandler *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileSystemHandler(void *, int);}
static void release_wxFileSystemHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxFileSystemHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFileSystemHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileSystemHandler(sipSimpleWrapper *);}
static void dealloc_wxFileSystemHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFileSystemHandler *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileSystemHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFileSystemHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileSystemHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFileSystemHandler *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxFileSystemHandler* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxFileSystemHandler, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemHandler(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileSystemHandler[] = {{352, 255, 1}};


static PyMethodDef methods_wxFileSystemHandler[] = {
    {SIP_MLNAME_CAST(sipName_CanOpen), (PyCFunction)meth_wxFileSystemHandler_CanOpen, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_CanOpen)},
    {SIP_MLNAME_CAST(sipName_FindFirst), (PyCFunction)meth_wxFileSystemHandler_FindFirst, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_FindFirst)},
    {SIP_MLNAME_CAST(sipName_FindNext), meth_wxFileSystemHandler_FindNext, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_FindNext)},
    {SIP_MLNAME_CAST(sipName_GetAnchor), (PyCFunction)meth_wxFileSystemHandler_GetAnchor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_GetAnchor)},
    {SIP_MLNAME_CAST(sipName_GetLeftLocation), (PyCFunction)meth_wxFileSystemHandler_GetLeftLocation, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_GetLeftLocation)},
    {SIP_MLNAME_CAST(sipName_GetMimeTypeFromExt), (PyCFunction)meth_wxFileSystemHandler_GetMimeTypeFromExt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_GetMimeTypeFromExt)},
    {SIP_MLNAME_CAST(sipName_GetProtocol), (PyCFunction)meth_wxFileSystemHandler_GetProtocol, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_GetProtocol)},
    {SIP_MLNAME_CAST(sipName_GetRightLocation), (PyCFunction)meth_wxFileSystemHandler_GetRightLocation, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_GetRightLocation)},
    {SIP_MLNAME_CAST(sipName_OpenFile), (PyCFunction)meth_wxFileSystemHandler_OpenFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemHandler_OpenFile)}
};

PyDoc_STRVAR(doc_wxFileSystemHandler, "FileSystemHandler()\n"
"\n"
"Classes derived from wxFileSystemHandler are used to access virtual\n"
"file systems.");


sipClassTypeDef sipTypeDef__core_wxFileSystemHandler = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFileSystemHandler,
        {0},
        0
    },
    {
        sipNameNr_FileSystemHandler,
        {0, 0, 1},
        9, methods_wxFileSystemHandler,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileSystemHandler,
    -1,
    -1,
    supers_wxFileSystemHandler,
    0,
    init_type_wxFileSystemHandler,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileSystemHandler,
    0,
    0,
    0,
    release_wxFileSystemHandler,
    cast_wxFileSystemHandler,
    0,
    0,
    0,
    0,
    0,
    0
};
