/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/fswatcher.h>

        #include <wx/event.h>
        #include <wx/event.h>
        #include <wx/eventfilter.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxFileSystemWatcher : public  ::wxFileSystemWatcher
{
public:
    sipwxFileSystemWatcher();
    virtual ~sipwxFileSystemWatcher();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtectVirt_TryBefore(bool, ::wxEvent&);
    bool sipProtectVirt_TryAfter(bool, ::wxEvent&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool RemoveAll();
    bool RemoveTree(const  ::wxFileName&);
    bool Remove(const  ::wxFileName&);
    bool AddTree(const  ::wxFileName&,int,const  ::wxString&);
    bool Add(const  ::wxFileName&,int);
    bool ProcessEvent( ::wxEvent&);
    bool TryBefore( ::wxEvent&);
    bool TryAfter( ::wxEvent&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFileSystemWatcher(const sipwxFileSystemWatcher &);
    sipwxFileSystemWatcher &operator = (const sipwxFileSystemWatcher &);

    char sipPyMethods[8];
};

sipwxFileSystemWatcher::sipwxFileSystemWatcher():  ::wxFileSystemWatcher(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemWatcher::~sipwxFileSystemWatcher()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxFileSystemWatcher::RemoveAll()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_RemoveAll);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::RemoveAll();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxFileSystemWatcher::RemoveTree(const  ::wxFileName& path)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_RemoveTree);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::RemoveTree(path);

    extern bool sipVH__core_218(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFileName&);

    return sipVH__core_218(sipGILState, 0, sipPySelf, sipMeth, path);
}

bool sipwxFileSystemWatcher::Remove(const  ::wxFileName& path)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_Remove);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::Remove(path);

    extern bool sipVH__core_218(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFileName&);

    return sipVH__core_218(sipGILState, 0, sipPySelf, sipMeth, path);
}

bool sipwxFileSystemWatcher::AddTree(const  ::wxFileName& path,int events,const  ::wxString& filter)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_AddTree);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::AddTree(path,events,filter);

    extern bool sipVH__core_217(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFileName&,int,const  ::wxString&);

    return sipVH__core_217(sipGILState, 0, sipPySelf, sipMeth, path, events, filter);
}

bool sipwxFileSystemWatcher::Add(const  ::wxFileName& path,int events)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_Add);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::Add(path,events);

    extern bool sipVH__core_216(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFileName&,int);

    return sipVH__core_216(sipGILState, 0, sipPySelf, sipMeth, path, events);
}

bool sipwxFileSystemWatcher::ProcessEvent( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_ProcessEvent);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::ProcessEvent(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxFileSystemWatcher::TryBefore( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_TryBefore);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::TryBefore(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxFileSystemWatcher::TryAfter( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_TryAfter);

    if (!sipMeth)
        return  ::wxFileSystemWatcher::TryAfter(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxFileSystemWatcher::sipProtectVirt_TryBefore(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxEvtHandler::TryBefore(event) : TryBefore(event));
}

bool sipwxFileSystemWatcher::sipProtectVirt_TryAfter(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxEvtHandler::TryAfter(event) : TryAfter(event));
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_TryBefore, "TryBefore(event) -> bool\n"
"\n"
"Method called by ProcessEvent() before examining this object event\n"
"tables.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_TryBefore(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_TryBefore(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryBefore(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_TryBefore, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_TryAfter, "TryAfter(event) -> bool\n"
"\n"
"Method called by ProcessEvent() as last resort.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_TryAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_TryAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryAfter(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_TryAfter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_Add, "Add(path, events=FSW_EVENT_ALL) -> bool\n"
"\n"
"Adds path to currently watched files.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileName* path;
        int pathState = 0;
        int events = wxFSW_EVENT_ALL;
         ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_events,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxFileName,&path, &pathState, &events))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcher::Add(*path,events) : sipCpp->Add(*path,events));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(path),sipType_wxFileName,pathState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_Add, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_AddTree, "AddTree(path, events=FSW_EVENT_ALL, filter=EmptyString) -> bool\n"
"\n"
"This is the same as Add(), but also recursively adds every\n"
"file/directory in the tree rooted at path.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_AddTree(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_AddTree(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileName* path;
        int pathState = 0;
        int events = wxFSW_EVENT_ALL;
        const  ::wxString& filterdef = wxEmptyString;
        const  ::wxString* filter = &filterdef;
        int filterState = 0;
         ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_events,
            sipName_filter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|iJ1", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxFileName,&path, &pathState, &events, sipType_wxString,&filter, &filterState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcher::AddTree(*path,events,*filter) : sipCpp->AddTree(*path,events,*filter));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(path),sipType_wxFileName,pathState);
            sipReleaseType(const_cast< ::wxString *>(filter),sipType_wxString,filterState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_AddTree, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_Remove, "Remove(path) -> bool\n"
"\n"
"Removes path from the list of watched paths.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_Remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_Remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileName* path;
        int pathState = 0;
         ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxFileName,&path, &pathState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcher::Remove(*path) : sipCpp->Remove(*path));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(path),sipType_wxFileName,pathState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_Remove, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_RemoveTree, "RemoveTree(path) -> bool\n"
"\n"
"This is the same as Remove(), but also removes every file/directory\n"
"belonging to the tree rooted at path.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_RemoveTree(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_RemoveTree(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileName* path;
        int pathState = 0;
         ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxFileName,&path, &pathState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcher::RemoveTree(*path) : sipCpp->RemoveTree(*path));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(path),sipType_wxFileName,pathState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_RemoveTree, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_RemoveAll, "RemoveAll() -> bool\n"
"\n"
"Clears the list of currently watched paths.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_RemoveAll(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_RemoveAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxFileSystemWatcher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcher::RemoveAll() : sipCpp->RemoveAll());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_RemoveAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_GetWatchedPathsCount, "GetWatchedPathsCount() -> int\n"
"\n"
"Returns the number of currently watched paths.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_GetWatchedPathsCount(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_GetWatchedPathsCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWatchedPathsCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_GetWatchedPathsCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_GetWatchedPaths, "GetWatchedPaths(paths) -> int\n"
"\n"
"Retrieves all watched paths and places them in paths.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_GetWatchedPaths(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_GetWatchedPaths(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxArrayString* paths;
        int pathsState = 0;
        const  ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_paths,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxArrayString,&paths, &pathsState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWatchedPaths(paths);
            Py_END_ALLOW_THREADS
            sipReleaseType(paths,sipType_wxArrayString,pathsState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_GetWatchedPaths, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcher_SetOwner, "SetOwner(handler)\n"
"\n"
"Associates the file system watcher with the given handler object.");

extern "C" {static PyObject *meth_wxFileSystemWatcher_SetOwner(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcher_SetOwner(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxEvtHandler* handler;
         ::wxFileSystemWatcher *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxFileSystemWatcher, &sipCpp, sipType_wxEvtHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOwner(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcher, sipName_SetOwner, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileSystemWatcher(void *, const sipTypeDef *);}
static void *cast_wxFileSystemWatcher(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileSystemWatcher *sipCpp = reinterpret_cast< ::wxFileSystemWatcher *>(sipCppV);

    if (targetType == sipType_wxEvtHandler)
        return static_cast< ::wxEvtHandler *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    if (targetType == sipType_wxTrackable)
        return static_cast< ::wxTrackable *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileSystemWatcher(void *, int);}
static void release_wxFileSystemWatcher(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxFileSystemWatcher *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFileSystemWatcher *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileSystemWatcher(sipSimpleWrapper *);}
static void dealloc_wxFileSystemWatcher(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFileSystemWatcher *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileSystemWatcher(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFileSystemWatcher(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileSystemWatcher(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFileSystemWatcher *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemWatcher();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileSystemWatcher[] = {{143, 255, 1}};


static PyMethodDef methods_wxFileSystemWatcher[] = {
    {SIP_MLNAME_CAST(sipName_Add), (PyCFunction)meth_wxFileSystemWatcher_Add, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_Add)},
    {SIP_MLNAME_CAST(sipName_AddTree), (PyCFunction)meth_wxFileSystemWatcher_AddTree, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_AddTree)},
    {SIP_MLNAME_CAST(sipName_GetWatchedPaths), (PyCFunction)meth_wxFileSystemWatcher_GetWatchedPaths, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_GetWatchedPaths)},
    {SIP_MLNAME_CAST(sipName_GetWatchedPathsCount), meth_wxFileSystemWatcher_GetWatchedPathsCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_GetWatchedPathsCount)},
    {SIP_MLNAME_CAST(sipName_Remove), (PyCFunction)meth_wxFileSystemWatcher_Remove, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_Remove)},
    {SIP_MLNAME_CAST(sipName_RemoveAll), meth_wxFileSystemWatcher_RemoveAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_RemoveAll)},
    {SIP_MLNAME_CAST(sipName_RemoveTree), (PyCFunction)meth_wxFileSystemWatcher_RemoveTree, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_RemoveTree)},
    {SIP_MLNAME_CAST(sipName_SetOwner), (PyCFunction)meth_wxFileSystemWatcher_SetOwner, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystemWatcher_SetOwner)},
    {SIP_MLNAME_CAST(sipName_TryAfter), (PyCFunction)meth_wxFileSystemWatcher_TryAfter, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_TryBefore), (PyCFunction)meth_wxFileSystemWatcher_TryBefore, METH_VARARGS|METH_KEYWORDS, NULL}
};

sipVariableDef variables_wxFileSystemWatcher[] = {
    {PropertyVariable, sipName_WatchedPathsCount, &methods_wxFileSystemWatcher[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFileSystemWatcher, "FileSystemWatcher()\n"
"\n"
"The wxFileSystemWatcher class allows to receive notifications of file\n"
"system changes.");


sipClassTypeDef sipTypeDef__core_wxFileSystemWatcher = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFileSystemWatcher,
        {0},
        0
    },
    {
        sipNameNr_FileSystemWatcher,
        {0, 0, 1},
        10, methods_wxFileSystemWatcher,
        0, 0,
        1, variables_wxFileSystemWatcher,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileSystemWatcher,
    -1,
    -1,
    supers_wxFileSystemWatcher,
    0,
    init_type_wxFileSystemWatcher,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileSystemWatcher,
    0,
    0,
    0,
    release_wxFileSystemWatcher,
    cast_wxFileSystemWatcher,
    0,
    0,
    0,
    0,
    0,
    0
};
