/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/dragimag.h>
        #include <wx/generic/dragimgg.h>

        #include <wx/bitmap.h>
        #include <wx/cursor.h>
        #include <wx/icon.h>
        #include <wx/treectrl.h>
        #include <wx/treebase.h>
        #include <wx/listctrl.h>
        #include <wx/dc.h>
        #include <wx/dcmemory.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/window.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxGenericDragImage : public  ::wxGenericDragImage
{
public:
    sipwxGenericDragImage();
    sipwxGenericDragImage(const  ::wxBitmap&,const  ::wxCursor&);
    sipwxGenericDragImage(const  ::wxIcon&,const  ::wxCursor&);
    sipwxGenericDragImage(const  ::wxString&,const  ::wxCursor&);
    sipwxGenericDragImage(const  ::wxTreeCtrl&, ::wxTreeItemId&);
    sipwxGenericDragImage(const  ::wxListCtrl&,long);
    virtual ~sipwxGenericDragImage();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool UpdateBackingFromWindow( ::wxDC&, ::wxMemoryDC&,const  ::wxRect&,const  ::wxRect&) const;
     ::wxRect GetImageRect(const  ::wxPoint&) const;
    bool DoDrawImage( ::wxDC&,const  ::wxPoint&) const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxGenericDragImage(const sipwxGenericDragImage &);
    sipwxGenericDragImage &operator = (const sipwxGenericDragImage &);

    char sipPyMethods[3];
};

sipwxGenericDragImage::sipwxGenericDragImage():  ::wxGenericDragImage(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::sipwxGenericDragImage(const  ::wxBitmap& image,const  ::wxCursor& cursor):  ::wxGenericDragImage(image,cursor), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::sipwxGenericDragImage(const  ::wxIcon& image,const  ::wxCursor& cursor):  ::wxGenericDragImage(image,cursor), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::sipwxGenericDragImage(const  ::wxString& text,const  ::wxCursor& cursor):  ::wxGenericDragImage(text,cursor), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::sipwxGenericDragImage(const  ::wxTreeCtrl& treeCtrl, ::wxTreeItemId& id):  ::wxGenericDragImage(treeCtrl,id), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::sipwxGenericDragImage(const  ::wxListCtrl& listCtrl,long id):  ::wxGenericDragImage(listCtrl,id), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxGenericDragImage::~sipwxGenericDragImage()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxGenericDragImage::UpdateBackingFromWindow( ::wxDC& windowDC, ::wxMemoryDC& destDC,const  ::wxRect& sourceRect,const  ::wxRect& destRect) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_UpdateBackingFromWindow);

    if (!sipMeth)
        return  ::wxGenericDragImage::UpdateBackingFromWindow(windowDC,destDC,sourceRect,destRect);

    extern bool sipVH__core_188(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDC&, ::wxMemoryDC&,const  ::wxRect&,const  ::wxRect&);

    return sipVH__core_188(sipGILState, 0, sipPySelf, sipMeth, windowDC, destDC, sourceRect, destRect);
}

 ::wxRect sipwxGenericDragImage::GetImageRect(const  ::wxPoint& pos) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetImageRect);

    if (!sipMeth)
        return  ::wxGenericDragImage::GetImageRect(pos);

    extern  ::wxRect sipVH__core_187(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxPoint&);

    return sipVH__core_187(sipGILState, 0, sipPySelf, sipMeth, pos);
}

bool sipwxGenericDragImage::DoDrawImage( ::wxDC& dc,const  ::wxPoint& pos) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[2]),sipPySelf,NULL,sipName_DoDrawImage);

    if (!sipMeth)
        return  ::wxGenericDragImage::DoDrawImage(dc,pos);

    extern bool sipVH__core_186(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDC&,const  ::wxPoint&);

    return sipVH__core_186(sipGILState, 0, sipPySelf, sipMeth, dc, pos);
}


PyDoc_STRVAR(doc_wxGenericDragImage_BeginDrag, "BeginDrag(hotspot, window, fullScreen=False, rect=None) -> bool\n"
"BeginDrag(hotspot, window, boundingWindow) -> bool\n"
"\n"
"Start dragging the image, in a window or full screen.\n"
"");

extern "C" {static PyObject *meth_wxGenericDragImage_BeginDrag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_BeginDrag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* hotspot;
        int hotspotState = 0;
         ::wxWindow* window;
        bool fullScreen = 0;
         ::wxRect* rect = 0;
        int rectState = 0;
         ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hotspot,
            sipName_window,
            sipName_fullScreen,
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8|bJ0", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxPoint, &hotspot, &hotspotState, sipType_wxWindow, &window, &fullScreen, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->BeginDrag(*hotspot,window,fullScreen,rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(hotspot),sipType_wxPoint,hotspotState);
            sipReleaseType(rect,sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxPoint* hotspot;
        int hotspotState = 0;
         ::wxWindow* window;
         ::wxWindow* boundingWindow;
         ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hotspot,
            sipName_window,
            sipName_boundingWindow,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8J8", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxPoint, &hotspot, &hotspotState, sipType_wxWindow, &window, sipType_wxWindow, &boundingWindow))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->BeginDrag(*hotspot,window,boundingWindow);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(hotspot),sipType_wxPoint,hotspotState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_BeginDrag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_DoDrawImage, "DoDrawImage(dc, pos) -> bool\n"
"\n"
"Draws the image on the device context with top-left corner at the\n"
"given position.");

extern "C" {static PyObject *meth_wxGenericDragImage_DoDrawImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_DoDrawImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDC* dc;
        const  ::wxPoint* pos;
        int posState = 0;
        const  ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxDC, &dc, sipType_wxPoint, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxGenericDragImage::DoDrawImage(*dc,*pos) : sipCpp->DoDrawImage(*dc,*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_DoDrawImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_EndDrag, "EndDrag() -> bool\n"
"\n"
"Call this when the drag has finished.");

extern "C" {static PyObject *meth_wxGenericDragImage_EndDrag(PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_EndDrag(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGenericDragImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGenericDragImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EndDrag();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_EndDrag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_GetImageRect, "GetImageRect(pos) -> Rect\n"
"\n"
"Returns the rectangle enclosing the image, assuming that the image is\n"
"drawn with its top-left corner at the given point.");

extern "C" {static PyObject *meth_wxGenericDragImage_GetImageRect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_GetImageRect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxPoint* pos;
        int posState = 0;
        const  ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxPoint, &pos, &posState))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect((sipSelfWasArg ? sipCpp-> ::wxGenericDragImage::GetImageRect(*pos) : sipCpp->GetImageRect(*pos)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_GetImageRect, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_Hide, "Hide() -> bool\n"
"\n"
"Hides the image.");

extern "C" {static PyObject *meth_wxGenericDragImage_Hide(PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_Hide(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGenericDragImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGenericDragImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Hide();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_Hide, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_Move, "Move(pt) -> bool\n"
"\n"
"Call this to move the image to a new position.");

extern "C" {static PyObject *meth_wxGenericDragImage_Move(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_Move(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Move(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_Move, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_Show, "Show() -> bool\n"
"\n"
"Shows the image.");

extern "C" {static PyObject *meth_wxGenericDragImage_Show(PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_Show(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGenericDragImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGenericDragImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Show();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_Show, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGenericDragImage_UpdateBackingFromWindow, "UpdateBackingFromWindow(windowDC, destDC, sourceRect, destRect) -> bool\n"
"\n"
"Override this if you wish to draw the window contents to the backing\n"
"bitmap yourself.");

extern "C" {static PyObject *meth_wxGenericDragImage_UpdateBackingFromWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGenericDragImage_UpdateBackingFromWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDC* windowDC;
         ::wxMemoryDC* destDC;
        const  ::wxRect* sourceRect;
        int sourceRectState = 0;
        const  ::wxRect* destRect;
        int destRectState = 0;
        const  ::wxGenericDragImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_windowDC,
            sipName_destDC,
            sipName_sourceRect,
            sipName_destRect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J9J1J1", &sipSelf, sipType_wxGenericDragImage, &sipCpp, sipType_wxDC, &windowDC, sipType_wxMemoryDC, &destDC, sipType_wxRect, &sourceRect, &sourceRectState, sipType_wxRect, &destRect, &destRectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxGenericDragImage::UpdateBackingFromWindow(*windowDC,*destDC,*sourceRect,*destRect) : sipCpp->UpdateBackingFromWindow(*windowDC,*destDC,*sourceRect,*destRect));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(sourceRect),sipType_wxRect,sourceRectState);
            sipReleaseType(const_cast< ::wxRect *>(destRect),sipType_wxRect,destRectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GenericDragImage, sipName_UpdateBackingFromWindow, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGenericDragImage(void *, const sipTypeDef *);}
static void *cast_wxGenericDragImage(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxGenericDragImage *sipCpp = reinterpret_cast< ::wxGenericDragImage *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGenericDragImage(void *, int);}
static void release_wxGenericDragImage(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxGenericDragImage *>(sipCppV);
    else
        delete reinterpret_cast< ::wxGenericDragImage *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxGenericDragImage(sipSimpleWrapper *);}
static void dealloc_wxGenericDragImage(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxGenericDragImage *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGenericDragImage(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxGenericDragImage(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGenericDragImage(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxGenericDragImage *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* image;
        const  ::wxCursor& cursordef = wxNullCursor;
        const  ::wxCursor* cursor = &cursordef;

        static const char *sipKwdList[] = {
            sipName_image,
            sipName_cursor,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|J9", sipType_wxBitmap, &image, sipType_wxCursor, &cursor))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage(*image,*cursor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxIcon* image;
        const  ::wxCursor& cursordef = wxNullCursor;
        const  ::wxCursor* cursor = &cursordef;

        static const char *sipKwdList[] = {
            sipName_image,
            sipName_cursor,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|J9", sipType_wxIcon, &image, sipType_wxCursor, &cursor))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage(*image,*cursor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxCursor& cursordef = wxNullCursor;
        const  ::wxCursor* cursor = &cursordef;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_cursor,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J9", sipType_wxString,&text, &textState, sipType_wxCursor, &cursor))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage(*text,*cursor);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxTreeCtrl* treeCtrl;
         ::wxTreeItemId* id;

        static const char *sipKwdList[] = {
            sipName_treeCtrl,
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9", sipType_wxTreeCtrl, &treeCtrl, sipType_wxTreeItemId, &id))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage(*treeCtrl,*id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxListCtrl* listCtrl;
        long id;

        static const char *sipKwdList[] = {
            sipName_listCtrl,
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9l", sipType_wxListCtrl, &listCtrl, &id))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxGenericDragImage(*listCtrl,id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGenericDragImage[] = {{352, 255, 1}};


static PyMethodDef methods_wxGenericDragImage[] = {
    {SIP_MLNAME_CAST(sipName_BeginDrag), (PyCFunction)meth_wxGenericDragImage_BeginDrag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGenericDragImage_BeginDrag)},
    {SIP_MLNAME_CAST(sipName_DoDrawImage), (PyCFunction)meth_wxGenericDragImage_DoDrawImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGenericDragImage_DoDrawImage)},
    {SIP_MLNAME_CAST(sipName_EndDrag), meth_wxGenericDragImage_EndDrag, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGenericDragImage_EndDrag)},
    {SIP_MLNAME_CAST(sipName_GetImageRect), (PyCFunction)meth_wxGenericDragImage_GetImageRect, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGenericDragImage_GetImageRect)},
    {SIP_MLNAME_CAST(sipName_Hide), meth_wxGenericDragImage_Hide, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGenericDragImage_Hide)},
    {SIP_MLNAME_CAST(sipName_Move), (PyCFunction)meth_wxGenericDragImage_Move, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGenericDragImage_Move)},
    {SIP_MLNAME_CAST(sipName_Show), meth_wxGenericDragImage_Show, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGenericDragImage_Show)},
    {SIP_MLNAME_CAST(sipName_UpdateBackingFromWindow), (PyCFunction)meth_wxGenericDragImage_UpdateBackingFromWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGenericDragImage_UpdateBackingFromWindow)}
};

PyDoc_STRVAR(doc_wxGenericDragImage, "GenericDragImage()\n"
"GenericDragImage(image, cursor=NullCursor)\n"
"GenericDragImage(image, cursor=NullCursor)\n"
"GenericDragImage(text, cursor=NullCursor)\n"
"GenericDragImage(treeCtrl, id)\n"
"GenericDragImage(listCtrl, id)\n"
"\n"
"This class is used when you wish to drag an object on the screen, and\n"
"a simple cursor is not enough.");


sipClassTypeDef sipTypeDef__core_wxGenericDragImage = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGenericDragImage,
        {0},
        0
    },
    {
        sipNameNr_GenericDragImage,
        {0, 0, 1},
        8, methods_wxGenericDragImage,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxGenericDragImage,
    -1,
    -1,
    supers_wxGenericDragImage,
    0,
    init_type_wxGenericDragImage,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxGenericDragImage,
    0,
    0,
    0,
    release_wxGenericDragImage,
    cast_wxGenericDragImage,
    0,
    0,
    0,
    0,
    0,
    0
};
