/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/graphics.h>

        #include <wx/graphics.h>
        #include <wx/geometry.h>
        #include <wx/geometry.h>
        #include <wx/graphics.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxGraphicsPath_AddArc, "AddArc(x, y, r, startAngle, endAngle, clockwise)\n"
"AddArc(c, r, startAngle, endAngle, clockwise)\n"
"\n"
"Adds an arc of a circle.\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble r;
         ::wxDouble startAngle;
         ::wxDouble endAngle;
        bool clockwise;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_r,
            sipName_startAngle,
            sipName_endAngle,
            sipName_clockwise,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddddb", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &r, &startAngle, &endAngle, &clockwise))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArc(x,y,r,startAngle,endAngle,clockwise);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* c;
        int cState = 0;
         ::wxDouble r;
         ::wxDouble startAngle;
         ::wxDouble endAngle;
        bool clockwise;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
            sipName_r,
            sipName_startAngle,
            sipName_endAngle,
            sipName_clockwise,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1dddb", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c, &cState, &r, &startAngle, &endAngle, &clockwise))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArc(*c,r,startAngle,endAngle,clockwise);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c),sipType_wxPoint2DDouble,cState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddArc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddArcToPoint, "AddArcToPoint(x1, y1, x2, y2, r)\n"
"\n"
"Appends a an arc to two tangents connecting (current) to (x1,y1) and\n"
"(x1,y1) to (x2,y2), also a straight line from (current) to (x1,y1).");

extern "C" {static PyObject *meth_wxGraphicsPath_AddArcToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddArcToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x1;
         ::wxDouble y1;
         ::wxDouble x2;
         ::wxDouble y2;
         ::wxDouble r;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_r,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x1, &y1, &x2, &y2, &r))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArcToPoint(x1,y1,x2,y2,r);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddArcToPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddCircle, "AddCircle(x, y, r)\n"
"\n"
"Appends a circle around (x,y) with radius r as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddCircle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddCircle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble r;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_r,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &r))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCircle(x,y,r);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddCircle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddCurveToPoint, "AddCurveToPoint(cx1, cy1, cx2, cy2, x, y)\n"
"AddCurveToPoint(c1, c2, e)\n"
"\n"
"Adds a cubic bezier curve from the current point, using two control\n"
"points and an end point.\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddCurveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddCurveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble cx1;
         ::wxDouble cy1;
         ::wxDouble cx2;
         ::wxDouble cy2;
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cx1,
            sipName_cy1,
            sipName_cx2,
            sipName_cy2,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &cx1, &cy1, &cx2, &cy2, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCurveToPoint(cx1,cy1,cx2,cy2,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* c1;
        int c1State = 0;
        const  ::wxPoint2D* c2;
        int c2State = 0;
        const  ::wxPoint2D* e;
        int eState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c1,
            sipName_c2,
            sipName_e,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c1, &c1State, sipType_wxPoint2DDouble, &c2, &c2State, sipType_wxPoint2DDouble, &e, &eState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCurveToPoint(*c1,*c2,*e);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c1),sipType_wxPoint2DDouble,c1State);
            sipReleaseType(const_cast< ::wxPoint2D *>(c2),sipType_wxPoint2DDouble,c2State);
            sipReleaseType(const_cast< ::wxPoint2D *>(e),sipType_wxPoint2DDouble,eState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddCurveToPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddEllipse, "AddEllipse(x, y, w, h)\n"
"\n"
"Appends an ellipse fitting into the passed in rectangle.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddEllipse(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddEllipse, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddLineToPoint, "AddLineToPoint(x, y)\n"
"AddLineToPoint(p)\n"
"\n"
"Adds a straight line from the current point to (x,y).\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddLineToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddLineToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddLineToPoint(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* p;
        int pState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddLineToPoint(*p);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(p),sipType_wxPoint2DDouble,pState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddLineToPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddPath, "AddPath(path)\n"
"\n"
"Adds another path.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath* path;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxGraphicsPath, &path))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddPath(*path);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddQuadCurveToPoint, "AddQuadCurveToPoint(cx, cy, x, y)\n"
"\n"
"Adds a quadratic bezier curve from the current point, using a control\n"
"point and an end point.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddQuadCurveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddQuadCurveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble cx;
         ::wxDouble cy;
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cx,
            sipName_cy,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &cx, &cy, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddQuadCurveToPoint(cx,cy,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddQuadCurveToPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddRectangle, "AddRectangle(x, y, w, h)\n"
"\n"
"Appends a rectangle as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddRectangle(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddRoundedRectangle, "AddRoundedRectangle(x, y, w, h, radius)\n"
"\n"
"Appends a rounded rectangle as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxDouble radius;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddRoundedRectangle(x,y,w,h,radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddRoundedRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_CloseSubpath, "CloseSubpath()\n"
"\n"
"Closes the current sub-path.");

extern "C" {static PyObject *meth_wxGraphicsPath_CloseSubpath(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_CloseSubpath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CloseSubpath();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_CloseSubpath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_Contains, "Contains(c, fillStyle=ODDEVEN_RULE) -> bool\n"
"Contains(x, y, fillStyle=ODDEVEN_RULE) -> bool\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint2D* c;
        int cState = 0;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c, &cState, sipType_wxPolygonFillMode, &fillStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*c,fillStyle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c),sipType_wxPoint2DDouble,cState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd|E", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, sipType_wxPolygonFillMode, &fillStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x,y,fillStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_Contains, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetBox, "GetBox() -> Rect2D\n"
"\n"
"Gets the bounding box enclosing all points (possibly including control\n"
"points).");

extern "C" {static PyObject *meth_wxGraphicsPath_GetBox(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
             ::wxRect2D*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect2D(sipCpp->GetBox());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect2DDouble,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetBox, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetCurrentPoint, "GetCurrentPoint() -> Point2D\n"
"\n"
"Gets the last point of the current path, (0,0) if not yet set.");

extern "C" {static PyObject *meth_wxGraphicsPath_GetCurrentPoint(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetCurrentPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
             ::wxPoint2D*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2D(sipCpp->GetCurrentPoint());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetCurrentPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetNativePath, "GetNativePath() -> void\n"
"\n"
"Returns the native path (CGPathRef for Core Graphics, Path pointer for\n"
"GDIPlus and a cairo_path_t pointer for cairo).");

extern "C" {static PyObject *meth_wxGraphicsPath_GetNativePath(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetNativePath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
            void*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativePath();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetNativePath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_MoveToPoint, "MoveToPoint(x, y)\n"
"MoveToPoint(p)\n"
"\n"
"Begins a new subpath at (x,y).\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_MoveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_MoveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MoveToPoint(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* p;
        int pState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MoveToPoint(*p);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(p),sipType_wxPoint2DDouble,pState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_MoveToPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_Transform, "Transform(matrix)\n"
"\n"
"Transforms each point of this path by the matrix.");

extern "C" {static PyObject *meth_wxGraphicsPath_Transform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_Transform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsMatrix* matrix;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxGraphicsMatrix, &matrix))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Transform(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_Transform, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsPath_UnGetNativePath, "UnGetNativePath(p)\n"
"\n"
"Gives back the native path returned by GetNativePath() because there\n"
"might be some deallocations necessary (e.g.");

extern "C" {static PyObject *meth_wxGraphicsPath_UnGetNativePath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_UnGetNativePath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        void* p;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bv", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &p))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UnGetNativePath(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_UnGetNativePath, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGraphicsPath(void *, const sipTypeDef *);}
static void *cast_wxGraphicsPath(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxGraphicsPath *sipCpp = reinterpret_cast< ::wxGraphicsPath *>(sipCppV);

    if (targetType == sipType_wxGraphicsObject)
        return static_cast< ::wxGraphicsObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsPath(void *, int);}
static void release_wxGraphicsPath(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGraphicsPath *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxGraphicsPath(void *, SIP_SSIZE_T, void *);}
static void assign_wxGraphicsPath(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxGraphicsPath *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxGraphicsPath *>(sipSrc);
}


extern "C" {static void *array_wxGraphicsPath(SIP_SSIZE_T);}
static void *array_wxGraphicsPath(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxGraphicsPath[sipNrElem];
}


extern "C" {static void *copy_wxGraphicsPath(const void *, SIP_SSIZE_T);}
static void *copy_wxGraphicsPath(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxGraphicsPath(reinterpret_cast<const  ::wxGraphicsPath *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGraphicsPath(sipSimpleWrapper *);}
static void dealloc_wxGraphicsPath(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsPath(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGraphicsPath(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGraphicsPath(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxGraphicsPath *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsPath();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxGraphicsPath* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxGraphicsPath, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsPath(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGraphicsPath[] = {{216, 255, 1}};


static PyMethodDef methods_wxGraphicsPath[] = {
    {SIP_MLNAME_CAST(sipName_AddArc), (PyCFunction)meth_wxGraphicsPath_AddArc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddArc)},
    {SIP_MLNAME_CAST(sipName_AddArcToPoint), (PyCFunction)meth_wxGraphicsPath_AddArcToPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddArcToPoint)},
    {SIP_MLNAME_CAST(sipName_AddCircle), (PyCFunction)meth_wxGraphicsPath_AddCircle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddCircle)},
    {SIP_MLNAME_CAST(sipName_AddCurveToPoint), (PyCFunction)meth_wxGraphicsPath_AddCurveToPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddCurveToPoint)},
    {SIP_MLNAME_CAST(sipName_AddEllipse), (PyCFunction)meth_wxGraphicsPath_AddEllipse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddEllipse)},
    {SIP_MLNAME_CAST(sipName_AddLineToPoint), (PyCFunction)meth_wxGraphicsPath_AddLineToPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddLineToPoint)},
    {SIP_MLNAME_CAST(sipName_AddPath), (PyCFunction)meth_wxGraphicsPath_AddPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddPath)},
    {SIP_MLNAME_CAST(sipName_AddQuadCurveToPoint), (PyCFunction)meth_wxGraphicsPath_AddQuadCurveToPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddQuadCurveToPoint)},
    {SIP_MLNAME_CAST(sipName_AddRectangle), (PyCFunction)meth_wxGraphicsPath_AddRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddRectangle)},
    {SIP_MLNAME_CAST(sipName_AddRoundedRectangle), (PyCFunction)meth_wxGraphicsPath_AddRoundedRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_AddRoundedRectangle)},
    {SIP_MLNAME_CAST(sipName_CloseSubpath), meth_wxGraphicsPath_CloseSubpath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsPath_CloseSubpath)},
    {SIP_MLNAME_CAST(sipName_Contains), (PyCFunction)meth_wxGraphicsPath_Contains, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_Contains)},
    {SIP_MLNAME_CAST(sipName_GetBox), meth_wxGraphicsPath_GetBox, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsPath_GetBox)},
    {SIP_MLNAME_CAST(sipName_GetCurrentPoint), meth_wxGraphicsPath_GetCurrentPoint, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsPath_GetCurrentPoint)},
    {SIP_MLNAME_CAST(sipName_GetNativePath), meth_wxGraphicsPath_GetNativePath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsPath_GetNativePath)},
    {SIP_MLNAME_CAST(sipName_MoveToPoint), (PyCFunction)meth_wxGraphicsPath_MoveToPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_MoveToPoint)},
    {SIP_MLNAME_CAST(sipName_Transform), (PyCFunction)meth_wxGraphicsPath_Transform, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_Transform)},
    {SIP_MLNAME_CAST(sipName_UnGetNativePath), (PyCFunction)meth_wxGraphicsPath_UnGetNativePath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsPath_UnGetNativePath)}
};

sipVariableDef variables_wxGraphicsPath[] = {
    {PropertyVariable, sipName_NativePath, &methods_wxGraphicsPath[14], NULL, NULL, NULL},
    {PropertyVariable, sipName_CurrentPoint, &methods_wxGraphicsPath[13], NULL, NULL, NULL},
    {PropertyVariable, sipName_Box, &methods_wxGraphicsPath[12], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxGraphicsPath, "A wxGraphicsPath is a native representation of a geometric path.");


sipClassTypeDef sipTypeDef__core_wxGraphicsPath = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsPath,
        {0},
        0
    },
    {
        sipNameNr_GraphicsPath,
        {0, 0, 1},
        18, methods_wxGraphicsPath,
        0, 0,
        3, variables_wxGraphicsPath,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxGraphicsPath,
    -1,
    -1,
    supers_wxGraphicsPath,
    0,
    init_type_wxGraphicsPath,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxGraphicsPath,
    assign_wxGraphicsPath,
    array_wxGraphicsPath,
    copy_wxGraphicsPath,
    release_wxGraphicsPath,
    cast_wxGraphicsPath,
    0,
    0,
    0,
    0,
    0,
    0
};
