/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/windowid.h>



PyDoc_STRVAR(doc_wxIdManager_ReserveId, "ReserveId(count=1) -> WindowID\n"
"\n"
"Called directly by wxWindow::NewControlId(), this function will create\n"
"a new ID or range of IDs.");

extern "C" {static PyObject *meth_wxIdManager_ReserveId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIdManager_ReserveId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int count = 1;

        static const char *sipKwdList[] = {
            sipName_count,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|i", &count))
        {
             ::wxWindowID sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxIdManager::ReserveId(count);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IdManager, sipName_ReserveId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxIdManager_UnreserveId, "UnreserveId(id, count=1)\n"
"\n"
"Called directly by wxWindow::UnreserveControlId(), this function will\n"
"unreserve an ID or range of IDs that is currently reserved.");

extern "C" {static PyObject *meth_wxIdManager_UnreserveId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIdManager_UnreserveId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindowID id;
        int count = 1;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_count,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i|i", &id, &count))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxIdManager::UnreserveId(id,count);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_IdManager, sipName_UnreserveId, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxIdManager(void *, int);}
static void release_wxIdManager(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxIdManager *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxIdManager(void *, SIP_SSIZE_T, void *);}
static void assign_wxIdManager(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxIdManager *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxIdManager *>(sipSrc);
}


extern "C" {static void *array_wxIdManager(SIP_SSIZE_T);}
static void *array_wxIdManager(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxIdManager[sipNrElem];
}


extern "C" {static void *copy_wxIdManager(const void *, SIP_SSIZE_T);}
static void *copy_wxIdManager(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxIdManager(reinterpret_cast<const  ::wxIdManager *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxIdManager(sipSimpleWrapper *);}
static void dealloc_wxIdManager(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxIdManager(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxIdManager(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxIdManager(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxIdManager *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIdManager();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxIdManager* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxIdManager, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIdManager(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxIdManager[] = {
    {SIP_MLNAME_CAST(sipName_ReserveId), (PyCFunction)meth_wxIdManager_ReserveId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIdManager_ReserveId)},
    {SIP_MLNAME_CAST(sipName_UnreserveId), (PyCFunction)meth_wxIdManager_UnreserveId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIdManager_UnreserveId)}
};

PyDoc_STRVAR(doc_wxIdManager, "wxIdManager is responsible for allocating and releasing window IDs.");


sipClassTypeDef sipTypeDef__core_wxIdManager = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxIdManager,
        {0},
        0
    },
    {
        sipNameNr_IdManager,
        {0, 0, 1},
        2, methods_wxIdManager,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxIdManager,
    -1,
    -1,
    0,
    0,
    init_type_wxIdManager,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxIdManager,
    assign_wxIdManager,
    array_wxIdManager,
    copy_wxIdManager,
    release_wxIdManager,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
