/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/image.h>

        #include <wx/gdicmn.h>
        #include <wx/stream.h>
        #include <wx/image.h>
            #include <wx/image.h>
        #include <wx/image.h>
            #include <wx/image.h>
        #include <wx/image.h>
        #include <wx/gdicmn.h>
        #include <wx/palette.h>
        #include <wx/stream.h>
        #include <wx/image.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    bool _wxImage_Create(wxImage* self, int width, int height, wxPyBuffer* data)
    {
        if (! data->checkSize(width*height*3))
            return false;
        void* copy = data->copy();
        if (! copy)
            return false;
        return self->Create(width, height, (byte*)copy);
    }
    bool _wxImage_Create(wxImage* self, int width, int height, wxPyBuffer* data, wxPyBuffer* alpha)
    {
        void* dcopy; void* acopy;
        if (!data->checkSize(width*height*3) || !alpha->checkSize(width*height))
            return false;
        if ((dcopy = data->copy()) == NULL || (acopy = alpha->copy()) == NULL)
            return false;
        return self->Create(width, height, (byte*)dcopy, (byte*)acopy);
    }
    bool _wxImage_Create(wxImage* self, const wxSize* size, wxPyBuffer* data)
    {
        if (! data->checkSize(size->x*size->y*3))
            return false;
        void* copy = data->copy();
        if (! copy)
            return false;
        return self->Create(size->x, size->y, (byte*)copy);
    }
    bool _wxImage_Create(wxImage* self, const wxSize* size, wxPyBuffer* data, wxPyBuffer* alpha)
    {
        void* dcopy; void* acopy;
        if (!data->checkSize(size->x*size->y*3) || !alpha->checkSize(size->x*size->y))
            return false;
        if ((dcopy = data->copy()) == NULL || (acopy = alpha->copy()) == NULL)
            return false;
        return self->Create(size->x, size->y, (byte*)dcopy, (byte*)acopy);
    }
    PyObject* _wxImage_GetAlpha(wxImage* self)
    {
        byte* data = self->GetAlpha();
        Py_ssize_t len = self->GetWidth() * self->GetHeight();
        PyObject* rv = NULL;
        wxPyBLOCK_THREADS( rv = PyByteArray_FromStringAndSize((const char*)data, len));
        return rv;
    }
    PyObject* _wxImage_GetData(wxImage* self)
    {
        byte* data = self->GetData();
        Py_ssize_t len = self->GetWidth() * self->GetHeight() * 3;
        PyObject* rv = NULL;
        wxPyBLOCK_THREADS( rv = PyByteArray_FromStringAndSize((const char*)data, len));
        return rv;
    }
    void _wxImage_SetAlpha(wxImage* self, wxPyBuffer* alpha)
    {
        if (!alpha->checkSize(self->GetWidth()*self->GetHeight()))
            return;
        void* copy = alpha->copy();
        if (!copy)
            return;
        self->SetAlpha((byte*)copy, false);
    }
    void _wxImage_SetData(wxImage* self, wxPyBuffer* data)
    {
        if (!data->checkSize(self->GetWidth()*self->GetHeight()*3))
            return;
        void* copy = data->copy();
        if (!copy)
            return;
        self->SetData((byte*)copy, false);
    }
    void _wxImage_SetData(wxImage* self, wxPyBuffer* data, int new_width, int new_height)
    {
        if (!data->checkSize(new_width*new_height*3))
            return;
        void* copy = data->copy();
        if (!copy)
            return;
        self->SetData((byte*)copy, new_width, new_height, false);
    }
    PyObject* _wxImage_GetDataBuffer(wxImage* self)
    {
        byte* data = self->GetData();
        Py_ssize_t len = self->GetWidth() * self->GetHeight() * 3;
        PyObject* rv;
        wxPyThreadBlocker blocker;
        rv = wxPyMakeBuffer(data, len);
        return rv;
    }
    PyObject* _wxImage_GetAlphaBuffer(wxImage* self)
    {
        byte* data = self->GetAlpha();
        Py_ssize_t len = self->GetWidth() * self->GetHeight();
        PyObject* rv;
        wxPyThreadBlocker blocker;
        rv = wxPyMakeBuffer(data, len);
        return rv;
    }
    void _wxImage_SetDataBuffer(wxImage* self, wxPyBuffer* data)
    {
        if (!data->checkSize(self->GetWidth() * self->GetHeight() * 3))
            return;
        // True means don't free() the pointer
        self->SetData((byte*)data->m_ptr, true);
    }
    void _wxImage_SetDataBuffer(wxImage* self, wxPyBuffer* data, int new_width, int new_height)
    {
        if (!data->checkSize(new_width * new_height * 3))
            return;
        // True means don't free() the pointer
        self->SetData((byte*)data->m_ptr, new_width, new_height, true);
    }
    void _wxImage_SetAlphaBuffer(wxImage* self, wxPyBuffer* alpha)
    {
        if (!alpha->checkSize(self->GetWidth() * self->GetHeight()))
            return;
        // True means don't free() the pointer
        self->SetAlpha((byte*)alpha->m_ptr, true);
    }
    int _wxImage___nonzero__(wxImage* self)
    {
        return self->IsOk();
    }
    wxImage* _wxImage_AdjustChannels(wxImage* self, double factor_red, double factor_green, double factor_blue, double factor_alpha)
    {
        wxCHECK_MSG( self->Ok(), NULL, wxT("invalid image") );
        
        wxImage* dest = new wxImage( self->GetWidth(), self->GetHeight(), false );
        wxCHECK_MSG( dest && dest->IsOk(), NULL, wxT("unable to create image") );
        
        unsigned rgblen =   3 * self->GetWidth() * self->GetHeight();
        unsigned alphalen = self->GetWidth() * self->GetHeight();
        byte* src_data =  self->GetData();
        byte* src_alpha = self->GetAlpha();
        byte* dst_data =  dest->GetData();
        byte* dst_alpha = NULL;
        
        // adjust rgb
        if ( factor_red == 1.0 && factor_green == 1.0 && factor_blue == 1.0)
        {
            // nothing to do for RGB
            memcpy(dst_data, src_data, rgblen);
        }
        else
        {
            // rgb pixel for pixel
            for ( unsigned i = 0; i < rgblen; i= i + 3 )
            {
                dst_data[i] =     (byte) wxMin( 255, (int) (factor_red * src_data[i]) );
                dst_data[i + 1] = (byte) wxMin( 255, (int) (factor_green * src_data[i + 1]) );
                dst_data[i + 2] = (byte) wxMin( 255, (int) (factor_blue * src_data[i + 2]) );
            }
        }
        
        // adjust the mask colour
        if ( self->HasMask() )
        {
            dest->SetMaskColour((byte) wxMin( 255, (int) (factor_red * self->GetMaskRed() ) ),
                                (byte) wxMin( 255, (int) (factor_green * self->GetMaskGreen() ) ),
                                (byte) wxMin( 255, (int) (factor_blue * self->GetMaskBlue() ) ) );
        }
        
        // adjust the alpha channel
        if ( src_alpha )
        {
            // source image already has alpha information
            dest->SetAlpha(); // create an empty alpha channel (not initialized)
            dst_alpha = dest->GetAlpha();
        
            wxCHECK_MSG( dst_alpha, NULL, wxT("unable to create alpha data") );
        
            if ( factor_alpha == 1.0)
            {
                // no need to adjust
                memcpy(dst_alpha, src_alpha, alphalen);
            }
            else
            {
                // alpha value for alpha value
                for ( unsigned i = 0; i < alphalen; ++i )
                {
                    dst_alpha[i] = (byte) wxMin( 255, (int) (factor_alpha * src_alpha[i]) );
                }
            }
        }
        else if ( factor_alpha != 1.0 )
        {
            // no alpha yet but we want to adjust -> create
            dest->SetAlpha(); // create an empty alpha channel (not initialized)
            dst_alpha = dest->GetAlpha();
        
            wxCHECK_MSG( dst_alpha, NULL, wxT("unable to create alpha data") );
        
            for ( unsigned i = 0; i < alphalen; ++i )
            {
                dst_alpha[i] = (byte) wxMin( 255, (int) (factor_alpha * 255) );
            }
        }
        
        // do we have an alpha channel and a mask in the new image?
        if ( dst_alpha && dest->HasMask() )
        {
            // make the mask transparent honoring the alpha channel
            const byte mr = dest->GetMaskRed();
            const byte mg = dest->GetMaskGreen();
            const byte mb = dest->GetMaskBlue();
        
            for ( unsigned i = 0; i < alphalen; ++i )
            {
                int n = i * 3;
                dst_alpha[i] = ( dst_data[n] == mr && dst_data[n + 1] == mg && dst_data[n + 2] == mb )
                    ? wxIMAGE_ALPHA_TRANSPARENT
                    : dst_alpha[i];
            }
        
            // remove the mask now
            dest->SetMask(false);
        }
        
        return dest;
    }


class sipwxImage : public  ::wxImage
{
public:
    sipwxImage();
    sipwxImage(int,int,bool);
    sipwxImage(const  ::wxSize&,bool);
    sipwxImage(const  ::wxString&, ::wxBitmapType,int);
    sipwxImage(const  ::wxString&,const  ::wxString&,int);
    sipwxImage( ::wxInputStream&, ::wxBitmapType,int);
    sipwxImage( ::wxInputStream&,const  ::wxString&,int);
    sipwxImage(const  ::wxImage&);
    virtual ~sipwxImage();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool SaveFile( ::wxOutputStream&, ::wxBitmapType) const;
    bool SaveFile(const  ::wxString&) const;
    bool SaveFile(const  ::wxString&,const  ::wxString&) const;
    bool SaveFile(const  ::wxString&, ::wxBitmapType) const;
    bool SaveFile( ::wxOutputStream&,const  ::wxString&) const;
    bool LoadFile( ::wxInputStream&,const  ::wxString&,int);
    bool LoadFile(const  ::wxString&,const  ::wxString&,int);
    bool LoadFile(const  ::wxString&, ::wxBitmapType,int);
    bool LoadFile( ::wxInputStream&, ::wxBitmapType,int);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxImage(const sipwxImage &);
    sipwxImage &operator = (const sipwxImage &);

    char sipPyMethods[9];
};

sipwxImage::sipwxImage():  ::wxImage(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage(int width,int height,bool clear):  ::wxImage(width,height,clear), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage(const  ::wxSize& sz,bool clear):  ::wxImage(sz,clear), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage(const  ::wxString& name, ::wxBitmapType type,int index):  ::wxImage(name,type,index), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage(const  ::wxString& name,const  ::wxString& mimetype,int index):  ::wxImage(name,mimetype,index), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage( ::wxInputStream& stream, ::wxBitmapType type,int index):  ::wxImage(stream,type,index), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage( ::wxInputStream& stream,const  ::wxString& mimetype,int index):  ::wxImage(stream,mimetype,index), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::sipwxImage(const  ::wxImage& a0):  ::wxImage(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImage::~sipwxImage()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxImage::SaveFile( ::wxOutputStream& stream, ::wxBitmapType type) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImage::SaveFile(stream,type);

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxOutputStream&, ::wxBitmapType);

    return sipVH__core_22(sipGILState, 0, sipPySelf, sipMeth, stream, type);
}

bool sipwxImage::SaveFile(const  ::wxString& name) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImage::SaveFile(name);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, name);
}

bool sipwxImage::SaveFile(const  ::wxString& name,const  ::wxString& mimetype) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[2]),sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImage::SaveFile(name,mimetype);

    extern bool sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    return sipVH__core_21(sipGILState, 0, sipPySelf, sipMeth, name, mimetype);
}

bool sipwxImage::SaveFile(const  ::wxString& name, ::wxBitmapType type) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[3]),sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImage::SaveFile(name,type);

    extern bool sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&, ::wxBitmapType);

    return sipVH__core_20(sipGILState, 0, sipPySelf, sipMeth, name, type);
}

bool sipwxImage::SaveFile( ::wxOutputStream& stream,const  ::wxString& mimetype) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxImage::SaveFile(stream,mimetype);

    extern bool sipVH__core_19(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxOutputStream&,const  ::wxString&);

    return sipVH__core_19(sipGILState, 0, sipPySelf, sipMeth, stream, mimetype);
}

bool sipwxImage::LoadFile( ::wxInputStream& stream,const  ::wxString& mimetype,int index)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxImage::LoadFile(stream,mimetype,index);

    extern bool sipVH__core_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxInputStream&,const  ::wxString&,int);

    return sipVH__core_18(sipGILState, 0, sipPySelf, sipMeth, stream, mimetype, index);
}

bool sipwxImage::LoadFile(const  ::wxString& name,const  ::wxString& mimetype,int index)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxImage::LoadFile(name,mimetype,index);

    extern bool sipVH__core_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&,int);

    return sipVH__core_17(sipGILState, 0, sipPySelf, sipMeth, name, mimetype, index);
}

bool sipwxImage::LoadFile(const  ::wxString& name, ::wxBitmapType type,int index)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxImage::LoadFile(name,type,index);

    extern bool sipVH__core_16(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&, ::wxBitmapType,int);

    return sipVH__core_16(sipGILState, 0, sipPySelf, sipMeth, name, type, index);
}

bool sipwxImage::LoadFile( ::wxInputStream& stream, ::wxBitmapType type,int index)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxImage::LoadFile(stream,type,index);

    extern bool sipVH__core_15(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxInputStream&, ::wxBitmapType,int);

    return sipVH__core_15(sipGILState, 0, sipPySelf, sipMeth, stream, type, index);
}


PyDoc_STRVAR(doc_wxImage_Copy, "Copy() -> Image\n"
"\n"
"Returns an identical copy of this image.");

extern "C" {static PyObject *meth_wxImage_Copy(PyObject *, PyObject *);}
static PyObject *meth_wxImage_Copy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Copy());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Copy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Create, "Create(width, height, clear=True) -> bool\n"
"Create(sz, clear=True) -> bool\n"
"Create(width, height, data) -> bool\n"
"Create(width, height, data, alpha) -> bool\n"
"Create(size, data) -> bool\n"
"Create(size, data, alpha) -> bool\n"
"\n"
"Creates a fresh image.\n"
"\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImage_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
        bool clear = 1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_clear,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii|b", &sipSelf, sipType_wxImage, &sipCpp, &width, &height, &clear))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(width,height,clear);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxSize* sz;
        int szState = 0;
        bool clear = 1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
            sipName_clear,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxSize, &sz, &szState, &clear))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(*sz,clear);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiJ0", &sipSelf, sipType_wxImage, &sipCpp, &width, &height, sipType_wxPyBuffer,&data, &dataState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_Create(sipCpp, width, height, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxPyBuffer* alpha;
        int alphaState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiJ0J0", &sipSelf, sipType_wxImage, &sipCpp, &width, &height, sipType_wxPyBuffer,&data, &dataState, sipType_wxPyBuffer,&alpha, &alphaState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_Create(sipCpp, width, height, data, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxSize, &size, &sizeState, sipType_wxPyBuffer,&data, &dataState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_Create(sipCpp, size, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxPyBuffer* alpha;
        int alphaState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_data,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J0J0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxSize, &size, &sizeState, sipType_wxPyBuffer,&data, &dataState, sipType_wxPyBuffer,&alpha, &alphaState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_Create(sipCpp, size, data, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Create, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Clear, "Clear(value=0)\n"
"\n"
"Initialize the image data with zeroes (the default) or with the byte\n"
"value given as value.");

extern "C" {static PyObject *meth_wxImage_Clear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Clear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char value = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|c", &sipSelf, sipType_wxImage, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Destroy, "Destroy()\n"
"\n"
"Destroys the image data.");

extern "C" {static PyObject *meth_wxImage_Destroy(PyObject *, PyObject *);}
static PyObject *meth_wxImage_Destroy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Destroy();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Destroy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_InitAlpha, "InitAlpha()\n"
"\n"
"Initializes the image alpha channel data.");

extern "C" {static PyObject *meth_wxImage_InitAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxImage_InitAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->InitAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_InitAlpha, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Blur, "Blur(blurRadius) -> Image\n"
"\n"
"Blurs the image in both horizontal and vertical directions by the\n"
"specified pixel blurRadius.");

extern "C" {static PyObject *meth_wxImage_Blur(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Blur(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int blurRadius;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blurRadius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImage, &sipCpp, &blurRadius))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Blur(blurRadius));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Blur, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_BlurHorizontal, "BlurHorizontal(blurRadius) -> Image\n"
"\n"
"Blurs the image in the horizontal direction only.");

extern "C" {static PyObject *meth_wxImage_BlurHorizontal(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_BlurHorizontal(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int blurRadius;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blurRadius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImage, &sipCpp, &blurRadius))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->BlurHorizontal(blurRadius));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_BlurHorizontal, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_BlurVertical, "BlurVertical(blurRadius) -> Image\n"
"\n"
"Blurs the image in the vertical direction only.");

extern "C" {static PyObject *meth_wxImage_BlurVertical(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_BlurVertical(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int blurRadius;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blurRadius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxImage, &sipCpp, &blurRadius))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->BlurVertical(blurRadius));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_BlurVertical, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Mirror, "Mirror(horizontally=True) -> Image\n"
"\n"
"Returns a mirrored copy of the image.");

extern "C" {static PyObject *meth_wxImage_Mirror(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Mirror(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool horizontally = 1;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_horizontally,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxImage, &sipCpp, &horizontally))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Mirror(horizontally));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Mirror, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Paste, "Paste(image, x, y)\n"
"\n"
"Copy the data of the given image to the specified position in this\n"
"image.");

extern "C" {static PyObject *meth_wxImage_Paste(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Paste(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage* image;
        int x;
        int y;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_image,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9ii", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxImage, &image, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Paste(*image,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Paste, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Replace, "Replace(r1, g1, b1, r2, g2, b2)\n"
"\n"
"Replaces the colour specified by r1,g1,b1 by the colour r2,g2,b2.");

extern "C" {static PyObject *meth_wxImage_Replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char r1;
        unsigned char g1;
        unsigned char b1;
        unsigned char r2;
        unsigned char g2;
        unsigned char b2;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_r1,
            sipName_g1,
            sipName_b1,
            sipName_r2,
            sipName_g2,
            sipName_b2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BMMMMMM", &sipSelf, sipType_wxImage, &sipCpp, &r1, &g1, &b1, &r2, &g2, &b2))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Replace(r1,g1,b1,r2,g2,b2);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Replace, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Rescale, "Rescale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image\n"
"\n"
"Changes the size of the image in-place by scaling it: after a call to\n"
"this function,the image will have the given width and height.");

extern "C" {static PyObject *meth_wxImage_Rescale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Rescale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
         ::wxImageResizeQuality quality = wxIMAGE_QUALITY_NORMAL;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_quality,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii|E", &sipSelf, sipType_wxImage, &sipCpp, &width, &height, sipType_wxImageResizeQuality, &quality))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Rescale(width,height,quality);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Rescale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Resize, "Resize(size, pos, red=-1, green=-1, blue=-1) -> Image\n"
"\n"
"Changes the size of the image in-place without scaling it by adding\n"
"either a border with the given colour or cropping as necessary.");

extern "C" {static PyObject *meth_wxImage_Resize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Resize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
        const  ::wxPoint* pos;
        int posState = 0;
        int red = -1;
        int green = -1;
        int blue = -1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_pos,
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|iii", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxSize, &size, &sizeState, sipType_wxPoint, &pos, &posState, &red, &green, &blue))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Resize(*size,*pos,red,green,blue);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Resize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Rotate, "Rotate(angle, rotationCentre, interpolating=True, offsetAfterRotation=None) -> Image\n"
"\n"
"Rotates the image about the given point, by angle radians.");

extern "C" {static PyObject *meth_wxImage_Rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double angle;
        const  ::wxPoint* rotationCentre;
        int rotationCentreState = 0;
        bool interpolating = 1;
         ::wxPoint* offsetAfterRotation = 0;
        int offsetAfterRotationState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_angle,
            sipName_rotationCentre,
            sipName_interpolating,
            sipName_offsetAfterRotation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BdJ1|bJ0", &sipSelf, sipType_wxImage, &sipCpp, &angle, sipType_wxPoint, &rotationCentre, &rotationCentreState, &interpolating, sipType_wxPoint, &offsetAfterRotation, &offsetAfterRotationState))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Rotate(angle,*rotationCentre,interpolating,offsetAfterRotation));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(rotationCentre),sipType_wxPoint,rotationCentreState);
            sipReleaseType(offsetAfterRotation,sipType_wxPoint,offsetAfterRotationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Rotate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Rotate90, "Rotate90(clockwise=True) -> Image\n"
"\n"
"Returns a copy of the image rotated 90 degrees in the direction\n"
"indicated by clockwise.");

extern "C" {static PyObject *meth_wxImage_Rotate90(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Rotate90(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool clockwise = 1;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_clockwise,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxImage, &sipCpp, &clockwise))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Rotate90(clockwise));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Rotate90, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Rotate180, "Rotate180() -> Image\n"
"\n"
"Returns a copy of the image rotated by 180 degrees.");

extern "C" {static PyObject *meth_wxImage_Rotate180(PyObject *, PyObject *);}
static PyObject *meth_wxImage_Rotate180(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Rotate180());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Rotate180, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_RotateHue, "RotateHue(angle)\n"
"\n"
"Rotates the hue of each pixel in the image by angle, which is a double\n"
"in the range of -1.0 to +1.0, where -1.0 corresponds to -360 degrees\n"
"and +1.0 corresponds to +360 degrees.");

extern "C" {static PyObject *meth_wxImage_RotateHue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_RotateHue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double angle;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bd", &sipSelf, sipType_wxImage, &sipCpp, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RotateHue(angle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_RotateHue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Scale, "Scale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image\n"
"\n"
"Returns a scaled version of the image.");

extern "C" {static PyObject *meth_wxImage_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
         ::wxImageResizeQuality quality = wxIMAGE_QUALITY_NORMAL;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_quality,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii|E", &sipSelf, sipType_wxImage, &sipCpp, &width, &height, sipType_wxImageResizeQuality, &quality))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Scale(width,height,quality));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Scale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_Size, "Size(size, pos, red=-1, green=-1, blue=-1) -> Image\n"
"\n"
"Returns a resized version of this image without scaling it by adding\n"
"either a border with the given colour or cropping as necessary.");

extern "C" {static PyObject *meth_wxImage_Size(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_Size(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
        const  ::wxPoint* pos;
        int posState = 0;
        int red = -1;
        int green = -1;
        int blue = -1;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_pos,
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|iii", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxSize, &size, &sizeState, sipType_wxPoint, &pos, &posState, &red, &green, &blue))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->Size(*size,*pos,red,green,blue));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_Size, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ConvertAlphaToMask, "ConvertAlphaToMask(threshold=IMAGE_ALPHA_THRESHOLD) -> bool\n"
"ConvertAlphaToMask(mr, mg, mb, threshold=IMAGE_ALPHA_THRESHOLD) -> bool\n"
"\n"
"If the image has alpha channel, this method converts it to mask.\n"
"");

extern "C" {static PyObject *meth_wxImage_ConvertAlphaToMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_ConvertAlphaToMask(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char threshold = wxIMAGE_ALPHA_THRESHOLD;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_threshold,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|M", &sipSelf, sipType_wxImage, &sipCpp, &threshold))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ConvertAlphaToMask(threshold);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        unsigned char mr;
        unsigned char mg;
        unsigned char mb;
        unsigned char threshold = wxIMAGE_ALPHA_THRESHOLD;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mr,
            sipName_mg,
            sipName_mb,
            sipName_threshold,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BMMM|M", &sipSelf, sipType_wxImage, &sipCpp, &mr, &mg, &mb, &threshold))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ConvertAlphaToMask(mr,mg,mb,threshold);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ConvertAlphaToMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ConvertToGreyscale, "ConvertToGreyscale(weight_r, weight_g, weight_b) -> Image\n"
"ConvertToGreyscale() -> Image\n"
"\n"
"Returns a greyscale version of the image.\n"
"");

extern "C" {static PyObject *meth_wxImage_ConvertToGreyscale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_ConvertToGreyscale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double weight_r;
        double weight_g;
        double weight_b;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weight_r,
            sipName_weight_g,
            sipName_weight_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddd", &sipSelf, sipType_wxImage, &sipCpp, &weight_r, &weight_g, &weight_b))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->ConvertToGreyscale(weight_r,weight_g,weight_b));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    {
        const  ::wxImage *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->ConvertToGreyscale());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ConvertToGreyscale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ConvertToMono, "ConvertToMono(r, g, b) -> Image\n"
"\n"
"Returns monochromatic version of the image.");

extern "C" {static PyObject *meth_wxImage_ConvertToMono(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_ConvertToMono(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_r,
            sipName_g,
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BMMM", &sipSelf, sipType_wxImage, &sipCpp, &r, &g, &b))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->ConvertToMono(r,g,b));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ConvertToMono, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ConvertToDisabled, "ConvertToDisabled(brightness=255) -> Image\n"
"\n"
"Returns disabled (dimmed) version of the image.");

extern "C" {static PyObject *meth_wxImage_ConvertToDisabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_ConvertToDisabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char brightness = 255;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brightness,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|M", &sipSelf, sipType_wxImage, &sipCpp, &brightness))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->ConvertToDisabled(brightness));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ConvertToDisabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ComputeHistogram, "ComputeHistogram(histogram) -> unsignedlong\n"
"\n"
"Computes the histogram of the image.");

extern "C" {static PyObject *meth_wxImage_ComputeHistogram(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_ComputeHistogram(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImageHistogram* histogram;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_histogram,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxImageHistogram, &histogram))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ComputeHistogram(*histogram);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ComputeHistogram, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_FindFirstUnusedColour, "FindFirstUnusedColour(startR=1, startG=0, startB=0) -> (r, g, b)\n"
"\n"
"Finds the first colour that is never used in the image.");

extern "C" {static PyObject *meth_wxImage_FindFirstUnusedColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_FindFirstUnusedColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        unsigned char startR = 1;
        unsigned char startG = 0;
        unsigned char startB = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_startR,
            sipName_startG,
            sipName_startB,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|MMM", &sipSelf, sipType_wxImage, &sipCpp, &startR, &startG, &startB))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FindFirstUnusedColour(&r,&g,&b,startR,startG,startB);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(MMM)",r,g,b);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_FindFirstUnusedColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetAlpha, "GetAlpha(x, y) -> unsignedchar\n"
"GetAlpha() -> PyObject\n"
"\n"
"Return alpha value at given pixel location.\n"
"");

extern "C" {static PyObject *meth_wxImage_GetAlpha(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetAlpha(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxImage, &sipCpp, &x, &y))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAlpha(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    {
         ::wxImage *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_GetAlpha(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetAlpha, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetData, "GetData() -> PyObject\n"
"\n"
"Returns a copy of the RGB bytes of the image.");

extern "C" {static PyObject *meth_wxImage_GetData(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_GetData(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetRed, "GetRed(x, y) -> unsignedchar\n"
"\n"
"Returns the red intensity at the given coordinate.");

extern "C" {static PyObject *meth_wxImage_GetRed(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetRed(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxImage, &sipCpp, &x, &y))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRed(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetRed, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetGreen, "GetGreen(x, y) -> unsignedchar\n"
"\n"
"Returns the green intensity at the given coordinate.");

extern "C" {static PyObject *meth_wxImage_GetGreen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetGreen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxImage, &sipCpp, &x, &y))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetGreen(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetGreen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetBlue, "GetBlue(x, y) -> unsignedchar\n"
"\n"
"Returns the blue intensity at the given coordinate.");

extern "C" {static PyObject *meth_wxImage_GetBlue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetBlue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxImage, &sipCpp, &x, &y))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBlue(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetBlue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetMaskRed, "GetMaskRed() -> unsignedchar\n"
"\n"
"Gets the red value of the mask colour.");

extern "C" {static PyObject *meth_wxImage_GetMaskRed(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetMaskRed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaskRed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetMaskRed, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetMaskGreen, "GetMaskGreen() -> unsignedchar\n"
"\n"
"Gets the green value of the mask colour.");

extern "C" {static PyObject *meth_wxImage_GetMaskGreen(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetMaskGreen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaskGreen();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetMaskGreen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetMaskBlue, "GetMaskBlue() -> unsignedchar\n"
"\n"
"Gets the blue value of the mask colour.");

extern "C" {static PyObject *meth_wxImage_GetMaskBlue(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetMaskBlue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaskBlue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetMaskBlue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetWidth, "GetWidth() -> int\n"
"\n"
"Gets the width of the image in pixels.");

extern "C" {static PyObject *meth_wxImage_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetHeight, "GetHeight() -> int\n"
"\n"
"Gets the height of the image in pixels.");

extern "C" {static PyObject *meth_wxImage_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetSize, "GetSize() -> Size\n"
"\n"
"Returns the size of the image in pixels.");

extern "C" {static PyObject *meth_wxImage_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetOption, "GetOption(name) -> String\n"
"\n"
"Gets a user-defined string-valued option.");

extern "C" {static PyObject *meth_wxImage_GetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetOption(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOption(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetOptionInt, "GetOptionInt(name) -> int\n"
"\n"
"Gets a user-defined integer-valued option.");

extern "C" {static PyObject *meth_wxImage_GetOptionInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetOptionInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOptionInt(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetOptionInt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetOrFindMaskColour, "GetOrFindMaskColour() -> (r, g, b)\n"
"\n"
"Get the current mask colour or find a suitable unused colour that\n"
"could be used as a mask colour.");

extern "C" {static PyObject *meth_wxImage_GetOrFindMaskColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetOrFindMaskColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char r;
        unsigned char g;
        unsigned char b;
        const  ::wxImage *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetOrFindMaskColour(&r,&g,&b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(MMM)",r,g,b);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetOrFindMaskColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetPalette, "GetPalette() -> Palette\n"
"\n"
"Returns the palette associated with the image.");

extern "C" {static PyObject *meth_wxImage_GetPalette(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetPalette(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxPalette*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPalette(sipCpp->GetPalette());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPalette,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetPalette, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetSubImage, "GetSubImage(rect) -> Image\n"
"\n"
"Returns a sub image of the current one as long as the rect belongs\n"
"entirely to the image.");

extern "C" {static PyObject *meth_wxImage_GetSubImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetSubImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->GetSubImage(*rect));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetSubImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetType, "GetType() -> BitmapType\n"
"\n"
"Gets the type of image found by LoadFile() or specified with\n"
"SaveFile().");

extern "C" {static PyObject *meth_wxImage_GetType(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
             ::wxBitmapType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxBitmapType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_HasAlpha, "HasAlpha() -> bool\n"
"\n"
"Returns true if this image has alpha channel, false otherwise.");

extern "C" {static PyObject *meth_wxImage_HasAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxImage_HasAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_HasAlpha, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_HasMask, "HasMask() -> bool\n"
"\n"
"Returns true if there is a mask active, false otherwise.");

extern "C" {static PyObject *meth_wxImage_HasMask(PyObject *, PyObject *);}
static PyObject *meth_wxImage_HasMask(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasMask();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_HasMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_HasOption, "HasOption(name) -> bool\n"
"\n"
"Returns true if the given option is present.");

extern "C" {static PyObject *meth_wxImage_HasOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_HasOption(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasOption(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_HasOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if image data is present.");

extern "C" {static PyObject *meth_wxImage_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxImage_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_IsTransparent, "IsTransparent(x, y, threshold=IMAGE_ALPHA_THRESHOLD) -> bool\n"
"\n"
"Returns true if the given pixel is transparent, i.e. either has the\n"
"mask colour if this image has a mask or if this image has alpha\n"
"channel and alpha value of this pixel is strictly less than threshold.");

extern "C" {static PyObject *meth_wxImage_IsTransparent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_IsTransparent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        unsigned char threshold = wxIMAGE_ALPHA_THRESHOLD;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_threshold,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii|M", &sipSelf, sipType_wxImage, &sipCpp, &x, &y, &threshold))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsTransparent(x,y,threshold);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_IsTransparent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_LoadFile, "LoadFile(stream, type=BITMAP_TYPE_ANY, index=-1) -> bool\n"
"LoadFile(name, type=BITMAP_TYPE_ANY, index=-1) -> bool\n"
"LoadFile(name, mimetype, index=-1) -> bool\n"
"LoadFile(stream, mimetype, index=-1) -> bool\n"
"\n"
"Loads an image from an input stream.\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImage_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int index = -1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|Ei", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxInputStream, &stream, &streamState, sipType_wxBitmapType, &type, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::LoadFile(*stream,type,index) : sipCpp->LoadFile(*stream,type,index));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int index = -1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|Ei", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxBitmapType, &type, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::LoadFile(*name,type,index) : sipCpp->LoadFile(*name,type,index));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        int index = -1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_mimetype,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|i", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&mimetype, &mimetypeState, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::LoadFile(*name,*mimetype,index) : sipCpp->LoadFile(*name,*mimetype,index));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        int index = -1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_mimetype,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|i", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxInputStream, &stream, &streamState, sipType_wxString,&mimetype, &mimetypeState, &index))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::LoadFile(*stream,*mimetype,index) : sipCpp->LoadFile(*stream,*mimetype,index));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_LoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SaveFile, "SaveFile(stream, mimetype) -> bool\n"
"SaveFile(name, type) -> bool\n"
"SaveFile(name, mimetype) -> bool\n"
"SaveFile(name) -> bool\n"
"SaveFile(stream, type) -> bool\n"
"\n"
"Saves an image in the given stream.\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImage_SaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxOutputStream* stream;
        int streamState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_mimetype,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxOutputStream, &stream, &streamState, sipType_wxString,&mimetype, &mimetypeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::SaveFile(*stream,*mimetype) : sipCpp->SaveFile(*stream,*mimetype));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxOutputStream,streamState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1E", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxBitmapType, &type))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::SaveFile(*name,type) : sipCpp->SaveFile(*name,type));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_mimetype,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&mimetype, &mimetypeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::SaveFile(*name,*mimetype) : sipCpp->SaveFile(*name,*mimetype));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::SaveFile(*name) : sipCpp->SaveFile(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxOutputStream* stream;
        int streamState = 0;
         ::wxBitmapType type;
        const  ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1E", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxOutputStream, &stream, &streamState, sipType_wxBitmapType, &type))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxImage::SaveFile(*stream,type) : sipCpp->SaveFile(*stream,type));
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxOutputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SaveFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetAlpha, "SetAlpha(x, y, alpha)\n"
"SetAlpha(alpha)\n"
"\n"
"Sets the alpha value for the given pixel.\n"
"");

extern "C" {static PyObject *meth_wxImage_SetAlpha(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetAlpha(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        unsigned char alpha;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiM", &sipSelf, sipType_wxImage, &sipCpp, &x, &y, &alpha))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAlpha(x,y,alpha);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxPyBuffer* alpha;
        int alphaState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&alpha, &alphaState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetAlpha(sipCpp, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetAlpha, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_ClearAlpha, "ClearAlpha()\n"
"\n"
"Removes the alpha channel from the image.");

extern "C" {static PyObject *meth_wxImage_ClearAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxImage_ClearAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_ClearAlpha, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetData, "SetData(data)\n"
"SetData(data, new_width, new_height)\n"
"\n"
"Sets the image data without performing checks.\n"
"");

extern "C" {static PyObject *meth_wxImage_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&data, &dataState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetData(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxPyBuffer* data;
        int dataState = 0;
        int new_width;
        int new_height;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_new_width,
            sipName_new_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0ii", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&data, &dataState, &new_width, &new_height))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetData(sipCpp, data, new_width, new_height);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetMask, "SetMask(hasMask=True)\n"
"\n"
"Specifies whether there is a mask or not.");

extern "C" {static PyObject *meth_wxImage_SetMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetMask(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool hasMask = 1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hasMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxImage, &sipCpp, &hasMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMask(hasMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetMaskColour, "SetMaskColour(red, green, blue)\n"
"\n"
"Sets the mask colour for this image (and tells the image to use the\n"
"mask).");

extern "C" {static PyObject *meth_wxImage_SetMaskColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetMaskColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BMMM", &sipSelf, sipType_wxImage, &sipCpp, &red, &green, &blue))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMaskColour(red,green,blue);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetMaskColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetMaskFromImage, "SetMaskFromImage(mask, mr, mg, mb) -> bool\n"
"\n"
"Sets image's mask so that the pixels that have RGB value of mr,mg,mb\n"
"in mask will be masked in the image.");

extern "C" {static PyObject *meth_wxImage_SetMaskFromImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetMaskFromImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage* mask;
        unsigned char mr;
        unsigned char mg;
        unsigned char mb;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mask,
            sipName_mr,
            sipName_mg,
            sipName_mb,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9MMM", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxImage, &mask, &mr, &mg, &mb))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetMaskFromImage(*mask,mr,mg,mb);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetMaskFromImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetOption, "SetOption(name, value)\n"
"SetOption(name, value)\n"
"\n"
"Sets a user-defined option.\n"
"");

extern "C" {static PyObject *meth_wxImage_SetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetOption(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOption(*name,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        int value;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxString,&name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOption(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetPalette, "SetPalette(palette)\n"
"\n"
"Associates a palette with the image.");

extern "C" {static PyObject *meth_wxImage_SetPalette(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetPalette(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPalette* palette;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_palette,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPalette, &palette))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPalette(*palette);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetPalette, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetRGB, "SetRGB(x, y, r, g, b)\n"
"SetRGB(rect, red, green, blue)\n"
"\n"
"Set the color of the pixel at the given x and y coordinate.\n"
"");

extern "C" {static PyObject *meth_wxImage_SetRGB(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetRGB(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
        unsigned char r;
        unsigned char g;
        unsigned char b;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_r,
            sipName_g,
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiMMM", &sipSelf, sipType_wxImage, &sipCpp, &x, &y, &r, &g, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRGB(x,y,r,g,b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
        unsigned char red;
        unsigned char green;
        unsigned char blue;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1MMM", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxRect, &rect, &rectState, &red, &green, &blue))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRGB(*rect,red,green,blue);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetRGB, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetType, "SetType(type)\n"
"\n"
"Set the type of image returned by GetType().");

extern "C" {static PyObject *meth_wxImage_SetType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxBitmapType type;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxBitmapType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_AddHandler, "AddHandler(handler)\n"
"\n"
"Register an image handler.");

extern "C" {static PyObject *meth_wxImage_AddHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_AddHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImageHandler* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxImageHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxImage::AddHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_AddHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_CleanUpHandlers, "CleanUpHandlers()\n"
"\n"
"Deletes all image handlers.");

extern "C" {static PyObject *meth_wxImage_CleanUpHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxImage_CleanUpHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxImage::CleanUpHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_CleanUpHandlers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_FindHandler, "FindHandler(name) -> ImageHandler\n"
"FindHandler(extension, imageType) -> ImageHandler\n"
"FindHandler(imageType) -> ImageHandler\n"
"\n"
"Finds the handler with the given name.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxImage_FindHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_FindHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
             ::wxImageHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::FindHandler(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageHandler,NULL);
        }
    }

    {
        const  ::wxString* extension;
        int extensionState = 0;
         ::wxBitmapType imageType;

        static const char *sipKwdList[] = {
            sipName_extension,
            sipName_imageType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1E", sipType_wxString,&extension, &extensionState, sipType_wxBitmapType, &imageType))
        {
             ::wxImageHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::FindHandler(*extension,imageType);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(extension),sipType_wxString,extensionState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageHandler,NULL);
        }
    }

    {
         ::wxBitmapType imageType;

        static const char *sipKwdList[] = {
            sipName_imageType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxBitmapType, &imageType))
        {
             ::wxImageHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::FindHandler(imageType);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageHandler,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_FindHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_FindHandlerMime, "FindHandlerMime(mimetype) -> ImageHandler\n"
"\n"
"Finds the handler associated with the given MIME type.");

extern "C" {static PyObject *meth_wxImage_FindHandlerMime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_FindHandlerMime(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* mimetype;
        int mimetypeState = 0;

        static const char *sipKwdList[] = {
            sipName_mimetype,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&mimetype, &mimetypeState))
        {
             ::wxImageHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::FindHandlerMime(*mimetype);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageHandler,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_FindHandlerMime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_InitStandardHandlers, "InitStandardHandlers()\n"
"\n"
"Internal use only.");

extern "C" {static PyObject *meth_wxImage_InitStandardHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxImage_InitStandardHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxImage::InitStandardHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_InitStandardHandlers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_InsertHandler, "InsertHandler(handler)\n"
"\n"
"Adds a handler at the start of the static list of format handlers.");

extern "C" {static PyObject *meth_wxImage_InsertHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_InsertHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImageHandler* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxImageHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxImage::InsertHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_InsertHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_RemoveHandler, "RemoveHandler(name) -> bool\n"
"\n"
"Finds the handler with the given name, and removes it.");

extern "C" {static PyObject *meth_wxImage_RemoveHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_RemoveHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::RemoveHandler(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_RemoveHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetImageCount, "GetImageCount(filename, type=BITMAP_TYPE_ANY) -> int\n"
"GetImageCount(stream, type=BITMAP_TYPE_ANY) -> int\n"
"\n"
"If the image file contains more than one image and the image handler\n"
"is capable of retrieving these individually, this function will return\n"
"the number of available images.\n"
"");

extern "C" {static PyObject *meth_wxImage_GetImageCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetImageCount(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_filename,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|E", sipType_wxString,&filename, &filenameState, sipType_wxBitmapType, &type))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::GetImageCount(*filename,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|E", sipType_wxInputStream, &stream, &streamState, sipType_wxBitmapType, &type))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::GetImageCount(*stream,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetImageCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_CanRead, "CanRead(filename) -> bool\n"
"CanRead(stream) -> bool\n"
"\n"
"Returns true if at least one of the available image handlers can read\n"
"the file with the given name.\n"
"");

extern "C" {static PyObject *meth_wxImage_CanRead(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_CanRead(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* filename;
        int filenameState = 0;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::CanRead(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;

        static const char *sipKwdList[] = {
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxImage::CanRead(*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_CanRead, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetImageExtWildcard, "GetImageExtWildcard() -> String\n"
"\n"
"Iterates all registered wxImageHandler objects, and returns a string\n"
"containing file extension masks suitable for passing to file open/save\n"
"dialog boxes.");

extern "C" {static PyObject *meth_wxImage_GetImageExtWildcard(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetImageExtWildcard(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxImage::GetImageExtWildcard());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetImageExtWildcard, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_RGBtoHSV, "RGBtoHSV(rgb) -> Image.HSVValue\n"
"\n"
"Converts a color in RGB color space to HSV color space.");

extern "C" {static PyObject *meth_wxImage_RGBtoHSV(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_RGBtoHSV(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage::RGBValue* rgb;

        static const char *sipKwdList[] = {
            sipName_rgb,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9", sipType_wxImage_RGBValue, &rgb))
        {
             ::wxImage::HSVValue*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage::HSVValue( ::wxImage::RGBtoHSV(*rgb));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage_HSVValue,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_RGBtoHSV, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_HSVtoRGB, "HSVtoRGB(hsv) -> Image.RGBValue\n"
"\n"
"Converts a color in HSV color space to RGB color space.");

extern "C" {static PyObject *meth_wxImage_HSVtoRGB(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_HSVtoRGB(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage::HSVValue* hsv;

        static const char *sipKwdList[] = {
            sipName_hsv,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9", sipType_wxImage_HSVValue, &hsv))
        {
             ::wxImage::RGBValue*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage::RGBValue( ::wxImage::HSVtoRGB(*hsv));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage_RGBValue,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_HSVtoRGB, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetDataBuffer, "GetDataBuffer() -> PyObject\n"
"\n"
"Returns a writable Python buffer object that is pointing at the RGB\n"
"image data buffer inside the :class:`Image`. You need to ensure that\n"
"you do\n"
"not use this buffer object after the image has been destroyed.");

extern "C" {static PyObject *meth_wxImage_GetDataBuffer(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetDataBuffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_GetDataBuffer(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetDataBuffer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_GetAlphaBuffer, "GetAlphaBuffer() -> PyObject\n"
"\n"
"Returns a writable Python buffer object that is pointing at the Alpha\n"
"data buffer inside the :class:`Image`. You need to ensure that you do\n"
"not use this buffer object after the image has been destroyed.");

extern "C" {static PyObject *meth_wxImage_GetAlphaBuffer(PyObject *, PyObject *);}
static PyObject *meth_wxImage_GetAlphaBuffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxImage *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImage, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_GetAlphaBuffer(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_GetAlphaBuffer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetDataBuffer, "SetDataBuffer(data)\n"
"SetDataBuffer(data, new_width, new_height)\n"
"\n"
"Sets the internal image data pointer to point at a Python buffer\n"
"object.  This can save making an extra copy of the data but you must\n"
"ensure that the buffer object lives lives at least as long as the\n"
":class:`Image` does.\n"
"");

extern "C" {static PyObject *meth_wxImage_SetDataBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetDataBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&data, &dataState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetDataBuffer(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxPyBuffer* data;
        int dataState = 0;
        int new_width;
        int new_height;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_new_width,
            sipName_new_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0ii", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&data, &dataState, &new_width, &new_height))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetDataBuffer(sipCpp, data, new_width, new_height);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetDataBuffer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_SetAlphaBuffer, "SetAlphaBuffer(alpha)\n"
"\n"
"Sets the internal image alpha pointer to point at a Python buffer\n"
"object.  This can save making an extra copy of the data but you must\n"
"ensure that the buffer object lives lives at least as long as the\n"
":class:`Image` does.");

extern "C" {static PyObject *meth_wxImage_SetAlphaBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_SetAlphaBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyBuffer* alpha;
        int alphaState = 0;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxImage, &sipCpp, sipType_wxPyBuffer,&alpha, &alphaState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxImage_SetAlphaBuffer(sipCpp, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_SetAlphaBuffer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxImage_AdjustChannels, "AdjustChannels(factor_red, factor_green, factor_blue, factor_alpha=1.0) -> Image\n"
"\n"
"This function muliplies all 4 channels (red, green, blue, alpha) with\n"
"a factor (around 1.0). Useful for gamma correction, colour correction\n"
"and to add a certain amount of transparency to a image (fade in fade\n"
"out effects). If factor_alpha is given but the original image has no\n"
"alpha channel then a alpha channel will be added.");

extern "C" {static PyObject *meth_wxImage_AdjustChannels(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImage_AdjustChannels(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        double factor_red;
        double factor_green;
        double factor_blue;
        double factor_alpha = 1;
         ::wxImage *sipCpp;

        static const char *sipKwdList[] = {
            sipName_factor_red,
            sipName_factor_green,
            sipName_factor_blue,
            sipName_factor_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddd|d", &sipSelf, sipType_wxImage, &sipCpp, &factor_red, &factor_green, &factor_blue, &factor_alpha))
        {
             ::wxImage*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage_AdjustChannels(sipCpp, factor_red, factor_green, factor_blue, factor_alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Image, sipName_AdjustChannels, NULL);

    return NULL;
}


extern "C" {static int slot_wxImage___nonzero__(PyObject *);}
static int slot_wxImage___nonzero__(PyObject *sipSelf)
{
     ::wxImage *sipCpp = reinterpret_cast< ::wxImage *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxImage));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImage___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxImage(void *, const sipTypeDef *);}
static void *cast_wxImage(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxImage *sipCpp = reinterpret_cast< ::wxImage *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImage(void *, int);}
static void release_wxImage(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxImage *>(sipCppV);
    else
        delete reinterpret_cast< ::wxImage *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxImage(void *, SIP_SSIZE_T, void *);}
static void assign_wxImage(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxImage *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxImage *>(sipSrc);
}


extern "C" {static void *array_wxImage(SIP_SSIZE_T);}
static void *array_wxImage(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxImage[sipNrElem];
}


extern "C" {static void *copy_wxImage(const void *, SIP_SSIZE_T);}
static void *copy_wxImage(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxImage(reinterpret_cast<const  ::wxImage *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxImage(sipSimpleWrapper *);}
static void dealloc_wxImage(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxImage *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImage(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxImage(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImage(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxImage *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int width;
        int height;
        bool clear = 1;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_clear,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii|b", &width, &height, &clear))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(width,height,clear);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxSize* sz;
        int szState = 0;
        bool clear = 1;

        static const char *sipKwdList[] = {
            sipName_sz,
            sipName_clear,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|b", sipType_wxSize, &sz, &szState, &clear))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*sz,clear);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int index = -1;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_index,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|Ei", sipType_wxString,&name, &nameState, sipType_wxBitmapType, &type, &index))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*name,type,index);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        int index = -1;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_mimetype,
            sipName_index,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1|i", sipType_wxString,&name, &nameState, sipType_wxString,&mimetype, &mimetypeState, &index))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*name,*mimetype,index);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int index = -1;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
            sipName_index,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|Ei", sipType_wxInputStream, &stream, &streamState, sipType_wxBitmapType, &type, &index))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*stream,type,index);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxInputStream* stream;
        int streamState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        int index = -1;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_mimetype,
            sipName_index,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1|i", sipType_wxInputStream, &stream, &streamState, sipType_wxString,&mimetype, &mimetypeState, &index))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*stream,*mimetype,index);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiJ0", &width, &height, sipType_wxPyBuffer,&data, &dataState))
        {
        if (! data->checkSize(width*height*3))
            return NULL;
        void* copy = data->copy();
        if (! copy)
            return NULL;
        sipCpp = new sipwxImage;
        sipCpp->Create(width, height, (byte*)copy);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxPyBuffer* alpha;
        int alphaState = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
            sipName_alpha,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiJ0J0", &width, &height, sipType_wxPyBuffer,&data, &dataState, sipType_wxPyBuffer,&alpha, &alphaState))
        {
        void* dcopy; void* acopy;
        if (!data->checkSize(width*height*3) || !alpha->checkSize(width*height))
            return NULL;
        if ((dcopy = data->copy()) == NULL || (acopy = alpha->copy()) == NULL)
            return NULL;
        sipCpp = new sipwxImage;
        sipCpp->Create(width, height, (byte*)dcopy, (byte*)acopy, false);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxPyBuffer* data;
        int dataState = 0;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J0", sipType_wxSize, &size, &sizeState, sipType_wxPyBuffer,&data, &dataState))
        {
        if (! data->checkSize(size->x*size->y*3))
            return NULL;
        void* copy = data->copy();
        if (! copy)
            return NULL;
        sipCpp = new sipwxImage;
        sipCpp->Create(size->x, size->y, (byte*)copy, false);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxPyBuffer* alpha;
        int alphaState = 0;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_data,
            sipName_alpha,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J0J0", sipType_wxSize, &size, &sizeState, sipType_wxPyBuffer,&data, &dataState, sipType_wxPyBuffer,&alpha, &alphaState))
        {
        void* dcopy; void* acopy;
        if (!data->checkSize(size->x*size->y*3) || !alpha->checkSize(size->x*size->y))
            return NULL;
        if ((dcopy = data->copy()) == NULL || (acopy = alpha->copy()) == NULL)
            return NULL;
        sipCpp = new sipwxImage;
        sipCpp->Create(size->x, size->y, (byte*)dcopy, (byte*)acopy, false);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(data,sipType_wxPyBuffer,dataState);
            sipReleaseType(alpha,sipType_wxPyBuffer,alphaState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxImage* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxImage, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImage(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxImage[] = {{352, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxImage[] = {
    {(void *)slot_wxImage___nonzero__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxImage[] = {
    {SIP_MLNAME_CAST(sipName_AddHandler), (PyCFunction)meth_wxImage_AddHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_AddHandler)},
    {SIP_MLNAME_CAST(sipName_AdjustChannels), (PyCFunction)meth_wxImage_AdjustChannels, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_AdjustChannels)},
    {SIP_MLNAME_CAST(sipName_Blur), (PyCFunction)meth_wxImage_Blur, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Blur)},
    {SIP_MLNAME_CAST(sipName_BlurHorizontal), (PyCFunction)meth_wxImage_BlurHorizontal, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_BlurHorizontal)},
    {SIP_MLNAME_CAST(sipName_BlurVertical), (PyCFunction)meth_wxImage_BlurVertical, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_BlurVertical)},
    {SIP_MLNAME_CAST(sipName_CanRead), (PyCFunction)meth_wxImage_CanRead, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_CanRead)},
    {SIP_MLNAME_CAST(sipName_CleanUpHandlers), meth_wxImage_CleanUpHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_CleanUpHandlers)},
    {SIP_MLNAME_CAST(sipName_Clear), (PyCFunction)meth_wxImage_Clear, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Clear)},
    {SIP_MLNAME_CAST(sipName_ClearAlpha), meth_wxImage_ClearAlpha, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_ClearAlpha)},
    {SIP_MLNAME_CAST(sipName_ComputeHistogram), (PyCFunction)meth_wxImage_ComputeHistogram, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_ComputeHistogram)},
    {SIP_MLNAME_CAST(sipName_ConvertAlphaToMask), (PyCFunction)meth_wxImage_ConvertAlphaToMask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_ConvertAlphaToMask)},
    {SIP_MLNAME_CAST(sipName_ConvertToDisabled), (PyCFunction)meth_wxImage_ConvertToDisabled, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_ConvertToDisabled)},
    {SIP_MLNAME_CAST(sipName_ConvertToGreyscale), (PyCFunction)meth_wxImage_ConvertToGreyscale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_ConvertToGreyscale)},
    {SIP_MLNAME_CAST(sipName_ConvertToMono), (PyCFunction)meth_wxImage_ConvertToMono, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_ConvertToMono)},
    {SIP_MLNAME_CAST(sipName_Copy), meth_wxImage_Copy, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_Copy)},
    {SIP_MLNAME_CAST(sipName_Create), (PyCFunction)meth_wxImage_Create, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Create)},
    {SIP_MLNAME_CAST(sipName_Destroy), meth_wxImage_Destroy, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_Destroy)},
    {SIP_MLNAME_CAST(sipName_FindFirstUnusedColour), (PyCFunction)meth_wxImage_FindFirstUnusedColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_FindFirstUnusedColour)},
    {SIP_MLNAME_CAST(sipName_FindHandler), (PyCFunction)meth_wxImage_FindHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_FindHandler)},
    {SIP_MLNAME_CAST(sipName_FindHandlerMime), (PyCFunction)meth_wxImage_FindHandlerMime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_FindHandlerMime)},
    {SIP_MLNAME_CAST(sipName_GetAlpha), (PyCFunction)meth_wxImage_GetAlpha, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetAlpha)},
    {SIP_MLNAME_CAST(sipName_GetAlphaBuffer), meth_wxImage_GetAlphaBuffer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetAlphaBuffer)},
    {SIP_MLNAME_CAST(sipName_GetBlue), (PyCFunction)meth_wxImage_GetBlue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetBlue)},
    {SIP_MLNAME_CAST(sipName_GetData), meth_wxImage_GetData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetData)},
    {SIP_MLNAME_CAST(sipName_GetDataBuffer), meth_wxImage_GetDataBuffer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetDataBuffer)},
    {SIP_MLNAME_CAST(sipName_GetGreen), (PyCFunction)meth_wxImage_GetGreen, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetGreen)},
    {SIP_MLNAME_CAST(sipName_GetHeight), meth_wxImage_GetHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetHeight)},
    {SIP_MLNAME_CAST(sipName_GetImageCount), (PyCFunction)meth_wxImage_GetImageCount, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetImageCount)},
    {SIP_MLNAME_CAST(sipName_GetImageExtWildcard), meth_wxImage_GetImageExtWildcard, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetImageExtWildcard)},
    {SIP_MLNAME_CAST(sipName_GetMaskBlue), meth_wxImage_GetMaskBlue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetMaskBlue)},
    {SIP_MLNAME_CAST(sipName_GetMaskGreen), meth_wxImage_GetMaskGreen, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetMaskGreen)},
    {SIP_MLNAME_CAST(sipName_GetMaskRed), meth_wxImage_GetMaskRed, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetMaskRed)},
    {SIP_MLNAME_CAST(sipName_GetOption), (PyCFunction)meth_wxImage_GetOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetOption)},
    {SIP_MLNAME_CAST(sipName_GetOptionInt), (PyCFunction)meth_wxImage_GetOptionInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetOptionInt)},
    {SIP_MLNAME_CAST(sipName_GetOrFindMaskColour), (PyCFunction)meth_wxImage_GetOrFindMaskColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetOrFindMaskColour)},
    {SIP_MLNAME_CAST(sipName_GetPalette), meth_wxImage_GetPalette, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetPalette)},
    {SIP_MLNAME_CAST(sipName_GetRed), (PyCFunction)meth_wxImage_GetRed, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetRed)},
    {SIP_MLNAME_CAST(sipName_GetSize), meth_wxImage_GetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetSize)},
    {SIP_MLNAME_CAST(sipName_GetSubImage), (PyCFunction)meth_wxImage_GetSubImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_GetSubImage)},
    {SIP_MLNAME_CAST(sipName_GetType), meth_wxImage_GetType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetType)},
    {SIP_MLNAME_CAST(sipName_GetWidth), meth_wxImage_GetWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_GetWidth)},
    {SIP_MLNAME_CAST(sipName_HSVtoRGB), (PyCFunction)meth_wxImage_HSVtoRGB, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_HSVtoRGB)},
    {SIP_MLNAME_CAST(sipName_HasAlpha), meth_wxImage_HasAlpha, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_HasAlpha)},
    {SIP_MLNAME_CAST(sipName_HasMask), meth_wxImage_HasMask, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_HasMask)},
    {SIP_MLNAME_CAST(sipName_HasOption), (PyCFunction)meth_wxImage_HasOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_HasOption)},
    {SIP_MLNAME_CAST(sipName_InitAlpha), meth_wxImage_InitAlpha, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_InitAlpha)},
    {SIP_MLNAME_CAST(sipName_InitStandardHandlers), meth_wxImage_InitStandardHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_InitStandardHandlers)},
    {SIP_MLNAME_CAST(sipName_InsertHandler), (PyCFunction)meth_wxImage_InsertHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_InsertHandler)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxImage_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_IsOk)},
    {SIP_MLNAME_CAST(sipName_IsTransparent), (PyCFunction)meth_wxImage_IsTransparent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_IsTransparent)},
    {SIP_MLNAME_CAST(sipName_LoadFile), (PyCFunction)meth_wxImage_LoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_LoadFile)},
    {SIP_MLNAME_CAST(sipName_Mirror), (PyCFunction)meth_wxImage_Mirror, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Mirror)},
    {SIP_MLNAME_CAST(sipName_Paste), (PyCFunction)meth_wxImage_Paste, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Paste)},
    {SIP_MLNAME_CAST(sipName_RGBtoHSV), (PyCFunction)meth_wxImage_RGBtoHSV, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_RGBtoHSV)},
    {SIP_MLNAME_CAST(sipName_RemoveHandler), (PyCFunction)meth_wxImage_RemoveHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_RemoveHandler)},
    {SIP_MLNAME_CAST(sipName_Replace), (PyCFunction)meth_wxImage_Replace, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Replace)},
    {SIP_MLNAME_CAST(sipName_Rescale), (PyCFunction)meth_wxImage_Rescale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Rescale)},
    {SIP_MLNAME_CAST(sipName_Resize), (PyCFunction)meth_wxImage_Resize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Resize)},
    {SIP_MLNAME_CAST(sipName_Rotate), (PyCFunction)meth_wxImage_Rotate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Rotate)},
    {SIP_MLNAME_CAST(sipName_Rotate180), meth_wxImage_Rotate180, METH_VARARGS, SIP_MLDOC_CAST(doc_wxImage_Rotate180)},
    {SIP_MLNAME_CAST(sipName_Rotate90), (PyCFunction)meth_wxImage_Rotate90, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Rotate90)},
    {SIP_MLNAME_CAST(sipName_RotateHue), (PyCFunction)meth_wxImage_RotateHue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_RotateHue)},
    {SIP_MLNAME_CAST(sipName_SaveFile), (PyCFunction)meth_wxImage_SaveFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SaveFile)},
    {SIP_MLNAME_CAST(sipName_Scale), (PyCFunction)meth_wxImage_Scale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Scale)},
    {SIP_MLNAME_CAST(sipName_SetAlpha), (PyCFunction)meth_wxImage_SetAlpha, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetAlpha)},
    {SIP_MLNAME_CAST(sipName_SetAlphaBuffer), (PyCFunction)meth_wxImage_SetAlphaBuffer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetAlphaBuffer)},
    {SIP_MLNAME_CAST(sipName_SetData), (PyCFunction)meth_wxImage_SetData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetData)},
    {SIP_MLNAME_CAST(sipName_SetDataBuffer), (PyCFunction)meth_wxImage_SetDataBuffer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetDataBuffer)},
    {SIP_MLNAME_CAST(sipName_SetMask), (PyCFunction)meth_wxImage_SetMask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetMask)},
    {SIP_MLNAME_CAST(sipName_SetMaskColour), (PyCFunction)meth_wxImage_SetMaskColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetMaskColour)},
    {SIP_MLNAME_CAST(sipName_SetMaskFromImage), (PyCFunction)meth_wxImage_SetMaskFromImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetMaskFromImage)},
    {SIP_MLNAME_CAST(sipName_SetOption), (PyCFunction)meth_wxImage_SetOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetOption)},
    {SIP_MLNAME_CAST(sipName_SetPalette), (PyCFunction)meth_wxImage_SetPalette, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetPalette)},
    {SIP_MLNAME_CAST(sipName_SetRGB), (PyCFunction)meth_wxImage_SetRGB, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetRGB)},
    {SIP_MLNAME_CAST(sipName_SetType), (PyCFunction)meth_wxImage_SetType, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_SetType)},
    {SIP_MLNAME_CAST(sipName_Size), (PyCFunction)meth_wxImage_Size, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImage_Size)}
};

sipVariableDef variables_wxImage[] = {
    {PropertyVariable, sipName_Type, &methods_wxImage[39], &methods_wxImage[74], NULL, NULL},
    {PropertyVariable, sipName_MaskRed, &methods_wxImage[31], NULL, NULL, NULL},
    {PropertyVariable, sipName_MaskGreen, &methods_wxImage[30], NULL, NULL, NULL},
    {PropertyVariable, sipName_MaskBlue, &methods_wxImage[29], NULL, NULL, NULL},
    {PropertyVariable, sipName_Height, &methods_wxImage[26], NULL, NULL, NULL},
    {PropertyVariable, sipName_Width, &methods_wxImage[40], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxImage, "Image()\n"
"Image(width, height, clear=True)\n"
"Image(sz, clear=True)\n"
"Image(name, type=BITMAP_TYPE_ANY, index=-1)\n"
"Image(name, mimetype, index=-1)\n"
"Image(stream, type=BITMAP_TYPE_ANY, index=-1)\n"
"Image(stream, mimetype, index=-1)\n"
"Image(width, height, data)\n"
"Image(width, height, data, alpha)\n"
"Image(size, data)\n"
"Image(size, data, alpha)\n"
"\n"
"This class encapsulates a platform-independent image.");


sipClassTypeDef sipTypeDef__core_wxImage = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxImage,
        {0},
        0
    },
    {
        sipNameNr_Image,
        {0, 0, 1},
        76, methods_wxImage,
        0, 0,
        6, variables_wxImage,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxImage,
    -1,
    -1,
    supers_wxImage,
    slots_wxImage,
    init_type_wxImage,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxImage,
    assign_wxImage,
    array_wxImage,
    copy_wxImage,
    release_wxImage,
    cast_wxImage,
    0,
    0,
    0,
    0,
    0,
    0
};
