/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/ctrlsub.h>



PyDoc_STRVAR(doc_wxItemContainer_Append, "Append(item) -> int\n"
"Append(item, clientData) -> int\n"
"Append(items) -> int\n"
"\n"
"Appends item into the control.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxItemContainer_Append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_Append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* item;
        int itemState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxString,&item, &itemState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Append(*item);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(item),sipType_wxString,itemState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* item;
        int itemState = 0;
         ::wxClientData* clientData;
        int clientDataState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_clientData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J2", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxString,&item, &itemState, sipType_wxClientData,&clientData, &clientDataState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Append(*item,clientData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(item),sipType_wxString,itemState);
            sipReleaseType(clientData,sipType_wxClientData,clientDataState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxArrayString* items;
        int itemsState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_items,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxArrayString,&items, &itemsState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Append(*items);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(items),sipType_wxArrayString,itemsState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_Append, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_GetClientData, "GetClientData(n) -> ClientData\n"
"\n"
"Returns a pointer to the client data associated with the given item\n"
"(if any).");

extern "C" {static PyObject *meth_wxItemContainer_GetClientData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_GetClientData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint n;
        const  ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxItemContainer, &sipCpp, &n))
        {
             ::wxClientData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClientObject(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxClientData,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_GetClientData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_SetClientData, "SetClientData(n, data)\n"
"\n"
"Associates the given typed client data pointer with the given item:\n"
"the data object will be deleted when the item is deleted (either\n"
"explicitly by using Delete() or implicitly when the control itself is\n"
"destroyed).");

extern "C" {static PyObject *meth_wxItemContainer_SetClientData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_SetClientData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint n;
         ::wxClientData* data;
        int dataState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BuJ2", &sipSelf, sipType_wxItemContainer, &sipCpp, &n, sipType_wxClientData,&data, &dataState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClientObject(n,data);
            Py_END_ALLOW_THREADS
            sipReleaseType(data,sipType_wxClientData,dataState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_SetClientData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_Insert, "Insert(item, pos) -> int\n"
"Insert(item, pos, clientData) -> int\n"
"Insert(items, pos) -> int\n"
"\n"
"Inserts item into the control.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxItemContainer_Insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_Insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* item;
        int itemState = 0;
        uint pos;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1u", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxString,&item, &itemState, &pos))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*item,pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(item),sipType_wxString,itemState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* item;
        int itemState = 0;
        uint pos;
         ::wxClientData* clientData;
        int clientDataState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_pos,
            sipName_clientData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1uJ2", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxString,&item, &itemState, &pos, sipType_wxClientData,&clientData, &clientDataState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*item,pos,clientData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(item),sipType_wxString,itemState);
            sipReleaseType(clientData,sipType_wxClientData,clientDataState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const  ::wxArrayString* items;
        int itemsState = 0;
        uint pos;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_items,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1u", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxArrayString,&items, &itemsState, &pos))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*items,pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(items),sipType_wxArrayString,itemsState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_Insert, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_Set, "Set(items)\n"
"\n"
"Replaces the current control contents with the given items.");

extern "C" {static PyObject *meth_wxItemContainer_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* items;
        int itemsState = 0;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_items,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxItemContainer, &sipCpp, sipType_wxArrayString,&items, &itemsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(*items);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(items),sipType_wxArrayString,itemsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_Clear, "Clear()\n"
"\n"
"Removes all items from the control.");

extern "C" {static PyObject *meth_wxItemContainer_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxItemContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainer, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_Delete, "Delete(n)\n"
"\n"
"Deletes an item from the control.");

extern "C" {static PyObject *meth_wxItemContainer_Delete(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_Delete(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint n;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxItemContainer, &sipCpp, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Delete(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_Delete, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_DetachClientObject, "DetachClientObject(n) -> ClientData\n"
"\n"
"Returns the client object associated with the given item and transfers\n"
"its ownership to the caller.");

extern "C" {static PyObject *meth_wxItemContainer_DetachClientObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_DetachClientObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint n;
         ::wxItemContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxItemContainer, &sipCpp, &n))
        {
             ::wxClientData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DetachClientObject(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxClientData,sipSelf);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_DetachClientObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_HasClientData, "HasClientData() -> bool\n"
"\n"
"Returns true, if either untyped data (void*) or object data\n"
"(wxClientData*) is associated with the items of the control.");

extern "C" {static PyObject *meth_wxItemContainer_HasClientData(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_HasClientData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxItemContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainer, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasClientData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_HasClientData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_HasClientObjectData, "HasClientObjectData() -> bool\n"
"\n"
"Returns true, if object data is associated with the items of the\n"
"control.");

extern "C" {static PyObject *meth_wxItemContainer_HasClientObjectData(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_HasClientObjectData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxItemContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainer, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasClientObjectData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_HasClientObjectData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainer_HasClientUntypedData, "HasClientUntypedData() -> bool\n"
"\n"
"Returns true, if untyped data (void*) is associated with the items of\n"
"the control.");

extern "C" {static PyObject *meth_wxItemContainer_HasClientUntypedData(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainer_HasClientUntypedData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxItemContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainer, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasClientUntypedData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainer, sipName_HasClientUntypedData, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxItemContainer(void *, const sipTypeDef *);}
static void *cast_wxItemContainer(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxItemContainer *sipCpp = reinterpret_cast< ::wxItemContainer *>(sipCppV);

    if (targetType == sipType_wxItemContainerImmutable)
        return static_cast< ::wxItemContainerImmutable *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxItemContainer(void *, int);}
static void release_wxItemContainer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxItemContainer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxItemContainer(sipSimpleWrapper *);}
static void dealloc_wxItemContainer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxItemContainer(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxItemContainer[] = {{266, 255, 1}};


static PyMethodDef methods_wxItemContainer[] = {
    {SIP_MLNAME_CAST(sipName_Append), (PyCFunction)meth_wxItemContainer_Append, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_Append)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxItemContainer_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainer_Clear)},
    {SIP_MLNAME_CAST(sipName_Delete), (PyCFunction)meth_wxItemContainer_Delete, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_Delete)},
    {SIP_MLNAME_CAST(sipName_DetachClientObject), (PyCFunction)meth_wxItemContainer_DetachClientObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_DetachClientObject)},
    {SIP_MLNAME_CAST(sipName_GetClientData), (PyCFunction)meth_wxItemContainer_GetClientData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_GetClientData)},
    {SIP_MLNAME_CAST(sipName_HasClientData), meth_wxItemContainer_HasClientData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainer_HasClientData)},
    {SIP_MLNAME_CAST(sipName_HasClientObjectData), meth_wxItemContainer_HasClientObjectData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainer_HasClientObjectData)},
    {SIP_MLNAME_CAST(sipName_HasClientUntypedData), meth_wxItemContainer_HasClientUntypedData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainer_HasClientUntypedData)},
    {SIP_MLNAME_CAST(sipName_Insert), (PyCFunction)meth_wxItemContainer_Insert, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_Insert)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxItemContainer_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_Set)},
    {SIP_MLNAME_CAST(sipName_SetClientData), (PyCFunction)meth_wxItemContainer_SetClientData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainer_SetClientData)}
};

PyDoc_STRVAR(doc_wxItemContainer, "This class is an abstract base class for some wxWidgets controls which\n"
"contain several items such as wxListBox, wxCheckListBox, wxComboBox or\n"
"wxChoice.");


sipClassTypeDef sipTypeDef__core_wxItemContainer = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxItemContainer,
        {0},
        0
    },
    {
        sipNameNr_ItemContainer,
        {0, 0, 1},
        11, methods_wxItemContainer,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxItemContainer,
    -1,
    -1,
    supers_wxItemContainer,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxItemContainer,
    0,
    0,
    0,
    release_wxItemContainer,
    cast_wxItemContainer,
    0,
    0,
    0,
    0,
    0,
    0
};
