/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/listctrl.h>

        #include <wx/colour.h>
        #include <wx/font.h>


PyDoc_STRVAR(doc_wxListItemAttr_GetBackgroundColour, "GetBackgroundColour() -> Colour\n"
"\n"
"Returns the currently set background color.");

extern "C" {static PyObject *meth_wxListItemAttr_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_GetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_GetFont, "GetFont() -> Font\n"
"\n"
"Returns the currently set font.");

extern "C" {static PyObject *meth_wxListItemAttr_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_GetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_GetTextColour, "GetTextColour() -> Colour\n"
"\n"
"Returns the currently set text color.");

extern "C" {static PyObject *meth_wxListItemAttr_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_GetTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_HasBackgroundColour, "HasBackgroundColour() -> bool\n"
"\n"
"Returns true if the currently set background color is valid.");

extern "C" {static PyObject *meth_wxListItemAttr_HasBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_HasBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBackgroundColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_HasBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_HasFont, "HasFont() -> bool\n"
"\n"
"Returns true if the currently set font is valid.");

extern "C" {static PyObject *meth_wxListItemAttr_HasFont(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_HasFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_HasFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_HasTextColour, "HasTextColour() -> bool\n"
"\n"
"Returns true if the currently set text color is valid.");

extern "C" {static PyObject *meth_wxListItemAttr_HasTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_HasTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxListItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxListItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTextColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_HasTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_SetBackgroundColour, "SetBackgroundColour(colour)\n"
"\n"
"Sets a new background color.");

extern "C" {static PyObject *meth_wxListItemAttr_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxListItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxListItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_SetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_SetFont, "SetFont(font)\n"
"\n"
"Sets a new font.");

extern "C" {static PyObject *meth_wxListItemAttr_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
         ::wxListItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxListItemAttr, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_SetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxListItemAttr_SetTextColour, "SetTextColour(colour)\n"
"\n"
"Sets a new text color.");

extern "C" {static PyObject *meth_wxListItemAttr_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxListItemAttr_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxListItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxListItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ListItemAttr, sipName_SetTextColour, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxListItemAttr(void *, int);}
static void release_wxListItemAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxListItemAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxListItemAttr(void *, SIP_SSIZE_T, void *);}
static void assign_wxListItemAttr(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxListItemAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxListItemAttr *>(sipSrc);
}


extern "C" {static void *array_wxListItemAttr(SIP_SSIZE_T);}
static void *array_wxListItemAttr(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxListItemAttr[sipNrElem];
}


extern "C" {static void *copy_wxListItemAttr(const void *, SIP_SSIZE_T);}
static void *copy_wxListItemAttr(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxListItemAttr(reinterpret_cast<const  ::wxListItemAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxListItemAttr(sipSimpleWrapper *);}
static void dealloc_wxListItemAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxListItemAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxListItemAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxListItemAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxListItemAttr *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxListItemAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxColour* colText;
        int colTextState = 0;
        const  ::wxColour* colBack;
        int colBackState = 0;
        const  ::wxFont* font;

        static const char *sipKwdList[] = {
            sipName_colText,
            sipName_colBack,
            sipName_font,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1J9", sipType_wxColour, &colText, &colTextState, sipType_wxColour, &colBack, &colBackState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxListItemAttr(*colText,*colBack,*font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText),sipType_wxColour,colTextState);
            sipReleaseType(const_cast< ::wxColour *>(colBack),sipType_wxColour,colBackState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxListItemAttr* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxListItemAttr, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxListItemAttr(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxListItemAttr[] = {
    {SIP_MLNAME_CAST(sipName_GetBackgroundColour), meth_wxListItemAttr_GetBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_GetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_GetFont), meth_wxListItemAttr_GetFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetTextColour), meth_wxListItemAttr_GetTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_GetTextColour)},
    {SIP_MLNAME_CAST(sipName_HasBackgroundColour), meth_wxListItemAttr_HasBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_HasBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_HasFont), meth_wxListItemAttr_HasFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_HasFont)},
    {SIP_MLNAME_CAST(sipName_HasTextColour), meth_wxListItemAttr_HasTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxListItemAttr_HasTextColour)},
    {SIP_MLNAME_CAST(sipName_SetBackgroundColour), (PyCFunction)meth_wxListItemAttr_SetBackgroundColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxListItemAttr_SetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_SetFont), (PyCFunction)meth_wxListItemAttr_SetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxListItemAttr_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetTextColour), (PyCFunction)meth_wxListItemAttr_SetTextColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxListItemAttr_SetTextColour)}
};

sipVariableDef variables_wxListItemAttr[] = {
    {PropertyVariable, sipName_TextColour, &methods_wxListItemAttr[2], &methods_wxListItemAttr[8], NULL, NULL},
    {PropertyVariable, sipName_Font, &methods_wxListItemAttr[1], &methods_wxListItemAttr[7], NULL, NULL},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxListItemAttr[0], &methods_wxListItemAttr[6], NULL, NULL},
};

PyDoc_STRVAR(doc_wxListItemAttr, "ListItemAttr()\n"
"ListItemAttr(colText, colBack, font)\n"
"\n"
"Represents the attributes (color, font, ...) of a wxListCtrl's\n"
"wxListItem.");


sipClassTypeDef sipTypeDef__core_wxListItemAttr = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxListItemAttr,
        {0},
        0
    },
    {
        sipNameNr_ListItemAttr,
        {0, 0, 1},
        9, methods_wxListItemAttr,
        0, 0,
        3, variables_wxListItemAttr,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxListItemAttr,
    -1,
    -1,
    0,
    0,
    init_type_wxListItemAttr,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxListItemAttr,
    assign_wxListItemAttr,
    array_wxListItemAttr,
    copy_wxListItemAttr,
    release_wxListItemAttr,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
