/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/metafile.h>

        #include <wx/dc.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxMetafile_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the metafile is valid.");

extern "C" {static PyObject *meth_wxMetafile_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxMetafile_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMetafile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMetafile, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Metafile, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMetafile_Play, "Play(dc) -> bool\n"
"\n"
"Plays the metafile into the given device context, returning true if\n"
"successful.");

extern "C" {static PyObject *meth_wxMetafile_Play(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMetafile_Play(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC* dc;
         ::wxMetafile *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxMetafile, &sipCpp, sipType_wxDC, &dc))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Play(dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Metafile, sipName_Play, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMetafile_SetClipboard, "SetClipboard(width=0, height=0) -> bool\n"
"\n"
"Passes the metafile data to the clipboard.");

extern "C" {static PyObject *meth_wxMetafile_SetClipboard(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMetafile_SetClipboard(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width = 0;
        int height = 0;
         ::wxMetafile *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|ii", &sipSelf, sipType_wxMetafile, &sipCpp, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetClipboard(width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Metafile, sipName_SetClipboard, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxMetafile(void *, const sipTypeDef *);}
static void *cast_wxMetafile(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxMetafile *sipCpp = reinterpret_cast< ::wxMetafile *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMetafile(void *, int);}
static void release_wxMetafile(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxMetafile *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxMetafile(sipSimpleWrapper *);}
static void dealloc_wxMetafile(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMetafile(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxMetafile(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMetafile(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxMetafile *sipCpp = 0;

    {
        const  ::wxString& filenamedef = wxEmptyString;
        const  ::wxString* filename = &filenamedef;
        int filenameState = 0;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1", sipType_wxString,&filename, &filenameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMetafile(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxMetafile[] = {{352, 255, 1}};


static PyMethodDef methods_wxMetafile[] = {
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxMetafile_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMetafile_IsOk)},
    {SIP_MLNAME_CAST(sipName_Play), (PyCFunction)meth_wxMetafile_Play, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMetafile_Play)},
    {SIP_MLNAME_CAST(sipName_SetClipboard), (PyCFunction)meth_wxMetafile_SetClipboard, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMetafile_SetClipboard)}
};

PyDoc_STRVAR(doc_wxMetafile, "Metafile(filename=EmptyString)\n"
"\n"
"A wxMetafile represents the MS Windows metafile object, so metafile\n"
"operations have no effect in X.");


sipClassTypeDef sipTypeDef__core_wxMetafile = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxMetafile,
        {0},
        0
    },
    {
        sipNameNr_Metafile,
        {0, 0, 1},
        3, methods_wxMetafile,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxMetafile,
    -1,
    -1,
    supers_wxMetafile,
    0,
    init_type_wxMetafile,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxMetafile,
    0,
    0,
    0,
    release_wxMetafile,
    cast_wxMetafile,
    0,
    0,
    0,
    0,
    0,
    0
};
