/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/cmndata.h>

        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxSize* _wxPrintData_GetPaperSize(wxPrintData* self)
    {
        return new wxSize(self->GetPaperSize());
    }
    void _wxPrintData_SetPaperSize(wxPrintData* self, const wxSize* sz)
    {
        self->SetPaperSize(*sz);
    }
    int _wxPrintData___nonzero__(wxPrintData* self)
    {
        return self->IsOk();
    }
    PyObject* _wxPrintData_GetPrivData(wxPrintData* self)
    {
        PyObject* data;
        wxPyThreadBlocker blocker;
        data = PyBytes_FromStringAndSize(self->GetPrivData(),
                                         self->GetPrivDataLen());
        return data;
    }
    void _wxPrintData_SetPrivData(wxPrintData* self, PyObject* data)
    {
        wxPyThreadBlocker blocker;
        if (! PyBytes_Check(data)) {
            wxPyErr_SetString(PyExc_TypeError, "Expected string object");
            return;
        }
        
        self->SetPrivData(PyBytes_AS_STRING(data), PyBytes_GET_SIZE(data));
    }


PyDoc_STRVAR(doc_wxPrintData_GetBin, "GetBin() -> PrintBin\n"
"\n"
"Returns the current bin (papersource).");

extern "C" {static PyObject *meth_wxPrintData_GetBin(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetBin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxPrintBin sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPrintBin);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetBin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetCollate, "GetCollate() -> bool\n"
"\n"
"Returns true if collation is on.");

extern "C" {static PyObject *meth_wxPrintData_GetCollate(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetCollate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCollate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetCollate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetColour, "GetColour() -> bool\n"
"\n"
"Returns true if colour printing is on.");

extern "C" {static PyObject *meth_wxPrintData_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetDuplex, "GetDuplex() -> DuplexMode\n"
"\n"
"Returns the duplex mode.");

extern "C" {static PyObject *meth_wxPrintData_GetDuplex(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetDuplex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxDuplexMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDuplex();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDuplexMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetDuplex, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetNoCopies, "GetNoCopies() -> int\n"
"\n"
"Returns the number of copies requested by the user.");

extern "C" {static PyObject *meth_wxPrintData_GetNoCopies(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetNoCopies(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNoCopies();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetNoCopies, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetOrientation, "GetOrientation() -> PrintOrientation\n"
"\n"
"Gets the orientation.");

extern "C" {static PyObject *meth_wxPrintData_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxPrintOrientation sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOrientation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPrintOrientation);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetOrientation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetPaperId, "GetPaperId() -> PaperSize\n"
"\n"
"Returns the paper size id.");

extern "C" {static PyObject *meth_wxPrintData_GetPaperId(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetPaperId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxPaperSize sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPaperId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPaperSize);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetPaperId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetPrinterName, "GetPrinterName() -> String\n"
"\n"
"Returns the printer name.");

extern "C" {static PyObject *meth_wxPrintData_GetPrinterName(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetPrinterName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPrinterName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetPrinterName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetQuality, "GetQuality() -> PrintQuality\n"
"\n"
"Returns the current print quality.");

extern "C" {static PyObject *meth_wxPrintData_GetQuality(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetQuality(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxPrintQuality sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetQuality();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetQuality, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the print data is valid for using in print dialogs.");

extern "C" {static PyObject *meth_wxPrintData_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetBin, "SetBin(flag)\n"
"\n"
"Sets the current bin.");

extern "C" {static PyObject *meth_wxPrintData_SetBin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetBin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintBin flag;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxPrintBin, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBin(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetBin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetCollate, "SetCollate(flag)\n"
"\n"
"Sets collation to on or off.");

extern "C" {static PyObject *meth_wxPrintData_SetCollate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetCollate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool flag;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxPrintData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCollate(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetCollate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetColour, "SetColour(flag)\n"
"\n"
"Sets colour printing on or off.");

extern "C" {static PyObject *meth_wxPrintData_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool flag;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxPrintData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetDuplex, "SetDuplex(mode)\n"
"\n"
"Returns the duplex mode.");

extern "C" {static PyObject *meth_wxPrintData_SetDuplex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetDuplex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDuplexMode mode;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxDuplexMode, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDuplex(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetDuplex, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetNoCopies, "SetNoCopies(n)\n"
"\n"
"Sets the default number of copies to be printed out.");

extern "C" {static PyObject *meth_wxPrintData_SetNoCopies(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetNoCopies(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxPrintData, &sipCpp, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNoCopies(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetNoCopies, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetOrientation, "SetOrientation(orientation)\n"
"\n"
"Sets the orientation.");

extern "C" {static PyObject *meth_wxPrintData_SetOrientation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetOrientation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintOrientation orientation;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_orientation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxPrintOrientation, &orientation))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOrientation(orientation);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetOrientation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetPaperId, "SetPaperId(paperId)\n"
"\n"
"Sets the paper id.");

extern "C" {static PyObject *meth_wxPrintData_SetPaperId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetPaperId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPaperSize paperId;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_paperId,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxPaperSize, &paperId))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPaperId(paperId);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetPaperId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetPrinterName, "SetPrinterName(printerName)\n"
"\n"
"Sets the printer name.");

extern "C" {static PyObject *meth_wxPrintData_SetPrinterName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetPrinterName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* printerName;
        int printerNameState = 0;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_printerName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxString,&printerName, &printerNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPrinterName(*printerName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(printerName),sipType_wxString,printerNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetPrinterName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetQuality, "SetQuality(quality)\n"
"\n"
"Sets the desired print quality.");

extern "C" {static PyObject *meth_wxPrintData_SetQuality(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetQuality(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintQuality quality;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_quality,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxPrintData, &sipCpp, &quality))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetQuality(quality);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetQuality, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetFilename, "GetFilename() -> String");

extern "C" {static PyObject *meth_wxPrintData_GetFilename(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetFilename(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFilename());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetFilename, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetFilename, "SetFilename(filename)");

extern "C" {static PyObject *meth_wxPrintData_SetFilename(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetFilename(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxString,&filename, &filenameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFilename(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetFilename, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetPrintMode, "GetPrintMode() -> PrintMode");

extern "C" {static PyObject *meth_wxPrintData_GetPrintMode(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetPrintMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxPrintMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPrintMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPrintMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetPrintMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetPrintMode, "SetPrintMode(printMode)");

extern "C" {static PyObject *meth_wxPrintData_SetPrintMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetPrintMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintMode printMode;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_printMode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxPrintMode, &printMode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPrintMode(printMode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetPrintMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetPaperSize, "GetPaperSize() -> Size");

extern "C" {static PyObject *meth_wxPrintData_GetPaperSize(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetPaperSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
             ::wxSize*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPrintData_GetPaperSize(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetPaperSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetPaperSize, "SetPaperSize(sz)");

extern "C" {static PyObject *meth_wxPrintData_SetPaperSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetPaperSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* sz;
        int szState = 0;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxPrintData, &sipCpp, sipType_wxSize, &sz, &szState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPrintData_SetPaperSize(sipCpp, sz);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetPaperSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_GetPrivData, "GetPrivData() -> PyObject");

extern "C" {static PyObject *meth_wxPrintData_GetPrivData(PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_GetPrivData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPrintData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintData, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPrintData_GetPrivData(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_GetPrivData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPrintData_SetPrivData, "SetPrivData(data)");

extern "C" {static PyObject *meth_wxPrintData_SetPrivData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintData_SetPrivData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * data;
         ::wxPrintData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0", &sipSelf, sipType_wxPrintData, &sipCpp, &data))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPrintData_SetPrivData(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PrintData, sipName_SetPrivData, NULL);

    return NULL;
}


extern "C" {static int slot_wxPrintData___nonzero__(PyObject *);}
static int slot_wxPrintData___nonzero__(PyObject *sipSelf)
{
     ::wxPrintData *sipCpp = reinterpret_cast< ::wxPrintData *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPrintData));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPrintData___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPrintData(void *, const sipTypeDef *);}
static void *cast_wxPrintData(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPrintData *sipCpp = reinterpret_cast< ::wxPrintData *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPrintData(void *, int);}
static void release_wxPrintData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPrintData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxPrintData(void *, SIP_SSIZE_T, void *);}
static void assign_wxPrintData(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPrintData *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPrintData *>(sipSrc);
}


extern "C" {static void *array_wxPrintData(SIP_SSIZE_T);}
static void *array_wxPrintData(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxPrintData[sipNrElem];
}


extern "C" {static void *copy_wxPrintData(const void *, SIP_SSIZE_T);}
static void *copy_wxPrintData(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPrintData(reinterpret_cast<const  ::wxPrintData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPrintData(sipSimpleWrapper *);}
static void dealloc_wxPrintData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPrintData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPrintData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPrintData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPrintData *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPrintData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPrintData* data;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPrintData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPrintData(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPrintData[] = {{352, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxPrintData[] = {
    {(void *)slot_wxPrintData___nonzero__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxPrintData[] = {
    {SIP_MLNAME_CAST(sipName_GetBin), meth_wxPrintData_GetBin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetBin)},
    {SIP_MLNAME_CAST(sipName_GetCollate), meth_wxPrintData_GetCollate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetCollate)},
    {SIP_MLNAME_CAST(sipName_GetColour), meth_wxPrintData_GetColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetDuplex), meth_wxPrintData_GetDuplex, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetDuplex)},
    {SIP_MLNAME_CAST(sipName_GetFilename), meth_wxPrintData_GetFilename, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetFilename)},
    {SIP_MLNAME_CAST(sipName_GetNoCopies), meth_wxPrintData_GetNoCopies, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetNoCopies)},
    {SIP_MLNAME_CAST(sipName_GetOrientation), meth_wxPrintData_GetOrientation, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetOrientation)},
    {SIP_MLNAME_CAST(sipName_GetPaperId), meth_wxPrintData_GetPaperId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetPaperId)},
    {SIP_MLNAME_CAST(sipName_GetPaperSize), meth_wxPrintData_GetPaperSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetPaperSize)},
    {SIP_MLNAME_CAST(sipName_GetPrintMode), meth_wxPrintData_GetPrintMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetPrintMode)},
    {SIP_MLNAME_CAST(sipName_GetPrinterName), meth_wxPrintData_GetPrinterName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetPrinterName)},
    {SIP_MLNAME_CAST(sipName_GetPrivData), meth_wxPrintData_GetPrivData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetPrivData)},
    {SIP_MLNAME_CAST(sipName_GetQuality), meth_wxPrintData_GetQuality, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_GetQuality)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxPrintData_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintData_IsOk)},
    {SIP_MLNAME_CAST(sipName_SetBin), (PyCFunction)meth_wxPrintData_SetBin, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetBin)},
    {SIP_MLNAME_CAST(sipName_SetCollate), (PyCFunction)meth_wxPrintData_SetCollate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetCollate)},
    {SIP_MLNAME_CAST(sipName_SetColour), (PyCFunction)meth_wxPrintData_SetColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetColour)},
    {SIP_MLNAME_CAST(sipName_SetDuplex), (PyCFunction)meth_wxPrintData_SetDuplex, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetDuplex)},
    {SIP_MLNAME_CAST(sipName_SetFilename), (PyCFunction)meth_wxPrintData_SetFilename, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetFilename)},
    {SIP_MLNAME_CAST(sipName_SetNoCopies), (PyCFunction)meth_wxPrintData_SetNoCopies, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetNoCopies)},
    {SIP_MLNAME_CAST(sipName_SetOrientation), (PyCFunction)meth_wxPrintData_SetOrientation, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetOrientation)},
    {SIP_MLNAME_CAST(sipName_SetPaperId), (PyCFunction)meth_wxPrintData_SetPaperId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetPaperId)},
    {SIP_MLNAME_CAST(sipName_SetPaperSize), (PyCFunction)meth_wxPrintData_SetPaperSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetPaperSize)},
    {SIP_MLNAME_CAST(sipName_SetPrintMode), (PyCFunction)meth_wxPrintData_SetPrintMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetPrintMode)},
    {SIP_MLNAME_CAST(sipName_SetPrinterName), (PyCFunction)meth_wxPrintData_SetPrinterName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetPrinterName)},
    {SIP_MLNAME_CAST(sipName_SetPrivData), (PyCFunction)meth_wxPrintData_SetPrivData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetPrivData)},
    {SIP_MLNAME_CAST(sipName_SetQuality), (PyCFunction)meth_wxPrintData_SetQuality, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintData_SetQuality)}
};

sipVariableDef variables_wxPrintData[] = {
    {PropertyVariable, sipName_Quality, &methods_wxPrintData[12], &methods_wxPrintData[26], NULL, NULL},
    {PropertyVariable, sipName_PrivData, &methods_wxPrintData[11], &methods_wxPrintData[25], NULL, NULL},
    {PropertyVariable, sipName_PrinterName, &methods_wxPrintData[10], &methods_wxPrintData[24], NULL, NULL},
    {PropertyVariable, sipName_PrintMode, &methods_wxPrintData[9], &methods_wxPrintData[23], NULL, NULL},
    {PropertyVariable, sipName_PaperSize, &methods_wxPrintData[8], &methods_wxPrintData[22], NULL, NULL},
    {PropertyVariable, sipName_PaperId, &methods_wxPrintData[7], &methods_wxPrintData[21], NULL, NULL},
    {PropertyVariable, sipName_Orientation, &methods_wxPrintData[6], &methods_wxPrintData[20], NULL, NULL},
    {PropertyVariable, sipName_NoCopies, &methods_wxPrintData[5], &methods_wxPrintData[19], NULL, NULL},
    {PropertyVariable, sipName_Filename, &methods_wxPrintData[4], &methods_wxPrintData[18], NULL, NULL},
    {PropertyVariable, sipName_Duplex, &methods_wxPrintData[3], &methods_wxPrintData[17], NULL, NULL},
    {PropertyVariable, sipName_Colour, &methods_wxPrintData[2], &methods_wxPrintData[16], NULL, NULL},
    {PropertyVariable, sipName_Collate, &methods_wxPrintData[1], &methods_wxPrintData[15], NULL, NULL},
    {PropertyVariable, sipName_Bin, &methods_wxPrintData[0], &methods_wxPrintData[14], NULL, NULL},
};

PyDoc_STRVAR(doc_wxPrintData, "PrintData()\n"
"PrintData(data)\n"
"\n"
"This class holds a variety of information related to printers and\n"
"printer device contexts.");


sipClassTypeDef sipTypeDef__core_wxPrintData = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPrintData,
        {0},
        0
    },
    {
        sipNameNr_PrintData,
        {0, 0, 1},
        27, methods_wxPrintData,
        0, 0,
        13, variables_wxPrintData,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPrintData,
    -1,
    -1,
    supers_wxPrintData,
    slots_wxPrintData,
    init_type_wxPrintData,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPrintData,
    assign_wxPrintData,
    array_wxPrintData,
    copy_wxPrintData,
    release_wxPrintData,
    cast_wxPrintData,
    0,
    0,
    0,
    0,
    0,
    0
};
