/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/app.h>

        #include <wx/event.h>
        #include <wx/window.h>
        #include <wx/vidmode.h>
        #include <wx/app.h>
        #include <wx/apptrait.h>
        #include <wx/evtloop.h>
        #include <wx/object.h>
        #include <wx/eventfilter.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        
        #ifdef __WXGTK__
        #include <gdk/gdkx.h>
        #include <gtk/gtk.h>
        #endif
        
        #ifdef __WXMAC__
        #include <wx/osx/private.h>
        #endif
        
        #ifdef __WXMSW__
        #include <wx/msw/private.h>
        #include <wx/msw/winundef.h>
        #include <wx/msw/msvcrt.h>
        #endif
        
        
        #ifdef __WXMSW__             // If building for Windows...
        
        //----------------------------------------------------------------------
        // This gets run when the DLL is loaded.  We just need to save the
        // instance handle.
        //----------------------------------------------------------------------
        
        extern "C"
        BOOL WINAPI DllMain(
            HINSTANCE   hinstDLL,    // handle to DLL module
            DWORD       fdwReason,   // reason for calling function
            LPVOID      lpvReserved  // reserved
           )
        {
            // If wxPython is embedded in another wxWidgets app then
            // the instance has already been set.
            if (! wxGetInstance())
                wxSetInstance(hinstDLL);
        
            return TRUE;
        }
        #endif  // __WXMSW__
        
        //----------------------------------------------------------------------
        // Classes for implementing the wxp main application shell.
        //----------------------------------------------------------------------
        
        
        class wxPyApp : public wxApp
        {
            DECLARE_ABSTRACT_CLASS(wxPyApp)
        
        public:
            wxPyApp() : wxApp() {
                m_assertMode = wxAPP_ASSERT_EXCEPTION;
                m_startupComplete = false;
                //m_callFilterEvent = false;
                ms_appInstance = this;
            }
        
            ~wxPyApp() {
                ms_appInstance = NULL;
                wxApp::SetInstance(NULL);
            }
        
        
        #ifndef __WXMAC__
            virtual void MacNewFile() {}
            virtual void MacOpenFile(const wxString &) {}
            virtual void MacOpenFiles(const wxArrayString& fileNames) {}
            virtual void MacOpenURL(const wxString &) {}
            virtual void MacPrintFile(const wxString &) {}
            virtual void MacReopenApp() {}
            virtual bool OSXIsGUIApplication() { return true; }
        #endif
        
        #ifdef __WXMAC__
            static long GetMacAboutMenuItemId()               { return s_macAboutMenuItemId; }
            static long GetMacPreferencesMenuItemId()         { return s_macPreferencesMenuItemId; }
            static long GetMacExitMenuItemId()                { return s_macExitMenuItemId; }
            static wxString GetMacHelpMenuTitleName()         { return s_macHelpMenuTitleName; }
            static void SetMacAboutMenuItemId(long val)       { s_macAboutMenuItemId = val; }
            static void SetMacPreferencesMenuItemId(long val) { s_macPreferencesMenuItemId = val; }
            static void SetMacExitMenuItemId(long val)        { s_macExitMenuItemId = val; }
            static void SetMacHelpMenuTitleName(const wxString& val) { s_macHelpMenuTitleName = val; }
        #else
            static long GetMacAboutMenuItemId()               { return 0; }
            static long GetMacPreferencesMenuItemId()         { return 0; }
            static long GetMacExitMenuItemId()                { return 0; }
            static wxString GetMacHelpMenuTitleName()         { return wxEmptyString; }
            static void SetMacAboutMenuItemId(long)           { }
            static void SetMacPreferencesMenuItemId(long)     { }
            static void SetMacExitMenuItemId(long)            { }
            static void SetMacHelpMenuTitleName(const wxString&) { }
        #endif
        
            wxAppAssertMode  GetAssertMode() { return m_assertMode; }
            void SetAssertMode(wxAppAssertMode mode) {
                m_assertMode = mode;
                if (mode & wxAPP_ASSERT_SUPPRESS)
                    wxDisableAsserts();
                else
                    wxSetDefaultAssertHandler();
            }
        
            virtual void OnAssertFailure(const wxChar *file,
                                         int line,
                                         const wxChar *func,
                                         const wxChar *cond,
                                         const wxChar *msg);
        
        
            // Implementing OnInit is optional for wxPython apps
            virtual bool OnInit()     { return true; }
            virtual void OnPreInit()  { }
        
            void _BootstrapApp();
            virtual int MainLoop();
        
            static bool IsDisplayAvailable();
        
            // implementation only
            void SetStartupComplete(bool val) { m_startupComplete = val; }
            static wxPyApp* ms_appInstance;
        
        private:
            wxAppAssertMode m_assertMode;
            bool m_startupComplete;
            //bool m_callFilterEvent;
        };
        
        IMPLEMENT_ABSTRACT_CLASS(wxPyApp, wxApp);
        
        wxPyApp* wxPyApp::ms_appInstance = NULL;
        extern PyObject* wxAssertionError;         // Exception object raised for wxASSERT failures
        
        
        void wxPyApp::OnAssertFailure(const wxChar *file,
                                      int line,
                                      const wxChar *func,
                                      const wxChar *cond,
                                      const wxChar *msg)
        {
            // ignore it?
            if (m_assertMode & wxAPP_ASSERT_SUPPRESS)
                return;
        
            // turn it into a Python exception?
            if (m_assertMode & wxAPP_ASSERT_EXCEPTION) {
                wxString buf;
                buf.Alloc(4096);
                buf.Printf(wxT("C++ assertion \"%s\" failed at %s(%d)"), cond, file, line);
                if ( func && *func )
                    buf << wxT(" in ") << func << wxT("()");
                if (msg != NULL)
                    buf << wxT(": ") << msg;
        
                // set the exception
                wxPyThreadBlocker blocker;
                PyObject* s = wx2PyString(buf);
                PyErr_SetObject(wxAssertionError, s);
                Py_DECREF(s);
        
                // Now when control returns to whatever API wrapper was called from
                // Python it should detect that an exception is set and will return
                // NULL, signalling the exception to Python.
            }
        
            // Send it to the normal log destination, but only if
            // not _DIALOG because it will call this too
            if ( (m_assertMode & wxAPP_ASSERT_LOG) && !(m_assertMode & wxAPP_ASSERT_DIALOG)) {
                wxString buf;
                buf.Alloc(4096);
                buf.Printf(wxT("%s(%d): assert \"%s\" failed"),
                           file, line, cond);
                if ( func && *func )
                    buf << wxT(" in ") << func << wxT("()");
                if (msg != NULL)
                    buf << wxT(": ") << msg;
                wxLogDebug(buf);
            }
        
            // do the normal wx assert dialog?
            if (m_assertMode & wxAPP_ASSERT_DIALOG)
                wxApp::OnAssertFailure(file, line, func, cond, msg);
        }
        
        
        void wxPyApp::_BootstrapApp()
        {
            static      bool haveInitialized = false;
            bool        result;
        
            // Only initialize wxWidgets once
            if (! haveInitialized) {
        
                // Copy the values in Python's sys.argv list to a C array of char* to
                // be passed to the wxEntryStart function below.
                #if PY_MAJOR_VERSION >= 3
                    #define argType   wchar_t
                #else
                    #define argType   char
                #endif
                int       argc = 0;
                argType** argv = NULL;
                {
                    wxPyThreadBlocker blocker;
                    PyObject* sysargv = PySys_GetObject("argv");
                    if (sysargv != NULL) {
                        argc = PyList_Size(sysargv);
                        argv = new argType*[argc+1];
                        int x;
                        for(x=0; x<argc; x++) {
                            PyObject *pyArg = PyList_GetItem(sysargv, x); // borrowed reference
                            // if there isn't anything in sys.argv[0] then set it to the python executable
                            if (x == 0 && PyObject_Length(pyArg) < 1)
                                pyArg = PySys_GetObject("executable");
                            #if PY_MAJOR_VERSION >= 3
                                int len = PyObject_Length(pyArg);
                                argv[x] = new argType[len+1];
                                wxPyUnicode_AsWideChar(pyArg, argv[x], len+1);
                            #else
                                argv[x] = strdup(PyBytes_AsString(pyArg));
                            #endif
                        }
                        argv[argc] = NULL;
                    }
                }
        
                // Initialize wxWidgets
        #ifdef __WXOSX__
                wxMacAutoreleasePool autoreleasePool;
        #endif
                result = wxEntryStart(argc, argv);
                // wxApp takes ownership of the argv array, don't delete it here
        
                if (! result)  {
                    wxPyThreadBlocker blocker;
                    PyErr_SetString(PyExc_SystemError,
                                      "wxEntryStart failed, unable to initialize wxWidgets!"
        #ifdef __WXGTK__
                                      "  (Is DISPLAY set properly?)"
        #endif
                        );
                    goto error;
                }
            }
            else {
                this->argc = 0;
            }
        
            // It's now ok to generate exceptions for assertion errors.
            SetStartupComplete(true);
        
            // Call the Python wxApp's OnPreInit and OnInit functions if they exist
            OnPreInit();
        
            // Only use CallOnInit the first time, otherwise it will block on [NSApp run] in wxOSX_Cocoa;
            if (! haveInitialized)
                result = CallOnInit();
            else
                result = OnInit();
        
        //#ifdef __WXOSX_COCOA__
        //    OSXSetInitWasCalled(true);  TODO: consider adding this method to wxApp
        //#endif
        
            if (! result) {
                wxPyErr_SetString(PyExc_SystemExit, "OnInit returned false, exiting...");
            }
        
            haveInitialized = true;
        
        error:
            return;
        }
        
        
        int wxPyApp::MainLoop()
        {
            int retval = 0;
        
            {
        #ifdef __WXOSX__
                wxMacAutoreleasePool autoreleasePool;
        #endif
                DeletePendingObjects();
            }
            bool initialized = wxTopLevelWindows.GetCount() != 0;
            if (initialized) {
                if ( m_exitOnFrameDelete == Later ) {
                    m_exitOnFrameDelete = Yes;
                }
        
                retval = wxApp::MainLoop();
                OnExit();
            }
            return retval;
        }
        
        
        // Function to test if the Display (or whatever is the platform equivallent)
        // can be connected to.
        bool wxPyApp::IsDisplayAvailable()
        {
        #ifdef __WXGTK__
            Display* display;
            display = XOpenDisplay(NULL);
            if (display == NULL)
                return false;
            XCloseDisplay(display);
            return true;
        #endif
        
        #ifdef __WXMAC__
            // This is adapted from Python's Mac/Modules/MacOS.c in the
            // MacOS_WMAvailable function.
            bool rv;
            ProcessSerialNumber psn;
        
            /*
            ** This is a fairly innocuous call to make if we don't have a window
            ** manager, or if we have no permission to talk to it. It will print
            ** a message on stderr, but at least it won't abort the process.
            ** It appears the function caches the result itself, and it's cheap, so
            ** no need for us to cache.
            */
        #ifdef kCGNullDirectDisplay
            /* On 10.1 CGMainDisplayID() isn't available, and
            ** kCGNullDirectDisplay isn't defined.
            */
            if (CGMainDisplayID() == 0) {
                rv = false;
            } else
        #endif
            {
                // Also foreground the application on the first call as a side-effect.
                if (GetCurrentProcess(&psn) < 0 || SetFrontProcess(&psn) < 0) {
                    rv = false;
                } else {
                    rv = true;
                }
            }
            return rv;
        #endif
        
        #ifdef __WXMSW__
            // TODO...
            return true;
        #endif
        }
        
        
        
        wxPyApp* wxGetApp()
        {
            return wxPyApp::ms_appInstance;
        }
    void _wxPyApp_MacHideApp(wxPyApp* self)
    {
        #ifdef __WXMAC__
            self->MacHideApp();
        #endif
    }
    int _wxPyApp_GetComCtl32Version()
    {
        #ifdef __WXMSW__
            return wxApp::GetComCtl32Version();
        #else
            wxPyRaiseNotImplemented();
            return 0;
        #endif
    }
    int _wxPyApp_GetShell32Version()
    {
        #ifdef __WXMSW__
            return wxApp::GetShell32Version();
        #else
            wxPyRaiseNotImplemented();
            return 0;
        #endif
    }


class sipwxPyApp : public  ::wxPyApp
{
public:
    sipwxPyApp();
    virtual ~sipwxPyApp();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtectVirt_TryBefore(bool, ::wxEvent&);
    bool sipProtectVirt_TryAfter(bool, ::wxEvent&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool OnInitGui();
    void OnPreInit();
    bool OSXIsGUIApplication();
    void MacReopenApp();
    void MacPrintFile(const  ::wxString&);
    void MacOpenURL(const  ::wxString&);
    void MacOpenFile(const  ::wxString&);
    void MacOpenFiles(const  ::wxArrayString&);
    void MacNewFile();
    bool TryAfter( ::wxEvent&);
    bool TryBefore( ::wxEvent&);
    bool ProcessEvent( ::wxEvent&);
    int FilterEvent( ::wxEvent&);
    int MainLoop();
    void ExitMainLoop();
    void ProcessPendingEvents();
    void OnEventLoopEnter( ::wxEventLoopBase*);
    void OnEventLoopExit( ::wxEventLoopBase*);
    int OnExit();
    bool OnInit();
    int OnRun();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxPyApp(const sipwxPyApp &);
    sipwxPyApp &operator = (const sipwxPyApp &);

    char sipPyMethods[21];
};

sipwxPyApp::sipwxPyApp():  ::wxPyApp(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxPyApp::~sipwxPyApp()
{
    sipInstanceDestroyed(sipPySelf);
}

bool sipwxPyApp::OnInitGui()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_OnInitGui);

    if (!sipMeth)
        return  ::wxPyApp::OnInitGui();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::OnPreInit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_OnPreInit);

    if (!sipMeth)
    {
         ::wxPyApp::OnPreInit();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::OSXIsGUIApplication()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_OSXIsGUIApplication);

    if (!sipMeth)
        return  ::wxPyApp::OSXIsGUIApplication();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::MacReopenApp()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_MacReopenApp);

    if (!sipMeth)
    {
         ::wxPyApp::MacReopenApp();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::MacPrintFile(const  ::wxString& fileName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_MacPrintFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacPrintFile(fileName);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_38(sipGILState, 0, sipPySelf, sipMeth, fileName);
}

void sipwxPyApp::MacOpenURL(const  ::wxString& url)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_MacOpenURL);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenURL(url);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_38(sipGILState, 0, sipPySelf, sipMeth, url);
}

void sipwxPyApp::MacOpenFile(const  ::wxString& fileName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_MacOpenFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenFile(fileName);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_38(sipGILState, 0, sipPySelf, sipMeth, fileName);
}

void sipwxPyApp::MacOpenFiles(const  ::wxArrayString& fileNames)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_MacOpenFiles);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenFiles(fileNames);
        return;
    }

    extern void sipVH__core_99(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxArrayString&);

    sipVH__core_99(sipGILState, 0, sipPySelf, sipMeth, fileNames);
}

void sipwxPyApp::MacNewFile()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_MacNewFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacNewFile();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::TryAfter( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,NULL,sipName_TryAfter);

    if (!sipMeth)
        return  ::wxPyApp::TryAfter(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxPyApp::TryBefore( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[10],sipPySelf,NULL,sipName_TryBefore);

    if (!sipMeth)
        return  ::wxPyApp::TryBefore(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxPyApp::ProcessEvent( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[11],sipPySelf,NULL,sipName_ProcessEvent);

    if (!sipMeth)
        return  ::wxPyApp::ProcessEvent(event);

    extern bool sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_81(sipGILState, 0, sipPySelf, sipMeth, event);
}

int sipwxPyApp::FilterEvent( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[12],sipPySelf,NULL,sipName_FilterEvent);

    if (!sipMeth)
        return  ::wxPyApp::FilterEvent(event);

    extern int sipVH__core_87(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_87(sipGILState, 0, sipPySelf, sipMeth, event);
}

int sipwxPyApp::MainLoop()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[13],sipPySelf,NULL,sipName_MainLoop);

    if (!sipMeth)
        return  ::wxPyApp::MainLoop();

    extern int sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::ExitMainLoop()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[14],sipPySelf,NULL,sipName_ExitMainLoop);

    if (!sipMeth)
    {
         ::wxPyApp::ExitMainLoop();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::ProcessPendingEvents()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[15],sipPySelf,NULL,sipName_ProcessPendingEvents);

    if (!sipMeth)
    {
         ::wxPyApp::ProcessPendingEvents();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::OnEventLoopEnter( ::wxEventLoopBase*loop)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[16],sipPySelf,NULL,sipName_OnEventLoopEnter);

    if (!sipMeth)
    {
         ::wxPyApp::OnEventLoopEnter(loop);
        return;
    }

    extern void sipVH__core_98(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEventLoopBase*);

    sipVH__core_98(sipGILState, 0, sipPySelf, sipMeth, loop);
}

void sipwxPyApp::OnEventLoopExit( ::wxEventLoopBase*loop)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[17],sipPySelf,NULL,sipName_OnEventLoopExit);

    if (!sipMeth)
    {
         ::wxPyApp::OnEventLoopExit(loop);
        return;
    }

    extern void sipVH__core_98(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEventLoopBase*);

    sipVH__core_98(sipGILState, 0, sipPySelf, sipMeth, loop);
}

int sipwxPyApp::OnExit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[18],sipPySelf,NULL,sipName_OnExit);

    if (!sipMeth)
        return  ::wxPyApp::OnExit();

    extern int sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::OnInit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[19],sipPySelf,NULL,sipName_OnInit);

    if (!sipMeth)
        return  ::wxPyApp::OnInit();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

int sipwxPyApp::OnRun()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[20],sipPySelf,NULL,sipName_OnRun);

    if (!sipMeth)
        return  ::wxPyApp::OnRun();

    extern int sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::sipProtectVirt_TryBefore(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxPyApp::TryBefore(event) : TryBefore(event));
}

bool sipwxPyApp::sipProtectVirt_TryAfter(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxPyApp::TryAfter(event) : TryAfter(event));
}


PyDoc_STRVAR(doc_wxPyApp_MacNewFile, "MacNewFile()\n"
"\n"
"Called in response of an \"open-application\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacNewFile(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacNewFile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacNewFile() : sipCpp->MacNewFile());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacNewFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenFiles, "MacOpenFiles(fileNames)\n"
"\n"
"Called in response of an openFiles message with Cocoa, or an \"open-\n"
"document\" Apple event with Carbon.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenFiles(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenFiles(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxArrayString* fileNames;
        int fileNamesState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileNames,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxArrayString,&fileNames, &fileNamesState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenFiles(*fileNames) : sipCpp->MacOpenFiles(*fileNames));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(fileNames),sipType_wxArrayString,fileNamesState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenFiles, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenFile, "MacOpenFile(fileName)\n"
"\n"
"Called in response of an \"open-document\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* fileName;
        int fileNameState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString,&fileName, &fileNameState))
        {
            if (sipDeprecated(sipName_PyApp,sipName_MacOpenFile) < 0)
                return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenFile(*fileName) : sipCpp->MacOpenFile(*fileName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(fileName),sipType_wxString,fileNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenURL, "MacOpenURL(url)\n"
"\n"
"Called in response of a \"get-url\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* url;
        int urlState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString,&url, &urlState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenURL(*url) : sipCpp->MacOpenURL(*url));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacPrintFile, "MacPrintFile(fileName)\n"
"\n"
"Called in response of a \"print-document\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacPrintFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacPrintFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* fileName;
        int fileNameState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString,&fileName, &fileNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacPrintFile(*fileName) : sipCpp->MacPrintFile(*fileName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(fileName),sipType_wxString,fileNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacPrintFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacReopenApp, "MacReopenApp()\n"
"\n"
"Called in response of a \"reopen-application\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacReopenApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacReopenApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacReopenApp() : sipCpp->MacReopenApp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacReopenApp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OSXIsGUIApplication, "OSXIsGUIApplication() -> bool\n"
"\n"
"May be overridden to indicate that the application is not a foreground\n"
"GUI application under OS X.");

extern "C" {static PyObject *meth_wxPyApp_OSXIsGUIApplication(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OSXIsGUIApplication(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OSXIsGUIApplication() : sipCpp->OSXIsGUIApplication());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OSXIsGUIApplication, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetDisplayMode, "GetDisplayMode() -> VideoMode\n"
"\n"
"Get display mode that is used use.");

extern "C" {static PyObject *meth_wxPyApp_GetDisplayMode(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetDisplayMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxVideoMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxVideoMode(sipCpp->GetDisplayMode());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxVideoMode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetDisplayMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetExitOnFrameDelete, "GetExitOnFrameDelete() -> bool\n"
"\n"
"Returns true if the application will exit when the top-level frame is\n"
"deleted.");

extern "C" {static PyObject *meth_wxPyApp_GetExitOnFrameDelete(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetExitOnFrameDelete(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetExitOnFrameDelete();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetExitOnFrameDelete, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetLayoutDirection, "GetLayoutDirection() -> LayoutDirection\n"
"\n"
"Return the layout direction for the current locale or wxLayout_Default\n"
"if it's unknown.");

extern "C" {static PyObject *meth_wxPyApp_GetLayoutDirection(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxLayoutDirection sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLayoutDirection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxLayoutDirection);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetLayoutDirection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetUseBestVisual, "GetUseBestVisual() -> bool\n"
"\n"
"Returns true if the application will use the best visual on systems\n"
"that support different visuals, false otherwise.");

extern "C" {static PyObject *meth_wxPyApp_GetUseBestVisual(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetUseBestVisual(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUseBestVisual();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetUseBestVisual, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetTopWindow, "GetTopWindow() -> Window\n"
"\n"
"Returns a pointer to the top window.");

extern "C" {static PyObject *meth_wxPyApp_GetTopWindow(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetTopWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTopWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetTopWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_IsActive, "IsActive() -> bool\n"
"\n"
"Returns true if the application is active, i.e. if one of its windows\n"
"is currently in the foreground.");

extern "C" {static PyObject *meth_wxPyApp_IsActive(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_IsActive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsActive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_IsActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SafeYield, "SafeYield(win, onlyIfNeeded) -> bool\n"
"\n"
"This function is similar to wxYield(), except that it disables the\n"
"user input to all program windows before calling wxAppConsole::Yield\n"
"and re-enables it again afterwards.");

extern "C" {static PyObject *meth_wxPyApp_SafeYield(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SafeYield(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* win;
        bool onlyIfNeeded;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
            sipName_onlyIfNeeded,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8b", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &win, &onlyIfNeeded))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SafeYield(win,onlyIfNeeded);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SafeYield, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SafeYieldFor, "SafeYieldFor(win, eventsToProcess) -> bool\n"
"\n"
"Works like SafeYield() with onlyIfNeeded == true except that it allows\n"
"the caller to specify a mask of events to be processed.");

extern "C" {static PyObject *meth_wxPyApp_SafeYieldFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SafeYieldFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* win;
        long eventsToProcess;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
            sipName_eventsToProcess,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8l", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &win, &eventsToProcess))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SafeYieldFor(win,eventsToProcess);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SafeYieldFor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetDisplayMode, "SetDisplayMode(info) -> bool\n"
"\n"
"Set display mode to use.");

extern "C" {static PyObject *meth_wxPyApp_SetDisplayMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetDisplayMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVideoMode* info;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxVideoMode, &info))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetDisplayMode(*info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetDisplayMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetExitOnFrameDelete, "SetExitOnFrameDelete(flag)\n"
"\n"
"Allows the programmer to specify whether the application will exit\n"
"when the top-level frame is deleted.");

extern "C" {static PyObject *meth_wxPyApp_SetExitOnFrameDelete(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetExitOnFrameDelete(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool flag;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxPyApp, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExitOnFrameDelete(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetExitOnFrameDelete, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetNativeTheme, "SetNativeTheme(theme) -> bool\n"
"\n"
"Allows runtime switching of the UI environment theme.");

extern "C" {static PyObject *meth_wxPyApp_SetNativeTheme(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetNativeTheme(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* theme;
        int themeState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_theme,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString,&theme, &themeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeTheme(*theme);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(theme),sipType_wxString,themeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetNativeTheme, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetTopWindow, "SetTopWindow(window)\n"
"\n"
"Sets the 'top' window.");

extern "C" {static PyObject *meth_wxPyApp_SetTopWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetTopWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* window;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &window))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTopWindow(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetTopWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetUseBestVisual, "SetUseBestVisual(flag, forceTrueColour=False)\n"
"\n"
"Allows the programmer to specify whether the application will use the\n"
"best visual on systems that support several visual on the same\n"
"display.");

extern "C" {static PyObject *meth_wxPyApp_SetUseBestVisual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetUseBestVisual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool flag;
        bool forceTrueColour = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
            sipName_forceTrueColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb|b", &sipSelf, sipType_wxPyApp, &sipCpp, &flag, &forceTrueColour))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUseBestVisual(flag,forceTrueColour);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetUseBestVisual, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MacHideApp, "MacHideApp()\n"
"\n"
"Hide all application windows just as the user can do with the\n"
"system Hide command.  Mac only.");

extern "C" {static PyObject *meth_wxPyApp_MacHideApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacHideApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPyApp_MacHideApp(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacHideApp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetComCtl32Version, "GetComCtl32Version() -> int\n"
"\n"
"Returns 400, 470, 471, etc. for comctl32.dll 4.00, 4.70, 4.71 or 0 if\n"
"it wasn't found at all.  Raises an exception on non-Windows platforms.");

extern "C" {static PyObject *meth_wxPyApp_GetComCtl32Version(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetComCtl32Version(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPyApp_GetComCtl32Version();
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetComCtl32Version, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetShell32Version, "GetShell32Version() -> int\n"
"\n"
"Returns 400, 470, 471, etc. for shell32.dll 4.00, 4.70, 4.71 or 0 if\n"
"it wasn't found at all.  Raises an exception on non-Windows platforms.");

extern "C" {static PyObject *meth_wxPyApp_GetShell32Version(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetShell32Version(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPyApp_GetShell32Version();
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetShell32Version, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_TryBefore, "TryBefore(self, event: Event) -> bool");

extern "C" {static PyObject *meth_wxPyApp_TryBefore(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_TryBefore(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryBefore(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_TryBefore, doc_wxPyApp_TryBefore);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_TryAfter, "TryAfter(self, event: Event) -> bool");

extern "C" {static PyObject *meth_wxPyApp_TryAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_TryAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryAfter(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_TryAfter, doc_wxPyApp_TryAfter);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_MainLoop, "MainLoop(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_MainLoop(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MainLoop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::MainLoop() : sipCpp->MainLoop());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MainLoop, doc_wxPyApp_MainLoop);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OnPreInit, "OnPreInit(self)");

extern "C" {static PyObject *meth_wxPyApp_OnPreInit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnPreInit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnPreInit() : sipCpp->OnPreInit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnPreInit, doc_wxPyApp_OnPreInit);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OnInit, "OnInit(self) -> bool");

extern "C" {static PyObject *meth_wxPyApp_OnInit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnInit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnInit() : sipCpp->OnInit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnInit, doc_wxPyApp_OnInit);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OnInitGui, "OnInitGui(self) -> bool");

extern "C" {static PyObject *meth_wxPyApp_OnInitGui(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnInitGui(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnInitGui() : sipCpp->OnInitGui());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnInitGui, doc_wxPyApp_OnInitGui);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OnRun, "OnRun(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_OnRun(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnRun(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnRun() : sipCpp->OnRun());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnRun, doc_wxPyApp_OnRun);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_OnExit, "OnExit(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_OnExit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnExit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnExit() : sipCpp->OnExit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnExit, doc_wxPyApp_OnExit);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp__BootstrapApp, "_BootstrapApp(self)");

extern "C" {static PyObject *meth_wxPyApp__BootstrapApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp__BootstrapApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->_BootstrapApp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName__BootstrapApp, doc_wxPyApp__BootstrapApp);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacAboutMenuItemId, "GetMacAboutMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacAboutMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacAboutMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacAboutMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacAboutMenuItemId, doc_wxPyApp_GetMacAboutMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacPreferencesMenuItemId, "GetMacPreferencesMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacPreferencesMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacPreferencesMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacPreferencesMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacPreferencesMenuItemId, doc_wxPyApp_GetMacPreferencesMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacExitMenuItemId, "GetMacExitMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacExitMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacExitMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacExitMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacExitMenuItemId, doc_wxPyApp_GetMacExitMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacHelpMenuTitleName, "GetMacHelpMenuTitleName() -> object");

extern "C" {static PyObject *meth_wxPyApp_GetMacHelpMenuTitleName(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacHelpMenuTitleName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxPyApp::GetMacHelpMenuTitleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacHelpMenuTitleName, doc_wxPyApp_GetMacHelpMenuTitleName);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacAboutMenuItemId, "SetMacAboutMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacAboutMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacAboutMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacAboutMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacAboutMenuItemId, doc_wxPyApp_SetMacAboutMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacPreferencesMenuItemId, "SetMacPreferencesMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacPreferencesMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacPreferencesMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacPreferencesMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacPreferencesMenuItemId, doc_wxPyApp_SetMacPreferencesMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacExitMenuItemId, "SetMacExitMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacExitMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacExitMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacExitMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacExitMenuItemId, doc_wxPyApp_SetMacExitMenuItemId);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacHelpMenuTitleName, "SetMacHelpMenuTitleName(val: object)");

extern "C" {static PyObject *meth_wxPyApp_SetMacHelpMenuTitleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacHelpMenuTitleName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* val;
        int valState = 0;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&val, &valState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacHelpMenuTitleName(*val);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(val),sipType_wxString,valState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacHelpMenuTitleName, doc_wxPyApp_SetMacHelpMenuTitleName);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_GetAssertMode, "GetAssertMode() -> AppAssertMode\n"
"\n"
"Returns the current mode for how the application responds to wx\n"
"asserts.");

extern "C" {static PyObject *meth_wxPyApp_GetAssertMode(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetAssertMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxAppAssertMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAssertMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxAppAssertMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetAssertMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_SetAssertMode, "SetAssertMode(AppAssertMode)\n"
"\n"
"Set the mode indicating how the application responds to wx assertion\n"
"statements. Valid settings are a combination of these flags:\n"
"\n"
"    - wx.APP_ASSERT_SUPPRESS\n"
"    - wx.APP_ASSERT_EXCEPTION\n"
"    - wx.APP_ASSERT_DIALOG\n"
"    - wx.APP_ASSERT_LOG\n"
"\n"
"The default behavior is to raise a wx.wxAssertionError exception.");

extern "C" {static PyObject *meth_wxPyApp_SetAssertMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetAssertMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxAppAssertMode wxAppAssertMode;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wxAppAssertMode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxAppAssertMode, &wxAppAssertMode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAssertMode(wxAppAssertMode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetAssertMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPyApp_IsDisplayAvailable, "IsDisplayAvailable() -> bool\n"
"\n"
"Returns True if the application is able to connect to the system's\n"
"display, or whatever the equivallent is for the platform.");

extern "C" {static PyObject *meth_wxPyApp_IsDisplayAvailable(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_IsDisplayAvailable(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::IsDisplayAvailable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PyApp, sipName_IsDisplayAvailable, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPyApp(void *, const sipTypeDef *);}
static void *cast_wxPyApp(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPyApp *sipCpp = reinterpret_cast< ::wxPyApp *>(sipCppV);

    if (targetType == sipType_wxAppConsole)
        return static_cast< ::wxAppConsole *>(sipCpp);

    if (targetType == sipType_wxEvtHandler)
        return static_cast< ::wxEvtHandler *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    if (targetType == sipType_wxTrackable)
        return static_cast< ::wxTrackable *>(sipCpp);

    if (targetType == sipType_wxEventFilter)
        return static_cast< ::wxEventFilter *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPyApp(void *, int);}
static void release_wxPyApp(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxPyApp *>(sipCppV);
    else
        delete reinterpret_cast< ::wxPyApp *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxPyApp(sipSimpleWrapper *);}
static void dealloc_wxPyApp(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxPyApp *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPyApp(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxPyApp(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPyApp(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxPyApp *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxPyApp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPyApp[] = {{15, 255, 1}};


static PyMethodDef methods_wxPyApp[] = {
    {SIP_MLNAME_CAST(sipName_GetAssertMode), meth_wxPyApp_GetAssertMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetAssertMode)},
    {SIP_MLNAME_CAST(sipName_GetComCtl32Version), meth_wxPyApp_GetComCtl32Version, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetComCtl32Version)},
    {SIP_MLNAME_CAST(sipName_GetDisplayMode), meth_wxPyApp_GetDisplayMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetDisplayMode)},
    {SIP_MLNAME_CAST(sipName_GetExitOnFrameDelete), meth_wxPyApp_GetExitOnFrameDelete, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetExitOnFrameDelete)},
    {SIP_MLNAME_CAST(sipName_GetLayoutDirection), meth_wxPyApp_GetLayoutDirection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetLayoutDirection)},
    {SIP_MLNAME_CAST(sipName_GetMacAboutMenuItemId), meth_wxPyApp_GetMacAboutMenuItemId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetMacAboutMenuItemId)},
    {SIP_MLNAME_CAST(sipName_GetMacExitMenuItemId), meth_wxPyApp_GetMacExitMenuItemId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetMacExitMenuItemId)},
    {SIP_MLNAME_CAST(sipName_GetMacHelpMenuTitleName), meth_wxPyApp_GetMacHelpMenuTitleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetMacHelpMenuTitleName)},
    {SIP_MLNAME_CAST(sipName_GetMacPreferencesMenuItemId), meth_wxPyApp_GetMacPreferencesMenuItemId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetMacPreferencesMenuItemId)},
    {SIP_MLNAME_CAST(sipName_GetShell32Version), meth_wxPyApp_GetShell32Version, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetShell32Version)},
    {SIP_MLNAME_CAST(sipName_GetTopWindow), meth_wxPyApp_GetTopWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetTopWindow)},
    {SIP_MLNAME_CAST(sipName_GetUseBestVisual), meth_wxPyApp_GetUseBestVisual, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_GetUseBestVisual)},
    {SIP_MLNAME_CAST(sipName_IsActive), meth_wxPyApp_IsActive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_IsActive)},
    {SIP_MLNAME_CAST(sipName_IsDisplayAvailable), meth_wxPyApp_IsDisplayAvailable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_IsDisplayAvailable)},
    {SIP_MLNAME_CAST(sipName_MacHideApp), meth_wxPyApp_MacHideApp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_MacHideApp)},
    {SIP_MLNAME_CAST(sipName_MacNewFile), meth_wxPyApp_MacNewFile, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_MacNewFile)},
    {SIP_MLNAME_CAST(sipName_MacOpenFile), (PyCFunction)meth_wxPyApp_MacOpenFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_MacOpenFile)},
    {SIP_MLNAME_CAST(sipName_MacOpenFiles), (PyCFunction)meth_wxPyApp_MacOpenFiles, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_MacOpenFiles)},
    {SIP_MLNAME_CAST(sipName_MacOpenURL), (PyCFunction)meth_wxPyApp_MacOpenURL, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_MacOpenURL)},
    {SIP_MLNAME_CAST(sipName_MacPrintFile), (PyCFunction)meth_wxPyApp_MacPrintFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_MacPrintFile)},
    {SIP_MLNAME_CAST(sipName_MacReopenApp), meth_wxPyApp_MacReopenApp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_MacReopenApp)},
    {SIP_MLNAME_CAST(sipName_MainLoop), meth_wxPyApp_MainLoop, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_MainLoop)},
    {SIP_MLNAME_CAST(sipName_OSXIsGUIApplication), meth_wxPyApp_OSXIsGUIApplication, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OSXIsGUIApplication)},
    {SIP_MLNAME_CAST(sipName_OnExit), meth_wxPyApp_OnExit, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OnExit)},
    {SIP_MLNAME_CAST(sipName_OnInit), meth_wxPyApp_OnInit, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OnInit)},
    {SIP_MLNAME_CAST(sipName_OnInitGui), meth_wxPyApp_OnInitGui, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OnInitGui)},
    {SIP_MLNAME_CAST(sipName_OnPreInit), meth_wxPyApp_OnPreInit, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OnPreInit)},
    {SIP_MLNAME_CAST(sipName_OnRun), meth_wxPyApp_OnRun, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp_OnRun)},
    {SIP_MLNAME_CAST(sipName_SafeYield), (PyCFunction)meth_wxPyApp_SafeYield, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SafeYield)},
    {SIP_MLNAME_CAST(sipName_SafeYieldFor), (PyCFunction)meth_wxPyApp_SafeYieldFor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SafeYieldFor)},
    {SIP_MLNAME_CAST(sipName_SetAssertMode), (PyCFunction)meth_wxPyApp_SetAssertMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetAssertMode)},
    {SIP_MLNAME_CAST(sipName_SetDisplayMode), (PyCFunction)meth_wxPyApp_SetDisplayMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetDisplayMode)},
    {SIP_MLNAME_CAST(sipName_SetExitOnFrameDelete), (PyCFunction)meth_wxPyApp_SetExitOnFrameDelete, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetExitOnFrameDelete)},
    {SIP_MLNAME_CAST(sipName_SetMacAboutMenuItemId), (PyCFunction)meth_wxPyApp_SetMacAboutMenuItemId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetMacAboutMenuItemId)},
    {SIP_MLNAME_CAST(sipName_SetMacExitMenuItemId), (PyCFunction)meth_wxPyApp_SetMacExitMenuItemId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetMacExitMenuItemId)},
    {SIP_MLNAME_CAST(sipName_SetMacHelpMenuTitleName), (PyCFunction)meth_wxPyApp_SetMacHelpMenuTitleName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetMacHelpMenuTitleName)},
    {SIP_MLNAME_CAST(sipName_SetMacPreferencesMenuItemId), (PyCFunction)meth_wxPyApp_SetMacPreferencesMenuItemId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetMacPreferencesMenuItemId)},
    {SIP_MLNAME_CAST(sipName_SetNativeTheme), (PyCFunction)meth_wxPyApp_SetNativeTheme, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetNativeTheme)},
    {SIP_MLNAME_CAST(sipName_SetTopWindow), (PyCFunction)meth_wxPyApp_SetTopWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetTopWindow)},
    {SIP_MLNAME_CAST(sipName_SetUseBestVisual), (PyCFunction)meth_wxPyApp_SetUseBestVisual, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_SetUseBestVisual)},
    {SIP_MLNAME_CAST(sipName_TryAfter), (PyCFunction)meth_wxPyApp_TryAfter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_TryAfter)},
    {SIP_MLNAME_CAST(sipName_TryBefore), (PyCFunction)meth_wxPyApp_TryBefore, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPyApp_TryBefore)},
    {SIP_MLNAME_CAST(sipName__BootstrapApp), meth_wxPyApp__BootstrapApp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPyApp__BootstrapApp)}
};

sipVariableDef variables_wxPyApp[] = {
    {PropertyVariable, sipName_TopWindow, &methods_wxPyApp[10], &methods_wxPyApp[38], NULL, NULL},
    {PropertyVariable, sipName_UseBestVisual, &methods_wxPyApp[11], &methods_wxPyApp[39], NULL, NULL},
    {PropertyVariable, sipName_LayoutDirection, &methods_wxPyApp[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_ExitOnFrameDelete, &methods_wxPyApp[3], &methods_wxPyApp[32], NULL, NULL},
    {PropertyVariable, sipName_DisplayMode, &methods_wxPyApp[2], &methods_wxPyApp[31], NULL, NULL},
    {PropertyVariable, sipName_AssertMode, &methods_wxPyApp[0], &methods_wxPyApp[30], NULL, NULL},
};

PyDoc_STRVAR(doc_wxPyApp, "PyApp()\n"
"\n"
"The wxApp class represents the application itself when wxUSE_GUI=1.");


sipClassTypeDef sipTypeDef__core_wxPyApp = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPyApp,
        {0},
        0
    },
    {
        sipNameNr_PyApp,
        {0, 0, 1},
        43, methods_wxPyApp,
        0, 0,
        6, variables_wxPyApp,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPyApp,
    -1,
    -1,
    supers_wxPyApp,
    0,
    init_type_wxPyApp,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPyApp,
    0,
    0,
    0,
    release_wxPyApp,
    cast_wxPyApp,
    0,
    0,
    0,
    0,
    0,
    0
};
