/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/object.h>



class sipwxRefCounter : public  ::wxRefCounter
{
public:
    sipwxRefCounter();
    ~sipwxRefCounter();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRefCounter(const sipwxRefCounter &);
    sipwxRefCounter &operator = (const sipwxRefCounter &);
};

sipwxRefCounter::sipwxRefCounter():  ::wxRefCounter(), sipPySelf(0)
{
}

sipwxRefCounter::~sipwxRefCounter()
{
    sipInstanceDestroyed(sipPySelf);
}


PyDoc_STRVAR(doc_wxRefCounter_DecRef, "DecRef()\n"
"\n"
"Decrements the reference count associated with this shared data and,\n"
"if it reaches zero, destroys this instance of wxRefCounter releasing\n"
"its memory.");

extern "C" {static PyObject *meth_wxRefCounter_DecRef(PyObject *, PyObject *);}
static PyObject *meth_wxRefCounter_DecRef(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRefCounter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRefCounter, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecRef();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RefCounter, sipName_DecRef, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRefCounter_GetRefCount, "GetRefCount() -> int\n"
"\n"
"Returns the reference count associated with this shared data.");

extern "C" {static PyObject *meth_wxRefCounter_GetRefCount(PyObject *, PyObject *);}
static PyObject *meth_wxRefCounter_GetRefCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRefCounter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRefCounter, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRefCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RefCounter, sipName_GetRefCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRefCounter_IncRef, "IncRef()\n"
"\n"
"Increments the reference count associated with this shared data.");

extern "C" {static PyObject *meth_wxRefCounter_IncRef(PyObject *, PyObject *);}
static PyObject *meth_wxRefCounter_IncRef(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRefCounter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRefCounter, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncRef();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RefCounter, sipName_IncRef, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRefCounter(void *, int);}
static void release_wxRefCounter(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRefCounter *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRefCounter(sipSimpleWrapper *);}
static void dealloc_wxRefCounter(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRefCounter *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRefCounter(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRefCounter(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRefCounter(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipwxRefCounter *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRefCounter();
            Py_END_ALLOW_THREADS

            *sipOwner = Py_None;

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxRefCounter[] = {
    {SIP_MLNAME_CAST(sipName_DecRef), meth_wxRefCounter_DecRef, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRefCounter_DecRef)},
    {SIP_MLNAME_CAST(sipName_GetRefCount), meth_wxRefCounter_GetRefCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRefCounter_GetRefCount)},
    {SIP_MLNAME_CAST(sipName_IncRef), meth_wxRefCounter_IncRef, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRefCounter_IncRef)}
};

sipVariableDef variables_wxRefCounter[] = {
    {PropertyVariable, sipName_RefCount, &methods_wxRefCounter[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRefCounter, "RefCounter()\n"
"\n"
"This class is used to manage reference-counting providing a simple\n"
"interface and a counter.");


sipClassTypeDef sipTypeDef__core_wxRefCounter = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRefCounter,
        {0},
        0
    },
    {
        sipNameNr_RefCounter,
        {0, 0, 1},
        3, methods_wxRefCounter,
        0, 0,
        1, variables_wxRefCounter,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRefCounter,
    -1,
    -1,
    0,
    0,
    init_type_wxRefCounter,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRefCounter,
    0,
    0,
    0,
    release_wxRefCounter,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
