/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/region.h>

        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/bitmap.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        // Convert a Python sequence of wxPoint objects, or items that can be converted
        // to wxPoint into a C array of wxPoint instances.
        static
        wxPoint* wxPoint_array_helper(PyObject* source, size_t *count)
        {
            wxPoint* array;
            Py_ssize_t idx, len;
            wxPyThreadBlocker blocker;
        
            // ensure that it is a sequence
            if (! PySequence_Check(source))
                goto error0;
            // ensure it is not a string or unicode object (they are sequences too)
            else if (PyBytes_Check(source) || PyUnicode_Check(source))
                goto error0;
            // ensure each item can be converted to wxPoint
            else {
                len = PySequence_Length(source);
                for (idx=0; idx<len; idx++) {
                    PyObject* item = PySequence_ITEM(source, idx);
                    if (!sipCanConvertToType(item, sipType_wxPoint, SIP_NOT_NONE)) {
                        Py_DECREF(item);
                        goto error0;
                    }
                    Py_DECREF(item);
                }
            }
        
            // The length of the sequence is returned in count.
            *count = len;
            array = new wxPoint[*count];
            if (!array) {
                PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
                return NULL;
            }
            for (idx=0; idx<len; idx++) {
                PyObject* obj = PySequence_ITEM(source, idx);
                int state = 0;
                int err = 0;
                wxPoint* item = reinterpret_cast<wxPoint*>(
                                sipConvertToType(obj, sipType_wxPoint, NULL, 0, &state, &err));
                array[idx] = *item;
                sipReleaseType((void*)item, sipType_wxPoint, state); // delete temporary instances
                Py_DECREF(obj);
            }
            return array;
        
        error0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of length-2 sequences or wx.Point objects.");
            return NULL;
        }


PyDoc_STRVAR(doc_wxRegion_GetBox, "GetBox() -> Rect\n"
"\n"
"Returns the outer bounds of the region.");

extern "C" {static PyObject *meth_wxRegion_GetBox(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_GetBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetBox());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_GetBox, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Offset, "Offset(x, y) -> bool\n"
"Offset(pt) -> bool\n"
"\n"
"Moves the region by the specified offsets in horizontal and vertical\n"
"directions.\n"
"");

extern "C" {static PyObject *meth_wxRegion_Offset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Offset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Offset(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Offset(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Offset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Clear, "Clear()\n"
"\n"
"Clears the current region.");

extern "C" {static PyObject *meth_wxRegion_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Contains, "Contains(x, y) -> RegionContain\n"
"Contains(pt) -> RegionContain\n"
"Contains(x, y, width, height) -> RegionContain\n"
"Contains(rect) -> RegionContain\n"
"\n"
"Returns a value indicating whether the given point is contained within\n"
"the region.\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
        const  ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y))
        {
             ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
        const  ::wxPoint* pt;
        int ptState = 0;
        const  ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
             ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
        const  ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
             ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
             ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Contains, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_ConvertToBitmap, "ConvertToBitmap() -> Bitmap\n"
"\n"
"Convert the region to a black and white bitmap with the white pixels\n"
"being inside the region.");

extern "C" {static PyObject *meth_wxRegion_ConvertToBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_ConvertToBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->ConvertToBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_ConvertToBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Intersect, "Intersect(x, y, width, height) -> bool\n"
"Intersect(rect) -> bool\n"
"Intersect(region) -> bool\n"
"\n"
"Finds the intersection of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Intersect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Intersect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRegion* region;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Intersect, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the region is empty, false otherwise.");

extern "C" {static PyObject *meth_wxRegion_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_IsEmpty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_IsEqual, "IsEqual(region) -> bool\n"
"\n"
"Returns true if the region is equal to, i.e. covers the same area as,\n"
"another one.");

extern "C" {static PyObject *meth_wxRegion_IsEqual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_IsEqual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion* region;
        const  ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqual(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_IsEqual, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Subtract, "Subtract(rect) -> bool\n"
"Subtract(region) -> bool\n"
"\n"
"Subtracts a rectangular region from this region.\n"
"");

extern "C" {static PyObject *meth_wxRegion_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Subtract(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRegion* region;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Subtract(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Subtract, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Union, "Union(x, y, width, height) -> bool\n"
"Union(rect) -> bool\n"
"Union(region) -> bool\n"
"Union(bmp) -> bool\n"
"Union(bmp, transColour, tolerance=0) -> bool\n"
"\n"
"Finds the union of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Union(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Union(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRegion* region;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxBitmap* bmp;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxBitmap, &bmp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxBitmap* bmp;
        const  ::wxColour* transColour;
        int transColourState = 0;
        int tolerance = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_transColour,
            sipName_tolerance,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1|i", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxBitmap, &bmp, sipType_wxColour, &transColour, &transColourState, &tolerance))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*bmp,*transColour,tolerance);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(transColour),sipType_wxColour,transColourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Union, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRegion_Xor, "Xor(x, y, width, height) -> bool\n"
"Xor(rect) -> bool\n"
"Xor(region) -> bool\n"
"\n"
"Finds the Xor of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Xor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Xor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxRegion* region;
         ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Region, sipName_Xor, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRegion(void *, const sipTypeDef *);}
static void *cast_wxRegion(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRegion *sipCpp = reinterpret_cast< ::wxRegion *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRegion(void *, int);}
static void release_wxRegion(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRegion *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRegion(void *, SIP_SSIZE_T, void *);}
static void assign_wxRegion(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRegion *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRegion *>(sipSrc);
}


extern "C" {static void *array_wxRegion(SIP_SSIZE_T);}
static void *array_wxRegion(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRegion[sipNrElem];
}


extern "C" {static void *copy_wxRegion(const void *, SIP_SSIZE_T);}
static void *copy_wxRegion(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRegion(reinterpret_cast<const  ::wxRegion *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRegion(sipSimpleWrapper *);}
static void dealloc_wxRegion(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRegion(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRegion(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRegion(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRegion *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxCoord width;
         ::wxCoord height;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiii", &x, &y, &width, &height))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(x,y,width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPoint* topLeft;
        int topLeftState = 0;
        const  ::wxPoint* bottomRight;
        int bottomRightState = 0;

        static const char *sipKwdList[] = {
            sipName_topLeft,
            sipName_bottomRight,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1", sipType_wxPoint, &topLeft, &topLeftState, sipType_wxPoint, &bottomRight, &bottomRightState))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(*topLeft,*bottomRight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(topLeft),sipType_wxPoint,topLeftState);
            sipReleaseType(const_cast< ::wxPoint *>(bottomRight),sipType_wxPoint,bottomRightState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRect* rect;
        int rectState = 0;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxRect, &rect, &rectState))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect),sipType_wxRect,rectState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRegion* region;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRegion, &region))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* bmp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bmp))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* bmp;
        const  ::wxColour* transColour;
        int transColourState = 0;
        int tolerance = 0;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_transColour,
            sipName_tolerance,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J1|i", sipType_wxBitmap, &bmp, sipType_wxColour, &transColour, &transColourState, &tolerance))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRegion(*bmp,*transColour,tolerance);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(transColour),sipType_wxColour,transColourState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        PyObject * points;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0|E", &points, sipType_wxPolygonFillMode, &fillStyle))
        {
            int sipIsErr = 0;

        size_t count;
        wxPoint* array = wxPoint_array_helper(points, &count);
        if ( array != NULL ) {
            sipCpp = new wxRegion(count, array, fillStyle);
            delete [] array;
        }
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
            {
                if (sipUnused)
                {
                    Py_XDECREF(*sipUnused);
                }

                sipAddException(sipErrorFail, sipParseErr);
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRegion[] = {{200, 255, 1}};


static PyMethodDef methods_wxRegion[] = {
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxRegion_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRegion_Clear)},
    {SIP_MLNAME_CAST(sipName_Contains), (PyCFunction)meth_wxRegion_Contains, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Contains)},
    {SIP_MLNAME_CAST(sipName_ConvertToBitmap), meth_wxRegion_ConvertToBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRegion_ConvertToBitmap)},
    {SIP_MLNAME_CAST(sipName_GetBox), meth_wxRegion_GetBox, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRegion_GetBox)},
    {SIP_MLNAME_CAST(sipName_Intersect), (PyCFunction)meth_wxRegion_Intersect, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Intersect)},
    {SIP_MLNAME_CAST(sipName_IsEmpty), meth_wxRegion_IsEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRegion_IsEmpty)},
    {SIP_MLNAME_CAST(sipName_IsEqual), (PyCFunction)meth_wxRegion_IsEqual, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_IsEqual)},
    {SIP_MLNAME_CAST(sipName_Offset), (PyCFunction)meth_wxRegion_Offset, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Offset)},
    {SIP_MLNAME_CAST(sipName_Subtract), (PyCFunction)meth_wxRegion_Subtract, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Subtract)},
    {SIP_MLNAME_CAST(sipName_Union), (PyCFunction)meth_wxRegion_Union, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Union)},
    {SIP_MLNAME_CAST(sipName_Xor), (PyCFunction)meth_wxRegion_Xor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRegion_Xor)}
};

sipVariableDef variables_wxRegion[] = {
    {PropertyVariable, sipName_Box, &methods_wxRegion[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRegion, "Region()\n"
"Region(x, y, width, height)\n"
"Region(topLeft, bottomRight)\n"
"Region(rect)\n"
"Region(region)\n"
"Region(bmp)\n"
"Region(bmp, transColour, tolerance=0)\n"
"Region(points, fillStyle=ODDEVEN_RULE)\n"
"\n"
"A wxRegion represents a simple or complex region on a device context\n"
"or window.");


sipClassTypeDef sipTypeDef__core_wxRegion = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRegion,
        {0},
        0
    },
    {
        sipNameNr_Region,
        {0, 0, 1},
        11, methods_wxRegion,
        0, 0,
        1, variables_wxRegion,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRegion,
    -1,
    -1,
    supers_wxRegion,
    0,
    init_type_wxRegion,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRegion,
    assign_wxRegion,
    array_wxRegion,
    copy_wxRegion,
    release_wxRegion,
    cast_wxRegion,
    0,
    0,
    0,
    0,
    0,
    0
};
