/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/sizer.h>



PyDoc_STRVAR(doc_wxSizerFlags_Align, "Align(alignment) -> SizerFlags\n"
"\n"
"Sets the alignment of this wxSizerFlags to align.");

extern "C" {static PyObject *meth_wxSizerFlags_Align(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Align(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int alignment;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_alignment,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSizerFlags, &sipCpp, &alignment))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Align(alignment);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Align, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Border, "Border(direction, borderinpixels) -> SizerFlags\n"
"Border(direction=ALL) -> SizerFlags\n"
"\n"
"Sets the wxSizerFlags to have a border of a number of pixels specified\n"
"by borderinpixels with the directions specified by direction.\n"
"");

extern "C" {static PyObject *meth_wxSizerFlags_Border(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Border(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int direction;
        int borderinpixels;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
            sipName_borderinpixels,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxSizerFlags, &sipCpp, &direction, &borderinpixels))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Border(direction,borderinpixels);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    {
        int direction = wxALL;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxSizerFlags, &sipCpp, &direction))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Border(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Border, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Bottom, "Bottom() -> SizerFlags\n"
"\n"
"Aligns the object to the bottom, similar for Align(wxALIGN_BOTTOM).");

extern "C" {static PyObject *meth_wxSizerFlags_Bottom(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Bottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Bottom();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Bottom, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Center, "Center() -> SizerFlags\n"
"\n"
"Sets the object of the wxSizerFlags to center itself in the area it is\n"
"given.");

extern "C" {static PyObject *meth_wxSizerFlags_Center(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Center(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Center();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Center, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Centre, "Centre() -> SizerFlags\n"
"\n"
"Center() for people with the other dialect of English.");

extern "C" {static PyObject *meth_wxSizerFlags_Centre(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Centre(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Centre();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Centre, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_DoubleBorder, "DoubleBorder(direction=ALL) -> SizerFlags\n"
"\n"
"Sets the border in the given direction having twice the default border\n"
"size.");

extern "C" {static PyObject *meth_wxSizerFlags_DoubleBorder(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_DoubleBorder(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int direction = wxALL;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxSizerFlags, &sipCpp, &direction))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DoubleBorder(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_DoubleBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_DoubleHorzBorder, "DoubleHorzBorder() -> SizerFlags\n"
"\n"
"Sets the border in left and right directions having twice the default\n"
"border size.");

extern "C" {static PyObject *meth_wxSizerFlags_DoubleHorzBorder(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_DoubleHorzBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DoubleHorzBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_DoubleHorzBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Expand, "Expand() -> SizerFlags\n"
"\n"
"Sets the object of the wxSizerFlags to expand to fill as much area as\n"
"it can.");

extern "C" {static PyObject *meth_wxSizerFlags_Expand(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Expand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Expand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Expand, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_FixedMinSize, "FixedMinSize() -> SizerFlags\n"
"\n"
"Set the wxFIXED_MINSIZE flag which indicates that the initial size of\n"
"the window should be also set as its minimal size.");

extern "C" {static PyObject *meth_wxSizerFlags_FixedMinSize(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_FixedMinSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FixedMinSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_FixedMinSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_ReserveSpaceEvenIfHidden, "ReserveSpaceEvenIfHidden() -> SizerFlags\n"
"\n"
"Set the wxRESERVE_SPACE_EVEN_IF_HIDDEN flag.");

extern "C" {static PyObject *meth_wxSizerFlags_ReserveSpaceEvenIfHidden(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_ReserveSpaceEvenIfHidden(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ReserveSpaceEvenIfHidden();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_ReserveSpaceEvenIfHidden, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Left, "Left() -> SizerFlags\n"
"\n"
"Aligns the object to the left, similar for Align(wxALIGN_LEFT).");

extern "C" {static PyObject *meth_wxSizerFlags_Left(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Left();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Left, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Proportion, "Proportion(proportion) -> SizerFlags\n"
"\n"
"Sets the proportion of this wxSizerFlags to proportion.");

extern "C" {static PyObject *meth_wxSizerFlags_Proportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Proportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int proportion;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_proportion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSizerFlags, &sipCpp, &proportion))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Proportion(proportion);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Proportion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Right, "Right() -> SizerFlags\n"
"\n"
"Aligns the object to the right, similar for Align(wxALIGN_RIGHT).");

extern "C" {static PyObject *meth_wxSizerFlags_Right(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Right();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Right, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Shaped, "Shaped() -> SizerFlags\n"
"\n"
"Set the wx_SHAPED flag which indicates that the elements should always\n"
"keep the fixed width to height ratio equal to its original value.");

extern "C" {static PyObject *meth_wxSizerFlags_Shaped(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Shaped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Shaped();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Shaped, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_Top, "Top() -> SizerFlags\n"
"\n"
"Aligns the object to the top, similar for Align(wxALIGN_TOP).");

extern "C" {static PyObject *meth_wxSizerFlags_Top(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_Top(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSizerFlags *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSizerFlags, &sipCpp))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Top();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_Top, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_TripleBorder, "TripleBorder(direction=ALL) -> SizerFlags\n"
"\n"
"Sets the border in the given direction having thrice the default\n"
"border size.");

extern "C" {static PyObject *meth_wxSizerFlags_TripleBorder(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_TripleBorder(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int direction = wxALL;
         ::wxSizerFlags *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxSizerFlags, &sipCpp, &direction))
        {
             ::wxSizerFlags*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->TripleBorder(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSizerFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_TripleBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSizerFlags_GetDefaultBorder, "GetDefaultBorder() -> int\n"
"\n"
"Returns the border used by default in Border() method.");

extern "C" {static PyObject *meth_wxSizerFlags_GetDefaultBorder(PyObject *, PyObject *);}
static PyObject *meth_wxSizerFlags_GetDefaultBorder(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSizerFlags::GetDefaultBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SizerFlags, sipName_GetDefaultBorder, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSizerFlags(void *, int);}
static void release_wxSizerFlags(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSizerFlags *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxSizerFlags(void *, SIP_SSIZE_T, void *);}
static void assign_wxSizerFlags(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxSizerFlags *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxSizerFlags *>(sipSrc);
}


extern "C" {static void *array_wxSizerFlags(SIP_SSIZE_T);}
static void *array_wxSizerFlags(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxSizerFlags[sipNrElem];
}


extern "C" {static void *copy_wxSizerFlags(const void *, SIP_SSIZE_T);}
static void *copy_wxSizerFlags(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxSizerFlags(reinterpret_cast<const  ::wxSizerFlags *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSizerFlags(sipSimpleWrapper *);}
static void dealloc_wxSizerFlags(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSizerFlags(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSizerFlags(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSizerFlags(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSizerFlags *sipCpp = 0;

    {
        int proportion = 0;

        static const char *sipKwdList[] = {
            sipName_proportion,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &proportion))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSizerFlags(proportion);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSizerFlags* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxSizerFlags, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSizerFlags(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxSizerFlags[] = {
    {SIP_MLNAME_CAST(sipName_Align), (PyCFunction)meth_wxSizerFlags_Align, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSizerFlags_Align)},
    {SIP_MLNAME_CAST(sipName_Border), (PyCFunction)meth_wxSizerFlags_Border, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSizerFlags_Border)},
    {SIP_MLNAME_CAST(sipName_Bottom), meth_wxSizerFlags_Bottom, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Bottom)},
    {SIP_MLNAME_CAST(sipName_Center), meth_wxSizerFlags_Center, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Center)},
    {SIP_MLNAME_CAST(sipName_Centre), meth_wxSizerFlags_Centre, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Centre)},
    {SIP_MLNAME_CAST(sipName_DoubleBorder), (PyCFunction)meth_wxSizerFlags_DoubleBorder, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSizerFlags_DoubleBorder)},
    {SIP_MLNAME_CAST(sipName_DoubleHorzBorder), meth_wxSizerFlags_DoubleHorzBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_DoubleHorzBorder)},
    {SIP_MLNAME_CAST(sipName_Expand), meth_wxSizerFlags_Expand, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Expand)},
    {SIP_MLNAME_CAST(sipName_FixedMinSize), meth_wxSizerFlags_FixedMinSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_FixedMinSize)},
    {SIP_MLNAME_CAST(sipName_GetDefaultBorder), meth_wxSizerFlags_GetDefaultBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_GetDefaultBorder)},
    {SIP_MLNAME_CAST(sipName_Left), meth_wxSizerFlags_Left, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Left)},
    {SIP_MLNAME_CAST(sipName_Proportion), (PyCFunction)meth_wxSizerFlags_Proportion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSizerFlags_Proportion)},
    {SIP_MLNAME_CAST(sipName_ReserveSpaceEvenIfHidden), meth_wxSizerFlags_ReserveSpaceEvenIfHidden, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_ReserveSpaceEvenIfHidden)},
    {SIP_MLNAME_CAST(sipName_Right), meth_wxSizerFlags_Right, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Right)},
    {SIP_MLNAME_CAST(sipName_Shaped), meth_wxSizerFlags_Shaped, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Shaped)},
    {SIP_MLNAME_CAST(sipName_Top), meth_wxSizerFlags_Top, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSizerFlags_Top)},
    {SIP_MLNAME_CAST(sipName_TripleBorder), (PyCFunction)meth_wxSizerFlags_TripleBorder, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSizerFlags_TripleBorder)}
};

PyDoc_STRVAR(doc_wxSizerFlags, "SizerFlags(proportion=0)\n"
"\n"
"Container for sizer items flags providing readable names for them.");


sipClassTypeDef sipTypeDef__core_wxSizerFlags = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxSizerFlags,
        {0},
        0
    },
    {
        sipNameNr_SizerFlags,
        {0, 0, 1},
        17, methods_wxSizerFlags,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxSizerFlags,
    -1,
    -1,
    0,
    0,
    init_type_wxSizerFlags,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxSizerFlags,
    assign_wxSizerFlags,
    array_wxSizerFlags,
    copy_wxSizerFlags,
    release_wxSizerFlags,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
