/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/textctrl.h>

        #include <wx/colour.h>
        #include <wx/font.h>


PyDoc_STRVAR(doc_wxTextAttr_GetAlignment, "GetAlignment() -> TextAttrAlignment\n"
"\n"
"Returns the alignment flags.");

extern "C" {static PyObject *meth_wxTextAttr_GetAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxTextAttrAlignment sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextAttrAlignment);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBackgroundColour, "GetBackgroundColour() -> Colour\n"
"\n"
"Returns the background colour.");

extern "C" {static PyObject *meth_wxTextAttr_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBulletFont, "GetBulletFont() -> String\n"
"\n"
"Returns a string containing the name of the font associated with the\n"
"bullet symbol.");

extern "C" {static PyObject *meth_wxTextAttr_GetBulletFont(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBulletFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBulletFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBulletFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBulletName, "GetBulletName() -> String\n"
"\n"
"Returns the standard bullet name, applicable if the bullet style is\n"
"wxTEXT_ATTR_BULLET_STYLE_STANDARD.");

extern "C" {static PyObject *meth_wxTextAttr_GetBulletName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBulletName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBulletName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBulletName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBulletNumber, "GetBulletNumber() -> int\n"
"\n"
"Returns the bullet number.");

extern "C" {static PyObject *meth_wxTextAttr_GetBulletNumber(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBulletNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBulletNumber();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBulletNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBulletStyle, "GetBulletStyle() -> int\n"
"\n"
"Returns the bullet style.");

extern "C" {static PyObject *meth_wxTextAttr_GetBulletStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBulletStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBulletStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBulletStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetBulletText, "GetBulletText() -> String\n"
"\n"
"Returns the bullet text, which could be a symbol, or (for example)\n"
"cached outline text.");

extern "C" {static PyObject *meth_wxTextAttr_GetBulletText(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetBulletText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBulletText());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetBulletText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetCharacterStyleName, "GetCharacterStyleName() -> String\n"
"\n"
"Returns the name of the character style.");

extern "C" {static PyObject *meth_wxTextAttr_GetCharacterStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetCharacterStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetCharacterStyleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetCharacterStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFlags, "GetFlags() -> long\n"
"\n"
"Returns flags indicating which attributes are applicable.");

extern "C" {static PyObject *meth_wxTextAttr_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFont, "GetFont() -> Font\n"
"\n"
"Creates and returns a font specified by the font attributes in the\n"
"wxTextAttr object.");

extern "C" {static PyObject *meth_wxTextAttr_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontAttributes, "GetFontAttributes(font, flags=TEXT_ATTR_FONT) -> bool\n"
"\n"
"Gets the font attributes from the given font, using only the\n"
"attributes specified by flags.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
        int flags = wxTEXT_ATTR_FONT;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFont, &font, &flags))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontAttributes(*font,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontEncoding, "GetFontEncoding() -> FontEncoding\n"
"\n"
"Returns the font encoding.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxFontEncoding sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontEncoding);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontFaceName, "GetFontFaceName() -> String\n"
"\n"
"Returns the font face name.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontFaceName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontFaceName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFontFaceName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontFaceName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontFamily, "GetFontFamily() -> FontFamily\n"
"\n"
"Returns the font family.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontFamily(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxFontFamily sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontFamily();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontFamily);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontFamily, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontSize, "GetFontSize() -> int\n"
"\n"
"Returns the font size in points.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontStyle, "GetFontStyle() -> FontStyle\n"
"\n"
"Returns the font style.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxFontStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontStyle);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontUnderlined, "GetFontUnderlined() -> bool\n"
"\n"
"Returns true if the font is underlined.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetFontWeight, "GetFontWeight() -> FontWeight\n"
"\n"
"Returns the font weight.");

extern "C" {static PyObject *meth_wxTextAttr_GetFontWeight(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetFontWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxFontWeight sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontWeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontWeight);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetFontWeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetLeftIndent, "GetLeftIndent() -> long\n"
"\n"
"Returns the left indent in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_GetLeftIndent(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetLeftIndent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLeftIndent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetLeftIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetLeftSubIndent, "GetLeftSubIndent() -> long\n"
"\n"
"Returns the left sub-indent in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_GetLeftSubIndent(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetLeftSubIndent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLeftSubIndent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetLeftSubIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetLineSpacing, "GetLineSpacing() -> int\n"
"\n"
"Returns the line spacing value, one of wxTextAttrLineSpacing values.");

extern "C" {static PyObject *meth_wxTextAttr_GetLineSpacing(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetLineSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLineSpacing();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetLineSpacing, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetListStyleName, "GetListStyleName() -> String\n"
"\n"
"Returns the name of the list style.");

extern "C" {static PyObject *meth_wxTextAttr_GetListStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetListStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetListStyleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetListStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetOutlineLevel, "GetOutlineLevel() -> int\n"
"\n"
"Returns the outline level.");

extern "C" {static PyObject *meth_wxTextAttr_GetOutlineLevel(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetOutlineLevel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOutlineLevel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetOutlineLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetParagraphSpacingAfter, "GetParagraphSpacingAfter() -> int\n"
"\n"
"Returns the space in tenths of a millimeter after the paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_GetParagraphSpacingAfter(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetParagraphSpacingAfter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParagraphSpacingAfter();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetParagraphSpacingAfter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetParagraphSpacingBefore, "GetParagraphSpacingBefore() -> int\n"
"\n"
"Returns the space in tenths of a millimeter before the paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_GetParagraphSpacingBefore(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetParagraphSpacingBefore(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParagraphSpacingBefore();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetParagraphSpacingBefore, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetParagraphStyleName, "GetParagraphStyleName() -> String\n"
"\n"
"Returns the name of the paragraph style.");

extern "C" {static PyObject *meth_wxTextAttr_GetParagraphStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetParagraphStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetParagraphStyleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetParagraphStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetRightIndent, "GetRightIndent() -> long\n"
"\n"
"Returns the right indent in tenths of a millimeter.");

extern "C" {static PyObject *meth_wxTextAttr_GetRightIndent(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetRightIndent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRightIndent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetRightIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetTabs, "GetTabs() -> ArrayInt\n"
"\n"
"Returns an array of tab stops, each expressed in tenths of a\n"
"millimeter.");

extern "C" {static PyObject *meth_wxTextAttr_GetTabs(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetTabs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayInt(sipCpp->GetTabs());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayInt,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetTabs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetTextColour, "GetTextColour() -> Colour\n"
"\n"
"Returns the text foreground colour.");

extern "C" {static PyObject *meth_wxTextAttr_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetTextEffectFlags, "GetTextEffectFlags() -> int\n"
"\n"
"Returns the text effect bits of interest.");

extern "C" {static PyObject *meth_wxTextAttr_GetTextEffectFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetTextEffectFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTextEffectFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetTextEffectFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetTextEffects, "GetTextEffects() -> int\n"
"\n"
"Returns the text effects, a bit list of styles.");

extern "C" {static PyObject *meth_wxTextAttr_GetTextEffects(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetTextEffects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTextEffects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetTextEffects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_GetURL, "GetURL() -> String\n"
"\n"
"Returns the URL for the content.");

extern "C" {static PyObject *meth_wxTextAttr_GetURL(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_GetURL(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetURL());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_GetURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasAlignment, "HasAlignment() -> bool\n"
"\n"
"Returns true if the attribute object specifies alignment.");

extern "C" {static PyObject *meth_wxTextAttr_HasAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasBackgroundColour, "HasBackgroundColour() -> bool\n"
"\n"
"Returns true if the attribute object specifies a background colour.");

extern "C" {static PyObject *meth_wxTextAttr_HasBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBackgroundColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasBulletName, "HasBulletName() -> bool\n"
"\n"
"Returns true if the attribute object specifies a standard bullet name.");

extern "C" {static PyObject *meth_wxTextAttr_HasBulletName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasBulletName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBulletName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasBulletName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasBulletNumber, "HasBulletNumber() -> bool\n"
"\n"
"Returns true if the attribute object specifies a bullet number.");

extern "C" {static PyObject *meth_wxTextAttr_HasBulletNumber(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasBulletNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBulletNumber();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasBulletNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasBulletStyle, "HasBulletStyle() -> bool\n"
"\n"
"Returns true if the attribute object specifies a bullet style.");

extern "C" {static PyObject *meth_wxTextAttr_HasBulletStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasBulletStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBulletStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasBulletStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasBulletText, "HasBulletText() -> bool\n"
"\n"
"Returns true if the attribute object specifies bullet text (usually\n"
"specifying a symbol).");

extern "C" {static PyObject *meth_wxTextAttr_HasBulletText(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasBulletText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBulletText();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasBulletText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasCharacterStyleName, "HasCharacterStyleName() -> bool\n"
"\n"
"Returns true if the attribute object specifies a character style name.");

extern "C" {static PyObject *meth_wxTextAttr_HasCharacterStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasCharacterStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCharacterStyleName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasCharacterStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFlag, "HasFlag(flag) -> bool\n"
"\n"
"Returns true if the flag is present in the attribute object's flag\n"
"bitlist.");

extern "C" {static PyObject *meth_wxTextAttr_HasFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long flag;
        const  ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxTextAttr, &sipCpp, &flag))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFlag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFont, "HasFont() -> bool\n"
"\n"
"Returns true if the attribute object specifies any font attributes.");

extern "C" {static PyObject *meth_wxTextAttr_HasFont(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontEncoding, "HasFontEncoding() -> bool\n"
"\n"
"Returns true if the attribute object specifies an encoding.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontFaceName, "HasFontFaceName() -> bool\n"
"\n"
"Returns true if the attribute object specifies a font face name.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontFaceName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontFaceName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontFaceName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontFaceName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontFamily, "HasFontFamily() -> bool\n"
"\n"
"Returns true if the attribute object specifies a font family.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontFamily(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontFamily();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontFamily, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontItalic, "HasFontItalic() -> bool\n"
"\n"
"Returns true if the attribute object specifies italic style.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontItalic(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontItalic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontItalic, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontSize, "HasFontSize() -> bool\n"
"\n"
"Returns true if the attribute object specifies a font point or pixel\n"
"size.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontPointSize, "HasFontPointSize() -> bool\n"
"\n"
"Returns true if the attribute object specifies a font point size.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontPointSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontPointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontPointSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontPointSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontPixelSize, "HasFontPixelSize() -> bool\n"
"\n"
"Returns true if the attribute object specifies a font pixel size.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontPixelSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontPixelSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontPixelSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontPixelSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontUnderlined, "HasFontUnderlined() -> bool\n"
"\n"
"Returns true if the attribute object specifies either underlining or\n"
"no underlining.");

extern "C" {static PyObject *meth_wxTextAttr_HasFontUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasFontWeight, "HasFontWeight() -> bool\n"
"\n"
"Returns true if the attribute object specifies font weight (bold,\n"
"light or normal).");

extern "C" {static PyObject *meth_wxTextAttr_HasFontWeight(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasFontWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFontWeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasFontWeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasLeftIndent, "HasLeftIndent() -> bool\n"
"\n"
"Returns true if the attribute object specifies a left indent.");

extern "C" {static PyObject *meth_wxTextAttr_HasLeftIndent(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasLeftIndent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasLeftIndent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasLeftIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasLineSpacing, "HasLineSpacing() -> bool\n"
"\n"
"Returns true if the attribute object specifies line spacing.");

extern "C" {static PyObject *meth_wxTextAttr_HasLineSpacing(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasLineSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasLineSpacing();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasLineSpacing, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasListStyleName, "HasListStyleName() -> bool\n"
"\n"
"Returns true if the attribute object specifies a list style name.");

extern "C" {static PyObject *meth_wxTextAttr_HasListStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasListStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasListStyleName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasListStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasOutlineLevel, "HasOutlineLevel() -> bool\n"
"\n"
"Returns true if the attribute object specifies an outline level.");

extern "C" {static PyObject *meth_wxTextAttr_HasOutlineLevel(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasOutlineLevel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasOutlineLevel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasOutlineLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasPageBreak, "HasPageBreak() -> bool\n"
"\n"
"Returns true if the attribute object specifies a page break before\n"
"this paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_HasPageBreak(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasPageBreak(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasPageBreak();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasPageBreak, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasParagraphSpacingAfter, "HasParagraphSpacingAfter() -> bool\n"
"\n"
"Returns true if the attribute object specifies spacing after a\n"
"paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_HasParagraphSpacingAfter(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasParagraphSpacingAfter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasParagraphSpacingAfter();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasParagraphSpacingAfter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasParagraphSpacingBefore, "HasParagraphSpacingBefore() -> bool\n"
"\n"
"Returns true if the attribute object specifies spacing before a\n"
"paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_HasParagraphSpacingBefore(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasParagraphSpacingBefore(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasParagraphSpacingBefore();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasParagraphSpacingBefore, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasParagraphStyleName, "HasParagraphStyleName() -> bool\n"
"\n"
"Returns true if the attribute object specifies a paragraph style name.");

extern "C" {static PyObject *meth_wxTextAttr_HasParagraphStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasParagraphStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasParagraphStyleName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasParagraphStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasRightIndent, "HasRightIndent() -> bool\n"
"\n"
"Returns true if the attribute object specifies a right indent.");

extern "C" {static PyObject *meth_wxTextAttr_HasRightIndent(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasRightIndent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasRightIndent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasRightIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasTabs, "HasTabs() -> bool\n"
"\n"
"Returns true if the attribute object specifies tab stops.");

extern "C" {static PyObject *meth_wxTextAttr_HasTabs(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasTabs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTabs();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasTabs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasTextColour, "HasTextColour() -> bool\n"
"\n"
"Returns true if the attribute object specifies a text foreground\n"
"colour.");

extern "C" {static PyObject *meth_wxTextAttr_HasTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTextColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasTextEffects, "HasTextEffects() -> bool\n"
"\n"
"Returns true if the attribute object specifies text effects.");

extern "C" {static PyObject *meth_wxTextAttr_HasTextEffects(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasTextEffects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTextEffects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasTextEffects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_HasURL, "HasURL() -> bool\n"
"\n"
"Returns true if the attribute object specifies a URL.");

extern "C" {static PyObject *meth_wxTextAttr_HasURL(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_HasURL(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasURL();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_HasURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_IsCharacterStyle, "IsCharacterStyle() -> bool\n"
"\n"
"Returns true if the object represents a character style, that is, the\n"
"flags specify a font or a text background or foreground colour.");

extern "C" {static PyObject *meth_wxTextAttr_IsCharacterStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_IsCharacterStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCharacterStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_IsCharacterStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_IsDefault, "IsDefault() -> bool\n"
"\n"
"Returns false if we have any attributes set, true otherwise.");

extern "C" {static PyObject *meth_wxTextAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_IsDefault, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_IsParagraphStyle, "IsParagraphStyle() -> bool\n"
"\n"
"Returns true if the object represents a paragraph style, that is, the\n"
"flags specify alignment, indentation, tabs, paragraph spacing, or\n"
"bullet style.");

extern "C" {static PyObject *meth_wxTextAttr_IsParagraphStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_IsParagraphStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsParagraphStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_IsParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetAlignment, "SetAlignment(alignment)\n"
"\n"
"Sets the paragraph alignment.");

extern "C" {static PyObject *meth_wxTextAttr_SetAlignment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetAlignment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextAttrAlignment alignment;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_alignment,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxTextAttrAlignment, &alignment))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAlignment(alignment);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBackgroundColour, "SetBackgroundColour(colBack)\n"
"\n"
"Sets the background colour.");

extern "C" {static PyObject *meth_wxTextAttr_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colBack;
        int colBackState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colBack,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxColour, &colBack, &colBackState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundColour(*colBack);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colBack),sipType_wxColour,colBackState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBulletFont, "SetBulletFont(font)\n"
"\n"
"Sets the name of the font associated with the bullet symbol.");

extern "C" {static PyObject *meth_wxTextAttr_SetBulletFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBulletFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* font;
        int fontState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&font, &fontState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBulletFont(*font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(font),sipType_wxString,fontState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBulletFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBulletName, "SetBulletName(name)\n"
"\n"
"Sets the standard bullet name, applicable if the bullet style is\n"
"wxTEXT_ATTR_BULLET_STYLE_STANDARD.");

extern "C" {static PyObject *meth_wxTextAttr_SetBulletName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBulletName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBulletName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBulletName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBulletNumber, "SetBulletNumber(n)\n"
"\n"
"Sets the bullet number.");

extern "C" {static PyObject *meth_wxTextAttr_SetBulletNumber(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBulletNumber(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBulletNumber(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBulletNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBulletStyle, "SetBulletStyle(style)\n"
"\n"
"Sets the bullet style.");

extern "C" {static PyObject *meth_wxTextAttr_SetBulletStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBulletStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int style;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBulletStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBulletStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetBulletText, "SetBulletText(text)\n"
"\n"
"Sets the bullet text, which could be a symbol, or (for example) cached\n"
"outline text.");

extern "C" {static PyObject *meth_wxTextAttr_SetBulletText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetBulletText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBulletText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetBulletText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetCharacterStyleName, "SetCharacterStyleName(name)\n"
"\n"
"Sets the character style name.");

extern "C" {static PyObject *meth_wxTextAttr_SetCharacterStyleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetCharacterStyleName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCharacterStyleName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetCharacterStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets the flags determining which styles are being specified.");

extern "C" {static PyObject *meth_wxTextAttr_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long flags;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxTextAttr, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFont, "SetFont(font, flags=TEXT_ATTR_FONT & ~TEXT_ATTR_FONT_PIXEL_SIZE)\n"
"\n"
"Sets the attributes for the given font.");

extern "C" {static PyObject *meth_wxTextAttr_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
        int flags = wxTEXT_ATTR_FONT&~wxTEXT_ATTR_FONT_PIXEL_SIZE;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFont, &font, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontEncoding, "SetFontEncoding(encoding)\n"
"\n"
"Sets the font encoding.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontEncoding encoding;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFontEncoding, &encoding))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontEncoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontFaceName, "SetFontFaceName(faceName)\n"
"\n"
"Sets the font face name.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontFaceName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontFaceName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* faceName;
        int faceNameState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_faceName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&faceName, &faceNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontFaceName(*faceName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontFaceName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontFamily, "SetFontFamily(family)\n"
"\n"
"Sets the font family.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontFamily(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontFamily(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontFamily family;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_family,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFontFamily, &family))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontFamily(family);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontFamily, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontSize, "SetFontSize(pointSize)\n"
"\n"
"Sets the font size in points.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int pointSize;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontSize(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontPointSize, "SetFontPointSize(pointSize)\n"
"\n"
"Sets the font size in points.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontPointSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontPointSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int pointSize;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontPointSize(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontPointSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontPixelSize, "SetFontPixelSize(pixelSize)\n"
"\n"
"Sets the font size in pixels.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontPixelSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontPixelSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int pixelSize;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &pixelSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontPixelSize(pixelSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontPixelSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontStyle, "SetFontStyle(fontStyle)\n"
"\n"
"Sets the font style (normal, italic or slanted).");

extern "C" {static PyObject *meth_wxTextAttr_SetFontStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontStyle fontStyle;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fontStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFontStyle, &fontStyle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontStyle(fontStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontUnderlined, "SetFontUnderlined(underlined)\n"
"\n"
"Sets the font underlining.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontUnderlined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontUnderlined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool underlined;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_underlined,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxTextAttr, &sipCpp, &underlined))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontUnderlined(underlined);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetFontWeight, "SetFontWeight(fontWeight)\n"
"\n"
"Sets the font weight.");

extern "C" {static PyObject *meth_wxTextAttr_SetFontWeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetFontWeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontWeight fontWeight;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fontWeight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxFontWeight, &fontWeight))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontWeight(fontWeight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetFontWeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetLeftIndent, "SetLeftIndent(indent, subIndent=0)\n"
"\n"
"Sets the left indent and left subindent in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_SetLeftIndent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetLeftIndent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int indent;
        int subIndent = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
            sipName_subIndent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_wxTextAttr, &sipCpp, &indent, &subIndent))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLeftIndent(indent,subIndent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetLeftIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetLineSpacing, "SetLineSpacing(spacing)\n"
"\n"
"Sets the line spacing.");

extern "C" {static PyObject *meth_wxTextAttr_SetLineSpacing(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetLineSpacing(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int spacing;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spacing,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &spacing))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLineSpacing(spacing);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetLineSpacing, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetListStyleName, "SetListStyleName(name)\n"
"\n"
"Sets the list style name.");

extern "C" {static PyObject *meth_wxTextAttr_SetListStyleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetListStyleName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetListStyleName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetListStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetOutlineLevel, "SetOutlineLevel(level)\n"
"\n"
"Specifies the outline level.");

extern "C" {static PyObject *meth_wxTextAttr_SetOutlineLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetOutlineLevel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int level;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &level))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOutlineLevel(level);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetOutlineLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetPageBreak, "SetPageBreak(pageBreak=True)\n"
"\n"
"Specifies a page break before this paragraph.");

extern "C" {static PyObject *meth_wxTextAttr_SetPageBreak(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetPageBreak(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool pageBreak = 1;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pageBreak,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxTextAttr, &sipCpp, &pageBreak))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPageBreak(pageBreak);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetPageBreak, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetParagraphSpacingAfter, "SetParagraphSpacingAfter(spacing)\n"
"\n"
"Sets the spacing after a paragraph, in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_SetParagraphSpacingAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetParagraphSpacingAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int spacing;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spacing,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &spacing))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParagraphSpacingAfter(spacing);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetParagraphSpacingAfter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetParagraphSpacingBefore, "SetParagraphSpacingBefore(spacing)\n"
"\n"
"Sets the spacing before a paragraph, in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_SetParagraphSpacingBefore(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetParagraphSpacingBefore(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int spacing;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spacing,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &spacing))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParagraphSpacingBefore(spacing);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetParagraphSpacingBefore, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetParagraphStyleName, "SetParagraphStyleName(name)\n"
"\n"
"Sets the name of the paragraph style.");

extern "C" {static PyObject *meth_wxTextAttr_SetParagraphStyleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetParagraphStyleName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParagraphStyleName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetParagraphStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetRightIndent, "SetRightIndent(indent)\n"
"\n"
"Sets the right indent in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_SetRightIndent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetRightIndent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int indent;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &indent))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRightIndent(indent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetRightIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetTabs, "SetTabs(tabs)\n"
"\n"
"Sets the tab stops, expressed in tenths of a millimetre.");

extern "C" {static PyObject *meth_wxTextAttr_SetTabs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetTabs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayInt* tabs;
        int tabsState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tabs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxArrayInt,&tabs, &tabsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTabs(*tabs);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayInt *>(tabs),sipType_wxArrayInt,tabsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetTabs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetTextColour, "SetTextColour(colText)\n"
"\n"
"Sets the text foreground colour.");

extern "C" {static PyObject *meth_wxTextAttr_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colText;
        int colTextState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colText,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxColour, &colText, &colTextState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextColour(*colText);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText),sipType_wxColour,colTextState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetTextEffectFlags, "SetTextEffectFlags(flags)\n"
"\n"
"Sets the text effect bits of interest.");

extern "C" {static PyObject *meth_wxTextAttr_SetTextEffectFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetTextEffectFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextEffectFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetTextEffectFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetTextEffects, "SetTextEffects(effects)\n"
"\n"
"Sets the text effects, a bit list of styles.");

extern "C" {static PyObject *meth_wxTextAttr_SetTextEffects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetTextEffects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int effects;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_effects,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttr, &sipCpp, &effects))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextEffects(effects);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetTextEffects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_SetURL, "SetURL(url)\n"
"\n"
"Sets the URL for the content.");

extern "C" {static PyObject *meth_wxTextAttr_SetURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_SetURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* url;
        int urlState = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxString,&url, &urlState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetURL(*url);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_SetURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_Apply, "Apply(style, compareWith=None) -> bool\n"
"\n"
"Applies the attributes in style to the original object, but not those\n"
"attributes from style that are the same as those in compareWith (if\n"
"passed).");

extern "C" {static PyObject *meth_wxTextAttr_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr* style;
        const  ::wxTextAttr* compareWith = 0;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J8", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxTextAttr, &style, sipType_wxTextAttr, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*style,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_Apply, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_Merge, "Merge(overlay)\n"
"Merge(base, overlay) -> TextAttr\n"
"\n"
"Copies all defined/valid properties from overlay to current object.\n"
"");

extern "C" {static PyObject *meth_wxTextAttr_Merge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_Merge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr* overlay;
         ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_overlay,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxTextAttr, &overlay))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Merge(*overlay);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxTextAttr* base;
        const  ::wxTextAttr* overlay;

        static const char *sipKwdList[] = {
            sipName_base,
            sipName_overlay,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9J9", sipType_wxTextAttr, &base, sipType_wxTextAttr, &overlay))
        {
             ::wxTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTextAttr( ::wxTextAttr::Merge(*base,*overlay));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_Merge, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttr_EqPartial, "EqPartial(attr, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxTextAttr_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttr_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttr* attr;
        bool weakTest = 1;
        const  ::wxTextAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxTextAttr, &sipCpp, sipType_wxTextAttr, &attr, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*attr,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttr, sipName_EqPartial, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttr(void *, int);}
static void release_wxTextAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextAttr(void *, SIP_SSIZE_T, void *);}
static void assign_wxTextAttr(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttr *>(sipSrc);
}


extern "C" {static void *array_wxTextAttr(SIP_SSIZE_T);}
static void *array_wxTextAttr(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxTextAttr[sipNrElem];
}


extern "C" {static void *copy_wxTextAttr(const void *, SIP_SSIZE_T);}
static void *copy_wxTextAttr(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxTextAttr(reinterpret_cast<const  ::wxTextAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttr(sipSimpleWrapper *);}
static void dealloc_wxTextAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextAttr *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxColour* colText;
        int colTextState = 0;
        const  ::wxColour& colBackdef = wxNullColour;
        const  ::wxColour* colBack = &colBackdef;
        int colBackState = 0;
        const  ::wxFont& fontdef = wxNullFont;
        const  ::wxFont* font = &fontdef;
         ::wxTextAttrAlignment alignment = wxTEXT_ALIGNMENT_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_colText,
            sipName_colBack,
            sipName_font,
            sipName_alignment,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J1J9E", sipType_wxColour, &colText, &colTextState, sipType_wxColour, &colBack, &colBackState, sipType_wxFont, &font, sipType_wxTextAttrAlignment, &alignment))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttr(*colText,*colBack,*font,alignment);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText),sipType_wxColour,colTextState);
            sipReleaseType(const_cast< ::wxColour *>(colBack),sipType_wxColour,colBackState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextAttr* attr;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxTextAttr[] = {
    {SIP_MLNAME_CAST(sipName_Apply), (PyCFunction)meth_wxTextAttr_Apply, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_Apply)},
    {SIP_MLNAME_CAST(sipName_EqPartial), (PyCFunction)meth_wxTextAttr_EqPartial, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_EqPartial)},
    {SIP_MLNAME_CAST(sipName_GetAlignment), meth_wxTextAttr_GetAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetAlignment)},
    {SIP_MLNAME_CAST(sipName_GetBackgroundColour), meth_wxTextAttr_GetBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_GetBulletFont), meth_wxTextAttr_GetBulletFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBulletFont)},
    {SIP_MLNAME_CAST(sipName_GetBulletName), meth_wxTextAttr_GetBulletName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBulletName)},
    {SIP_MLNAME_CAST(sipName_GetBulletNumber), meth_wxTextAttr_GetBulletNumber, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBulletNumber)},
    {SIP_MLNAME_CAST(sipName_GetBulletStyle), meth_wxTextAttr_GetBulletStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBulletStyle)},
    {SIP_MLNAME_CAST(sipName_GetBulletText), meth_wxTextAttr_GetBulletText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetBulletText)},
    {SIP_MLNAME_CAST(sipName_GetCharacterStyleName), meth_wxTextAttr_GetCharacterStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetCharacterStyleName)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxTextAttr_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetFont), meth_wxTextAttr_GetFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetFontAttributes), (PyCFunction)meth_wxTextAttr_GetFontAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontAttributes)},
    {SIP_MLNAME_CAST(sipName_GetFontEncoding), meth_wxTextAttr_GetFontEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontEncoding)},
    {SIP_MLNAME_CAST(sipName_GetFontFaceName), meth_wxTextAttr_GetFontFaceName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontFaceName)},
    {SIP_MLNAME_CAST(sipName_GetFontFamily), meth_wxTextAttr_GetFontFamily, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontFamily)},
    {SIP_MLNAME_CAST(sipName_GetFontSize), meth_wxTextAttr_GetFontSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontSize)},
    {SIP_MLNAME_CAST(sipName_GetFontStyle), meth_wxTextAttr_GetFontStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontStyle)},
    {SIP_MLNAME_CAST(sipName_GetFontUnderlined), meth_wxTextAttr_GetFontUnderlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontUnderlined)},
    {SIP_MLNAME_CAST(sipName_GetFontWeight), meth_wxTextAttr_GetFontWeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetFontWeight)},
    {SIP_MLNAME_CAST(sipName_GetLeftIndent), meth_wxTextAttr_GetLeftIndent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetLeftIndent)},
    {SIP_MLNAME_CAST(sipName_GetLeftSubIndent), meth_wxTextAttr_GetLeftSubIndent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetLeftSubIndent)},
    {SIP_MLNAME_CAST(sipName_GetLineSpacing), meth_wxTextAttr_GetLineSpacing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetLineSpacing)},
    {SIP_MLNAME_CAST(sipName_GetListStyleName), meth_wxTextAttr_GetListStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetListStyleName)},
    {SIP_MLNAME_CAST(sipName_GetOutlineLevel), meth_wxTextAttr_GetOutlineLevel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetOutlineLevel)},
    {SIP_MLNAME_CAST(sipName_GetParagraphSpacingAfter), meth_wxTextAttr_GetParagraphSpacingAfter, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetParagraphSpacingAfter)},
    {SIP_MLNAME_CAST(sipName_GetParagraphSpacingBefore), meth_wxTextAttr_GetParagraphSpacingBefore, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetParagraphSpacingBefore)},
    {SIP_MLNAME_CAST(sipName_GetParagraphStyleName), meth_wxTextAttr_GetParagraphStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetParagraphStyleName)},
    {SIP_MLNAME_CAST(sipName_GetRightIndent), meth_wxTextAttr_GetRightIndent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetRightIndent)},
    {SIP_MLNAME_CAST(sipName_GetTabs), meth_wxTextAttr_GetTabs, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetTabs)},
    {SIP_MLNAME_CAST(sipName_GetTextColour), meth_wxTextAttr_GetTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetTextColour)},
    {SIP_MLNAME_CAST(sipName_GetTextEffectFlags), meth_wxTextAttr_GetTextEffectFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetTextEffectFlags)},
    {SIP_MLNAME_CAST(sipName_GetTextEffects), meth_wxTextAttr_GetTextEffects, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetTextEffects)},
    {SIP_MLNAME_CAST(sipName_GetURL), meth_wxTextAttr_GetURL, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_GetURL)},
    {SIP_MLNAME_CAST(sipName_HasAlignment), meth_wxTextAttr_HasAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasAlignment)},
    {SIP_MLNAME_CAST(sipName_HasBackgroundColour), meth_wxTextAttr_HasBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_HasBulletName), meth_wxTextAttr_HasBulletName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasBulletName)},
    {SIP_MLNAME_CAST(sipName_HasBulletNumber), meth_wxTextAttr_HasBulletNumber, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasBulletNumber)},
    {SIP_MLNAME_CAST(sipName_HasBulletStyle), meth_wxTextAttr_HasBulletStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasBulletStyle)},
    {SIP_MLNAME_CAST(sipName_HasBulletText), meth_wxTextAttr_HasBulletText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasBulletText)},
    {SIP_MLNAME_CAST(sipName_HasCharacterStyleName), meth_wxTextAttr_HasCharacterStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasCharacterStyleName)},
    {SIP_MLNAME_CAST(sipName_HasFlag), (PyCFunction)meth_wxTextAttr_HasFlag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFlag)},
    {SIP_MLNAME_CAST(sipName_HasFont), meth_wxTextAttr_HasFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFont)},
    {SIP_MLNAME_CAST(sipName_HasFontEncoding), meth_wxTextAttr_HasFontEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontEncoding)},
    {SIP_MLNAME_CAST(sipName_HasFontFaceName), meth_wxTextAttr_HasFontFaceName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontFaceName)},
    {SIP_MLNAME_CAST(sipName_HasFontFamily), meth_wxTextAttr_HasFontFamily, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontFamily)},
    {SIP_MLNAME_CAST(sipName_HasFontItalic), meth_wxTextAttr_HasFontItalic, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontItalic)},
    {SIP_MLNAME_CAST(sipName_HasFontPixelSize), meth_wxTextAttr_HasFontPixelSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontPixelSize)},
    {SIP_MLNAME_CAST(sipName_HasFontPointSize), meth_wxTextAttr_HasFontPointSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontPointSize)},
    {SIP_MLNAME_CAST(sipName_HasFontSize), meth_wxTextAttr_HasFontSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontSize)},
    {SIP_MLNAME_CAST(sipName_HasFontUnderlined), meth_wxTextAttr_HasFontUnderlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontUnderlined)},
    {SIP_MLNAME_CAST(sipName_HasFontWeight), meth_wxTextAttr_HasFontWeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasFontWeight)},
    {SIP_MLNAME_CAST(sipName_HasLeftIndent), meth_wxTextAttr_HasLeftIndent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasLeftIndent)},
    {SIP_MLNAME_CAST(sipName_HasLineSpacing), meth_wxTextAttr_HasLineSpacing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasLineSpacing)},
    {SIP_MLNAME_CAST(sipName_HasListStyleName), meth_wxTextAttr_HasListStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasListStyleName)},
    {SIP_MLNAME_CAST(sipName_HasOutlineLevel), meth_wxTextAttr_HasOutlineLevel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasOutlineLevel)},
    {SIP_MLNAME_CAST(sipName_HasPageBreak), meth_wxTextAttr_HasPageBreak, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasPageBreak)},
    {SIP_MLNAME_CAST(sipName_HasParagraphSpacingAfter), meth_wxTextAttr_HasParagraphSpacingAfter, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasParagraphSpacingAfter)},
    {SIP_MLNAME_CAST(sipName_HasParagraphSpacingBefore), meth_wxTextAttr_HasParagraphSpacingBefore, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasParagraphSpacingBefore)},
    {SIP_MLNAME_CAST(sipName_HasParagraphStyleName), meth_wxTextAttr_HasParagraphStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasParagraphStyleName)},
    {SIP_MLNAME_CAST(sipName_HasRightIndent), meth_wxTextAttr_HasRightIndent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasRightIndent)},
    {SIP_MLNAME_CAST(sipName_HasTabs), meth_wxTextAttr_HasTabs, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasTabs)},
    {SIP_MLNAME_CAST(sipName_HasTextColour), meth_wxTextAttr_HasTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasTextColour)},
    {SIP_MLNAME_CAST(sipName_HasTextEffects), meth_wxTextAttr_HasTextEffects, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasTextEffects)},
    {SIP_MLNAME_CAST(sipName_HasURL), meth_wxTextAttr_HasURL, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_HasURL)},
    {SIP_MLNAME_CAST(sipName_IsCharacterStyle), meth_wxTextAttr_IsCharacterStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_IsCharacterStyle)},
    {SIP_MLNAME_CAST(sipName_IsDefault), meth_wxTextAttr_IsDefault, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_IsDefault)},
    {SIP_MLNAME_CAST(sipName_IsParagraphStyle), meth_wxTextAttr_IsParagraphStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttr_IsParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_Merge), (PyCFunction)meth_wxTextAttr_Merge, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_Merge)},
    {SIP_MLNAME_CAST(sipName_SetAlignment), (PyCFunction)meth_wxTextAttr_SetAlignment, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetAlignment)},
    {SIP_MLNAME_CAST(sipName_SetBackgroundColour), (PyCFunction)meth_wxTextAttr_SetBackgroundColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_SetBulletFont), (PyCFunction)meth_wxTextAttr_SetBulletFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBulletFont)},
    {SIP_MLNAME_CAST(sipName_SetBulletName), (PyCFunction)meth_wxTextAttr_SetBulletName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBulletName)},
    {SIP_MLNAME_CAST(sipName_SetBulletNumber), (PyCFunction)meth_wxTextAttr_SetBulletNumber, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBulletNumber)},
    {SIP_MLNAME_CAST(sipName_SetBulletStyle), (PyCFunction)meth_wxTextAttr_SetBulletStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBulletStyle)},
    {SIP_MLNAME_CAST(sipName_SetBulletText), (PyCFunction)meth_wxTextAttr_SetBulletText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetBulletText)},
    {SIP_MLNAME_CAST(sipName_SetCharacterStyleName), (PyCFunction)meth_wxTextAttr_SetCharacterStyleName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetCharacterStyleName)},
    {SIP_MLNAME_CAST(sipName_SetFlags), (PyCFunction)meth_wxTextAttr_SetFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetFont), (PyCFunction)meth_wxTextAttr_SetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetFontEncoding), (PyCFunction)meth_wxTextAttr_SetFontEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontEncoding)},
    {SIP_MLNAME_CAST(sipName_SetFontFaceName), (PyCFunction)meth_wxTextAttr_SetFontFaceName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontFaceName)},
    {SIP_MLNAME_CAST(sipName_SetFontFamily), (PyCFunction)meth_wxTextAttr_SetFontFamily, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontFamily)},
    {SIP_MLNAME_CAST(sipName_SetFontPixelSize), (PyCFunction)meth_wxTextAttr_SetFontPixelSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontPixelSize)},
    {SIP_MLNAME_CAST(sipName_SetFontPointSize), (PyCFunction)meth_wxTextAttr_SetFontPointSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontPointSize)},
    {SIP_MLNAME_CAST(sipName_SetFontSize), (PyCFunction)meth_wxTextAttr_SetFontSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontSize)},
    {SIP_MLNAME_CAST(sipName_SetFontStyle), (PyCFunction)meth_wxTextAttr_SetFontStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontStyle)},
    {SIP_MLNAME_CAST(sipName_SetFontUnderlined), (PyCFunction)meth_wxTextAttr_SetFontUnderlined, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontUnderlined)},
    {SIP_MLNAME_CAST(sipName_SetFontWeight), (PyCFunction)meth_wxTextAttr_SetFontWeight, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetFontWeight)},
    {SIP_MLNAME_CAST(sipName_SetLeftIndent), (PyCFunction)meth_wxTextAttr_SetLeftIndent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetLeftIndent)},
    {SIP_MLNAME_CAST(sipName_SetLineSpacing), (PyCFunction)meth_wxTextAttr_SetLineSpacing, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetLineSpacing)},
    {SIP_MLNAME_CAST(sipName_SetListStyleName), (PyCFunction)meth_wxTextAttr_SetListStyleName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetListStyleName)},
    {SIP_MLNAME_CAST(sipName_SetOutlineLevel), (PyCFunction)meth_wxTextAttr_SetOutlineLevel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetOutlineLevel)},
    {SIP_MLNAME_CAST(sipName_SetPageBreak), (PyCFunction)meth_wxTextAttr_SetPageBreak, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetPageBreak)},
    {SIP_MLNAME_CAST(sipName_SetParagraphSpacingAfter), (PyCFunction)meth_wxTextAttr_SetParagraphSpacingAfter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetParagraphSpacingAfter)},
    {SIP_MLNAME_CAST(sipName_SetParagraphSpacingBefore), (PyCFunction)meth_wxTextAttr_SetParagraphSpacingBefore, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetParagraphSpacingBefore)},
    {SIP_MLNAME_CAST(sipName_SetParagraphStyleName), (PyCFunction)meth_wxTextAttr_SetParagraphStyleName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetParagraphStyleName)},
    {SIP_MLNAME_CAST(sipName_SetRightIndent), (PyCFunction)meth_wxTextAttr_SetRightIndent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetRightIndent)},
    {SIP_MLNAME_CAST(sipName_SetTabs), (PyCFunction)meth_wxTextAttr_SetTabs, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetTabs)},
    {SIP_MLNAME_CAST(sipName_SetTextColour), (PyCFunction)meth_wxTextAttr_SetTextColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetTextColour)},
    {SIP_MLNAME_CAST(sipName_SetTextEffectFlags), (PyCFunction)meth_wxTextAttr_SetTextEffectFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetTextEffectFlags)},
    {SIP_MLNAME_CAST(sipName_SetTextEffects), (PyCFunction)meth_wxTextAttr_SetTextEffects, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetTextEffects)},
    {SIP_MLNAME_CAST(sipName_SetURL), (PyCFunction)meth_wxTextAttr_SetURL, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttr_SetURL)}
};

sipVariableDef variables_wxTextAttr[] = {
    {PropertyVariable, sipName_URL, &methods_wxTextAttr[33], &methods_wxTextAttr[101], NULL, NULL},
    {PropertyVariable, sipName_TextEffects, &methods_wxTextAttr[32], &methods_wxTextAttr[100], NULL, NULL},
    {PropertyVariable, sipName_TextEffectFlags, &methods_wxTextAttr[31], &methods_wxTextAttr[99], NULL, NULL},
    {PropertyVariable, sipName_TextColour, &methods_wxTextAttr[30], &methods_wxTextAttr[98], NULL, NULL},
    {PropertyVariable, sipName_Tabs, &methods_wxTextAttr[29], &methods_wxTextAttr[97], NULL, NULL},
    {PropertyVariable, sipName_RightIndent, &methods_wxTextAttr[28], &methods_wxTextAttr[96], NULL, NULL},
    {PropertyVariable, sipName_ParagraphStyleName, &methods_wxTextAttr[27], &methods_wxTextAttr[95], NULL, NULL},
    {PropertyVariable, sipName_ParagraphSpacingBefore, &methods_wxTextAttr[26], &methods_wxTextAttr[94], NULL, NULL},
    {PropertyVariable, sipName_ParagraphSpacingAfter, &methods_wxTextAttr[25], &methods_wxTextAttr[93], NULL, NULL},
    {PropertyVariable, sipName_OutlineLevel, &methods_wxTextAttr[24], &methods_wxTextAttr[91], NULL, NULL},
    {PropertyVariable, sipName_ListStyleName, &methods_wxTextAttr[23], &methods_wxTextAttr[90], NULL, NULL},
    {PropertyVariable, sipName_LineSpacing, &methods_wxTextAttr[22], &methods_wxTextAttr[89], NULL, NULL},
    {PropertyVariable, sipName_LeftSubIndent, &methods_wxTextAttr[21], NULL, NULL, NULL},
    {PropertyVariable, sipName_LeftIndent, &methods_wxTextAttr[20], &methods_wxTextAttr[88], NULL, NULL},
    {PropertyVariable, sipName_FontWeight, &methods_wxTextAttr[19], &methods_wxTextAttr[87], NULL, NULL},
    {PropertyVariable, sipName_FontUnderlined, &methods_wxTextAttr[18], &methods_wxTextAttr[86], NULL, NULL},
    {PropertyVariable, sipName_FontStyle, &methods_wxTextAttr[17], &methods_wxTextAttr[85], NULL, NULL},
    {PropertyVariable, sipName_FontSize, &methods_wxTextAttr[16], &methods_wxTextAttr[84], NULL, NULL},
    {PropertyVariable, sipName_FontFamily, &methods_wxTextAttr[15], &methods_wxTextAttr[81], NULL, NULL},
    {PropertyVariable, sipName_FontFaceName, &methods_wxTextAttr[14], &methods_wxTextAttr[80], NULL, NULL},
    {PropertyVariable, sipName_FontEncoding, &methods_wxTextAttr[13], &methods_wxTextAttr[79], NULL, NULL},
    {PropertyVariable, sipName_Font, &methods_wxTextAttr[11], &methods_wxTextAttr[78], NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxTextAttr[10], &methods_wxTextAttr[77], NULL, NULL},
    {PropertyVariable, sipName_CharacterStyleName, &methods_wxTextAttr[9], &methods_wxTextAttr[76], NULL, NULL},
    {PropertyVariable, sipName_BulletText, &methods_wxTextAttr[8], &methods_wxTextAttr[75], NULL, NULL},
    {PropertyVariable, sipName_BulletStyle, &methods_wxTextAttr[7], &methods_wxTextAttr[74], NULL, NULL},
    {PropertyVariable, sipName_BulletNumber, &methods_wxTextAttr[6], &methods_wxTextAttr[73], NULL, NULL},
    {PropertyVariable, sipName_BulletName, &methods_wxTextAttr[5], &methods_wxTextAttr[72], NULL, NULL},
    {PropertyVariable, sipName_BulletFont, &methods_wxTextAttr[4], &methods_wxTextAttr[71], NULL, NULL},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxTextAttr[3], &methods_wxTextAttr[70], NULL, NULL},
    {PropertyVariable, sipName_Alignment, &methods_wxTextAttr[2], &methods_wxTextAttr[69], NULL, NULL},
};

PyDoc_STRVAR(doc_wxTextAttr, "TextAttr()\n"
"TextAttr(colText, colBack=NullColour, font=NullFont, alignment=TEXT_ALIGNMENT_DEFAULT)\n"
"TextAttr(attr)\n"
"\n"
"wxTextAttr represents the character and paragraph attributes, or\n"
"style, for a range of text in a wxTextCtrl or wxRichTextCtrl.");


sipClassTypeDef sipTypeDef__core_wxTextAttr = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttr,
        {0},
        0
    },
    {
        sipNameNr_TextAttr,
        {0, 0, 1},
        102, methods_wxTextAttr,
        0, 0,
        31, variables_wxTextAttr,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxTextAttr,
    -1,
    -1,
    0,
    0,
    init_type_wxTextAttr,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxTextAttr,
    assign_wxTextAttr,
    array_wxTextAttr,
    copy_wxTextAttr,
    release_wxTextAttr,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
