/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/datetime.h>

    #include <wx/longlong.h>


PyDoc_STRVAR(doc_wxTimeSpan_Abs, "Abs() -> TimeSpan\n"
"\n"
"Returns the absolute value of the timespan: does not modify the\n"
"object.");

extern "C" {static PyObject *meth_wxTimeSpan_Abs(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Abs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan(sipCpp->Abs());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Abs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Add, "Add(diff) -> TimeSpan\n"
"\n"
"Adds the given wxTimeSpan to this wxTimeSpan and returns a reference\n"
"to itself.");

extern "C" {static PyObject *meth_wxTimeSpan_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;
         ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &diff))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Add, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Format, "Format(format=DefaultTimeSpanFormat) -> String\n"
"\n"
"Returns the string containing the formatted representation of the time\n"
"span.");

extern "C" {static PyObject *meth_wxTimeSpan_Format(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Format(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString& formatdef = wxDefaultTimeSpanFormat;
        const  ::wxString* format = &formatdef;
        int formatState = 0;
        const  ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J1", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxString,&format, &formatState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->Format(*format));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(format),sipType_wxString,formatState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Format, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetDays, "GetDays() -> int\n"
"\n"
"Returns the difference in number of days.");

extern "C" {static PyObject *meth_wxTimeSpan_GetDays(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDays();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetDays, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetHours, "GetHours() -> int\n"
"\n"
"Returns the difference in number of hours.");

extern "C" {static PyObject *meth_wxTimeSpan_GetHours(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetHours(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHours();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetHours, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetMilliseconds, "GetMilliseconds() -> LongLong\n"
"\n"
"Returns the difference in number of milliseconds.");

extern "C" {static PyObject *meth_wxTimeSpan_GetMilliseconds(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetMilliseconds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxLongLong(sipCpp->GetMilliseconds());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxLongLong,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetMilliseconds, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetMinutes, "GetMinutes() -> int\n"
"\n"
"Returns the difference in number of minutes.");

extern "C" {static PyObject *meth_wxTimeSpan_GetMinutes(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetMinutes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMinutes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetMinutes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetSeconds, "GetSeconds() -> LongLong\n"
"\n"
"Returns the difference in number of seconds.");

extern "C" {static PyObject *meth_wxTimeSpan_GetSeconds(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetSeconds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxLongLong(sipCpp->GetSeconds());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxLongLong,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetSeconds, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetValue, "GetValue() -> LongLong\n"
"\n"
"Returns the internal representation of timespan.");

extern "C" {static PyObject *meth_wxTimeSpan_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxLongLong*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxLongLong(sipCpp->GetValue());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxLongLong,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_GetWeeks, "GetWeeks() -> int\n"
"\n"
"Returns the difference in number of weeks.");

extern "C" {static PyObject *meth_wxTimeSpan_GetWeeks(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_GetWeeks(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWeeks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_GetWeeks, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsEqualTo, "IsEqualTo(ts) -> bool\n"
"\n"
"Returns true if two timespans are equal.");

extern "C" {static PyObject *meth_wxTimeSpan_IsEqualTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsEqualTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;
        const  ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqualTo(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsEqualTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsLongerThan, "IsLongerThan(ts) -> bool\n"
"\n"
"Compares two timespans: works with the absolute values, i.e. -2 hours\n"
"is longer than 1 hour.");

extern "C" {static PyObject *meth_wxTimeSpan_IsLongerThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsLongerThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;
        const  ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLongerThan(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsLongerThan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsNegative, "IsNegative() -> bool\n"
"\n"
"Returns true if the timespan is negative.");

extern "C" {static PyObject *meth_wxTimeSpan_IsNegative(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsNegative(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNegative();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsNegative, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsNull, "IsNull() -> bool\n"
"\n"
"Returns true if the timespan is empty.");

extern "C" {static PyObject *meth_wxTimeSpan_IsNull(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNull();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsNull, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsPositive, "IsPositive() -> bool\n"
"\n"
"Returns true if the timespan is positive.");

extern "C" {static PyObject *meth_wxTimeSpan_IsPositive(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsPositive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPositive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsPositive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_IsShorterThan, "IsShorterThan(ts) -> bool\n"
"\n"
"Compares two timespans: works with the absolute values, i.e. 1 hour is\n"
"shorter than -2 hours.");

extern "C" {static PyObject *meth_wxTimeSpan_IsShorterThan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_IsShorterThan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;
        const  ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ts,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsShorterThan(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_IsShorterThan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Multiply, "Multiply(n) -> TimeSpan\n"
"\n"
"Multiplies this time span by n.");

extern "C" {static PyObject *meth_wxTimeSpan_Multiply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Multiply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
         ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTimeSpan, &sipCpp, &n))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Multiply(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Multiply, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Neg, "Neg() -> TimeSpan\n"
"\n"
"Negate the value of the timespan.");

extern "C" {static PyObject *meth_wxTimeSpan_Neg(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Neg(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Neg();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Neg, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Negate, "Negate() -> TimeSpan\n"
"\n"
"Returns timespan with inverted sign.");

extern "C" {static PyObject *meth_wxTimeSpan_Negate(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Negate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTimeSpan, &sipCpp))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan(sipCpp->Negate());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Negate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Subtract, "Subtract(diff) -> TimeSpan\n"
"\n"
"Subtracts the given wxTimeSpan to this wxTimeSpan and returns a\n"
"reference to itself.");

extern "C" {static PyObject *meth_wxTimeSpan_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;
         ::wxTimeSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_diff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTimeSpan, &sipCpp, sipType_wxTimeSpan, &diff))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Subtract(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Subtract, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Day, "Day() -> TimeSpan\n"
"\n"
"Returns the timespan for one day.");

extern "C" {static PyObject *meth_wxTimeSpan_Day(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Day(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Day());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Day, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Days, "Days(days) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of days.");

extern "C" {static PyObject *meth_wxTimeSpan_Days(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Days(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long days;

        static const char *sipKwdList[] = {
            sipName_days,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &days))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Days(days));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Days, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Hour, "Hour() -> TimeSpan\n"
"\n"
"Returns the timespan for one hour.");

extern "C" {static PyObject *meth_wxTimeSpan_Hour(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Hour(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Hour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Hour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Hours, "Hours(hours) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of hours.");

extern "C" {static PyObject *meth_wxTimeSpan_Hours(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Hours(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long hours;

        static const char *sipKwdList[] = {
            sipName_hours,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &hours))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Hours(hours));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Hours, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Millisecond, "Millisecond() -> TimeSpan\n"
"\n"
"Returns the timespan for one millisecond.");

extern "C" {static PyObject *meth_wxTimeSpan_Millisecond(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Millisecond(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Millisecond());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Millisecond, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Milliseconds, "Milliseconds(ms) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of milliseconds.");

extern "C" {static PyObject *meth_wxTimeSpan_Milliseconds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Milliseconds(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLongLong* ms;
        int msState = 0;

        static const char *sipKwdList[] = {
            sipName_ms,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxLongLong,&ms, &msState))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Milliseconds(*ms));
            Py_END_ALLOW_THREADS
            sipReleaseType(ms,sipType_wxLongLong,msState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Milliseconds, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Minute, "Minute() -> TimeSpan\n"
"\n"
"Returns the timespan for one minute.");

extern "C" {static PyObject *meth_wxTimeSpan_Minute(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Minute(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Minute());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Minute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Minutes, "Minutes(min) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of minutes.");

extern "C" {static PyObject *meth_wxTimeSpan_Minutes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Minutes(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long min;

        static const char *sipKwdList[] = {
            sipName_min,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &min))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Minutes(min));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Minutes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Second, "Second() -> TimeSpan\n"
"\n"
"Returns the timespan for one second.");

extern "C" {static PyObject *meth_wxTimeSpan_Second(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Second(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Second());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Second, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Seconds, "Seconds(sec) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of seconds.");

extern "C" {static PyObject *meth_wxTimeSpan_Seconds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Seconds(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLongLong* sec;
        int secState = 0;

        static const char *sipKwdList[] = {
            sipName_sec,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxLongLong,&sec, &secState))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Seconds(*sec));
            Py_END_ALLOW_THREADS
            sipReleaseType(sec,sipType_wxLongLong,secState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Seconds, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Week, "Week() -> TimeSpan\n"
"\n"
"Returns the timespan for one week.");

extern "C" {static PyObject *meth_wxTimeSpan_Week(PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Week(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Week());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Week, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTimeSpan_Weeks, "Weeks(weeks) -> TimeSpan\n"
"\n"
"Returns the timespan for the given number of weeks.");

extern "C" {static PyObject *meth_wxTimeSpan_Weeks(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTimeSpan_Weeks(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long weeks;

        static const char *sipKwdList[] = {
            sipName_weeks,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "l", &weeks))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan( ::wxTimeSpan::Weeks(weeks));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TimeSpan, sipName_Weeks, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxTimeSpan___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator!=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator==(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___ge__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___ge__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator>=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ge_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___gt__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___gt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator>(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, gt_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___le__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___le__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator<=(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, le_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___lt__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___lt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* ts;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &ts))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTimeSpan::operator<(*ts);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, lt_slot, sipType_wxTimeSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTimeSpan___neg__(PyObject *);}
static PyObject *slot_wxTimeSpan___neg__(PyObject *sipSelf)
{
     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;


    {
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &-(*sipCpp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxTimeSpan___mul__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTimeSpan* a0;
        int n;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9i", sipType_wxTimeSpan, &a0, &n))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan((*a0 * n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, mul_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___imul__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int n;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxTimeSpan::operator*=(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxTimeSpan___sub__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTimeSpan* a0;
        const  ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxTimeSpan, &a0, sipType_wxTimeSpan, &ts))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan((*a0 - *ts));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___isub__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxTimeSpan::operator-=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxTimeSpan___add__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTimeSpan* a0;
        const  ::wxTimeSpan* ts;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_wxTimeSpan, &a0, sipType_wxTimeSpan, &ts))
        {
             ::wxTimeSpan*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxTimeSpan((*a0 + *ts));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxTimeSpan,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxTimeSpan___iadd__(PyObject *,PyObject *);}
static PyObject *slot_wxTimeSpan___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxTimeSpan)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxTimeSpan *sipCpp = reinterpret_cast< ::wxTimeSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTimeSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTimeSpan* diff;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTimeSpan, &diff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxTimeSpan::operator+=(*diff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTimeSpan(void *, int);}
static void release_wxTimeSpan(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTimeSpan *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTimeSpan(void *, SIP_SSIZE_T, void *);}
static void assign_wxTimeSpan(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTimeSpan *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTimeSpan *>(sipSrc);
}


extern "C" {static void *array_wxTimeSpan(SIP_SSIZE_T);}
static void *array_wxTimeSpan(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxTimeSpan[sipNrElem];
}


extern "C" {static void *copy_wxTimeSpan(const void *, SIP_SSIZE_T);}
static void *copy_wxTimeSpan(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxTimeSpan(reinterpret_cast<const  ::wxTimeSpan *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTimeSpan(sipSimpleWrapper *);}
static void dealloc_wxTimeSpan(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTimeSpan(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTimeSpan(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTimeSpan(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTimeSpan *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTimeSpan();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        long hours;
        long min = 0;
         ::wxLongLong secdef = 0;
         ::wxLongLong* sec = &secdef;
        int secState = 0;
         ::wxLongLong msecdef = 0;
         ::wxLongLong* msec = &msecdef;
        int msecState = 0;

        static const char *sipKwdList[] = {
            sipName_hours,
            sipName_min,
            sipName_sec,
            sipName_msec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "l|lJ1J1", &hours, &min, sipType_wxLongLong,&sec, &secState, sipType_wxLongLong,&msec, &msecState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTimeSpan(hours,min,*sec,*msec);
            Py_END_ALLOW_THREADS
            sipReleaseType(sec,sipType_wxLongLong,secState);
            sipReleaseType(msec,sipType_wxLongLong,msecState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTimeSpan* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxTimeSpan, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTimeSpan(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTimeSpan[] = {
    {(void *)slot_wxTimeSpan___ne__, ne_slot},
    {(void *)slot_wxTimeSpan___eq__, eq_slot},
    {(void *)slot_wxTimeSpan___ge__, ge_slot},
    {(void *)slot_wxTimeSpan___gt__, gt_slot},
    {(void *)slot_wxTimeSpan___le__, le_slot},
    {(void *)slot_wxTimeSpan___lt__, lt_slot},
    {(void *)slot_wxTimeSpan___neg__, neg_slot},
    {(void *)slot_wxTimeSpan___mul__, mul_slot},
    {(void *)slot_wxTimeSpan___imul__, imul_slot},
    {(void *)slot_wxTimeSpan___sub__, sub_slot},
    {(void *)slot_wxTimeSpan___isub__, isub_slot},
    {(void *)slot_wxTimeSpan___add__, add_slot},
    {(void *)slot_wxTimeSpan___iadd__, iadd_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTimeSpan[] = {
    {SIP_MLNAME_CAST(sipName_Abs), meth_wxTimeSpan_Abs, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Abs)},
    {SIP_MLNAME_CAST(sipName_Add), (PyCFunction)meth_wxTimeSpan_Add, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Add)},
    {SIP_MLNAME_CAST(sipName_Day), meth_wxTimeSpan_Day, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Day)},
    {SIP_MLNAME_CAST(sipName_Days), (PyCFunction)meth_wxTimeSpan_Days, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Days)},
    {SIP_MLNAME_CAST(sipName_Format), (PyCFunction)meth_wxTimeSpan_Format, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Format)},
    {SIP_MLNAME_CAST(sipName_GetDays), meth_wxTimeSpan_GetDays, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetDays)},
    {SIP_MLNAME_CAST(sipName_GetHours), meth_wxTimeSpan_GetHours, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetHours)},
    {SIP_MLNAME_CAST(sipName_GetMilliseconds), meth_wxTimeSpan_GetMilliseconds, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetMilliseconds)},
    {SIP_MLNAME_CAST(sipName_GetMinutes), meth_wxTimeSpan_GetMinutes, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetMinutes)},
    {SIP_MLNAME_CAST(sipName_GetSeconds), meth_wxTimeSpan_GetSeconds, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetSeconds)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxTimeSpan_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetValue)},
    {SIP_MLNAME_CAST(sipName_GetWeeks), meth_wxTimeSpan_GetWeeks, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_GetWeeks)},
    {SIP_MLNAME_CAST(sipName_Hour), meth_wxTimeSpan_Hour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Hour)},
    {SIP_MLNAME_CAST(sipName_Hours), (PyCFunction)meth_wxTimeSpan_Hours, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Hours)},
    {SIP_MLNAME_CAST(sipName_IsEqualTo), (PyCFunction)meth_wxTimeSpan_IsEqualTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsEqualTo)},
    {SIP_MLNAME_CAST(sipName_IsLongerThan), (PyCFunction)meth_wxTimeSpan_IsLongerThan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsLongerThan)},
    {SIP_MLNAME_CAST(sipName_IsNegative), meth_wxTimeSpan_IsNegative, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsNegative)},
    {SIP_MLNAME_CAST(sipName_IsNull), meth_wxTimeSpan_IsNull, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsNull)},
    {SIP_MLNAME_CAST(sipName_IsPositive), meth_wxTimeSpan_IsPositive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsPositive)},
    {SIP_MLNAME_CAST(sipName_IsShorterThan), (PyCFunction)meth_wxTimeSpan_IsShorterThan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_IsShorterThan)},
    {SIP_MLNAME_CAST(sipName_Millisecond), meth_wxTimeSpan_Millisecond, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Millisecond)},
    {SIP_MLNAME_CAST(sipName_Milliseconds), (PyCFunction)meth_wxTimeSpan_Milliseconds, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Milliseconds)},
    {SIP_MLNAME_CAST(sipName_Minute), meth_wxTimeSpan_Minute, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Minute)},
    {SIP_MLNAME_CAST(sipName_Minutes), (PyCFunction)meth_wxTimeSpan_Minutes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Minutes)},
    {SIP_MLNAME_CAST(sipName_Multiply), (PyCFunction)meth_wxTimeSpan_Multiply, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Multiply)},
    {SIP_MLNAME_CAST(sipName_Neg), meth_wxTimeSpan_Neg, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Neg)},
    {SIP_MLNAME_CAST(sipName_Negate), meth_wxTimeSpan_Negate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Negate)},
    {SIP_MLNAME_CAST(sipName_Second), meth_wxTimeSpan_Second, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Second)},
    {SIP_MLNAME_CAST(sipName_Seconds), (PyCFunction)meth_wxTimeSpan_Seconds, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Seconds)},
    {SIP_MLNAME_CAST(sipName_Subtract), (PyCFunction)meth_wxTimeSpan_Subtract, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Subtract)},
    {SIP_MLNAME_CAST(sipName_Week), meth_wxTimeSpan_Week, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTimeSpan_Week)},
    {SIP_MLNAME_CAST(sipName_Weeks), (PyCFunction)meth_wxTimeSpan_Weeks, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTimeSpan_Weeks)}
};

PyDoc_STRVAR(doc_wxTimeSpan, "TimeSpan()\n"
"TimeSpan(hours, min=0, sec=0, msec=0)\n"
"\n"
"wxTimeSpan class represents a time interval.");


sipClassTypeDef sipTypeDef__core_wxTimeSpan = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxTimeSpan,
        {0},
        0
    },
    {
        sipNameNr_TimeSpan,
        {0, 0, 1},
        32, methods_wxTimeSpan,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxTimeSpan,
    -1,
    -1,
    0,
    slots_wxTimeSpan,
    init_type_wxTimeSpan,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxTimeSpan,
    assign_wxTimeSpan,
    array_wxTimeSpan,
    copy_wxTimeSpan,
    release_wxTimeSpan,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
