/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/vscroll.h>

        #include <wx/window.h>
    #include <wxpy_api.h>


PyDoc_STRVAR(doc_wxVarScrollHelperBase_CalcScrolledPosition, "CalcScrolledPosition(coord) -> int\n"
"\n"
"Translates the logical coordinate given to the current device\n"
"coordinate.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_CalcScrolledPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_CalcScrolledPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CalcScrolledPosition(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_CalcScrolledPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_CalcUnscrolledPosition, "CalcUnscrolledPosition(coord) -> int\n"
"\n"
"Translates the device coordinate given to the corresponding logical\n"
"coordinate.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_CalcUnscrolledPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_CalcUnscrolledPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CalcUnscrolledPosition(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_CalcUnscrolledPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_EnablePhysicalScrolling, "EnablePhysicalScrolling(scrolling=True)\n"
"\n"
"With physical scrolling on (when this is true), the device origin is\n"
"changed properly when a wxPaintDC is prepared, children are actually\n"
"moved and laid out properly, and the contents of the window (pixels)\n"
"are actually moved.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_EnablePhysicalScrolling(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_EnablePhysicalScrolling(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool scrolling = 1;
         ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_scrolling,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &scrolling))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnablePhysicalScrolling(scrolling);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_EnablePhysicalScrolling, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetNonOrientationTargetSize, "GetNonOrientationTargetSize() -> int\n"
"\n"
"This function needs to be overridden in the in the derived class to\n"
"return the window size with respect to the opposing orientation.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetNonOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetNonOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetNonOrientationTargetSize);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNonOrientationTargetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetNonOrientationTargetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetOrientation, "GetOrientation() -> Orientation\n"
"\n"
"This function need to be overridden to return the orientation that\n"
"this helper is working with, either wxHORIZONTAL or wxVERTICAL.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::wxOrientation sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetOrientation);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOrientation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOrientation);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetOrientation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetOrientationTargetSize, "GetOrientationTargetSize() -> int\n"
"\n"
"This function needs to be overridden in the in the derived class to\n"
"return the window size with respect to the orientation this helper is\n"
"working with.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarScrollHelperBase, sipName_GetOrientationTargetSize);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOrientationTargetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetOrientationTargetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetTargetWindow, "GetTargetWindow() -> Window\n"
"\n"
"This function will return the target window this helper class is\n"
"currently scrolling.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetTargetWindow(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetTargetWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTargetWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetTargetWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetVisibleBegin, "GetVisibleBegin() -> size_t\n"
"\n"
"Returns the index of the first visible unit based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetVisibleBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetVisibleBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetVisibleBegin());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetVisibleBegin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_GetVisibleEnd, "GetVisibleEnd() -> size_t\n"
"\n"
"Returns the index of the last visible unit based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_GetVisibleEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_GetVisibleEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetVisibleEnd());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_GetVisibleEnd, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_IsVisible, "IsVisible(unit) -> bool\n"
"\n"
"Returns true if the given scroll unit is currently visible (even if\n"
"only partially visible) or false otherwise.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_IsVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_IsVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* unit;
        int unitState = 0;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, sipType_size_t,&unit, &unitState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsVisible(*unit);
            Py_END_ALLOW_THREADS
            sipReleaseType(unit,sipType_size_t,unitState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_IsVisible, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_RefreshAll, "RefreshAll()\n"
"\n"
"Recalculate all parameters and repaint all units.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_RefreshAll(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_RefreshAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RefreshAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_RefreshAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_SetTargetWindow, "SetTargetWindow(target)\n"
"\n"
"Normally the window will scroll itself, but in some rare occasions you\n"
"might want it to scroll (part of) another window (e.g.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_SetTargetWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_SetTargetWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* target;
         ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_target,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, sipType_wxWindow, &target))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTargetWindow(target);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_SetTargetWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_UpdateScrollbar, "UpdateScrollbar()\n"
"\n"
"Update the thumb size shown by the scrollbar.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_UpdateScrollbar(PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_UpdateScrollbar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxVarScrollHelperBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UpdateScrollbar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_UpdateScrollbar, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarScrollHelperBase_VirtualHitTest, "VirtualHitTest(coord) -> int\n"
"\n"
"Returns the virtual scroll unit under the device unit given accounting\n"
"for scroll position or wxNOT_FOUND if none (i.e.");

extern "C" {static PyObject *meth_wxVarScrollHelperBase_VirtualHitTest(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarScrollHelperBase_VirtualHitTest(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCoord coord;
        const  ::wxVarScrollHelperBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_coord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxVarScrollHelperBase, &sipCpp, &coord))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->VirtualHitTest(coord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarScrollHelperBase, sipName_VirtualHitTest, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarScrollHelperBase(void *, int);}
static void release_wxVarScrollHelperBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxVarScrollHelperBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarScrollHelperBase(sipSimpleWrapper *);}
static void dealloc_wxVarScrollHelperBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarScrollHelperBase(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxVarScrollHelperBase[] = {
    {SIP_MLNAME_CAST(sipName_CalcScrolledPosition), (PyCFunction)meth_wxVarScrollHelperBase_CalcScrolledPosition, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_CalcScrolledPosition)},
    {SIP_MLNAME_CAST(sipName_CalcUnscrolledPosition), (PyCFunction)meth_wxVarScrollHelperBase_CalcUnscrolledPosition, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_CalcUnscrolledPosition)},
    {SIP_MLNAME_CAST(sipName_EnablePhysicalScrolling), (PyCFunction)meth_wxVarScrollHelperBase_EnablePhysicalScrolling, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_EnablePhysicalScrolling)},
    {SIP_MLNAME_CAST(sipName_GetNonOrientationTargetSize), meth_wxVarScrollHelperBase_GetNonOrientationTargetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetNonOrientationTargetSize)},
    {SIP_MLNAME_CAST(sipName_GetOrientation), meth_wxVarScrollHelperBase_GetOrientation, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetOrientation)},
    {SIP_MLNAME_CAST(sipName_GetOrientationTargetSize), meth_wxVarScrollHelperBase_GetOrientationTargetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetOrientationTargetSize)},
    {SIP_MLNAME_CAST(sipName_GetTargetWindow), meth_wxVarScrollHelperBase_GetTargetWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetTargetWindow)},
    {SIP_MLNAME_CAST(sipName_GetVisibleBegin), meth_wxVarScrollHelperBase_GetVisibleBegin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetVisibleBegin)},
    {SIP_MLNAME_CAST(sipName_GetVisibleEnd), meth_wxVarScrollHelperBase_GetVisibleEnd, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_GetVisibleEnd)},
    {SIP_MLNAME_CAST(sipName_IsVisible), (PyCFunction)meth_wxVarScrollHelperBase_IsVisible, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_IsVisible)},
    {SIP_MLNAME_CAST(sipName_RefreshAll), meth_wxVarScrollHelperBase_RefreshAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_RefreshAll)},
    {SIP_MLNAME_CAST(sipName_SetTargetWindow), (PyCFunction)meth_wxVarScrollHelperBase_SetTargetWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_SetTargetWindow)},
    {SIP_MLNAME_CAST(sipName_UpdateScrollbar), meth_wxVarScrollHelperBase_UpdateScrollbar, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_UpdateScrollbar)},
    {SIP_MLNAME_CAST(sipName_VirtualHitTest), (PyCFunction)meth_wxVarScrollHelperBase_VirtualHitTest, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarScrollHelperBase_VirtualHitTest)}
};

sipVariableDef variables_wxVarScrollHelperBase[] = {
    {PropertyVariable, sipName_VisibleEnd, &methods_wxVarScrollHelperBase[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_VisibleBegin, &methods_wxVarScrollHelperBase[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_TargetWindow, &methods_wxVarScrollHelperBase[6], &methods_wxVarScrollHelperBase[11], NULL, NULL},
    {PropertyVariable, sipName_OrientationTargetSize, &methods_wxVarScrollHelperBase[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Orientation, &methods_wxVarScrollHelperBase[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_NonOrientationTargetSize, &methods_wxVarScrollHelperBase[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxVarScrollHelperBase, "VarScrollHelperBase(winToScroll)\n"
"\n"
"This class provides all common base functionality for scroll\n"
"calculations shared among all variable scrolled window implementations\n"
"as well as automatic scrollbar functionality, saved scroll positions,\n"
"controlling target windows to be scrolled, as well as defining all\n"
"required virtual functions that need to be implemented for any\n"
"orientation specific work.");


sipClassTypeDef sipTypeDef__core_wxVarScrollHelperBase = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarScrollHelperBase,
        {0},
        0
    },
    {
        sipNameNr_VarScrollHelperBase,
        {0, 0, 1},
        14, methods_wxVarScrollHelperBase,
        0, 0,
        6, variables_wxVarScrollHelperBase,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxVarScrollHelperBase,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxVarScrollHelperBase,
    0,
    0,
    0,
    release_wxVarScrollHelperBase,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
