/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmlpars.h>

        #include <wx/html/htmltag.h>
        #include <wx/filesys.h>
        #include <wx/html/htmlpars.h>
        #include <wx/object.h>
        #include <wx/filesys.h>


PyDoc_STRVAR(doc_wxHtmlParser_AddTagHandler, "AddTagHandler(handler)\n"
"\n"
"Adds handler to the internal list ( hash table) of handlers.");

extern "C" {static PyObject *meth_wxHtmlParser_AddTagHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_AddTagHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlTagHandler* handler;
         ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxHtmlTagHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHtmlParser::AddTagHandler(handler) : sipCpp->AddTagHandler(handler));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_AddTagHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_DoParsing, "DoParsing()\n"
"\n"
"Parses the whole m_Source.");

extern "C" {static PyObject *meth_wxHtmlParser_DoParsing(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_DoParsing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DoParsing();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_DoParsing, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_DoneParser, "DoneParser()\n"
"\n"
"This must be called after DoParsing().");

extern "C" {static PyObject *meth_wxHtmlParser_DoneParser(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_DoneParser(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHtmlParser::DoneParser() : sipCpp->DoneParser());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_DoneParser, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_GetFS, "GetFS() -> wx.FileSystem\n"
"\n"
"Returns pointer to the file system.");

extern "C" {static PyObject *meth_wxHtmlParser_GetFS(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_GetFS(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
             ::wxFileSystem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFS();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFileSystem,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_GetFS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_GetProduct, "GetProduct() -> wx.Object\n"
"\n"
"Returns product of parsing.");

extern "C" {static PyObject *meth_wxHtmlParser_GetProduct(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_GetProduct(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
             ::wxObject*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlParser, sipName_GetProduct);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProduct();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_GetProduct, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_GetSource, "GetSource() -> String\n"
"\n"
"Returns pointer to the source being parsed.");

extern "C" {static PyObject *meth_wxHtmlParser_GetSource(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_GetSource(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
            const  ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSource();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxString *>(sipRes),sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_GetSource, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_InitParser, "InitParser(source)\n"
"\n"
"Setups the parser for parsing the source string.");

extern "C" {static PyObject *meth_wxHtmlParser_InitParser(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_InitParser(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* source;
        int sourceState = 0;
         ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_source,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxString,&source, &sourceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHtmlParser::InitParser(*source) : sipCpp->InitParser(*source));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(source),sipType_wxString,sourceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_InitParser, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_OpenURL, "OpenURL(type, url) -> wx.FSFile\n"
"\n"
"Opens given URL and returns wxFSFile object that can be used to read\n"
"data from it.");

extern "C" {static PyObject *meth_wxHtmlParser_OpenURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_OpenURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlURLType type;
        const  ::wxString* url;
        int urlState = 0;
        const  ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BEJ1", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxHtmlURLType, &type, sipType_wxString,&url, &urlState))
        {
             ::wxFSFile*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHtmlParser::OpenURL(type,*url) : sipCpp->OpenURL(type,*url));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFSFile,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_OpenURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_Parse, "Parse(source) -> wx.Object\n"
"\n"
"Proceeds parsing of the document.");

extern "C" {static PyObject *meth_wxHtmlParser_Parse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_Parse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* source;
        int sourceState = 0;
         ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_source,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxString,&source, &sourceState))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Parse(*source);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(source),sipType_wxString,sourceState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_Parse, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_PopTagHandler, "PopTagHandler()\n"
"\n"
"Restores parser's state before last call to PushTagHandler().");

extern "C" {static PyObject *meth_wxHtmlParser_PopTagHandler(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_PopTagHandler(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PopTagHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_PopTagHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_PushTagHandler, "PushTagHandler(handler, tags)\n"
"\n"
"Forces the handler to handle additional tags (not returned by\n"
"wxHtmlTagHandler::GetSupportedTags).");

extern "C" {static PyObject *meth_wxHtmlParser_PushTagHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_PushTagHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlTagHandler* handler;
        const  ::wxString* tags;
        int tagsState = 0;
         ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
            sipName_tags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxHtmlTagHandler, &handler, sipType_wxString,&tags, &tagsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PushTagHandler(handler,*tags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(tags),sipType_wxString,tagsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_PushTagHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_SetFS, "SetFS(fs)\n"
"\n"
"Sets the virtual file system that will be used to request additional\n"
"files.");

extern "C" {static PyObject *meth_wxHtmlParser_SetFS(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_SetFS(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFileSystem* fs;
         ::wxHtmlParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHtmlParser, &sipCpp, sipType_wxFileSystem, &fs))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFS(fs);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_SetFS, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlParser_StopParsing, "StopParsing()\n"
"\n"
"Call this function to interrupt parsing from a tag handler.");

extern "C" {static PyObject *meth_wxHtmlParser_StopParsing(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlParser_StopParsing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlParser, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHtmlParser::StopParsing() : sipCpp->StopParsing());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlParser, sipName_StopParsing, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlParser(void *, int);}
static void release_wxHtmlParser(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlParser *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlParser(sipSimpleWrapper *);}
static void dealloc_wxHtmlParser(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlParser(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxHtmlParser[] = {
    {SIP_MLNAME_CAST(sipName_AddTagHandler), (PyCFunction)meth_wxHtmlParser_AddTagHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_AddTagHandler)},
    {SIP_MLNAME_CAST(sipName_DoParsing), meth_wxHtmlParser_DoParsing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_DoParsing)},
    {SIP_MLNAME_CAST(sipName_DoneParser), meth_wxHtmlParser_DoneParser, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_DoneParser)},
    {SIP_MLNAME_CAST(sipName_GetFS), meth_wxHtmlParser_GetFS, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_GetFS)},
    {SIP_MLNAME_CAST(sipName_GetProduct), meth_wxHtmlParser_GetProduct, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_GetProduct)},
    {SIP_MLNAME_CAST(sipName_GetSource), meth_wxHtmlParser_GetSource, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_GetSource)},
    {SIP_MLNAME_CAST(sipName_InitParser), (PyCFunction)meth_wxHtmlParser_InitParser, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_InitParser)},
    {SIP_MLNAME_CAST(sipName_OpenURL), (PyCFunction)meth_wxHtmlParser_OpenURL, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_OpenURL)},
    {SIP_MLNAME_CAST(sipName_Parse), (PyCFunction)meth_wxHtmlParser_Parse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_Parse)},
    {SIP_MLNAME_CAST(sipName_PopTagHandler), meth_wxHtmlParser_PopTagHandler, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_PopTagHandler)},
    {SIP_MLNAME_CAST(sipName_PushTagHandler), (PyCFunction)meth_wxHtmlParser_PushTagHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_PushTagHandler)},
    {SIP_MLNAME_CAST(sipName_SetFS), (PyCFunction)meth_wxHtmlParser_SetFS, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlParser_SetFS)},
    {SIP_MLNAME_CAST(sipName_StopParsing), meth_wxHtmlParser_StopParsing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlParser_StopParsing)}
};

sipVariableDef variables_wxHtmlParser[] = {
    {PropertyVariable, sipName_Source, &methods_wxHtmlParser[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Product, &methods_wxHtmlParser[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_FS, &methods_wxHtmlParser[3], &methods_wxHtmlParser[11], NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlParser, "HtmlParser()\n"
"\n"
"Classes derived from this handle the generic parsing of HTML\n"
"documents: it scans the document and divide it into blocks of tags\n"
"(where one block consists of beginning and ending tag and of text\n"
"between these two tags).");


sipClassTypeDef sipTypeDef__html_wxHtmlParser = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlParser,
        {0},
        0
    },
    {
        sipNameNr_HtmlParser,
        {0, 0, 1},
        13, methods_wxHtmlParser,
        0, 0,
        3, variables_wxHtmlParser,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlParser,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlParser,
    0,
    0,
    0,
    release_wxHtmlParser,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
