/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmltag.h>

        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxHtmlTag_GetAllParams, "GetAllParams() -> String\n"
"\n"
"Returns a string containing all parameters.");

extern "C" {static PyObject *meth_wxHtmlTag_GetAllParams(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetAllParams(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetAllParams());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetAllParams, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetBeginPos, "GetBeginPos() -> int\n"
"\n"
"Returns beginning position of the text between this tag and paired\n"
"ending tag.");

extern "C" {static PyObject *meth_wxHtmlTag_GetBeginPos(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetBeginPos(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
            int sipRes;

            if (sipDeprecated(sipName_HtmlTag,sipName_GetBeginPos) < 0)
                return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBeginPos();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetBeginPos, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetEndPos1, "GetEndPos1() -> int\n"
"\n"
"Returns ending position of the text between this tag and paired ending\n"
"tag.");

extern "C" {static PyObject *meth_wxHtmlTag_GetEndPos1(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetEndPos1(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
            int sipRes;

            if (sipDeprecated(sipName_HtmlTag,sipName_GetEndPos1) < 0)
                return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEndPos1();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetEndPos1, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetEndPos2, "GetEndPos2() -> int\n"
"\n"
"Returns ending position 2 of the text between this tag and paired\n"
"ending tag.");

extern "C" {static PyObject *meth_wxHtmlTag_GetEndPos2(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetEndPos2(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
            int sipRes;

            if (sipDeprecated(sipName_HtmlTag,sipName_GetEndPos2) < 0)
                return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEndPos2();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetEndPos2, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetName, "GetName() -> String\n"
"\n"
"Returns tag's name.");

extern "C" {static PyObject *meth_wxHtmlTag_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetParam, "GetParam(par, with_quotes=False) -> String\n"
"\n"
"Returns the value of the parameter.");

extern "C" {static PyObject *meth_wxHtmlTag_GetParam(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetParam(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* par;
        int parState = 0;
        bool with_quotes = 0;
        const  ::wxHtmlTag *sipCpp;

        static const char *sipKwdList[] = {
            sipName_par,
            sipName_with_quotes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxHtmlTag, &sipCpp, sipType_wxString,&par, &parState, &with_quotes))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetParam(*par,with_quotes));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(par),sipType_wxString,parState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetParam, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetParamAsColour, "GetParamAsColour(par) -> (bool, clr)\n"
"\n"
"Interprets tag parameter par as colour specification and saves its\n"
"value into wxColour variable pointed by clr.");

extern "C" {static PyObject *meth_wxHtmlTag_GetParamAsColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetParamAsColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* par;
        int parState = 0;
         ::wxColour* clr;
        const  ::wxHtmlTag *sipCpp;

        static const char *sipKwdList[] = {
            sipName_par,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlTag, &sipCpp, sipType_wxString,&par, &parState))
        {
            bool sipRes;
            clr = new  ::wxColour();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParamAsColour(*par,clr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(par),sipType_wxString,parState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(bN)",sipRes,clr,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetParamAsColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetParamAsInt, "GetParamAsInt(par) -> (bool, value)\n"
"\n"
"Interprets tag parameter par as an integer and saves its value into\n"
"int variable pointed by value.");

extern "C" {static PyObject *meth_wxHtmlTag_GetParamAsInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetParamAsInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* par;
        int parState = 0;
        int value;
        const  ::wxHtmlTag *sipCpp;

        static const char *sipKwdList[] = {
            sipName_par,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlTag, &sipCpp, sipType_wxString,&par, &parState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParamAsInt(*par,&value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(par),sipType_wxString,parState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(bi)",sipRes,value);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetParamAsInt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_GetParamAsString, "GetParamAsString(par, value) -> bool\n"
"\n"
"Get the value of the parameter.");

extern "C" {static PyObject *meth_wxHtmlTag_GetParamAsString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_GetParamAsString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* par;
        int parState = 0;
         ::wxString* value;
        int valueState = 0;
        const  ::wxHtmlTag *sipCpp;

        static const char *sipKwdList[] = {
            sipName_par,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J0", &sipSelf, sipType_wxHtmlTag, &sipCpp, sipType_wxString,&par, &parState, sipType_wxString,&value, &valueState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParamAsString(*par,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(par),sipType_wxString,parState);
            sipReleaseType(value,sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_GetParamAsString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_HasEnding, "HasEnding() -> bool\n"
"\n"
"Returns true if this tag is paired with ending tag, false otherwise.");

extern "C" {static PyObject *meth_wxHtmlTag_HasEnding(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_HasEnding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlTag *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlTag, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasEnding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_HasEnding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_HasParam, "HasParam(par) -> bool\n"
"\n"
"Returns true if the tag has a parameter of the given name.");

extern "C" {static PyObject *meth_wxHtmlTag_HasParam(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_HasParam(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* par;
        int parState = 0;
        const  ::wxHtmlTag *sipCpp;

        static const char *sipKwdList[] = {
            sipName_par,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlTag, &sipCpp, sipType_wxString,&par, &parState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasParam(*par);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(par),sipType_wxString,parState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_HasParam, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlTag_ParseAsColour, "ParseAsColour(str) -> (bool, clr)\n"
"\n"
"Parses the given string as an HTML colour.");

extern "C" {static PyObject *meth_wxHtmlTag_ParseAsColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlTag_ParseAsColour(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxColour* clr;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&str, &strState))
        {
            bool sipRes;
            clr = new  ::wxColour();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxHtmlTag::ParseAsColour(*str,clr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(bN)",sipRes,clr,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlTag, sipName_ParseAsColour, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlTag(void *, int);}
static void release_wxHtmlTag(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlTag *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlTag(sipSimpleWrapper *);}
static void dealloc_wxHtmlTag(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlTag(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxHtmlTag[] = {
    {SIP_MLNAME_CAST(sipName_GetAllParams), meth_wxHtmlTag_GetAllParams, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetAllParams)},
    {SIP_MLNAME_CAST(sipName_GetBeginPos), meth_wxHtmlTag_GetBeginPos, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetBeginPos)},
    {SIP_MLNAME_CAST(sipName_GetEndPos1), meth_wxHtmlTag_GetEndPos1, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetEndPos1)},
    {SIP_MLNAME_CAST(sipName_GetEndPos2), meth_wxHtmlTag_GetEndPos2, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetEndPos2)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxHtmlTag_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetName)},
    {SIP_MLNAME_CAST(sipName_GetParam), (PyCFunction)meth_wxHtmlTag_GetParam, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetParam)},
    {SIP_MLNAME_CAST(sipName_GetParamAsColour), (PyCFunction)meth_wxHtmlTag_GetParamAsColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetParamAsColour)},
    {SIP_MLNAME_CAST(sipName_GetParamAsInt), (PyCFunction)meth_wxHtmlTag_GetParamAsInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetParamAsInt)},
    {SIP_MLNAME_CAST(sipName_GetParamAsString), (PyCFunction)meth_wxHtmlTag_GetParamAsString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_GetParamAsString)},
    {SIP_MLNAME_CAST(sipName_HasEnding), meth_wxHtmlTag_HasEnding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlTag_HasEnding)},
    {SIP_MLNAME_CAST(sipName_HasParam), (PyCFunction)meth_wxHtmlTag_HasParam, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_HasParam)},
    {SIP_MLNAME_CAST(sipName_ParseAsColour), (PyCFunction)meth_wxHtmlTag_ParseAsColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlTag_ParseAsColour)}
};

sipVariableDef variables_wxHtmlTag[] = {
    {PropertyVariable, sipName_Name, &methods_wxHtmlTag[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_EndPos2, &methods_wxHtmlTag[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_EndPos1, &methods_wxHtmlTag[2], NULL, NULL, NULL},
    {PropertyVariable, sipName_BeginPos, &methods_wxHtmlTag[1], NULL, NULL, NULL},
    {PropertyVariable, sipName_AllParams, &methods_wxHtmlTag[0], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlTag, "This class represents a single HTML tag.");


sipClassTypeDef sipTypeDef__html_wxHtmlTag = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxHtmlTag,
        {0},
        0
    },
    {
        sipNameNr_HtmlTag,
        {0, 0, 1},
        12, methods_wxHtmlTag,
        0, 0,
        5, variables_wxHtmlTag,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlTag,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlTag,
    0,
    0,
    0,
    release_wxHtmlTag,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
