/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_propgrid.h"

        #include <wx/propgrid/property.h>

        #include <wx/propgrid/property.h>
    #include <wxpy_api.h>
        #include <wx/propgrid/property.h>
        #include <wx/bitmap.h>


PyDoc_STRVAR(doc_wxPGChoices_Add, "Add(labels, values=None)\n"
"Add(arr, arrint)\n"
"Add(label, value=PG_INVALID_VALUE) -> PGChoiceEntry\n"
"Add(label, bitmap, value=PG_INVALID_VALUE) -> PGChoiceEntry\n"
"Add(entry) -> PGChoiceEntry\n"
"\n"
"Adds to current.\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxPGChoices_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxChar* labels;
         ::wxPGChoices::ValArrItem values = 0;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_labels,
            sipName_values,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bx|l", &sipSelf, sipType_wxPGChoices, &sipCpp, &labels, &values))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Add(&labels,&values);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxArrayString* arr;
        int arrState = 0;
        const  ::wxArrayInt* arrint;
        int arrintState = 0;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_arr,
            sipName_arrint,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxArrayString,&arr, &arrState, sipType_wxArrayInt,&arrint, &arrintState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Add(*arr,*arrint);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(arr),sipType_wxArrayString,arrState);
            sipReleaseType(const_cast< ::wxArrayInt *>(arrint),sipType_wxArrayInt,arrintState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* label;
        int labelState = 0;
        int value = wxPG_INVALID_VALUE;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxString,&label, &labelState, &value))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*label,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    {
        const  ::wxString* label;
        int labelState = 0;
        const  ::wxBitmap* bitmap;
        int value = wxPG_INVALID_VALUE;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_bitmap,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9|i", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxString,&label, &labelState, sipType_wxBitmap, &bitmap, &value))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*label,*bitmap,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    {
        const  ::wxPGChoiceEntry* entry;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_entry,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxPGChoiceEntry, &entry))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Add(*entry);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Add, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_AddAsSorted, "AddAsSorted(label, value=PG_INVALID_VALUE) -> PGChoiceEntry\n"
"\n"
"Adds single item, sorted.");

extern "C" {static PyObject *meth_wxPGChoices_AddAsSorted(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_AddAsSorted(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
        int value = wxPG_INVALID_VALUE;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxString,&label, &labelState, &value))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->AddAsSorted(*label,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_AddAsSorted, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Assign, "Assign(a)\n"
"\n"
"Assigns choices data, using reference counting.");

extern "C" {static PyObject *meth_wxPGChoices_Assign(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Assign(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGChoices* a;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_a,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxPGChoices, &a))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Assign(*a);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Assign, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_AssignData, "AssignData(data)\n"
"\n"
"Assigns data from another set of choices.");

extern "C" {static PyObject *meth_wxPGChoices_AssignData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_AssignData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGChoicesData* data;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxPGChoicesData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AssignData(data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_AssignData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Clear, "Clear()\n"
"\n"
"Deletes all items.");

extern "C" {static PyObject *meth_wxPGChoices_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Copy, "Copy() -> PGChoices\n"
"\n"
"Returns a real copy of the choices.");

extern "C" {static PyObject *meth_wxPGChoices_Copy(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Copy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
             ::wxPGChoices*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPGChoices(sipCpp->Copy());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPGChoices,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Copy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetLabel, "GetLabel(ind) -> String\n"
"\n"
"Returns label of item.");

extern "C" {static PyObject *meth_wxPGChoices_GetLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint ind;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ind,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxPGChoices, &sipCpp, &ind))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLabel(ind));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetCount, "GetCount() -> unsignedint\n"
"\n"
"Returns number of items.");

extern "C" {static PyObject *meth_wxPGChoices_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetValue, "GetValue(ind) -> int\n"
"\n"
"Returns value of item;.");

extern "C" {static PyObject *meth_wxPGChoices_GetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint ind;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ind,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxPGChoices, &sipCpp, &ind))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue(ind);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetValuesForStrings, "GetValuesForStrings(strings) -> ArrayInt\n"
"\n"
"Returns array of values matching the given strings.");

extern "C" {static PyObject *meth_wxPGChoices_GetValuesForStrings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetValuesForStrings(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* strings;
        int stringsState = 0;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strings,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxArrayString,&strings, &stringsState))
        {
             ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayInt(sipCpp->GetValuesForStrings(*strings));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(strings),sipType_wxArrayString,stringsState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayInt,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetValuesForStrings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetIndicesForStrings, "GetIndicesForStrings(strings, unmatched=None) -> ArrayInt\n"
"\n"
"Returns array of indices matching given strings.");

extern "C" {static PyObject *meth_wxPGChoices_GetIndicesForStrings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetIndicesForStrings(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* strings;
        int stringsState = 0;
         ::wxArrayString* unmatched = 0;
        int unmatchedState = 0;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strings,
            sipName_unmatched,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J0", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxArrayString,&strings, &stringsState, sipType_wxArrayString,&unmatched, &unmatchedState))
        {
             ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayInt(sipCpp->GetIndicesForStrings(*strings,unmatched));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(strings),sipType_wxArrayString,stringsState);
            sipReleaseType(unmatched,sipType_wxArrayString,unmatchedState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayInt,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetIndicesForStrings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Index, "Index(label) -> int\n"
"Index(val) -> int\n"
"\n"
"Returns index of item with given label.\n"
"");

extern "C" {static PyObject *meth_wxPGChoices_Index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxString,&label, &labelState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Index(*label);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        int val;
        const  ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxPGChoices, &sipCpp, &val))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Index(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Index, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Insert, "Insert(label, index, value=PG_INVALID_VALUE) -> PGChoiceEntry\n"
"Insert(entry, index) -> PGChoiceEntry\n"
"\n"
"Inserts single item.\n"
"");

extern "C" {static PyObject *meth_wxPGChoices_Insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
        int index;
        int value = wxPG_INVALID_VALUE;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_index,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i|i", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxString,&label, &labelState, &index, &value))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Insert(*label,index,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    {
        const  ::wxPGChoiceEntry* entry;
        int index;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_entry,
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9i", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxPGChoiceEntry, &entry, &index))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Insert(*entry,index);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Insert, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_IsOk, "IsOk() -> bool\n"
"\n"
"Returns false if this is a constant empty set of choices, which should\n"
"not be modified.");

extern "C" {static PyObject *meth_wxPGChoices_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Item, "Item(i) -> PGChoiceEntry\n"
"\n"
"Returns item at given index.");

extern "C" {static PyObject *meth_wxPGChoices_Item(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Item(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint i;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxPGChoices, &sipCpp, &i))
        {
             ::wxPGChoiceEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Item(i);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGChoiceEntry,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Item, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_RemoveAt, "RemoveAt(nIndex, count=1)\n"
"\n"
"Removes count items starting at position nIndex.");

extern "C" {static PyObject *meth_wxPGChoices_RemoveAt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_RemoveAt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* nIndex;
        int nIndexState = 0;
         ::size_t countdef = 1;
         ::size_t* count = &countdef;
        int countState = 0;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_nIndex,
            sipName_count,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_size_t,&nIndex, &nIndexState, sipType_size_t,&count, &countState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveAt(*nIndex,*count);
            Py_END_ALLOW_THREADS
            sipReleaseType(nIndex,sipType_size_t,nIndexState);
            sipReleaseType(count,sipType_size_t,countState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_RemoveAt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_Set, "Set(labels, values=None)\n"
"Set(labels, values=[])\n"
"\n"
"Sets contents from lists of strings and values.\n"
"");

extern "C" {static PyObject *meth_wxPGChoices_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxChar* labels;
        long values = 0;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_labels,
            sipName_values,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bx|l", &sipSelf, sipType_wxPGChoices, &sipCpp, &labels, &values))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(&labels,&values);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxArrayString* labels;
        int labelsState = 0;
        const  ::wxArrayInt& valuesdef = wxArrayInt();
        const  ::wxArrayInt* values = &valuesdef;
        int valuesState = 0;
         ::wxPGChoices *sipCpp;

        static const char *sipKwdList[] = {
            sipName_labels,
            sipName_values,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxPGChoices, &sipCpp, sipType_wxArrayString,&labels, &labelsState, sipType_wxArrayInt,&values, &valuesState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(*labels,*values);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(labels),sipType_wxArrayString,labelsState);
            sipReleaseType(const_cast< ::wxArrayInt *>(values),sipType_wxArrayInt,valuesState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_AllocExclusive, "AllocExclusive()\n"
"\n"
"Creates exclusive copy of current choices.");

extern "C" {static PyObject *meth_wxPGChoices_AllocExclusive(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_AllocExclusive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AllocExclusive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_AllocExclusive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPGChoices_GetLabels, "GetLabels() -> ArrayString\n"
"\n"
"Returns array of choice labels.");

extern "C" {static PyObject *meth_wxPGChoices_GetLabels(PyObject *, PyObject *);}
static PyObject *meth_wxPGChoices_GetLabels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGChoices *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGChoices, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetLabels());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGChoices, sipName_GetLabels, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPGChoices(void *, int);}
static void release_wxPGChoices(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPGChoices *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxPGChoices(void *, SIP_SSIZE_T, void *);}
static void assign_wxPGChoices(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPGChoices *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPGChoices *>(sipSrc);
}


extern "C" {static void *array_wxPGChoices(SIP_SSIZE_T);}
static void *array_wxPGChoices(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxPGChoices[sipNrElem];
}


extern "C" {static void *copy_wxPGChoices(const void *, SIP_SSIZE_T);}
static void *copy_wxPGChoices(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPGChoices(reinterpret_cast<const  ::wxPGChoices *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPGChoices(sipSimpleWrapper *);}
static void dealloc_wxPGChoices(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPGChoices(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPGChoices(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPGChoices(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPGChoices *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGChoices();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPGChoices* a;

        static const char *sipKwdList[] = {
            sipName_a,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPGChoices, &a))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGChoices(*a);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxArrayString* labels;
        int labelsState = 0;
        const  ::wxArrayInt& valuesdef = wxArrayInt();
        const  ::wxArrayInt* values = &valuesdef;
        int valuesState = 0;

        static const char *sipKwdList[] = {
            sipName_labels,
            sipName_values,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J1", sipType_wxArrayString,&labels, &labelsState, sipType_wxArrayInt,&values, &valuesState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGChoices(*labels,*values);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(labels),sipType_wxArrayString,labelsState);
            sipReleaseType(const_cast< ::wxArrayInt *>(values),sipType_wxArrayInt,valuesState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
         ::wxPGChoicesData* data;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_wxPGChoicesData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGChoices(data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxPGChoices[] = {
    {SIP_MLNAME_CAST(sipName_Add), (PyCFunction)meth_wxPGChoices_Add, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Add)},
    {SIP_MLNAME_CAST(sipName_AddAsSorted), (PyCFunction)meth_wxPGChoices_AddAsSorted, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_AddAsSorted)},
    {SIP_MLNAME_CAST(sipName_AllocExclusive), meth_wxPGChoices_AllocExclusive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_AllocExclusive)},
    {SIP_MLNAME_CAST(sipName_Assign), (PyCFunction)meth_wxPGChoices_Assign, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Assign)},
    {SIP_MLNAME_CAST(sipName_AssignData), (PyCFunction)meth_wxPGChoices_AssignData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_AssignData)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxPGChoices_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_Clear)},
    {SIP_MLNAME_CAST(sipName_Copy), meth_wxPGChoices_Copy, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_Copy)},
    {SIP_MLNAME_CAST(sipName_GetCount), meth_wxPGChoices_GetCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_GetCount)},
    {SIP_MLNAME_CAST(sipName_GetIndicesForStrings), (PyCFunction)meth_wxPGChoices_GetIndicesForStrings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_GetIndicesForStrings)},
    {SIP_MLNAME_CAST(sipName_GetLabel), (PyCFunction)meth_wxPGChoices_GetLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_GetLabel)},
    {SIP_MLNAME_CAST(sipName_GetLabels), meth_wxPGChoices_GetLabels, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_GetLabels)},
    {SIP_MLNAME_CAST(sipName_GetValue), (PyCFunction)meth_wxPGChoices_GetValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_GetValue)},
    {SIP_MLNAME_CAST(sipName_GetValuesForStrings), (PyCFunction)meth_wxPGChoices_GetValuesForStrings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_GetValuesForStrings)},
    {SIP_MLNAME_CAST(sipName_Index), (PyCFunction)meth_wxPGChoices_Index, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Index)},
    {SIP_MLNAME_CAST(sipName_Insert), (PyCFunction)meth_wxPGChoices_Insert, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Insert)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxPGChoices_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGChoices_IsOk)},
    {SIP_MLNAME_CAST(sipName_Item), (PyCFunction)meth_wxPGChoices_Item, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Item)},
    {SIP_MLNAME_CAST(sipName_RemoveAt), (PyCFunction)meth_wxPGChoices_RemoveAt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_RemoveAt)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxPGChoices_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGChoices_Set)}
};

sipVariableDef variables_wxPGChoices[] = {
    {PropertyVariable, sipName_Labels, &methods_wxPGChoices[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_Count, &methods_wxPGChoices[7], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxPGChoices, "PGChoices()\n"
"PGChoices(a)\n"
"PGChoices(labels, values=[])\n"
"PGChoices(data)\n"
"\n"
"Helper class for managing choices of wxPropertyGrid properties.");


sipClassTypeDef sipTypeDef__propgrid_wxPGChoices = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxPGChoices,
        {0},
        0
    },
    {
        sipNameNr_PGChoices,
        {0, 0, 1},
        19, methods_wxPGChoices,
        0, 0,
        2, variables_wxPGChoices,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPGChoices,
    -1,
    -1,
    0,
    0,
    init_type_wxPGChoices,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPGChoices,
    assign_wxPGChoices,
    array_wxPGChoices,
    copy_wxPGChoices,
    release_wxPGChoices,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
