/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_propgrid.h"

        #include <wx/propgrid/propgrid.h>

        #include <wx/event.h>
        #include <wx/propgrid/property.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxPropertyGridEvent : public  ::wxPropertyGridEvent
{
public:
    sipwxPropertyGridEvent( ::wxEventType,int);
    sipwxPropertyGridEvent(const  ::wxPropertyGridEvent&);
    virtual ~sipwxPropertyGridEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEventCategory GetEventCategory() const;
     ::wxEvent* Clone() const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxPropertyGridEvent(const sipwxPropertyGridEvent &);
    sipwxPropertyGridEvent &operator = (const sipwxPropertyGridEvent &);

    char sipPyMethods[2];
};

sipwxPropertyGridEvent::sipwxPropertyGridEvent( ::wxEventType commandType,int id):  ::wxPropertyGridEvent(commandType,id), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxPropertyGridEvent::sipwxPropertyGridEvent(const  ::wxPropertyGridEvent& event):  ::wxPropertyGridEvent(event), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxPropertyGridEvent::~sipwxPropertyGridEvent()
{
    sipInstanceDestroyed(sipPySelf);
}

 ::wxEventCategory sipwxPropertyGridEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxPropertyGridEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__propgrid_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__propgrid_57(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEvent* sipwxPropertyGridEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_Clone);

    if (!sipMeth)
        return  ::wxPropertyGridEvent::Clone();

    extern  ::wxEvent* sipVH__propgrid_56(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__propgrid_56(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_CanVeto, "CanVeto() -> bool\n"
"\n"
"Returns true if you can veto the action that the event is signaling.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_CanVeto(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_CanVeto(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanVeto();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_CanVeto, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetColumn, "GetColumn() -> unsignedint\n"
"\n"
"Returns the column index associated with this event.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetColumn(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetColumn(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumn();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetColumn, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetMainParent, "GetMainParent() -> PGProperty\n"
"\n"
"Returns highest level non-category, non-root parent of property for\n"
"which event occurred.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetMainParent(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetMainParent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMainParent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetMainParent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetProperty, "GetProperty() -> PGProperty\n"
"\n"
"Returns property associated with this event.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetProperty(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetProperty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProperty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetValidationFailureBehavior, "GetValidationFailureBehavior() -> PGVFBFlags\n"
"\n"
"Returns current validation failure flags.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetValidationFailureBehavior(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetValidationFailureBehavior(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValidationFailureBehavior();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPBytes_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetValidationFailureBehavior, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetPropertyName, "GetPropertyName() -> String\n"
"\n"
"Returns name of the associated property.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetPropertyName(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetPropertyName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetPropertyName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_GetPropertyValue, "GetPropertyValue() -> PGVariant\n"
"\n"
"Returns value of the associated property.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_GetPropertyValue(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_GetPropertyValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
             ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPGVariant(sipCpp->GetPropertyValue());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPGVariant,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_GetPropertyValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_SetCanVeto, "SetCanVeto(canVeto)\n"
"\n"
"Set if event can be vetoed.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_SetCanVeto(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_SetCanVeto(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool canVeto;
         ::wxPropertyGridEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_canVeto,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp, &canVeto))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCanVeto(canVeto);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_SetCanVeto, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_SetProperty, "SetProperty(p)\n"
"\n"
"Changes the property associated with this event.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_SetProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_SetProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGProperty* p;
         ::wxPropertyGridEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp, sipType_wxPGProperty, &p))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_SetProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_SetValidationFailureBehavior, "SetValidationFailureBehavior(flags)\n"
"\n"
"Set override validation failure behaviour.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_SetValidationFailureBehavior(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_SetValidationFailureBehavior(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned char flags;
         ::wxPropertyGridEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bc", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValidationFailureBehavior(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_SetValidationFailureBehavior, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_SetValidationFailureMessage, "SetValidationFailureMessage(message)\n"
"\n"
"Sets custom failure message for this time only.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_SetValidationFailureMessage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_SetValidationFailureMessage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* message;
        int messageState = 0;
         ::wxPropertyGridEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp, sipType_wxString,&message, &messageState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValidationFailureMessage(*message);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(message),sipType_wxString,messageState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_SetValidationFailureMessage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_Veto, "Veto(veto=True)\n"
"\n"
"Call this from your event handler to veto action that the event is\n"
"signaling.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_Veto(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_Veto(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool veto = 1;
         ::wxPropertyGridEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_veto,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp, &veto))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Veto(veto);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_Veto, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_WasVetoed, "WasVetoed() -> bool\n"
"\n"
"Returns true if event was vetoed.");

extern "C" {static PyObject *meth_wxPropertyGridEvent_WasVetoed(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_WasVetoed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->WasVetoed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_WasVetoed, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxPropertyGridEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxPropertyGridEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPropertyGridEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridEvent, sipName_Clone, doc_wxPropertyGridEvent_Clone);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPropertyGridEvent(void *, const sipTypeDef *);}
static void *cast_wxPropertyGridEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPropertyGridEvent *sipCpp = reinterpret_cast< ::wxPropertyGridEvent *>(sipCppV);

    if (targetType == sipType_wxCommandEvent)
        return static_cast< ::wxCommandEvent *>(sipCpp);

    if (targetType == sipType_wxEvent)
        return static_cast< ::wxEvent *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPropertyGridEvent(void *, int);}
static void release_wxPropertyGridEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxPropertyGridEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxPropertyGridEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxPropertyGridEvent(sipSimpleWrapper *);}
static void dealloc_wxPropertyGridEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxPropertyGridEvent *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPropertyGridEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxPropertyGridEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPropertyGridEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxPropertyGridEvent *sipCpp = 0;

    {
         ::wxEventType commandType = 0;
        int id = 0;

        static const char *sipKwdList[] = {
            sipName_commandType,
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &commandType, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxPropertyGridEvent(commandType,id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxPropertyGridEvent* event;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPropertyGridEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxPropertyGridEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPropertyGridEvent[] = {{8, 0, 1}};


static PyMethodDef methods_wxPropertyGridEvent[] = {
    {SIP_MLNAME_CAST(sipName_CanVeto), meth_wxPropertyGridEvent_CanVeto, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_CanVeto)},
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxPropertyGridEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_GetColumn), meth_wxPropertyGridEvent_GetColumn, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetColumn)},
    {SIP_MLNAME_CAST(sipName_GetMainParent), meth_wxPropertyGridEvent_GetMainParent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetMainParent)},
    {SIP_MLNAME_CAST(sipName_GetProperty), meth_wxPropertyGridEvent_GetProperty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetProperty)},
    {SIP_MLNAME_CAST(sipName_GetPropertyName), meth_wxPropertyGridEvent_GetPropertyName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetPropertyName)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValue), meth_wxPropertyGridEvent_GetPropertyValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetPropertyValue)},
    {SIP_MLNAME_CAST(sipName_GetValidationFailureBehavior), meth_wxPropertyGridEvent_GetValidationFailureBehavior, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_GetValidationFailureBehavior)},
    {SIP_MLNAME_CAST(sipName_SetCanVeto), (PyCFunction)meth_wxPropertyGridEvent_SetCanVeto, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_SetCanVeto)},
    {SIP_MLNAME_CAST(sipName_SetProperty), (PyCFunction)meth_wxPropertyGridEvent_SetProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_SetProperty)},
    {SIP_MLNAME_CAST(sipName_SetValidationFailureBehavior), (PyCFunction)meth_wxPropertyGridEvent_SetValidationFailureBehavior, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_SetValidationFailureBehavior)},
    {SIP_MLNAME_CAST(sipName_SetValidationFailureMessage), (PyCFunction)meth_wxPropertyGridEvent_SetValidationFailureMessage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_SetValidationFailureMessage)},
    {SIP_MLNAME_CAST(sipName_Veto), (PyCFunction)meth_wxPropertyGridEvent_Veto, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_Veto)},
    {SIP_MLNAME_CAST(sipName_WasVetoed), meth_wxPropertyGridEvent_WasVetoed, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridEvent_WasVetoed)}
};

sipVariableDef variables_wxPropertyGridEvent[] = {
    {PropertyVariable, sipName_ValidationFailureBehavior, &methods_wxPropertyGridEvent[7], &methods_wxPropertyGridEvent[10], NULL, NULL},
    {PropertyVariable, sipName_PropertyValue, &methods_wxPropertyGridEvent[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_PropertyName, &methods_wxPropertyGridEvent[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Property, &methods_wxPropertyGridEvent[4], &methods_wxPropertyGridEvent[9], NULL, NULL},
    {PropertyVariable, sipName_MainParent, &methods_wxPropertyGridEvent[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_Column, &methods_wxPropertyGridEvent[2], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxPropertyGridEvent, "PropertyGridEvent(commandType=0, id=0)\n"
"PropertyGridEvent(event)\n"
"\n"
"A property grid event holds information about events associated with\n"
"wxPropertyGrid objects.");


sipClassTypeDef sipTypeDef__propgrid_wxPropertyGridEvent = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPropertyGridEvent,
        {0},
        0
    },
    {
        sipNameNr_PropertyGridEvent,
        {0, 0, 1},
        14, methods_wxPropertyGridEvent,
        0, 0,
        6, variables_wxPropertyGridEvent,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPropertyGridEvent,
    -1,
    -1,
    supers_wxPropertyGridEvent,
    0,
    init_type_wxPropertyGridEvent,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPropertyGridEvent,
    0,
    0,
    0,
    release_wxPropertyGridEvent,
    cast_wxPropertyGridEvent,
    0,
    0,
    0,
    0,
    0,
    0
};
