/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"


        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxRichTextAttrArray_append, "append(self, obj: RichTextAttr)");

extern "C" {static PyObject *meth_wxRichTextAttrArray_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttrArray_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAttr* obj;
         ::wxRichTextAttrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextAttrArray, &sipCpp, sipType_wxRichTextAttr, &obj))
        {
        sipCpp->Add(*obj);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAttrArray, sipName_append, doc_wxRichTextAttrArray_append);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAttrArray_index, "index(self, obj: RichTextAttr) -> int");

extern "C" {static PyObject *meth_wxRichTextAttrArray_index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAttrArray_index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAttr* obj;
         ::wxRichTextAttrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextAttrArray, &sipCpp, sipType_wxRichTextAttr, &obj))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

        int idx = sipCpp->Index(*obj, false);
        if (idx == wxNOT_FOUND) {
            sipError = sipErrorFail;
            wxPyErr_SetString(PyExc_ValueError,
                              "sequence.index(x): x not in sequence");
            }
        sipRes = idx;

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return SIPLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAttrArray, sipName_index, doc_wxRichTextAttrArray_index);

    return NULL;
}


extern "C" {static int slot_wxRichTextAttrArray___contains__(PyObject *,PyObject *);}
static int slot_wxRichTextAttrArray___contains__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextAttrArray *sipCpp = reinterpret_cast< ::wxRichTextAttrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextAttrArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAttr* obj;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextAttr, &obj))
        {
            int sipRes = 0;

        int idx = sipCpp->Index(*obj, false);
        sipRes = idx != wxNOT_FOUND;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAttrArray, sipName___contains__, NULL);

    return -1;
}


extern "C" {static PyObject *slot_wxRichTextAttrArray___getitem__(PyObject *,PyObject *);}
static PyObject *slot_wxRichTextAttrArray___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextAttrArray *sipCpp = reinterpret_cast< ::wxRichTextAttrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextAttrArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        long index;

        if (sipParseArgs(&sipParseErr, sipArg, "1l", &index))
        {
             ::wxRichTextAttr*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

            if (0 > index)
                index += sipCpp->GetCount();

            if ((index < sipCpp->GetCount()) && (0 <= index)) {
                sipRes = &sipCpp->Item(index);
            }
            else {
                wxPyErr_SetString(PyExc_IndexError, "sequence index out of range");
                sipError = sipErrorFail;
            }

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes,sipType_wxRichTextAttr,NULL);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAttrArray, sipName___getitem__, NULL);

    return 0;
}


extern "C" {static SIP_SSIZE_T slot_wxRichTextAttrArray___len__(PyObject *);}
static SIP_SSIZE_T slot_wxRichTextAttrArray___len__(PyObject *sipSelf)
{
     ::wxRichTextAttrArray *sipCpp = reinterpret_cast< ::wxRichTextAttrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextAttrArray));

    if (!sipCpp)
        return 0;


    {
        {
            SIP_SSIZE_T sipRes = 0;

        sipRes = sipCpp->GetCount();

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextAttrArray(void *, int);}
static void release_wxRichTextAttrArray(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextAttrArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextAttrArray(void *, SIP_SSIZE_T, void *);}
static void assign_wxRichTextAttrArray(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextAttrArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextAttrArray *>(sipSrc);
}


extern "C" {static void *array_wxRichTextAttrArray(SIP_SSIZE_T);}
static void *array_wxRichTextAttrArray(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextAttrArray[sipNrElem];
}


extern "C" {static void *copy_wxRichTextAttrArray(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextAttrArray(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextAttrArray(reinterpret_cast<const  ::wxRichTextAttrArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextAttrArray(sipSimpleWrapper *);}
static void dealloc_wxRichTextAttrArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextAttrArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextAttrArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextAttrArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextAttrArray *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextAttrArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextAttrArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextAttrArray, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextAttrArray(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextAttrArray[] = {
    {(void *)slot_wxRichTextAttrArray___contains__, contains_slot},
    {(void *)slot_wxRichTextAttrArray___getitem__, getitem_slot},
    {(void *)slot_wxRichTextAttrArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextAttrArray[] = {
    {SIP_MLNAME_CAST(sipName_append), (PyCFunction)meth_wxRichTextAttrArray_append, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAttrArray_append)},
    {SIP_MLNAME_CAST(sipName_index), (PyCFunction)meth_wxRichTextAttrArray_index, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAttrArray_index)}
};

PyDoc_STRVAR(doc_wxRichTextAttrArray, "\1RichTextAttrArray()\n"
"RichTextAttrArray(RichTextAttrArray)");


sipClassTypeDef sipTypeDef__richtext_wxRichTextAttrArray = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextAttrArray,
        {0},
        0
    },
    {
        sipNameNr_RichTextAttrArray,
        {0, 0, 1},
        2, methods_wxRichTextAttrArray,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextAttrArray,
    -1,
    -1,
    0,
    slots_wxRichTextAttrArray,
    init_type_wxRichTextAttrArray,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextAttrArray,
    assign_wxRichTextAttrArray,
    array_wxRichTextAttrArray,
    copy_wxRichTextAttrArray,
    release_wxRichTextAttrArray,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
