/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextctrl.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextctrl.h>
        #include <wx/menu.h>


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_Init, "Init()\n"
"\n"
"Initialisation.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Init(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_Init, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddItem, "AddItem(label, obj) -> bool\n"
"\n"
"Adds an item.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
         ::wxRichTextObject* obj;
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxString,&label, &labelState, sipType_wxRichTextObject, &obj))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddItem(*label,obj);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddItem, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddMenuItems, "AddMenuItems(menu, startCmd=ID_RICHTEXT_PROPERTIES1) -> int\n"
"\n"
"Returns the number of menu items that were added.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMenu* menu;
        int startCmd = wxID_RICHTEXT_PROPERTIES1;
        const  ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
            sipName_startCmd,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|i", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxMenu, &menu, &startCmd))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddMenuItems(menu,startCmd);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddMenuItems, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddItems, "AddItems(ctrl, container, obj) -> int\n"
"\n"
"Adds appropriate menu items for the current container and clicked on\n"
"object (and container's parent, if appropriate).");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItems(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItems(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextCtrl* ctrl;
         ::wxRichTextObject* container;
         ::wxRichTextObject* obj;
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ctrl,
            sipName_container,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J8", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxRichTextCtrl, &ctrl, sipType_wxRichTextObject, &container, sipType_wxRichTextObject, &obj))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddItems(ctrl,container,obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddItems, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_Clear, "Clear()\n"
"\n"
"Clears the items.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetLabel, "GetLabel(n) -> String\n"
"\n"
"Returns the nth label.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
        const  ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, &n))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLabel(n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetObject, "GetObject(n) -> RichTextObject\n"
"\n"
"Returns the nth object.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
        const  ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, &n))
        {
             ::wxRichTextObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetObject(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetObjects, "GetObjects() -> RichTextObjectPtrArray\n"
"\n"
"Returns the array of objects.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObjects(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObjects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
             ::wxRichTextObjectPtrArray*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetObjects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextObjectPtrArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetObjects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetLabels, "GetLabels() -> ArrayString\n"
"\n"
"Returns the array of labels.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabels(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLabels();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetLabels, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetCount, "GetCount() -> int\n"
"\n"
"Returns the number of items.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetCount, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextContextMenuPropertiesInfo(void *, int);}
static void release_wxRichTextContextMenuPropertiesInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextContextMenuPropertiesInfo(void *, SIP_SSIZE_T, void *);}
static void assign_wxRichTextContextMenuPropertiesInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipSrc);
}


extern "C" {static void *array_wxRichTextContextMenuPropertiesInfo(SIP_SSIZE_T);}
static void *array_wxRichTextContextMenuPropertiesInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextContextMenuPropertiesInfo[sipNrElem];
}


extern "C" {static void *copy_wxRichTextContextMenuPropertiesInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextContextMenuPropertiesInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextContextMenuPropertiesInfo(reinterpret_cast<const  ::wxRichTextContextMenuPropertiesInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *);}
static void dealloc_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextContextMenuPropertiesInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextContextMenuPropertiesInfo *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextContextMenuPropertiesInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextContextMenuPropertiesInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextContextMenuPropertiesInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextContextMenuPropertiesInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxRichTextContextMenuPropertiesInfo[] = {
    {SIP_MLNAME_CAST(sipName_AddItem), (PyCFunction)meth_wxRichTextContextMenuPropertiesInfo_AddItem, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_AddItem)},
    {SIP_MLNAME_CAST(sipName_AddItems), (PyCFunction)meth_wxRichTextContextMenuPropertiesInfo_AddItems, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_AddItems)},
    {SIP_MLNAME_CAST(sipName_AddMenuItems), (PyCFunction)meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_AddMenuItems)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxRichTextContextMenuPropertiesInfo_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_Clear)},
    {SIP_MLNAME_CAST(sipName_GetCount), meth_wxRichTextContextMenuPropertiesInfo_GetCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_GetCount)},
    {SIP_MLNAME_CAST(sipName_GetLabel), (PyCFunction)meth_wxRichTextContextMenuPropertiesInfo_GetLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_GetLabel)},
    {SIP_MLNAME_CAST(sipName_GetLabels), meth_wxRichTextContextMenuPropertiesInfo_GetLabels, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_GetLabels)},
    {SIP_MLNAME_CAST(sipName_GetObject), (PyCFunction)meth_wxRichTextContextMenuPropertiesInfo_GetObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_GetObject)},
    {SIP_MLNAME_CAST(sipName_GetObjects), meth_wxRichTextContextMenuPropertiesInfo_GetObjects, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_GetObjects)},
    {SIP_MLNAME_CAST(sipName_Init), meth_wxRichTextContextMenuPropertiesInfo_Init, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextContextMenuPropertiesInfo_Init)}
};


extern "C" {static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_labels(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_labels(void *sipSelf, PyObject *, PyObject *)
{
     ::wxArrayString*sipVal;
     ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    sipVal = &sipCpp->m_labels;

    return sipConvertFromType(sipVal, sipType_wxArrayString, NULL);
}


extern "C" {static int varset_wxRichTextContextMenuPropertiesInfo_m_labels(void *, PyObject *, PyObject *);}
static int varset_wxRichTextContextMenuPropertiesInfo_m_labels(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxArrayString*sipVal;
     ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxArrayString *>(sipForceConvertToType(sipPy,sipType_wxArrayString,NULL,SIP_NOT_NONE,&sipValState,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_labels = *sipVal;

    sipReleaseType(sipVal, sipType_wxArrayString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_objects(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_objects(void *sipSelf, PyObject *, PyObject *)
{
     ::wxRichTextObjectPtrArray*sipVal;
     ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    sipVal = &sipCpp->m_objects;

    return sipConvertFromType(sipVal, sipType_wxRichTextObjectPtrArray, NULL);
}


extern "C" {static int varset_wxRichTextContextMenuPropertiesInfo_m_objects(void *, PyObject *, PyObject *);}
static int varset_wxRichTextContextMenuPropertiesInfo_m_objects(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxRichTextObjectPtrArray*sipVal;
     ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast< ::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipForceConvertToType(sipPy,sipType_wxRichTextObjectPtrArray,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_objects = *sipVal;

    return 0;
}

sipVariableDef variables_wxRichTextContextMenuPropertiesInfo[] = {
    {PropertyVariable, sipName_Objects, &methods_wxRichTextContextMenuPropertiesInfo[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Labels, &methods_wxRichTextContextMenuPropertiesInfo[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_Count, &methods_wxRichTextContextMenuPropertiesInfo[4], NULL, NULL, NULL},
    {InstanceVariable, sipName_m_labels, (PyMethodDef *)varget_wxRichTextContextMenuPropertiesInfo_m_labels, (PyMethodDef *)varset_wxRichTextContextMenuPropertiesInfo_m_labels, NULL, NULL},
    {InstanceVariable, sipName_m_objects, (PyMethodDef *)varget_wxRichTextContextMenuPropertiesInfo_m_objects, (PyMethodDef *)varset_wxRichTextContextMenuPropertiesInfo_m_objects, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo, "RichTextContextMenuPropertiesInfo()\n"
"\n"
"wxRichTextContextMenuPropertiesInfo keeps track of objects that appear\n"
"in the context menu, whose properties are available to be edited.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextContextMenuPropertiesInfo = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextContextMenuPropertiesInfo,
        {0},
        0
    },
    {
        sipNameNr_RichTextContextMenuPropertiesInfo,
        {0, 0, 1},
        10, methods_wxRichTextContextMenuPropertiesInfo,
        0, 0,
        5, variables_wxRichTextContextMenuPropertiesInfo,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextContextMenuPropertiesInfo,
    -1,
    -1,
    0,
    0,
    init_type_wxRichTextContextMenuPropertiesInfo,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextContextMenuPropertiesInfo,
    assign_wxRichTextContextMenuPropertiesInfo,
    array_wxRichTextContextMenuPropertiesInfo,
    copy_wxRichTextContextMenuPropertiesInfo,
    release_wxRichTextContextMenuPropertiesInfo,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
