/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

    int _wxTextAttrDimension___nonzero__(wxTextAttrDimension* self)
    {
        return self->IsValid();
    }


PyDoc_STRVAR(doc_wxTextAttrDimension_Reset, "Reset()\n"
"\n"
"Resets the dimension value and flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_Reset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_EqPartial, "EqPartial(dim, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxTextAttrDimension_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension* dim;
        bool weakTest = 1;
        const  ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*dim,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_EqPartial, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_Apply, "Apply(dim, compareWith=None) -> bool\n"
"\n"
"Apply the dimension, but not those identical to compareWith if\n"
"present.");

extern "C" {static PyObject *meth_wxTextAttrDimension_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension* dim;
        const  ::wxTextAttrDimension* compareWith = 0;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J8", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim, sipType_wxTextAttrDimension, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*dim,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_Apply, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr)\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxTextAttrDimension_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension* attr;
         ::wxTextAttrDimension* clashingAttr;
         ::wxTextAttrDimension* absentAttr;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J9J9", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &attr, sipType_wxTextAttrDimension, &clashingAttr, sipType_wxTextAttrDimension, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr,*clashingAttr,*absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_CollectCommonAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetValue, "GetValue() -> int\n"
"\n"
"Returns the integer value of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetValueMM, "GetValueMM() -> float\n"
"\n"
"Returns the floating-pointing value of the dimension in mm.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetValueMM(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetValueMM(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            float sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValueMM();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetValueMM, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValueMM, "SetValueMM(value)\n"
"\n"
"Sets the value of the dimension in mm.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValueMM(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValueMM(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        float value;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bf", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValueMM(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValueMM, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValue, "SetValue(value)\n"
"SetValue(value, flags)\n"
"SetValue(dim)\n"
"\n"
"Sets the integer value of the dimension.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int value;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int value;
         ::wxTextAttrDimensionFlags flags;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bit", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(value,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxTextAttrDimension* dim;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetUnits, "GetUnits() -> TextAttrUnits\n"
"\n"
"Gets the units of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetUnits(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetUnits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
             ::wxTextAttrUnits sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUnits();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextAttrUnits);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetUnits, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetUnits, "SetUnits(units)\n"
"\n"
"Sets the units of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetUnits(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetUnits(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextAttrUnits units;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_units,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrUnits, &units))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUnits(units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetUnits, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetPosition, "GetPosition() -> TextBoxAttrPosition\n"
"\n"
"Gets the position flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
             ::wxTextBoxAttrPosition sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrPosition);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetPosition, "SetPosition(pos)\n"
"\n"
"Sets the position flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrPosition pos;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextBoxAttrPosition, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the dimension is valid.");

extern "C" {static PyObject *meth_wxTextAttrDimension_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_IsValid, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValid, "SetValid(b)\n"
"\n"
"Sets the valid flag.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool b;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValid(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValid, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetFlags, "GetFlags() -> TextAttrDimensionFlags\n"
"\n"
"Gets the dimension flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
             ::wxTextAttrDimensionFlags sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

#if PY_MAJOR_VERSION >= 3
            return PyLong_FromUnsignedLong(sipRes);
#else
            return PyInt_FromLong(sipRes);
#endif
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets the dimension flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextAttrDimensionFlags flags;
         ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bt", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetFlags, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxTextAttrDimension___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrDimension___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrDimension));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension* dim;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrDimension, &dim))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxTextAttrDimension::operator==(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextAttrDimension, sipSelf, sipArg);
}


extern "C" {static int slot_wxTextAttrDimension___nonzero__(PyObject *);}
static int slot_wxTextAttrDimension___nonzero__(PyObject *sipSelf)
{
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrDimension));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxTextAttrDimension___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxTextAttrDimension___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrDimension___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrDimension));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrDimension* dim;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrDimension, &dim))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTextAttrDimension::operator==(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextAttrDimension, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttrDimension(void *, int);}
static void release_wxTextAttrDimension(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttrDimension *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextAttrDimension(void *, SIP_SSIZE_T, void *);}
static void assign_wxTextAttrDimension(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttrDimension *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttrDimension *>(sipSrc);
}


extern "C" {static void *array_wxTextAttrDimension(SIP_SSIZE_T);}
static void *array_wxTextAttrDimension(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxTextAttrDimension[sipNrElem];
}


extern "C" {static void *copy_wxTextAttrDimension(const void *, SIP_SSIZE_T);}
static void *copy_wxTextAttrDimension(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxTextAttrDimension(reinterpret_cast<const  ::wxTextAttrDimension *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttrDimension(sipSimpleWrapper *);}
static void dealloc_wxTextAttrDimension(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttrDimension(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttrDimension(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttrDimension(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextAttrDimension *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrDimension();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        int value;
         ::wxTextAttrUnits units = wxTEXT_ATTR_UNITS_TENTHS_MM;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_units,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "i|E", &value, sipType_wxTextAttrUnits, &units))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrDimension(value,units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextAttrDimension* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxTextAttrDimension, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrDimension(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextAttrDimension[] = {
    {(void *)slot_wxTextAttrDimension___ne__, ne_slot},
    {(void *)slot_wxTextAttrDimension___nonzero__, bool_slot},
    {(void *)slot_wxTextAttrDimension___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextAttrDimension[] = {
    {SIP_MLNAME_CAST(sipName_Apply), (PyCFunction)meth_wxTextAttrDimension_Apply, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_Apply)},
    {SIP_MLNAME_CAST(sipName_CollectCommonAttributes), (PyCFunction)meth_wxTextAttrDimension_CollectCommonAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_CollectCommonAttributes)},
    {SIP_MLNAME_CAST(sipName_EqPartial), (PyCFunction)meth_wxTextAttrDimension_EqPartial, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_EqPartial)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxTextAttrDimension_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxTextAttrDimension_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetUnits), meth_wxTextAttrDimension_GetUnits, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_GetUnits)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxTextAttrDimension_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_GetValue)},
    {SIP_MLNAME_CAST(sipName_GetValueMM), meth_wxTextAttrDimension_GetValueMM, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_GetValueMM)},
    {SIP_MLNAME_CAST(sipName_IsValid), meth_wxTextAttrDimension_IsValid, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_IsValid)},
    {SIP_MLNAME_CAST(sipName_Reset), meth_wxTextAttrDimension_Reset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_Reset)},
    {SIP_MLNAME_CAST(sipName_SetFlags), (PyCFunction)meth_wxTextAttrDimension_SetFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetPosition), (PyCFunction)meth_wxTextAttrDimension_SetPosition, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetPosition)},
    {SIP_MLNAME_CAST(sipName_SetUnits), (PyCFunction)meth_wxTextAttrDimension_SetUnits, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetUnits)},
    {SIP_MLNAME_CAST(sipName_SetValid), (PyCFunction)meth_wxTextAttrDimension_SetValid, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetValid)},
    {SIP_MLNAME_CAST(sipName_SetValue), (PyCFunction)meth_wxTextAttrDimension_SetValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetValue)},
    {SIP_MLNAME_CAST(sipName_SetValueMM), (PyCFunction)meth_wxTextAttrDimension_SetValueMM, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrDimension_SetValueMM)}
};


extern "C" {static PyObject *varget_wxTextAttrDimension_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimension_m_flags(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimensionFlags sipVal;
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipCpp->m_flags;

#if PY_MAJOR_VERSION >= 3
    return PyLong_FromUnsignedLong(sipVal);
#else
    return PyInt_FromLong(sipVal);
#endif
}


extern "C" {static int varset_wxTextAttrDimension_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimension_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensionFlags sipVal;
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipLong_AsUnsignedShort(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrDimension_m_value(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimension_m_value(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipCpp->m_value;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrDimension_m_value(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimension_m_value(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_value = sipVal;

    return 0;
}

sipVariableDef variables_wxTextAttrDimension[] = {
    {PropertyVariable, sipName_ValueMM, &methods_wxTextAttrDimension[7], &methods_wxTextAttrDimension[15], NULL, NULL},
    {PropertyVariable, sipName_Value, &methods_wxTextAttrDimension[6], &methods_wxTextAttrDimension[14], NULL, NULL},
    {PropertyVariable, sipName_Units, &methods_wxTextAttrDimension[5], &methods_wxTextAttrDimension[12], NULL, NULL},
    {PropertyVariable, sipName_Position, &methods_wxTextAttrDimension[4], &methods_wxTextAttrDimension[11], NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxTextAttrDimension[3], &methods_wxTextAttrDimension[10], NULL, NULL},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextAttrDimension_m_flags, (PyMethodDef *)varset_wxTextAttrDimension_m_flags, NULL, NULL},
    {InstanceVariable, sipName_m_value, (PyMethodDef *)varget_wxTextAttrDimension_m_value, (PyMethodDef *)varset_wxTextAttrDimension_m_value, NULL, NULL},
};

PyDoc_STRVAR(doc_wxTextAttrDimension, "TextAttrDimension()\n"
"TextAttrDimension(value, units=TEXT_ATTR_UNITS_TENTHS_MM)\n"
"\n"
"A class representing a rich text dimension, including units and\n"
"position.");


sipClassTypeDef sipTypeDef__richtext_wxTextAttrDimension = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttrDimension,
        {0},
        0
    },
    {
        sipNameNr_TextAttrDimension,
        {0, 0, 1},
        16, methods_wxTextAttrDimension,
        0, 0,
        7, variables_wxTextAttrDimension,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxTextAttrDimension,
    -1,
    -1,
    0,
    slots_wxTextAttrDimension,
    init_type_wxTextAttrDimension,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxTextAttrDimension,
    assign_wxTextAttrDimension,
    array_wxTextAttrDimension,
    copy_wxTextAttrDimension,
    release_wxTextAttrDimension,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
