/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_xrc.h"

        #include <wx/xrc/xmlres.h>

        #include <wx/toolbar.h>
        #include <wx/window.h>
        #include <wx/panel.h>
        #include <wx/menu.h>
        #include <wx/icon.h>
        #include <wx/frame.h>
        #include <wx/dialog.h>
        #include <wx/bitmap.h>
        #include <wx/xml/xml.h>
        #include <wx/xrc/xmlres.h>
        #include <wx/object.h>
        #include <wx/menu.h>
        #include <wx/object.h>
        #include <wx/object.h>
    bool _wxXmlResource_LoadFromBuffer(wxXmlResource* self, wxPyBuffer* data)
    {
        static int s_memFileIdx = 0;
        
        // Check for memory FS. If not present, load the handler:
        wxMemoryFSHandler::AddFile(wxT("XRC_resource/dummy_file"),
                                   wxT("dummy data"));
        wxFileSystem fsys;
        wxFSFile *f = fsys.OpenFile(wxT("memory:XRC_resource/dummy_file"));
        wxMemoryFSHandler::RemoveFile(wxT("XRC_resource/dummy_file"));
        if (f)
            delete f;
        else
            wxFileSystem::AddHandler(new wxMemoryFSHandler);
        
        // Now put the resource data into the memory FS
        wxString filename(wxT("XRC_resource/data_string_"));
        filename << s_memFileIdx;
        s_memFileIdx += 1;
        wxMemoryFSHandler::AddFile(filename, data->m_ptr, data->m_len);
        
        // Load the "file" into the resource object
        bool retval = self->Load(wxT("memory:") + filename );
        return retval;
    }


class sipwxXmlResource : public  ::wxXmlResource
{
public:
    sipwxXmlResource(const  ::wxString&,int,const  ::wxString&);
    sipwxXmlResource(int,const  ::wxString&);
    ~sipwxXmlResource();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxXmlResource(const sipwxXmlResource &);
    sipwxXmlResource &operator = (const sipwxXmlResource &);
};

sipwxXmlResource::sipwxXmlResource(const  ::wxString& filemask,int flags,const  ::wxString& domain):  ::wxXmlResource(filemask,flags,domain), sipPySelf(0)
{
}

sipwxXmlResource::sipwxXmlResource(int flags,const  ::wxString& domain):  ::wxXmlResource(flags,domain), sipPySelf(0)
{
}

sipwxXmlResource::~sipwxXmlResource()
{
    sipInstanceDestroyed(sipPySelf);
}


PyDoc_STRVAR(doc_wxXmlResource_LoadMenuBar, "LoadMenuBar(parent, name) -> MenuBar\n"
"LoadMenuBar(name) -> MenuBar\n"
"\n"
"Loads a menubar from resource.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadMenuBar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadMenuBar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
             ::wxMenuBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenuBar(parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenuBar,NULL);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxMenuBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenuBar(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenuBar,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadMenuBar, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadObject, "LoadObject(parent, name, classname) -> Object\n"
"LoadObject(instance, parent, name, classname) -> bool\n"
"\n"
"Load an object from the resource specifying both the resource name and\n"
"the class name.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* classname;
        int classnameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState, sipType_wxString,&classname, &classnameState))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObject(parent,*name,*classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(classname),sipType_wxString,classnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,NULL);
        }
    }

    {
         ::wxObject* instance;
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* classname;
        int classnameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_instance,
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxObject, &instance, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState, sipType_wxString,&classname, &classnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObject(instance,parent,*name,*classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(classname),sipType_wxString,classnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadObjectRecursively, "LoadObjectRecursively(parent, name, classname) -> Object\n"
"LoadObjectRecursively(instance, parent, name, classname) -> bool\n"
"\n"
"Load an object from anywhere in the resource tree.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadObjectRecursively(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadObjectRecursively(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* classname;
        int classnameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState, sipType_wxString,&classname, &classnameState))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObjectRecursively(parent,*name,*classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(classname),sipType_wxString,classnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,NULL);
        }
    }

    {
         ::wxObject* instance;
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* classname;
        int classnameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_instance,
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxObject, &instance, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState, sipType_wxString,&classname, &classnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObjectRecursively(instance,parent,*name,*classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(classname),sipType_wxString,classnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadObjectRecursively, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_AddHandler, "AddHandler(handler)\n"
"\n"
"Initializes only a specific handler (or custom handler).");

extern "C" {static PyObject *meth_wxXmlResource_AddHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AddHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlResourceHandler* handler;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxXmlResourceHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AddHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_InsertHandler, "InsertHandler(handler)\n"
"\n"
"Add a new handler at the begining of the handler list.");

extern "C" {static PyObject *meth_wxXmlResource_InsertHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_InsertHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlResourceHandler* handler;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxXmlResourceHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->InsertHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_InsertHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_AttachUnknownControl, "AttachUnknownControl(name, control, parent=None) -> bool\n"
"\n"
"Attaches an unknown control to the given panel/window/dialog.");

extern "C" {static PyObject *meth_wxXmlResource_AttachUnknownControl(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AttachUnknownControl(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxWindow* control;
         ::wxWindow* parent = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_control,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8|J8", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxWindow, &control, sipType_wxWindow, &parent))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AttachUnknownControl(*name,control,parent);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AttachUnknownControl, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_ClearHandlers, "ClearHandlers()\n"
"\n"
"Removes all handlers and deletes them (this means that any handlers\n"
"added using AddHandler() must be allocated on the heap).");

extern "C" {static PyObject *meth_wxXmlResource_ClearHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_ClearHandlers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_ClearHandlers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_CompareVersion, "CompareVersion(major, minor, release, revision) -> int\n"
"\n"
"Compares the XRC version to the argument.");

extern "C" {static PyObject *meth_wxXmlResource_CompareVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_CompareVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int major;
        int minor;
        int release;
        int revision;
        const  ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_release,
            sipName_revision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biiii", &sipSelf, sipType_wxXmlResource, &sipCpp, &major, &minor, &release, &revision))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CompareVersion(major,minor,release,revision);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_CompareVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_GetDomain, "GetDomain() -> String\n"
"\n"
"Returns the domain (message catalog) that will be used to load\n"
"translatable strings in the XRC.");

extern "C" {static PyObject *meth_wxXmlResource_GetDomain(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetDomain(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDomain());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetDomain, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns flags, which may be a bitlist of wxXmlResourceFlags\n"
"enumeration values.");

extern "C" {static PyObject *meth_wxXmlResource_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_GetResourceNode, "GetResourceNode(name) -> XmlNode\n"
"\n"
"Returns the wxXmlNode containing the definition of the object with the\n"
"given name or NULL.");

extern "C" {static PyObject *meth_wxXmlResource_GetResourceNode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetResourceNode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState))
        {
            const  ::wxXmlNode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetResourceNode(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxXmlNode *>(sipRes),sipType_wxXmlNode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetResourceNode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_GetVersion, "GetVersion() -> long\n"
"\n"
"Returns version information (a.b.c.d = d + 256*c + 2562*b + 2563*a).");

extern "C" {static PyObject *meth_wxXmlResource_GetVersion(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_InitAllHandlers, "InitAllHandlers()\n"
"\n"
"Initializes handlers for all supported controls/windows.");

extern "C" {static PyObject *meth_wxXmlResource_InitAllHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_InitAllHandlers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->InitAllHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_InitAllHandlers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_Load, "Load(filemask) -> bool\n"
"\n"
"Loads resources from XML files that match given filemask.");

extern "C" {static PyObject *meth_wxXmlResource_Load(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Load(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* filemask;
        int filemaskState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filemask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&filemask, &filemaskState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Load(*filemask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filemask),sipType_wxString,filemaskState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Load, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFile, "LoadFile(file) -> bool\n"
"\n"
"Simpler form of Load() for loading a single XRC file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileName* file;
        int fileState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxFileName,&file, &fileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(file),sipType_wxFileName,fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadAllFiles, "LoadAllFiles(dirname) -> bool\n"
"\n"
"Loads all .xrc files from directory dirname.");

extern "C" {static PyObject *meth_wxXmlResource_LoadAllFiles(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadAllFiles(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* dirname;
        int dirnameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dirname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&dirname, &dirnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadAllFiles(*dirname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(dirname),sipType_wxString,dirnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadAllFiles, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadBitmap, "LoadBitmap(name) -> Bitmap\n"
"\n"
"Loads a bitmap resource from a file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->LoadBitmap(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadDialog, "LoadDialog(parent, name) -> Dialog\n"
"LoadDialog(dlg, parent, name) -> bool\n"
"\n"
"Loads a dialog.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadDialog(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadDialog(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
             ::wxDialog*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadDialog(parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDialog,NULL);
        }
    }

    {
         ::wxDialog* dlg;
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dlg,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxDialog, &dlg, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadDialog(dlg,parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadDialog, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFrame, "LoadFrame(parent, name) -> Frame\n"
"LoadFrame(frame, parent, name) -> bool\n"
"\n"
"Loads a frame from the resource.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadFrame(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFrame(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
             ::wxFrame*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFrame(parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFrame,NULL);
        }
    }

    {
         ::wxFrame* frame;
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_frame,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxFrame, &frame, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFrame(frame,parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFrame, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadIcon, "LoadIcon(name) -> Icon\n"
"\n"
"Loads an icon resource from a file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->LoadIcon(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadMenu, "LoadMenu(name) -> Menu\n"
"\n"
"Loads menu from resource.");

extern "C" {static PyObject *meth_wxXmlResource_LoadMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenu(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadPanel, "LoadPanel(parent, name) -> Panel\n"
"LoadPanel(panel, parent, name) -> bool\n"
"\n"
"Loads a panel.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadPanel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadPanel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
             ::wxPanel*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadPanel(parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPanel,NULL);
        }
    }

    {
         ::wxPanel* panel;
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_panel,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxPanel, &panel, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadPanel(panel,parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadPanel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadToolBar, "LoadToolBar(parent, name) -> ToolBar\n"
"\n"
"Loads a toolbar.");

extern "C" {static PyObject *meth_wxXmlResource_LoadToolBar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadToolBar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* parent;
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString,&name, &nameState))
        {
             ::wxToolBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadToolBar(parent,*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxToolBar,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadToolBar, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_SetDomain, "SetDomain(domain)\n"
"\n"
"Sets the domain (message catalog) that will be used to load\n"
"translatable strings in the XRC.");

extern "C" {static PyObject *meth_wxXmlResource_SetDomain(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_SetDomain(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* domain;
        int domainState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&domain, &domainState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDomain(*domain);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_SetDomain, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets flags (bitlist of wxXmlResourceFlags enumeration values).");

extern "C" {static PyObject *meth_wxXmlResource_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxXmlResource, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_SetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_Unload, "Unload(filename) -> bool\n"
"\n"
"This function unloads a resource previously loaded by Load().");

extern "C" {static PyObject *meth_wxXmlResource_Unload(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Unload(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Unload(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Unload, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_AddSubclassFactory, "AddSubclassFactory(factory)\n"
"\n"
"Registers subclasses factory for use in XRC.");

extern "C" {static PyObject *meth_wxXmlResource_AddSubclassFactory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AddSubclassFactory(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlSubclassFactory* factory;

        static const char *sipKwdList[] = {
            sipName_factory,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxXmlSubclassFactory, &factory))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxXmlResource::AddSubclassFactory(factory);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AddSubclassFactory, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_FindXRCIDById, "FindXRCIDById(numId) -> String\n"
"\n"
"Returns a string ID corresponding to the given numeric ID.");

extern "C" {static PyObject *meth_wxXmlResource_FindXRCIDById(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_FindXRCIDById(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int numId;

        static const char *sipKwdList[] = {
            sipName_numId,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &numId))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxXmlResource::FindXRCIDById(numId));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_FindXRCIDById, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_Get, "Get() -> XmlResource\n"
"\n"
"Gets the global resources object or creates one if none exists.");

extern "C" {static PyObject *meth_wxXmlResource_Get(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxXmlResource*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxXmlResource::Get();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlResource,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Get, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_GetXRCID, "GetXRCID(str_id, value_if_not_found=ID_NONE) -> int\n"
"\n"
"Returns a numeric ID that is equivalent to the string ID used in an\n"
"XML resource.");

extern "C" {static PyObject *meth_wxXmlResource_GetXRCID(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetXRCID(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* str_id;
        int str_idState = 0;
        int value_if_not_found = wxID_NONE;

        static const char *sipKwdList[] = {
            sipName_str_id,
            sipName_value_if_not_found,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|i", sipType_wxString,&str_id, &str_idState, &value_if_not_found))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxXmlResource::GetXRCID(*str_id,value_if_not_found);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str_id),sipType_wxString,str_idState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetXRCID, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_Set, "Set(res) -> XmlResource\n"
"\n"
"Sets the global resources object and returns a pointer to the previous\n"
"one (may be NULL).");

extern "C" {static PyObject *meth_wxXmlResource_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Set(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlResource* res;

        static const char *sipKwdList[] = {
            sipName_res,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxXmlResource, &res))
        {
             ::wxXmlResource*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxXmlResource::Set(res);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlResource,Py_None);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFromBuffer, "LoadFromBuffer(data) -> bool\n"
"\n"
"Load the resource from a bytes string or other data buffer compatible\n"
"object.");

extern "C" {static PyObject *meth_wxXmlResource_LoadFromBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFromBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxPyBuffer,&data, &dataState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxXmlResource_LoadFromBuffer(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data,sipType_wxPyBuffer,dataState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFromBuffer, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxXmlResource(void *, const sipTypeDef *);}
static void *cast_wxXmlResource(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxXmlResource *sipCpp = reinterpret_cast< ::wxXmlResource *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxXmlResource(void *, int);}
static void release_wxXmlResource(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxXmlResource *>(sipCppV);
    else
        delete reinterpret_cast< ::wxXmlResource *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxXmlResource(sipSimpleWrapper *);}
static void dealloc_wxXmlResource(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxXmlResource *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxXmlResource(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxXmlResource(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxXmlResource(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxXmlResource *sipCpp = 0;

    {
        const  ::wxString* filemask;
        int filemaskState = 0;
        int flags = wxXRC_USE_LOCALE;
        const  ::wxString& domaindef = wxEmptyString;
        const  ::wxString* domain = &domaindef;
        int domainState = 0;

        static const char *sipKwdList[] = {
            sipName_filemask,
            sipName_flags,
            sipName_domain,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|iJ1", sipType_wxString,&filemask, &filemaskState, &flags, sipType_wxString,&domain, &domainState))
        {
        Py_BEGIN_ALLOW_THREADS
        sipCpp = new sipwxXmlResource(*filemask,flags,*domain);
        sipCpp->InitAllHandlers();
        Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filemask),sipType_wxString,filemaskState);
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int flags = wxXRC_USE_LOCALE;
        const  ::wxString& domaindef = wxEmptyString;
        const  ::wxString* domain = &domaindef;
        int domainState = 0;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_domain,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iJ1", &flags, sipType_wxString,&domain, &domainState))
        {
        Py_BEGIN_ALLOW_THREADS
        sipCpp = new sipwxXmlResource(flags,*domain);
        sipCpp->InitAllHandlers();
        Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxXmlResource[] = {{13, 0, 1}};


static PyMethodDef methods_wxXmlResource[] = {
    {SIP_MLNAME_CAST(sipName_AddHandler), (PyCFunction)meth_wxXmlResource_AddHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_AddHandler)},
    {SIP_MLNAME_CAST(sipName_AddSubclassFactory), (PyCFunction)meth_wxXmlResource_AddSubclassFactory, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_AddSubclassFactory)},
    {SIP_MLNAME_CAST(sipName_AttachUnknownControl), (PyCFunction)meth_wxXmlResource_AttachUnknownControl, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_AttachUnknownControl)},
    {SIP_MLNAME_CAST(sipName_ClearHandlers), meth_wxXmlResource_ClearHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_ClearHandlers)},
    {SIP_MLNAME_CAST(sipName_CompareVersion), (PyCFunction)meth_wxXmlResource_CompareVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_CompareVersion)},
    {SIP_MLNAME_CAST(sipName_FindXRCIDById), (PyCFunction)meth_wxXmlResource_FindXRCIDById, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_FindXRCIDById)},
    {SIP_MLNAME_CAST(sipName_Get), meth_wxXmlResource_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_Get)},
    {SIP_MLNAME_CAST(sipName_GetDomain), meth_wxXmlResource_GetDomain, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_GetDomain)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxXmlResource_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetResourceNode), (PyCFunction)meth_wxXmlResource_GetResourceNode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_GetResourceNode)},
    {SIP_MLNAME_CAST(sipName_GetVersion), meth_wxXmlResource_GetVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_GetVersion)},
    {SIP_MLNAME_CAST(sipName_GetXRCID), (PyCFunction)meth_wxXmlResource_GetXRCID, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_GetXRCID)},
    {SIP_MLNAME_CAST(sipName_InitAllHandlers), meth_wxXmlResource_InitAllHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlResource_InitAllHandlers)},
    {SIP_MLNAME_CAST(sipName_InsertHandler), (PyCFunction)meth_wxXmlResource_InsertHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_InsertHandler)},
    {SIP_MLNAME_CAST(sipName_Load), (PyCFunction)meth_wxXmlResource_Load, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_Load)},
    {SIP_MLNAME_CAST(sipName_LoadAllFiles), (PyCFunction)meth_wxXmlResource_LoadAllFiles, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadAllFiles)},
    {SIP_MLNAME_CAST(sipName_LoadBitmap), (PyCFunction)meth_wxXmlResource_LoadBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadBitmap)},
    {SIP_MLNAME_CAST(sipName_LoadDialog), (PyCFunction)meth_wxXmlResource_LoadDialog, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadDialog)},
    {SIP_MLNAME_CAST(sipName_LoadFile), (PyCFunction)meth_wxXmlResource_LoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadFile)},
    {SIP_MLNAME_CAST(sipName_LoadFrame), (PyCFunction)meth_wxXmlResource_LoadFrame, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadFrame)},
    {SIP_MLNAME_CAST(sipName_LoadFromBuffer), (PyCFunction)meth_wxXmlResource_LoadFromBuffer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadFromBuffer)},
    {SIP_MLNAME_CAST(sipName_LoadIcon), (PyCFunction)meth_wxXmlResource_LoadIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadIcon)},
    {SIP_MLNAME_CAST(sipName_LoadMenu), (PyCFunction)meth_wxXmlResource_LoadMenu, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadMenu)},
    {SIP_MLNAME_CAST(sipName_LoadMenuBar), (PyCFunction)meth_wxXmlResource_LoadMenuBar, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadMenuBar)},
    {SIP_MLNAME_CAST(sipName_LoadObject), (PyCFunction)meth_wxXmlResource_LoadObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadObject)},
    {SIP_MLNAME_CAST(sipName_LoadObjectRecursively), (PyCFunction)meth_wxXmlResource_LoadObjectRecursively, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadObjectRecursively)},
    {SIP_MLNAME_CAST(sipName_LoadPanel), (PyCFunction)meth_wxXmlResource_LoadPanel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadPanel)},
    {SIP_MLNAME_CAST(sipName_LoadToolBar), (PyCFunction)meth_wxXmlResource_LoadToolBar, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_LoadToolBar)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxXmlResource_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_Set)},
    {SIP_MLNAME_CAST(sipName_SetDomain), (PyCFunction)meth_wxXmlResource_SetDomain, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_SetDomain)},
    {SIP_MLNAME_CAST(sipName_SetFlags), (PyCFunction)meth_wxXmlResource_SetFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_SetFlags)},
    {SIP_MLNAME_CAST(sipName_Unload), (PyCFunction)meth_wxXmlResource_Unload, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlResource_Unload)}
};

sipVariableDef variables_wxXmlResource[] = {
    {PropertyVariable, sipName_Version, &methods_wxXmlResource[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxXmlResource[8], &methods_wxXmlResource[30], NULL, NULL},
    {PropertyVariable, sipName_Domain, &methods_wxXmlResource[7], &methods_wxXmlResource[29], NULL, NULL},
};

PyDoc_STRVAR(doc_wxXmlResource, "XmlResource(filemask, flags=XRC_USE_LOCALE, domain=wx.EmptyString)\n"
"XmlResource(flags=XRC_USE_LOCALE, domain=wx.EmptyString)\n"
"\n"
"This is the main class for interacting with the XML-based resource\n"
"system.");


sipClassTypeDef sipTypeDef__xrc_wxXmlResource = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxXmlResource,
        {0},
        0
    },
    {
        sipNameNr_XmlResource,
        {0, 0, 1},
        32, methods_wxXmlResource,
        0, 0,
        3, variables_wxXmlResource,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxXmlResource,
    -1,
    -1,
    supers_wxXmlResource,
    0,
    init_type_wxXmlResource,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxXmlResource,
    0,
    0,
    0,
    release_wxXmlResource,
    cast_wxXmlResource,
    0,
    0,
    0,
    0,
    0,
    0
};
