from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.add_team_member_request_role import AddTeamMemberRequestRole
from ..types import UNSET, Unset

T = TypeVar("T", bound="AddTeamMemberRequest")


@_attrs_define
class AddTeamMemberRequest:
    """
    Attributes:
        user_id (int):  Example: 1.
        role (Union[Unset, AddTeamMemberRequestRole]):  Default: AddTeamMemberRequestRole.MEMBER. Example: member.
    """

    user_id: int
    role: Union[Unset, AddTeamMemberRequestRole] = AddTeamMemberRequestRole.MEMBER
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        user_id = self.user_id

        role: Union[Unset, str] = UNSET
        if not isinstance(self.role, Unset):
            role = self.role.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "user_id": user_id,
            }
        )
        if role is not UNSET:
            field_dict["role"] = role

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        user_id = d.pop("user_id")

        _role = d.pop("role", UNSET)
        role: Union[Unset, AddTeamMemberRequestRole]
        if isinstance(_role, Unset):
            role = UNSET
        else:
            role = AddTeamMemberRequestRole(_role)

        add_team_member_request = cls(
            user_id=user_id,
            role=role,
        )

        add_team_member_request.additional_properties = d
        return add_team_member_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
