"""
    The version of the XENDIT API: 2.91.2
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.payment_method.model.billing_information import BillingInformation
from xendit.payment_method.model.card import Card
from xendit.payment_method.model.direct_debit import DirectDebit
from xendit.payment_method.model.e_wallet import EWallet
from xendit.payment_method.model.over_the_counter import OverTheCounter
from xendit.payment_method.model.payment_method_action import PaymentMethodAction
from xendit.payment_method.model.payment_method_country import PaymentMethodCountry
from xendit.payment_method.model.payment_method_reusability import PaymentMethodReusability
from xendit.payment_method.model.payment_method_status import PaymentMethodStatus
from xendit.payment_method.model.payment_method_type import PaymentMethodType
from xendit.payment_method.model.qr_code import QRCode
from xendit.payment_method.model.virtual_account import VirtualAccount
globals()['BillingInformation'] = BillingInformation
globals()['Card'] = Card
globals()['DirectDebit'] = DirectDebit
globals()['EWallet'] = EWallet
globals()['OverTheCounter'] = OverTheCounter
globals()['PaymentMethodAction'] = PaymentMethodAction
globals()['PaymentMethodCountry'] = PaymentMethodCountry
globals()['PaymentMethodReusability'] = PaymentMethodReusability
globals()['PaymentMethodStatus'] = PaymentMethodStatus
globals()['PaymentMethodType'] = PaymentMethodType
globals()['QRCode'] = QRCode
globals()['VirtualAccount'] = VirtualAccount

def lazy_import():
    pass

class PaymentMethod(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'business_id': (str, none_type),  # noqa: E501
            'type': (PaymentMethodType, none_type),  # noqa: E501
            'country': (PaymentMethodCountry, none_type),  # noqa: E501
            'customer_id': (str, none_type, none_type),  # noqa: E501
            'customer': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type, none_type),  # noqa: E501
            'reference_id': (str, none_type),  # noqa: E501
            'description': (str, none_type, none_type),  # noqa: E501
            'status': (PaymentMethodStatus, none_type),  # noqa: E501
            'reusability': (PaymentMethodReusability, none_type),  # noqa: E501
            'actions': ([PaymentMethodAction], none_type),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type, none_type),  # noqa: E501
            'billing_information': (BillingInformation, none_type),  # noqa: E501
            'failure_code': (str, none_type, none_type),  # noqa: E501
            'created': (datetime, none_type),  # noqa: E501
            'updated': (datetime, none_type),  # noqa: E501
            'ewallet': (EWallet, none_type),  # noqa: E501
            'direct_debit': (DirectDebit, none_type),  # noqa: E501
            'over_the_counter': (OverTheCounter, none_type),  # noqa: E501
            'card': (Card, none_type),  # noqa: E501
            'qr_code': (QRCode, none_type),  # noqa: E501
            'virtual_account': (VirtualAccount, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'type': 'type',  # noqa: E501
        'country': 'country',  # noqa: E501
        'customer_id': 'customer_id',  # noqa: E501
        'customer': 'customer',  # noqa: E501
        'reference_id': 'reference_id',  # noqa: E501
        'description': 'description',  # noqa: E501
        'status': 'status',  # noqa: E501
        'reusability': 'reusability',  # noqa: E501
        'actions': 'actions',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'billing_information': 'billing_information',  # noqa: E501
        'failure_code': 'failure_code',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'ewallet': 'ewallet',  # noqa: E501
        'direct_debit': 'direct_debit',  # noqa: E501
        'over_the_counter': 'over_the_counter',  # noqa: E501
        'card': 'card',  # noqa: E501
        'qr_code': 'qr_code',  # noqa: E501
        'virtual_account': 'virtual_account',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, *args, **kwargs):  # noqa: E501
        """PaymentMethod - a model defined in OpenAPI

        Args:
            id (str):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): [optional]  # noqa: E501
            type (PaymentMethodType): [optional]  # noqa: E501
            country (PaymentMethodCountry): [optional]  # noqa: E501
            customer_id (str, none_type): [optional]  # noqa: E501
            customer ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            reference_id (str): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            status (PaymentMethodStatus): [optional]  # noqa: E501
            reusability (PaymentMethodReusability): [optional]  # noqa: E501
            actions ([PaymentMethodAction]): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            billing_information (BillingInformation): [optional]  # noqa: E501
            failure_code (str, none_type): [optional]  # noqa: E501
            created (datetime): [optional]  # noqa: E501
            updated (datetime): [optional]  # noqa: E501
            ewallet (EWallet): [optional]  # noqa: E501
            direct_debit (DirectDebit): [optional]  # noqa: E501
            over_the_counter (OverTheCounter): [optional]  # noqa: E501
            card (Card): [optional]  # noqa: E501
            qr_code (QRCode): [optional]  # noqa: E501
            virtual_account (VirtualAccount): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self,
        id: str,
        business_id: str | None = None,
        type: PaymentMethodType | None = None,
        country: PaymentMethodCountry | None = None,
        customer_id: str | None = None,
        customer: dict | None = None,
        reference_id: str | None = None,
        description: str | None = None,
        status: PaymentMethodStatus | None = None,
        reusability: PaymentMethodReusability | None = None,
        actions: list | None = None,
        metadata: dict | None = None,
        billing_information: BillingInformation | None = None,
        failure_code: str | None = None,
        created: datetime | None = None,
        updated: datetime | None = None,
        ewallet: EWallet | None = None,
        direct_debit: DirectDebit | None = None,
        over_the_counter: OverTheCounter | None = None,
        card: Card | None = None,
        qr_code: QRCode | None = None,
        virtual_account: VirtualAccount | None = None,
        *args, **kwargs
    ):  # noqa: E501
        """PaymentMethod - a model defined in OpenAPI

        Args:
            id (str):


        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): [optional]  # noqa: E501
            type (PaymentMethodType): [optional]  # noqa: E501
            country (PaymentMethodCountry): [optional]  # noqa: E501
            customer_id (str, none_type): [optional]  # noqa: E501
            customer ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            reference_id (str): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            status (PaymentMethodStatus): [optional]  # noqa: E501
            reusability (PaymentMethodReusability): [optional]  # noqa: E501
            actions ([PaymentMethodAction]): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            billing_information (BillingInformation): [optional]  # noqa: E501
            failure_code (str, none_type): [optional]  # noqa: E501
            created (datetime): [optional]  # noqa: E501
            updated (datetime): [optional]  # noqa: E501
            ewallet (EWallet): [optional]  # noqa: E501
            direct_debit (DirectDebit): [optional]  # noqa: E501
            over_the_counter (OverTheCounter): [optional]  # noqa: E501
            card (Card): [optional]  # noqa: E501
            qr_code (QRCode): [optional]  # noqa: E501
            virtual_account (VirtualAccount): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        if business_id is not None:
            self.business_id = business_id
        if type is not None:
            self.type = type
        if country is not None:
            self.country = country
        if customer_id is not None:
            self.customer_id = customer_id
        if customer is not None:
            self.customer = customer
        if reference_id is not None:
            self.reference_id = reference_id
        if description is not None:
            self.description = description
        if status is not None:
            self.status = status
        if reusability is not None:
            self.reusability = reusability
        if actions is not None:
            self.actions = actions
        if metadata is not None:
            self.metadata = metadata
        if billing_information is not None:
            self.billing_information = billing_information
        if failure_code is not None:
            self.failure_code = failure_code
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated
        if ewallet is not None:
            self.ewallet = ewallet
        if direct_debit is not None:
            self.direct_debit = direct_debit
        if over_the_counter is not None:
            self.over_the_counter = over_the_counter
        if card is not None:
            self.card = card
        if qr_code is not None:
            self.qr_code = qr_code
        if virtual_account is not None:
            self.virtual_account = virtual_account
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
