"""
    The version of the XENDIT API: 1.0.0
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.customer.model.address_request import AddressRequest
from xendit.customer.model.business_detail import BusinessDetail
from xendit.customer.model.end_customer_status import EndCustomerStatus
from xendit.customer.model.identity_account_request import IdentityAccountRequest
from xendit.customer.model.individual_detail import IndividualDetail
from xendit.customer.model.kyc_document_request import KYCDocumentRequest
globals()['AddressRequest'] = AddressRequest
globals()['BusinessDetail'] = BusinessDetail
globals()['EndCustomerStatus'] = EndCustomerStatus
globals()['IdentityAccountRequest'] = IdentityAccountRequest
globals()['IndividualDetail'] = IndividualDetail
globals()['KYCDocumentRequest'] = KYCDocumentRequest

def lazy_import():
    pass

class PatchCustomer(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('reference_id',): {
            'max_length': 255,
        },
        ('description',): {
            'max_length': 1000,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'client_name': (str, none_type, none_type),  # noqa: E501
            'reference_id': (str, none_type, none_type),  # noqa: E501
            'individual_detail': (IndividualDetail, none_type),  # noqa: E501
            'business_detail': (BusinessDetail, none_type),  # noqa: E501
            'description': (str, none_type, none_type),  # noqa: E501
            'email': (str, none_type, none_type),  # noqa: E501
            'mobile_number': (str, none_type, none_type),  # noqa: E501
            'phone_number': (str, none_type, none_type),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type, none_type),  # noqa: E501
            'addresses': ([AddressRequest], none_type, none_type),  # noqa: E501
            'identity_accounts': ([IdentityAccountRequest], none_type, none_type),  # noqa: E501
            'kyc_documents': ([KYCDocumentRequest], none_type, none_type),  # noqa: E501
            'status': (EndCustomerStatus, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'client_name': 'client_name',  # noqa: E501
        'reference_id': 'reference_id',  # noqa: E501
        'individual_detail': 'individual_detail',  # noqa: E501
        'business_detail': 'business_detail',  # noqa: E501
        'description': 'description',  # noqa: E501
        'email': 'email',  # noqa: E501
        'mobile_number': 'mobile_number',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'addresses': 'addresses',  # noqa: E501
        'identity_accounts': 'identity_accounts',  # noqa: E501
        'kyc_documents': 'kyc_documents',  # noqa: E501
        'status': 'status',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PatchCustomer - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_name (str, none_type): Entity's name for this client. [optional]  # noqa: E501
            reference_id (str, none_type): Merchant's reference of this end customer, eg Merchant's user's id. Must be unique.. [optional]  # noqa: E501
            individual_detail (IndividualDetail): [optional]  # noqa: E501
            business_detail (BusinessDetail): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            email (str, none_type): [optional]  # noqa: E501
            mobile_number (str, none_type): [optional]  # noqa: E501
            phone_number (str, none_type): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            addresses ([AddressRequest], none_type): [optional]  # noqa: E501
            identity_accounts ([IdentityAccountRequest], none_type): [optional]  # noqa: E501
            kyc_documents ([KYCDocumentRequest], none_type): [optional]  # noqa: E501
            status (EndCustomerStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self,
        client_name: str | None = None,
        reference_id: str | None = None,
        individual_detail: IndividualDetail | None = None,
        business_detail: BusinessDetail | None = None,
        description: str | None = None,
        email: str | None = None,
        mobile_number: str | None = None,
        phone_number: str | None = None,
        metadata: dict | None = None,
        addresses: list | None = None,
        identity_accounts: list | None = None,
        kyc_documents: list | None = None,
        status: EndCustomerStatus | None = None,
        *args, **kwargs
    ):  # noqa: E501
        """PatchCustomer - a model defined in OpenAPI


        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_name (str, none_type): Entity's name for this client. [optional]  # noqa: E501
            reference_id (str, none_type): Merchant's reference of this end customer, eg Merchant's user's id. Must be unique.. [optional]  # noqa: E501
            individual_detail (IndividualDetail): [optional]  # noqa: E501
            business_detail (BusinessDetail): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            email (str, none_type): [optional]  # noqa: E501
            mobile_number (str, none_type): [optional]  # noqa: E501
            phone_number (str, none_type): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            addresses ([AddressRequest], none_type): [optional]  # noqa: E501
            identity_accounts ([IdentityAccountRequest], none_type): [optional]  # noqa: E501
            kyc_documents ([KYCDocumentRequest], none_type): [optional]  # noqa: E501
            status (EndCustomerStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        if client_name is not None:
            self.client_name = client_name
        if reference_id is not None:
            self.reference_id = reference_id
        if individual_detail is not None:
            self.individual_detail = individual_detail
        if business_detail is not None:
            self.business_detail = business_detail
        if description is not None:
            self.description = description
        if email is not None:
            self.email = email
        if mobile_number is not None:
            self.mobile_number = mobile_number
        if phone_number is not None:
            self.phone_number = phone_number
        if metadata is not None:
            self.metadata = metadata
        if addresses is not None:
            self.addresses = addresses
        if identity_accounts is not None:
            self.identity_accounts = identity_accounts
        if kyc_documents is not None:
            self.kyc_documents = kyc_documents
        if status is not None:
            self.status = status
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
