"""
    The version of the XENDIT API: 3.5.2
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.balance_and_transaction.model.channels_categories import ChannelsCategories
from xendit.balance_and_transaction.model.currency import Currency
from xendit.balance_and_transaction.model.fee_response import FeeResponse
from xendit.balance_and_transaction.model.transaction_id import TransactionId
from xendit.balance_and_transaction.model.transaction_response_type import TransactionResponseType
from xendit.balance_and_transaction.model.transaction_statuses import TransactionStatuses
globals()['ChannelsCategories'] = ChannelsCategories
globals()['Currency'] = Currency
globals()['FeeResponse'] = FeeResponse
globals()['TransactionId'] = TransactionId
globals()['TransactionResponseType'] = TransactionResponseType
globals()['TransactionStatuses'] = TransactionStatuses

def lazy_import():
    pass

class TransactionResponse(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('cashflow',): {
            'IN': "MONEY_IN",
            'OUT': "MONEY_OUT",
        },
        ('settlement_status',): {
            'None': None,
            'PENDING': "PENDING",
            'SETTLED': "SETTLED",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (TransactionId,),  # noqa: E501
            'product_id': (str,),  # noqa: E501
            'type': (TransactionResponseType,),  # noqa: E501
            'status': (TransactionStatuses,),  # noqa: E501
            'channel_category': (ChannelsCategories,),  # noqa: E501
            'channel_code': (str, none_type,),  # noqa: E501
            'account_identifier': (str, none_type,),  # noqa: E501
            'reference_id': (str,),  # noqa: E501
            'currency': (Currency,),  # noqa: E501
            'amount': (float,),  # noqa: E501
            'cashflow': (str,),  # noqa: E501
            'business_id': (str,),  # noqa: E501
            'fee': (FeeResponse,),  # noqa: E501
            'created': (datetime,),  # noqa: E501
            'updated': (datetime,),  # noqa: E501
            'settlement_status': (str, none_type, none_type),  # noqa: E501
            'estimated_settlement_time': (datetime, none_type, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'product_id': 'product_id',  # noqa: E501
        'type': 'type',  # noqa: E501
        'status': 'status',  # noqa: E501
        'channel_category': 'channel_category',  # noqa: E501
        'channel_code': 'channel_code',  # noqa: E501
        'account_identifier': 'account_identifier',  # noqa: E501
        'reference_id': 'reference_id',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'cashflow': 'cashflow',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'fee': 'fee',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'settlement_status': 'settlement_status',  # noqa: E501
        'estimated_settlement_time': 'estimated_settlement_time',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, product_id, type, status, channel_category, channel_code, account_identifier, reference_id, currency, amount, cashflow, business_id, fee, created, updated, *args, **kwargs):  # noqa: E501
        """TransactionResponse - a model defined in OpenAPI

        Args:
            id (TransactionId):
            product_id (str): The product_id of the transaction. Product id will have a different prefix for each product. You can use this id to match the transaction from this API to each product API.
            type (TransactionResponseType):
            status (TransactionStatuses):
            channel_category (ChannelsCategories):
            channel_code (str, none_type): The channel of the transaction that is used. See [channel codes](https://docs.xendit.co/xendisburse/channel-codes) for the list of available per channel categories.
            account_identifier (str, none_type): Account identifier of transaction. The format will be different from each channel.
            reference_id (str): customer supplied reference/external_id
            currency (Currency):
            amount (float): The transaction amount. The number of decimal places will be different for each currency according to ISO 4217.
            cashflow (str): Representing whether the transaction is money in or money out For transfer, the transfer out side it will shows up as money out and on transfer in side in will shows up as money-in. Available values are `MONEY_IN` for money in and `MONEY_OUT` for money out.
            business_id (str): The id of business where this transaction belong to
            fee (FeeResponse):
            created (datetime): Transaction created timestamp (UTC+0)
            updated (datetime): Transaction updated timestamp (UTC+0)

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            settlement_status (str, none_type): The settlement status of the transaction. `PENDING` - Transaction amount has not been settled to merchant's balance. `SETTLED` - Transaction has been settled to merchant's balance. [optional]  # noqa: E501
            estimated_settlement_time (datetime, none_type): Estimated settlement time will only apply to money-in transactions. For money-out transaction, the value will be `NULL`. Estimated settlement time in which transaction amount will be settled to merchant's balance.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.product_id = product_id
        self.type = type
        self.status = status
        self.channel_category = channel_category
        self.channel_code = channel_code
        self.account_identifier = account_identifier
        self.reference_id = reference_id
        self.currency = currency
        self.amount = amount
        self.cashflow = cashflow
        self.business_id = business_id
        self.fee = fee
        self.created = created
        self.updated = updated
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self,
        id: str,
        product_id: str,
        type: TransactionResponseType,
        status: TransactionStatuses,
        channel_category: ChannelsCategories,
        channel_code: str | None,
        account_identifier: str | None,
        reference_id: str,
        currency: Currency,
        amount: float,
        cashflow: str,
        business_id: str,
        fee: FeeResponse,
        created: datetime,
        updated: datetime,
        settlement_status: str | None = None,
        estimated_settlement_time: datetime | None = None,
        *args, **kwargs
    ):  # noqa: E501
        """TransactionResponse - a model defined in OpenAPI

        Args:
            id (TransactionId):
            product_id (str): The product_id of the transaction. Product id will have a different prefix for each product. You can use this id to match the transaction from this API to each product API.
            type (TransactionResponseType):
            status (TransactionStatuses):
            channel_category (ChannelsCategories):
            channel_code (str, none_type): The channel of the transaction that is used. See [channel codes](https://docs.xendit.co/xendisburse/channel-codes) for the list of available per channel categories.
            account_identifier (str, none_type): Account identifier of transaction. The format will be different from each channel.
            reference_id (str): customer supplied reference/external_id
            currency (Currency):
            amount (float): The transaction amount. The number of decimal places will be different for each currency according to ISO 4217.
            cashflow (str): Representing whether the transaction is money in or money out For transfer, the transfer out side it will shows up as money out and on transfer in side in will shows up as money-in. Available values are `MONEY_IN` for money in and `MONEY_OUT` for money out.
            business_id (str): The id of business where this transaction belong to
            fee (FeeResponse):
            created (datetime): Transaction created timestamp (UTC+0)
            updated (datetime): Transaction updated timestamp (UTC+0)


        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            settlement_status (str, none_type): The settlement status of the transaction. `PENDING` - Transaction amount has not been settled to merchant's balance. `SETTLED` - Transaction has been settled to merchant's balance. [optional]  # noqa: E501
            estimated_settlement_time (datetime, none_type): Estimated settlement time will only apply to money-in transactions. For money-out transaction, the value will be `NULL`. Estimated settlement time in which transaction amount will be settled to merchant's balance.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.product_id = product_id
        self.type = type
        self.status = status
        self.channel_category = channel_category
        self.channel_code = channel_code
        self.account_identifier = account_identifier
        self.reference_id = reference_id
        self.currency = currency
        self.amount = amount
        self.cashflow = cashflow
        self.business_id = business_id
        self.fee = fee
        self.created = created
        self.updated = updated
        if settlement_status is not None:
            self.settlement_status = settlement_status
        if estimated_settlement_time is not None:
            self.estimated_settlement_time = estimated_settlement_time
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
