"""
    The version of the XENDIT API: 1.59.0
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.payment_request.model.payment_method import PaymentMethod
from xendit.payment_request.model.payment_request_action import PaymentRequestAction
from xendit.payment_request.model.payment_request_basket import PaymentRequestBasket
from xendit.payment_request.model.payment_request_capture_method import PaymentRequestCaptureMethod
from xendit.payment_request.model.payment_request_card_verification_results import PaymentRequestCardVerificationResults
from xendit.payment_request.model.payment_request_country import PaymentRequestCountry
from xendit.payment_request.model.payment_request_currency import PaymentRequestCurrency
from xendit.payment_request.model.payment_request_initiator import PaymentRequestInitiator
from xendit.payment_request.model.payment_request_shipping_information import PaymentRequestShippingInformation
from xendit.payment_request.model.payment_request_status import PaymentRequestStatus
globals()['PaymentMethod'] = PaymentMethod
globals()['PaymentRequestAction'] = PaymentRequestAction
globals()['PaymentRequestBasket'] = PaymentRequestBasket
globals()['PaymentRequestCaptureMethod'] = PaymentRequestCaptureMethod
globals()['PaymentRequestCardVerificationResults'] = PaymentRequestCardVerificationResults
globals()['PaymentRequestCountry'] = PaymentRequestCountry
globals()['PaymentRequestCurrency'] = PaymentRequestCurrency
globals()['PaymentRequestInitiator'] = PaymentRequestInitiator
globals()['PaymentRequestShippingInformation'] = PaymentRequestShippingInformation
globals()['PaymentRequestStatus'] = PaymentRequestStatus

def lazy_import():
    pass

class PaymentRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'created': (str,),  # noqa: E501
            'updated': (str,),  # noqa: E501
            'reference_id': (str,),  # noqa: E501
            'business_id': (str,),  # noqa: E501
            'currency': (PaymentRequestCurrency,),  # noqa: E501
            'payment_method': (PaymentMethod,),  # noqa: E501
            'status': (PaymentRequestStatus,),  # noqa: E501
            'customer_id': (str, none_type, none_type),  # noqa: E501
            'customer': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type, none_type),  # noqa: E501
            'amount': (float, none_type),  # noqa: E501
            'min_amount': (float, none_type, none_type),  # noqa: E501
            'max_amount': (float, none_type, none_type),  # noqa: E501
            'country': (PaymentRequestCountry, none_type),  # noqa: E501
            'description': (str, none_type, none_type),  # noqa: E501
            'failure_code': (str, none_type, none_type),  # noqa: E501
            'capture_method': (PaymentRequestCaptureMethod, none_type),  # noqa: E501
            'initiator': (PaymentRequestInitiator, none_type),  # noqa: E501
            'card_verification_results': (PaymentRequestCardVerificationResults, none_type),  # noqa: E501
            'actions': ([PaymentRequestAction], none_type),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type, none_type),  # noqa: E501
            'shipping_information': (PaymentRequestShippingInformation, none_type),  # noqa: E501
            'items': (PaymentRequestBasket, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'reference_id': 'reference_id',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'payment_method': 'payment_method',  # noqa: E501
        'status': 'status',  # noqa: E501
        'customer_id': 'customer_id',  # noqa: E501
        'customer': 'customer',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'min_amount': 'min_amount',  # noqa: E501
        'max_amount': 'max_amount',  # noqa: E501
        'country': 'country',  # noqa: E501
        'description': 'description',  # noqa: E501
        'failure_code': 'failure_code',  # noqa: E501
        'capture_method': 'capture_method',  # noqa: E501
        'initiator': 'initiator',  # noqa: E501
        'card_verification_results': 'card_verification_results',  # noqa: E501
        'actions': 'actions',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'shipping_information': 'shipping_information',  # noqa: E501
        'items': 'items',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, created, updated, reference_id, business_id, currency, payment_method, status, *args, **kwargs):  # noqa: E501
        """PaymentRequest - a model defined in OpenAPI

        Args:
            id (str):
            created (str):
            updated (str):
            reference_id (str):
            business_id (str):
            currency (PaymentRequestCurrency):
            payment_method (PaymentMethod):
            status (PaymentRequestStatus):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            customer_id (str, none_type): [optional]  # noqa: E501
            customer ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            amount (float): [optional]  # noqa: E501
            min_amount (float, none_type): [optional]  # noqa: E501
            max_amount (float, none_type): [optional]  # noqa: E501
            country (PaymentRequestCountry): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            failure_code (str, none_type): [optional]  # noqa: E501
            capture_method (PaymentRequestCaptureMethod): [optional]  # noqa: E501
            initiator (PaymentRequestInitiator): [optional]  # noqa: E501
            card_verification_results (PaymentRequestCardVerificationResults): [optional]  # noqa: E501
            actions ([PaymentRequestAction]): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            shipping_information (PaymentRequestShippingInformation): [optional]  # noqa: E501
            items (PaymentRequestBasket): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.created = created
        self.updated = updated
        self.reference_id = reference_id
        self.business_id = business_id
        self.currency = currency
        self.payment_method = payment_method
        self.status = status
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self,
        id: str,
        created: str,
        updated: str,
        reference_id: str,
        business_id: str,
        currency: PaymentRequestCurrency,
        payment_method: PaymentMethod,
        status: PaymentRequestStatus,
        customer_id: str | None = None,
        customer: dict | None = None,
        amount: float | None = None,
        min_amount: float | None = None,
        max_amount: float | None = None,
        country: PaymentRequestCountry | None = None,
        description: str | None = None,
        failure_code: str | None = None,
        capture_method: PaymentRequestCaptureMethod | None = None,
        initiator: PaymentRequestInitiator | None = None,
        card_verification_results: PaymentRequestCardVerificationResults | None = None,
        actions: list | None = None,
        metadata: dict | None = None,
        shipping_information: PaymentRequestShippingInformation | None = None,
        items: PaymentRequestBasket | None = None,
        *args, **kwargs
    ):  # noqa: E501
        """PaymentRequest - a model defined in OpenAPI

        Args:
            id (str):
            created (str):
            updated (str):
            reference_id (str):
            business_id (str):
            currency (PaymentRequestCurrency):
            payment_method (PaymentMethod):
            status (PaymentRequestStatus):


        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            customer_id (str, none_type): [optional]  # noqa: E501
            customer ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            amount (float): [optional]  # noqa: E501
            min_amount (float, none_type): [optional]  # noqa: E501
            max_amount (float, none_type): [optional]  # noqa: E501
            country (PaymentRequestCountry): [optional]  # noqa: E501
            description (str, none_type): [optional]  # noqa: E501
            failure_code (str, none_type): [optional]  # noqa: E501
            capture_method (PaymentRequestCaptureMethod): [optional]  # noqa: E501
            initiator (PaymentRequestInitiator): [optional]  # noqa: E501
            card_verification_results (PaymentRequestCardVerificationResults): [optional]  # noqa: E501
            actions ([PaymentRequestAction]): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): [optional]  # noqa: E501
            shipping_information (PaymentRequestShippingInformation): [optional]  # noqa: E501
            items (PaymentRequestBasket): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.created = created
        self.updated = updated
        self.reference_id = reference_id
        self.business_id = business_id
        self.currency = currency
        self.payment_method = payment_method
        self.status = status
        if customer_id is not None:
            self.customer_id = customer_id
        if customer is not None:
            self.customer = customer
        if amount is not None:
            self.amount = amount
        if min_amount is not None:
            self.min_amount = min_amount
        if max_amount is not None:
            self.max_amount = max_amount
        if country is not None:
            self.country = country
        if description is not None:
            self.description = description
        if failure_code is not None:
            self.failure_code = failure_code
        if capture_method is not None:
            self.capture_method = capture_method
        if initiator is not None:
            self.initiator = initiator
        if card_verification_results is not None:
            self.card_verification_results = card_verification_results
        if actions is not None:
            self.actions = actions
        if metadata is not None:
            self.metadata = metadata
        if shipping_information is not None:
            self.shipping_information = shipping_information
        if items is not None:
            self.items = items
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
