"""
    The version of the XENDIT API: 1.7.6
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.invoice.model.invoice_callback_item import InvoiceCallbackItem
from xendit.invoice.model.invoice_fee import InvoiceFee
from xendit.invoice.model.payment_details import PaymentDetails
globals()['InvoiceCallbackItem'] = InvoiceCallbackItem
globals()['InvoiceFee'] = InvoiceFee
globals()['PaymentDetails'] = PaymentDetails

def lazy_import():
    pass

class InvoiceCallback(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'external_id': (str,),  # noqa: E501
            'user_id': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'merchant_name': (str,),  # noqa: E501
            'amount': (float,),  # noqa: E501
            'created': (str,),  # noqa: E501
            'updated': (str,),  # noqa: E501
            'currency': (str,),  # noqa: E501
            'payer_email': (str, none_type),  # noqa: E501
            'description': (str, none_type),  # noqa: E501
            'paid_amount': (float, none_type),  # noqa: E501
            'paid_at': (str, none_type),  # noqa: E501
            'payment_method': (str, none_type),  # noqa: E501
            'payment_channel': (str, none_type),  # noqa: E501
            'payment_destination': (str, none_type),  # noqa: E501
            'payment_details': (PaymentDetails, none_type),  # noqa: E501
            'payment_id': (str, none_type),  # noqa: E501
            'success_redirect_url': (str, none_type),  # noqa: E501
            'failure_redirect_url': (str, none_type),  # noqa: E501
            'credit_card_charge_id': (str, none_type),  # noqa: E501
            'items': ([InvoiceCallbackItem], none_type),  # noqa: E501
            'fees': ([InvoiceFee], none_type),  # noqa: E501
            'should_authenticate_credit_card': (bool, none_type),  # noqa: E501
            'bank_code': (str, none_type),  # noqa: E501
            'ewallet_type': (str, none_type),  # noqa: E501
            'on_demand_link': (str, none_type),  # noqa: E501
            'recurring_payment_id': (str, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'external_id': 'external_id',  # noqa: E501
        'user_id': 'user_id',  # noqa: E501
        'status': 'status',  # noqa: E501
        'merchant_name': 'merchant_name',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'payer_email': 'payer_email',  # noqa: E501
        'description': 'description',  # noqa: E501
        'paid_amount': 'paid_amount',  # noqa: E501
        'paid_at': 'paid_at',  # noqa: E501
        'payment_method': 'payment_method',  # noqa: E501
        'payment_channel': 'payment_channel',  # noqa: E501
        'payment_destination': 'payment_destination',  # noqa: E501
        'payment_details': 'payment_details',  # noqa: E501
        'payment_id': 'payment_id',  # noqa: E501
        'success_redirect_url': 'success_redirect_url',  # noqa: E501
        'failure_redirect_url': 'failure_redirect_url',  # noqa: E501
        'credit_card_charge_id': 'credit_card_charge_id',  # noqa: E501
        'items': 'items',  # noqa: E501
        'fees': 'fees',  # noqa: E501
        'should_authenticate_credit_card': 'should_authenticate_credit_card',  # noqa: E501
        'bank_code': 'bank_code',  # noqa: E501
        'ewallet_type': 'ewallet_type',  # noqa: E501
        'on_demand_link': 'on_demand_link',  # noqa: E501
        'recurring_payment_id': 'recurring_payment_id',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, external_id, user_id, status, merchant_name, amount, created, updated, currency, *args, **kwargs):  # noqa: E501
        """InvoiceCallback - a model defined in OpenAPI

        Args:
            id (str): An invoice ID generated by Xendit
            external_id (str): ID of your choice (typically the unique identifier of an invoice in your system)
            user_id (str): Xendit Business ID
            status (str): The status of the invoice.
            merchant_name (str): The name of company or website
            amount (float): Nominal amount for the invoice
            created (str): The date and time when the invoice was created.
            updated (str): The date and time when the invoice was last updated.
            currency (str): The currency of the invoice.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            payer_email (str): Email of the payer. [optional]  # noqa: E501
            description (str): Description for the invoice. [optional]  # noqa: E501
            paid_amount (float): Total amount paid for the invoice. [optional]  # noqa: E501
            paid_at (str): The date and time when the invoice was paid.. [optional]  # noqa: E501
            payment_method (str): The payment method used for the invoice.. [optional]  # noqa: E501
            payment_channel (str): The payment channel.. [optional]  # noqa: E501
            payment_destination (str): The payment destination.. [optional]  # noqa: E501
            payment_details (PaymentDetails): [optional]  # noqa: E501
            payment_id (str): The ID of the payment.. [optional]  # noqa: E501
            success_redirect_url (str): The URL to redirect to on successful payment.. [optional]  # noqa: E501
            failure_redirect_url (str): The URL to redirect to on payment failure.. [optional]  # noqa: E501
            credit_card_charge_id (str): The ID associated with a credit card charge (if applicable).. [optional]  # noqa: E501
            items ([InvoiceCallbackItem]): [optional]  # noqa: E501
            fees ([InvoiceFee]): An array of fees associated with the invoice.. [optional]  # noqa: E501
            should_authenticate_credit_card (bool): Indicates whether credit card authentication is required.. [optional]  # noqa: E501
            bank_code (str): The bank code for the bank details.. [optional]  # noqa: E501
            ewallet_type (str): The type of eWallet.. [optional]  # noqa: E501
            on_demand_link (str): The on-demand link.. [optional]  # noqa: E501
            recurring_payment_id (str): The ID of the recurring payment.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.external_id = external_id
        self.user_id = user_id
        self.status = status
        self.merchant_name = merchant_name
        self.amount = amount
        self.created = created
        self.updated = updated
        self.currency = currency
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self,
        id: str,
        external_id: str,
        user_id: str,
        status: str,
        merchant_name: str,
        amount: float,
        created: str,
        updated: str,
        currency: str,
        payer_email: str | None = None,
        description: str | None = None,
        paid_amount: float | None = None,
        paid_at: str | None = None,
        payment_method: str | None = None,
        payment_channel: str | None = None,
        payment_destination: str | None = None,
        payment_details: PaymentDetails | None = None,
        payment_id: str | None = None,
        success_redirect_url: str | None = None,
        failure_redirect_url: str | None = None,
        credit_card_charge_id: str | None = None,
        items: list | None = None,
        fees: list | None = None,
        should_authenticate_credit_card: bool | None = None,
        bank_code: str | None = None,
        ewallet_type: str | None = None,
        on_demand_link: str | None = None,
        recurring_payment_id: str | None = None,
        *args, **kwargs
    ):  # noqa: E501
        """InvoiceCallback - a model defined in OpenAPI

        Args:
            id (str): An invoice ID generated by Xendit
            external_id (str): ID of your choice (typically the unique identifier of an invoice in your system)
            user_id (str): Xendit Business ID
            status (str): The status of the invoice.
            merchant_name (str): The name of company or website
            amount (float): Nominal amount for the invoice
            created (str): The date and time when the invoice was created.
            updated (str): The date and time when the invoice was last updated.
            currency (str): The currency of the invoice.


        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            payer_email (str): Email of the payer. [optional]  # noqa: E501
            description (str): Description for the invoice. [optional]  # noqa: E501
            paid_amount (float): Total amount paid for the invoice. [optional]  # noqa: E501
            paid_at (str): The date and time when the invoice was paid.. [optional]  # noqa: E501
            payment_method (str): The payment method used for the invoice.. [optional]  # noqa: E501
            payment_channel (str): The payment channel.. [optional]  # noqa: E501
            payment_destination (str): The payment destination.. [optional]  # noqa: E501
            payment_details (PaymentDetails): [optional]  # noqa: E501
            payment_id (str): The ID of the payment.. [optional]  # noqa: E501
            success_redirect_url (str): The URL to redirect to on successful payment.. [optional]  # noqa: E501
            failure_redirect_url (str): The URL to redirect to on payment failure.. [optional]  # noqa: E501
            credit_card_charge_id (str): The ID associated with a credit card charge (if applicable).. [optional]  # noqa: E501
            items ([InvoiceCallbackItem]): [optional]  # noqa: E501
            fees ([InvoiceFee]): An array of fees associated with the invoice.. [optional]  # noqa: E501
            should_authenticate_credit_card (bool): Indicates whether credit card authentication is required.. [optional]  # noqa: E501
            bank_code (str): The bank code for the bank details.. [optional]  # noqa: E501
            ewallet_type (str): The type of eWallet.. [optional]  # noqa: E501
            on_demand_link (str): The on-demand link.. [optional]  # noqa: E501
            recurring_payment_id (str): The ID of the recurring payment.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.external_id = external_id
        self.user_id = user_id
        self.status = status
        self.merchant_name = merchant_name
        self.amount = amount
        self.created = created
        self.updated = updated
        self.currency = currency
        if payer_email is not None:
            self.payer_email = payer_email
        if description is not None:
            self.description = description
        if paid_amount is not None:
            self.paid_amount = paid_amount
        if paid_at is not None:
            self.paid_at = paid_at
        if payment_method is not None:
            self.payment_method = payment_method
        if payment_channel is not None:
            self.payment_channel = payment_channel
        if payment_destination is not None:
            self.payment_destination = payment_destination
        if payment_details is not None:
            self.payment_details = payment_details
        if payment_id is not None:
            self.payment_id = payment_id
        if success_redirect_url is not None:
            self.success_redirect_url = success_redirect_url
        if failure_redirect_url is not None:
            self.failure_redirect_url = failure_redirect_url
        if credit_card_charge_id is not None:
            self.credit_card_charge_id = credit_card_charge_id
        if items is not None:
            self.items = items
        if fees is not None:
            self.fees = fees
        if should_authenticate_credit_card is not None:
            self.should_authenticate_credit_card = should_authenticate_credit_card
        if bank_code is not None:
            self.bank_code = bank_code
        if ewallet_type is not None:
            self.ewallet_type = ewallet_type
        if on_demand_link is not None:
            self.on_demand_link = on_demand_link
        if recurring_payment_id is not None:
            self.recurring_payment_id = recurring_payment_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
