"""
    The version of the XENDIT API: 1.0.0
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.payout.model.create_payout_request import CreatePayoutRequest
from xendit.payout.model.digital_payout_channel_properties import DigitalPayoutChannelProperties
from xendit.payout.model.payout_all_of import PayoutAllOf
from xendit.payout.model.receipt_notification import ReceiptNotification
globals()['CreatePayoutRequest'] = CreatePayoutRequest
globals()['DigitalPayoutChannelProperties'] = DigitalPayoutChannelProperties
globals()['PayoutAllOf'] = PayoutAllOf
globals()['ReceiptNotification'] = ReceiptNotification

def lazy_import():
    pass

class Payout(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'SUCCEEDED': "SUCCEEDED",
            'FAILED': "FAILED",
            'ACCEPTED': "ACCEPTED",
            'REQUESTED': "REQUESTED",
            'LOCKED': "LOCKED",
            'CANCELLED': "CANCELLED",
            'REVERSED': "REVERSED",
        },
        ('failure_code',): {
            'INSUFFICIENT_BALANCE': "INSUFFICIENT_BALANCE",
            'REJECTED_BY_CHANNEL': "REJECTED_BY_CHANNEL",
            'TEMPORARY_TRANSFER_ERROR': "TEMPORARY_TRANSFER_ERROR",
            'INVALID_DESTINATION': "INVALID_DESTINATION",
            'TRANSFER_ERROR': "TRANSFER_ERROR",
        },
    }

    validations = {
        ('reference_id',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'reference_id': (str,),  # noqa: E501
            'channel_code': (str,),  # noqa: E501
            'channel_properties': (DigitalPayoutChannelProperties,),  # noqa: E501
            'amount': (float,),  # noqa: E501
            'currency': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'created': (datetime,),  # noqa: E501
            'updated': (datetime,),  # noqa: E501
            'business_id': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'description': (str, none_type),  # noqa: E501
            'receipt_notification': (ReceiptNotification, none_type),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type),  # noqa: E501
            'failure_code': (str, none_type),  # noqa: E501
            'estimated_arrival_time': (datetime, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'reference_id': 'reference_id',  # noqa: E501
        'channel_code': 'channel_code',  # noqa: E501
        'channel_properties': 'channel_properties',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'id': 'id',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'status': 'status',  # noqa: E501
        'description': 'description',  # noqa: E501
        'receipt_notification': 'receipt_notification',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'failure_code': 'failure_code',  # noqa: E501
        'estimated_arrival_time': 'estimated_arrival_time',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Payout - a model defined in OpenAPI

        Keyword Args:
            reference_id (str): A client defined payout identifier
            channel_code (str): Channel code of selected destination bank or e-wallet
            channel_properties (DigitalPayoutChannelProperties):
            amount (float): Amount to be sent to the destination account and should be a multiple of the minimum increment for the selected channel
            currency (str): Currency of the destination channel using ISO-4217 currency code
            id (str): Xendit-generated unique identifier for each payout
            created (datetime): The time payout was created on Xendit's system, in ISO 8601 format
            updated (datetime): The time payout was last updated on Xendit's system, in ISO 8601 format
            business_id (str): Xendit Business ID
            status (str): Status of payout
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description to send with the payout, the recipient may see this e.g., in their bank statement (if supported) or in email receipts we send on your behalf. [optional]  # noqa: E501
            receipt_notification (ReceiptNotification): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Object of additional information you may use. [optional]  # noqa: E501
            failure_code (str): If the Payout failed, we include a failure code for more details on the failure.. [optional]  # noqa: E501
            estimated_arrival_time (datetime): Our estimated time on to when your payout is reflected to the destination account. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Payout - a model defined in OpenAPI

        Keyword Args:
            reference_id (str): A client defined payout identifier
            channel_code (str): Channel code of selected destination bank or e-wallet
            channel_properties (DigitalPayoutChannelProperties):
            amount (float): Amount to be sent to the destination account and should be a multiple of the minimum increment for the selected channel
            currency (str): Currency of the destination channel using ISO-4217 currency code
            id (str): Xendit-generated unique identifier for each payout
            created (datetime): The time payout was created on Xendit's system, in ISO 8601 format
            updated (datetime): The time payout was last updated on Xendit's system, in ISO 8601 format
            business_id (str): Xendit Business ID
            status (str): Status of payout
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description to send with the payout, the recipient may see this e.g., in their bank statement (if supported) or in email receipts we send on your behalf. [optional]  # noqa: E501
            receipt_notification (ReceiptNotification): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Object of additional information you may use. [optional]  # noqa: E501
            failure_code (str): If the Payout failed, we include a failure code for more details on the failure.. [optional]  # noqa: E501
            estimated_arrival_time (datetime): Our estimated time on to when your payout is reflected to the destination account. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              CreatePayoutRequest,
              PayoutAllOf,
          ],
          'oneOf': [
          ],
        }
