"""
    XENDIT SDK openapi spec

    XENDIT SDK openapi spec  # noqa: E501

    The version of the OpenAPI document: 1.0.0
"""

import re  # noqa: F401
import sys  # noqa: F401

from xendit.api_client import ApiClient, Endpoint as _Endpoint
from xendit.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from typing import Optional, List # noqa: F401

from xendit.customer.model import *  # noqa: F401,E501

class CustomerApi(object):
    """NOTE: This class is auto generated by the OpenAPI Generator.
    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_customer_endpoint = _Endpoint(
            settings={
                'response_type': (Customer,),
                'auth': [],
                'endpoint_path': '/customers',
                'operation_id': 'create_customer',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'idempotency_key',
                    'for_user_id',
                    'customer_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'idempotency_key':
                        (str,),
                    'for_user_id':
                        (str,),
                    'customer_request':
                        (CustomerRequest,),
                },
                'attribute_map': {
                    'idempotency_key': 'idempotency-key',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'idempotency_key': 'header',
                    'for_user_id': 'header',
                    'customer_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_customer_endpoint = _Endpoint(
            settings={
                'response_type': (Customer,),
                'auth': [],
                'endpoint_path': '/customers/{id}',
                'operation_id': 'get_customer',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'for_user_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'for_user_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'id': 'path',
                    'for_user_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_customer_by_reference_id_endpoint = _Endpoint(
            settings={
                'response_type': (GetCustomerByReferenceID200Response,),
                'auth': [],
                'endpoint_path': '/customers',
                'operation_id': 'get_customer_by_reference_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'reference_id',
                    'for_user_id',
                ],
                'required': [
                    'reference_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'reference_id',
                ]
            },
            root_map={
                'validations': {
                    ('reference_id',): {
                        'max_length': 255,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reference_id':
                        (str,),
                    'for_user_id':
                        (str,),
                },
                'attribute_map': {
                    'reference_id': 'reference_id',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'reference_id': 'query',
                    'for_user_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_customer_endpoint = _Endpoint(
            settings={
                'response_type': (Customer,),
                'auth': [],
                'endpoint_path': '/customers/{id}',
                'operation_id': 'update_customer',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'for_user_id',
                    'patch_customer',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'for_user_id':
                        (str,),
                    'patch_customer':
                        (PatchCustomer,),
                },
                'attribute_map': {
                    'id': 'id',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'id': 'path',
                    'for_user_id': 'header',
                    'patch_customer': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_customer(
        self,
        idempotency_key: Optional[str] = None,
        for_user_id: Optional[str] = None,
        customer_request: Optional[CustomerRequest] = None,
        **kwargs
    ) -> Customer:
        """Create Customer  # noqa: E501

        Function to create a customer that you may use in your Invoice or Payment Requests. For detail explanations, see this link: https://developers.xendit.co/api-reference/#create-customer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer(idempotency_key, for_user_id, customer_request, async_req=True)
        >>> result = thread.get()


        Keyword Args:
            idempotency_key (str): A unique key to prevent processing duplicate requests.. [optional]
            for_user_id (str): The sub-account user-id that you want to make this transaction for.. [optional]
            customer_request (CustomerRequest): Request object for end customer object. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Customer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        if idempotency_key is not None:
            kwargs['idempotency_key'] = idempotency_key
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if customer_request is not None:
            kwargs['customer_request'] = customer_request
        return self.create_customer_endpoint.call_with_http_info(**kwargs)

    def get_customer(
        self,
        id: str,
        for_user_id: Optional[str] = None,
        **kwargs
    ) -> Customer:
        """Get Customer By ID  # noqa: E501

        Retrieves a single customer object For detail explanations, see this link: https://developers.xendit.co/api-reference/#get-customer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer(id, for_user_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): End customer resource id

        Keyword Args:
            for_user_id (str): The sub-account user-id that you want to make this transaction for.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Customer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        return self.get_customer_endpoint.call_with_http_info(**kwargs)

    def get_customer_by_reference_id(
        self,
        reference_id: str,
        for_user_id: Optional[str] = None,
        **kwargs
    ) -> GetCustomerByReferenceID200Response:
        """GET customers by reference id  # noqa: E501

        Retrieves an array with a customer object that matches the provided reference_id - the identifier provided by you For detail explanations, see this link: https://developers.xendit.co/api-reference/#get-customer-by-reference-id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer_by_reference_id(reference_id, for_user_id, async_req=True)
        >>> result = thread.get()

        Args:
            reference_id (str): Merchant's reference of end customer

        Keyword Args:
            for_user_id (str): The sub-account user-id that you want to make this transaction for.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetCustomerByReferenceID200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['reference_id'] = reference_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        return self.get_customer_by_reference_id_endpoint.call_with_http_info(**kwargs)

    def update_customer(
        self,
        id: str,
        for_user_id: Optional[str] = None,
        patch_customer: Optional[PatchCustomer] = None,
        **kwargs
    ) -> Customer:
        """Update End Customer Resource  # noqa: E501

        Function to update an existing customer. For a detailed explanation For detail explanations, see this link: https://developers.xendit.co/api-reference/#update-customer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_customer(id, for_user_id, patch_customer, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): End customer resource id

        Keyword Args:
            for_user_id (str): The sub-account user-id that you want to make this transaction for.. [optional]
            patch_customer (PatchCustomer): Update Request for end customer object. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Customer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if patch_customer is not None:
            kwargs['patch_customer'] = patch_customer
        return self.update_customer_endpoint.call_with_http_info(**kwargs)

