"""
    The version of the XENDIT API: 1.0.0
"""


import re  # noqa: F401
import sys  # noqa: F401
from typing import List  # noqa: F401

from xendit.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from xendit.exceptions import ApiAttributeError

from xendit.customer.model.account_bank import AccountBank
from xendit.customer.model.account_card import AccountCard
from xendit.customer.model.account_ewallet import AccountEwallet
from xendit.customer.model.account_otc import AccountOTC
from xendit.customer.model.account_pay_later import AccountPayLater
from xendit.customer.model.account_qr_code import AccountQRCode
globals()['AccountBank'] = AccountBank
globals()['AccountCard'] = AccountCard
globals()['AccountEwallet'] = AccountEwallet
globals()['AccountOTC'] = AccountOTC
globals()['AccountPayLater'] = AccountPayLater
globals()['AccountQRCode'] = AccountQRCode

def lazy_import():
    pass

class IdentityAccountResponseProperties(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'account_number': (str, none_type),  # noqa: E501
            'account_holder_name': (str, none_type, none_type),  # noqa: E501
            'swift_code': (str, none_type, none_type),  # noqa: E501
            'account_type': (str, none_type, none_type),  # noqa: E501
            'account_details': (str, none_type, none_type),  # noqa: E501
            'currency': (bool, date, datetime, dict, float, int, list, str, none_type, none_type),  # noqa: E501
            'token_id': (str, none_type),  # noqa: E501
            'payment_code': (str, none_type),  # noqa: E501
            'expires_at': (str, none_type, none_type),  # noqa: E501
            'qr_string': (str, none_type),  # noqa: E501
            'account_id': (str, none_type),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account_number': 'account_number',  # noqa: E501
        'account_holder_name': 'account_holder_name',  # noqa: E501
        'swift_code': 'swift_code',  # noqa: E501
        'account_type': 'account_type',  # noqa: E501
        'account_details': 'account_details',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'token_id': 'token_id',  # noqa: E501
        'payment_code': 'payment_code',  # noqa: E501
        'expires_at': 'expires_at',  # noqa: E501
        'qr_string': 'qr_string',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """IdentityAccountResponseProperties - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_number (str): Unique account identifier as per the bank records.. [optional]  # noqa: E501
            account_holder_name (str, none_type): Name of account holder as per the cardless credit account.. [optional]  # noqa: E501
            swift_code (str, none_type): The SWIFT code for international payments. [optional]  # noqa: E501
            account_type (str, none_type): Free text account type, e.g., Savings, Transaction, Virtual Account.. [optional]  # noqa: E501
            account_details (str, none_type): Potentially masked account detail, for display purposes only.. [optional]  # noqa: E501
            currency (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            token_id (str): The token id returned in tokenisation. [optional]  # noqa: E501
            payment_code (str): Complete fixed payment code (including prefix). [optional]  # noqa: E501
            expires_at (str, none_type): YYYY-MM-DD string with expiry date for the payment code. [optional]  # noqa: E501
            qr_string (str): String representation of the QR Code image. [optional]  # noqa: E501
            account_id (str): Alphanumeric string identifying this account. Usually an email address or phone number.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """IdentityAccountResponseProperties - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_number (str): Unique account identifier as per the bank records.. [optional]  # noqa: E501
            account_holder_name (str, none_type): Name of account holder as per the cardless credit account.. [optional]  # noqa: E501
            swift_code (str, none_type): The SWIFT code for international payments. [optional]  # noqa: E501
            account_type (str, none_type): Free text account type, e.g., Savings, Transaction, Virtual Account.. [optional]  # noqa: E501
            account_details (str, none_type): Potentially masked account detail, for display purposes only.. [optional]  # noqa: E501
            currency (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            token_id (str): The token id returned in tokenisation. [optional]  # noqa: E501
            payment_code (str): Complete fixed payment code (including prefix). [optional]  # noqa: E501
            expires_at (str, none_type): YYYY-MM-DD string with expiry date for the payment code. [optional]  # noqa: E501
            qr_string (str): String representation of the QR Code image. [optional]  # noqa: E501
            account_id (str): Alphanumeric string identifying this account. Usually an email address or phone number.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                elif isinstance(arg, str):
                    kwargs.update({"value": arg})
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
              AccountBank,
              AccountCard,
              AccountEwallet,
              AccountOTC,
              AccountPayLater,
              AccountQRCode,
          ],
          'allOf': [
          ],
          'oneOf': [
          ],
        }
