"""
    Payment Method Service v2

    This API is used for Payment Method Service v2  # noqa: E501

    The version of the OpenAPI document: 2.128.0
"""

import re  # noqa: F401
import sys  # noqa: F401

from xendit.api_client import ApiClient, Endpoint as _Endpoint
from xendit.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from typing import Optional, List # noqa: F401

from xendit.payment_method.model import *  # noqa: F401,E501

class PaymentMethodApi(object):
    """NOTE: This class is auto generated by the OpenAPI Generator.
    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethod,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods',
                'operation_id': 'create_payment_method',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'for_user_id',
                    'payment_method_parameters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'for_user_id':
                        (str,),
                    'payment_method_parameters':
                        (PaymentMethodParameters,),
                },
                'attribute_map': {
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'for_user_id': 'header',
                    'payment_method_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_payment_method_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethod,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}',
                'operation_id': 'get_payment_method_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'for_user_id',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'for_user_id':
                        (str,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'for_user_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payments_by_payment_method_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}/payments',
                'operation_id': 'get_payments_by_payment_method_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'for_user_id',
                    'payment_request_id',
                    'payment_method_id2',
                    'reference_id',
                    'payment_method_type',
                    'channel_code',
                    'status',
                    'currency',
                    'created_gte',
                    'created_lte',
                    'updated_gte',
                    'updated_lte',
                    'limit',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'for_user_id':
                        (str,),
                    'payment_request_id':
                        ([str],),
                    'payment_method_id2':
                        ([str],),
                    'reference_id':
                        ([str],),
                    'payment_method_type':
                        ([PaymentMethodType],),
                    'channel_code':
                        ([str],),
                    'status':
                        ([str],),
                    'currency':
                        ([str],),
                    'created_gte':
                        (datetime,),
                    'created_lte':
                        (datetime,),
                    'updated_gte':
                        (datetime,),
                    'updated_lte':
                        (datetime,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                    'for_user_id': 'for-user-id',
                    'payment_request_id': 'payment_request_id',
                    'payment_method_id2': 'payment_method_id',
                    'reference_id': 'reference_id',
                    'payment_method_type': 'payment_method_type',
                    'channel_code': 'channel_code',
                    'status': 'status',
                    'currency': 'currency',
                    'created_gte': 'created[gte]',
                    'created_lte': 'created[lte]',
                    'updated_gte': 'updated[gte]',
                    'updated_lte': 'updated[lte]',
                    'limit': 'limit',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'for_user_id': 'header',
                    'payment_request_id': 'query',
                    'payment_method_id2': 'query',
                    'reference_id': 'query',
                    'payment_method_type': 'query',
                    'channel_code': 'query',
                    'status': 'query',
                    'currency': 'query',
                    'created_gte': 'query',
                    'created_lte': 'query',
                    'updated_gte': 'query',
                    'updated_lte': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                    'payment_request_id': 'multi',
                    'payment_method_id2': 'multi',
                    'reference_id': 'multi',
                    'payment_method_type': 'multi',
                    'channel_code': 'multi',
                    'status': 'multi',
                    'currency': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethod,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}',
                'operation_id': 'patch_payment_method',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'for_user_id',
                    'payment_method_update_parameters',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'for_user_id':
                        (str,),
                    'payment_method_update_parameters':
                        (PaymentMethodUpdateParameters,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'for_user_id': 'header',
                    'payment_method_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_all_payment_methods_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethodList,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods',
                'operation_id': 'get_all_payment_methods',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'for_user_id',
                    'id',
                    'type',
                    'status',
                    'reusability',
                    'customer_id',
                    'reference_id',
                    'after_id',
                    'before_id',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'for_user_id':
                        (str,),
                    'id':
                        ([str],),
                    'type':
                        ([str],),
                    'status':
                        ([PaymentMethodStatus],),
                    'reusability':
                        (PaymentMethodReusability,),
                    'customer_id':
                        (str,),
                    'reference_id':
                        (str,),
                    'after_id':
                        (str,),
                    'before_id':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'for_user_id': 'for-user-id',
                    'id': 'id',
                    'type': 'type',
                    'status': 'status',
                    'reusability': 'reusability',
                    'customer_id': 'customer_id',
                    'reference_id': 'reference_id',
                    'after_id': 'after_id',
                    'before_id': 'before_id',
                    'limit': 'limit',
                },
                'location_map': {
                    'for_user_id': 'header',
                    'id': 'query',
                    'type': 'query',
                    'status': 'query',
                    'reusability': 'query',
                    'customer_id': 'query',
                    'reference_id': 'query',
                    'after_id': 'query',
                    'before_id': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                    'id': 'multi',
                    'type': 'multi',
                    'status': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.expire_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethod,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}/expire',
                'operation_id': 'expire_payment_method',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'for_user_id',
                    'payment_method_expire_parameters',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                    'payment_method_expire_parameters',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'for_user_id':
                        (str,),
                    'payment_method_expire_parameters':
                        (PaymentMethodExpireParameters,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'for_user_id': 'header',
                    'payment_method_expire_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.auth_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentMethod,),
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}/auth',
                'operation_id': 'auth_payment_method',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'for_user_id',
                    'payment_method_auth_parameters',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'for_user_id':
                        (str,),
                    'payment_method_auth_parameters':
                        (PaymentMethodAuthParameters,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                    'for_user_id': 'for-user-id',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'for_user_id': 'header',
                    'payment_method_auth_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.simulate_payment_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v2/payment_methods/{paymentMethodId}/payments/simulate',
                'operation_id': 'simulate_payment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_method_id',
                    'simulate_payment_request',
                ],
                'required': [
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_method_id':
                        (str,),
                    'simulate_payment_request':
                        (SimulatePaymentRequest,),
                },
                'attribute_map': {
                    'payment_method_id': 'paymentMethodId',
                },
                'location_map': {
                    'payment_method_id': 'path',
                    'simulate_payment_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_payment_method(
        self,
        for_user_id: Optional[str] = None,
        payment_method_parameters: Optional[PaymentMethodParameters] = None,
        **kwargs
    ) -> PaymentMethod:
        """Creates payment method  # noqa: E501

        This endpoint initiates creation of payment method  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_method(for_user_id, payment_method_parameters, async_req=True)
        >>> result = thread.get()


        Keyword Args:
            for_user_id (str): [optional]
            payment_method_parameters (PaymentMethodParameters): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethod
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if payment_method_parameters is not None:
            kwargs['payment_method_parameters'] = payment_method_parameters
        return self.create_payment_method_endpoint.call_with_http_info(**kwargs)

    def get_payment_method_by_id(
        self,
        payment_method_id: str,
        for_user_id: Optional[str] = None,
        **kwargs
    ) -> PaymentMethod:
        """Get payment method by ID  # noqa: E501

        Get payment method by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payment_method_by_id(payment_method_id, for_user_id, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            for_user_id (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethod
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        return self.get_payment_method_by_id_endpoint.call_with_http_info(**kwargs)

    def get_payments_by_payment_method_id(
        self,
        payment_method_id: str,
        for_user_id: Optional[str] = None,
        payment_request_id: Optional[List[str]] = None,
        payment_method_id2: Optional[List[str]] = None,
        reference_id: Optional[List[str]] = None,
        payment_method_type: Optional[List[PaymentMethodType]] = None,
        channel_code: Optional[List[str]] = None,
        status: Optional[List[str]] = None,
        currency: Optional[List[str]] = None,
        created_gte: Optional[datetime] = None,
        created_lte: Optional[datetime] = None,
        updated_gte: Optional[datetime] = None,
        updated_lte: Optional[datetime] = None,
        limit: Optional[int] = None,
        **kwargs
    ) -> {str: (bool, date, datetime, dict, float, int, list, str, none_type)}:
        """Returns payments with matching PaymentMethodID.  # noqa: E501

        Returns payments with matching PaymentMethodID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payments_by_payment_method_id(payment_method_id, for_user_id, payment_request_id, payment_method_id2, reference_id, payment_method_type, channel_code, status, currency, created_gte, created_lte, updated_gte, updated_lte, limit, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            for_user_id (str): [optional]
            payment_request_id ([str]): [optional]
            payment_method_id2 ([str]): [optional]
            reference_id ([str]): [optional]
            payment_method_type ([PaymentMethodType]): [optional]
            channel_code ([str]): [optional]
            status ([str]): [optional]
            currency ([str]): [optional]
            created_gte (datetime): [optional]
            created_lte (datetime): [optional]
            updated_gte (datetime): [optional]
            updated_lte (datetime): [optional]
            limit (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if payment_request_id is not None:
            kwargs['payment_request_id'] = payment_request_id
        if payment_method_id2 is not None:
            kwargs['payment_method_id2'] = payment_method_id2
        if reference_id is not None:
            kwargs['reference_id'] = reference_id
        if payment_method_type is not None:
            kwargs['payment_method_type'] = payment_method_type
        if channel_code is not None:
            kwargs['channel_code'] = channel_code
        if status is not None:
            kwargs['status'] = status
        if currency is not None:
            kwargs['currency'] = currency
        if created_gte is not None:
            kwargs['created_gte'] = created_gte
        if created_lte is not None:
            kwargs['created_lte'] = created_lte
        if updated_gte is not None:
            kwargs['updated_gte'] = updated_gte
        if updated_lte is not None:
            kwargs['updated_lte'] = updated_lte
        if limit is not None:
            kwargs['limit'] = limit
        return self.get_payments_by_payment_method_id_endpoint.call_with_http_info(**kwargs)

    def patch_payment_method(
        self,
        payment_method_id: str,
        for_user_id: Optional[str] = None,
        payment_method_update_parameters: Optional[PaymentMethodUpdateParameters] = None,
        **kwargs
    ) -> PaymentMethod:
        """Patch payment methods  # noqa: E501

        This endpoint is used to toggle the ```status``` of an e-Wallet or a Direct Debit payment method to ```ACTIVE``` or ```INACTIVE```. This is also used to update the details of an Over-the-Counter or a Virtual Account payment method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_payment_method(payment_method_id, for_user_id, payment_method_update_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            for_user_id (str): [optional]
            payment_method_update_parameters (PaymentMethodUpdateParameters): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethod
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if payment_method_update_parameters is not None:
            kwargs['payment_method_update_parameters'] = payment_method_update_parameters
        return self.patch_payment_method_endpoint.call_with_http_info(**kwargs)

    def get_all_payment_methods(
        self,
        for_user_id: Optional[str] = None,
        id: Optional[List[str]] = None,
        type: Optional[List[str]] = None,
        status: Optional[List[PaymentMethodStatus]] = None,
        reusability: Optional[PaymentMethodReusability] = None,
        customer_id: Optional[str] = None,
        reference_id: Optional[str] = None,
        after_id: Optional[str] = None,
        before_id: Optional[str] = None,
        limit: Optional[int] = None,
        **kwargs
    ) -> PaymentMethodList:
        """Get all payment methods by filters  # noqa: E501

        Get all payment methods by filters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_payment_methods(for_user_id, id, type, status, reusability, customer_id, reference_id, after_id, before_id, limit, async_req=True)
        >>> result = thread.get()


        Keyword Args:
            for_user_id (str): [optional]
            id ([str]): [optional]
            type ([str]): [optional]
            status ([PaymentMethodStatus]): [optional]
            reusability (PaymentMethodReusability): [optional]
            customer_id (str): [optional]
            reference_id (str): [optional]
            after_id (str): [optional]
            before_id (str): [optional]
            limit (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethodList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if id is not None:
            kwargs['id'] = id
        if type is not None:
            kwargs['type'] = type
        if status is not None:
            kwargs['status'] = status
        if reusability is not None:
            kwargs['reusability'] = reusability
        if customer_id is not None:
            kwargs['customer_id'] = customer_id
        if reference_id is not None:
            kwargs['reference_id'] = reference_id
        if after_id is not None:
            kwargs['after_id'] = after_id
        if before_id is not None:
            kwargs['before_id'] = before_id
        if limit is not None:
            kwargs['limit'] = limit
        return self.get_all_payment_methods_endpoint.call_with_http_info(**kwargs)

    def expire_payment_method(
        self,
        payment_method_id: str,
        for_user_id: Optional[str] = None,
        payment_method_expire_parameters: Optional[PaymentMethodExpireParameters] = None,
        **kwargs
    ) -> PaymentMethod:
        """Expires a payment method  # noqa: E501

        This endpoint expires a payment method and performs unlinking if necessary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.expire_payment_method(payment_method_id, for_user_id, payment_method_expire_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            for_user_id (str): [optional]
            payment_method_expire_parameters (PaymentMethodExpireParameters): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethod
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if payment_method_expire_parameters is not None:
            kwargs['payment_method_expire_parameters'] = payment_method_expire_parameters
        return self.expire_payment_method_endpoint.call_with_http_info(**kwargs)

    def auth_payment_method(
        self,
        payment_method_id: str,
        for_user_id: Optional[str] = None,
        payment_method_auth_parameters: Optional[PaymentMethodAuthParameters] = None,
        **kwargs
    ) -> PaymentMethod:
        """Validate a payment method's linking OTP  # noqa: E501

        This endpoint validates a payment method linking OTP  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.auth_payment_method(payment_method_id, for_user_id, payment_method_auth_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            for_user_id (str): [optional]
            payment_method_auth_parameters (PaymentMethodAuthParameters): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentMethod
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if for_user_id is not None:
            kwargs['for_user_id'] = for_user_id
        if payment_method_auth_parameters is not None:
            kwargs['payment_method_auth_parameters'] = payment_method_auth_parameters
        return self.auth_payment_method_endpoint.call_with_http_info(**kwargs)

    def simulate_payment(
        self,
        payment_method_id: str,
        simulate_payment_request: Optional[SimulatePaymentRequest] = None,
        **kwargs
    ) -> None:
        """Makes payment with matching PaymentMethodID.  # noqa: E501

        Makes payment with matching PaymentMethodID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.simulate_payment(payment_method_id, simulate_payment_request, async_req=True)
        >>> result = thread.get()

        Args:
            payment_method_id (str):

        Keyword Args:
            simulate_payment_request (SimulatePaymentRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_method_id'] = payment_method_id
        if simulate_payment_request is not None:
            kwargs['simulate_payment_request'] = simulate_payment_request
        return self.simulate_payment_endpoint.call_with_http_info(**kwargs)

