## Message Queue Client for Python

### 生成安装包
参考 https://packaging.python.org/tutorials/packaging-projects/

- 升级安装必要工具

```python
python3 -m pip install --upgrade build
python3 -m pip install --user --upgrade twine
```

- 生成安装包

```python
python3 -m build
```

- 上传安装包

```python
python3 -m twine upload --repository-url https://<私有镜像地址> dist/*
```

默认上传到 https://pypi.org

```python
python3 -m twine upload  dist/*
```

### 使用安装包

- 发送消息

```python
from xmq_python.producer import Producer
producer = Producer(producer_group_id='BOH', lookup_address='rocketmq-ns.infra:9876')
producer.start()
producer.Publish('order','demand',{"id":123, "name": "neil"})
producer.stop()

```

- 接收消息

```python

from xmq_python.comsumer import Comsumer
import time
def callback(message):
    print("Got message: ", message)
    return True
comsumer = Comsumer(comsumer_group_id='BOH', lookup_address='rocketmq-ns.infra:9876')
comsumer.Register("order","demand",callback)
comsumer.start()
time.sleep(100)
comsumer.stop()
```
