from typing import Optional, List, Dict, Any, Union
from datetime import datetime
from ..types.types import Role, Language, DeviceType, LookingFor, Gender, RelationshipStatus, NewsType


class StageInfo:
    def __init__(self):
        self.id: Optional[int] = None
        self.locked: Optional[bool] = None
        self.occupier_id: Optional[int] = None
        self.occupier_muted: Optional[bool] = None
        self.uuid: Optional[str] = None
        self.connection_state: Optional[str] = None


class AdminActionResult:
    def __init__(self):
        self.success: bool = False
        self.no_power: bool = False
        self.insufficient_power: bool = False
        self.bot_no_longer_in_group: bool = False
        self.user_no_longer_in_group: bool = False
        self.full_admin_not_enabled: bool = False
        self.unknown_reason: bool = False


class GroupActionResult:
    def __init__(self):
        self.success: bool = False
        self.higher_level: bool = False
        self.group_is_full: bool = False
        self.hit_group_limit: bool = False
        self.no_longer_exists: bool = False
        self.banned: bool = False
        self.restricted_to_new_users: bool = False
        self.group_is_closed: bool = False
        self.too_many_accounts: bool = False
        self.group_can_only_be_joined_from_game: bool = False
        self.already_in_group: bool = False
        self.group_not_found: bool = False
        self.unknown_error: bool = False


class GroupMember:
    def __init__(self):
        self.id: Optional[int] = None
        self.hash: Optional[str] = None
        self.capabilities: Optional[Role] = None
        self.sort: Optional[Dict[str, Any]] = None


class SelectedList:
    def __init__(self):
        self.charm_id: Optional[int] = None
        self.position: Optional[int] = None


class Charms:
    def __init__(self):
        self.id: Optional[int] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.product_id: Optional[int] = None
        self.image_url: Optional[str] = None


class ExpiredCharms:
    def __init__(self):
        self.id: Optional[int] = None
        self.charm_id: Optional[int] = None
        self.subscriber_id: Optional[int] = None
        self.source_subscriber_id: Optional[int] = None
        self.expire_time: Optional[datetime] = None


class CharmStats:
    def __init__(self):
        self.subscriber_id: Optional[int] = None
        self.total_lifetime: Optional[int] = None
        self.total_gifted_sent: Optional[int] = None
        self.total_gifted_received: Optional[int] = None
        self.total_active: Optional[int] = None
        self.total_expired: Optional[int] = None


class Welcome:
    def __init__(self):
        self.ip: Optional[str] = None
        self.country: Optional[str] = None
        self.token: Optional[str] = None
        self.endpoint_config: Optional[Dict[str, Any]] = None


class ClientModel:
    def __init__(self):
        self.cognito: Optional[Dict[str, str]] = None
        self.subscriber: Optional[Dict[str, Any]] = None
        self.is_new: Optional[bool] = None


class ExtendedClient(ClientModel):
    def __init__(self):
        super().__init__()
        self.extended: Optional[Dict[str, Any]] = None
        self.is_staff: Optional[bool] = None
        self.is_volunteer: Optional[bool] = None
        self.is_agent: Optional[bool] = None
        self.is_vip: Optional[bool] = None
        self.is_bot: Optional[bool] = None
        self.is_pest: Optional[bool] = None
        self.is_elite_club_one: Optional[bool] = None
        self.is_elite_club_two: Optional[bool] = None
        self.is_elite_club_three: Optional[bool] = None
        self.is_select_club_one: Optional[bool] = None
        self.is_select_club_two: Optional[bool] = None
        self.is_shadow_banned: Optional[bool] = None
        self.has_premium: Optional[bool] = None
        self.avatar: Optional[str] = None


class User:
    def __init__(self):
        self.id: Optional[int] = None
        self.hash: Optional[str] = None
        self.privileges: Optional[int] = None
        self.nickname: Optional[str] = None
        self.status: Optional[str] = None
        self.reputation: Optional[int] = None
        self.icon: Optional[int] = None
        self.online_state: Optional[int] = None
        self.device_type: Optional[DeviceType] = None
        self.group_member_capabilities: Optional[Role] = None
        self.contact_list_blocked_state: Optional[Any] = None
        self.contact_list_auth_state: Optional[Any] = None
        self.charms: Optional[List[SelectedList]] = None
        self.email: Optional[str] = None


class ExtendedUser(User):
    def __init__(self):
        super().__init__()
        self.extended: Optional[Dict[str, Any]] = None
        self.is_staff: Optional[bool] = None
        self.is_volunteer: Optional[bool] = None
        self.is_agent: Optional[bool] = None
        self.is_vip: Optional[bool] = None
        self.is_bot: Optional[bool] = None
        self.is_pest: Optional[bool] = None
        self.is_elite_club_one: Optional[bool] = None
        self.is_elite_club_two: Optional[bool] = None
        self.is_elite_club_three: Optional[bool] = None
        self.is_select_club_one: Optional[bool] = None
        self.is_select_club_two: Optional[bool] = None
        self.is_shadow_banned: Optional[bool] = None
        self.has_premium: Optional[bool] = None
        self.avatar: Optional[str] = None


class CGroup:
    def __init__(self):
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.extended: Optional[Dict[str, Any]] = None
        self.password: Optional[str] = None
        self.peekable: Optional[bool] = None


class Group:
    def __init__(self):
        self.id: Optional[int] = None
        self.name: Optional[str] = None
        self.hash: Optional[str] = None
        self.description: Optional[str] = None
        self.reputation: Optional[int] = None
        self.premium: Optional[bool] = None
        self.members: Optional[int] = None
        self.official: Optional[bool] = None
        self.owner: Optional[Dict[str, Any]] = None
        self.peekable: Optional[bool] = None
        self.icon: Optional[int] = None


class ExtendedGroup(Group):
    def __init__(self):
        super().__init__()
        self.discoverable: Optional[bool] = None
        self.advanced_admin: Optional[bool] = None
        self.locked: Optional[bool] = None
        self.questionable: Optional[bool] = None
        self.entry_level: Optional[int] = None
        self.passworded: Optional[bool] = None
        self.language: Optional[Language] = None


class Message:
    def __init__(self, msg: Optional[Dict[str, Any]] = None):
        self.id: Optional[str] = None
        self.recipient: Optional[int] = None
        self.originator: Optional[int] = None
        self.is_group: Optional[bool] = None
        self.timestamp: Optional[datetime] = None
        self.mime_type: Optional[str] = None
        self.data: Optional[bytes] = None
        self.flight_id: Optional[str] = None

        self.is_image: bool = False
        self.is_text: bool = False
        self.is_voice: bool = False
        self.is_html: bool = False
        self.text: Optional[str] = None

        if msg:
            self.id = msg.get('id')
            self.is_group = msg.get('isGroup')
            self.mime_type = msg.get('mimeType')
            self.originator = msg.get('originator')
            self.recipient = msg.get('recipient')
            self.data = msg.get('data')
            self.timestamp = msg.get('timestamp')
            self.flight_id = msg.get('flightId')

            self.is_image = self.mime_type in ['text/image_link', 'image/jpeg']
            self.is_text = self.mime_type == 'text/plain'
            self.is_voice = self.mime_type in ['audio/x-speex', 'text/voice_link']
            self.is_html = self.mime_type == 'text/html'

            if self.mime_type != 'audio/x-speex' and self.data:
                if isinstance(self.data, bytes):
                    self.text = self.data.decode('utf-8')
                else:
                    self.text = str(self.data)


class ExtendedMessage(Message):
    def __init__(self, msg: Optional[Dict[str, Any]] = None):
        super().__init__(msg)
        self.user_profile: Optional[ExtendedUser] = None
        self.group: Optional[Group] = None


class AdminAction:
    def __init__(self):
        self.type: Optional[str] = None
        self.group_id: Optional[int] = None
        self.target_id: Optional[int] = None
        self.source_id: Optional[int] = None


class Achievements:
    def __init__(self):
        self.id: Optional[int] = None
        self.type_id: Optional[int] = None
        self.parent_id: Optional[int] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.image_url: Optional[str] = None
        self.notification_phrase_id: Optional[Any] = None
        self.weight: Optional[int] = None
        self.is_secret: Optional[bool] = None
        self.client: Optional[int] = None
        self.children: Optional[List[Dict[str, Any]]] = None


class UserAchievements:
    def __init__(self):
        self.achievement_id: Optional[int] = None
        self.update_time: Optional[datetime] = None


class GroupStatistics:
    def __init__(self):
        self.id: Optional[int] = None
        self.name: Optional[str] = None
        self.owner: Optional[Dict[str, Any]] = None
        self.word_count: Optional[int] = None
        self.text_count: Optional[int] = None
        self.line_count: Optional[int] = None
        self.swear_count: Optional[int] = None
        self.question_count: Optional[int] = None
        self.image_count: Optional[int] = None
        self.action_count: Optional[int] = None
        self.voice_count: Optional[int] = None
        self.emotion_count: Optional[int] = None
        self.happy_count: Optional[int] = None
        self.sad_count: Optional[int] = None
        self.pack_count: Optional[int] = None
        self.spoken_count: Optional[int] = None
        self.member_count: Optional[int] = None
        self.trends_hour: Optional[List[Dict[str, int]]] = None
        self.trends_day: Optional[List[Dict[str, int]]] = None
        self.trends: Optional[List[Dict[str, int]]] = None
        self.top25: Optional[List[Dict[str, Any]]] = None
        self.top30: Optional[List[Dict[str, Any]]] = None
        self.top_word: Optional[List[Dict[str, Any]]] = None
        self.top_text: Optional[List[Dict[str, Any]]] = None
        self.top_question: Optional[List[Dict[str, Any]]] = None
        self.top_emoticon: Optional[List[Dict[str, Any]]] = None
        self.top_happy: Optional[List[Dict[str, Any]]] = None
        self.top_sad: Optional[List[Dict[str, Any]]] = None
        self.top_swear: Optional[List[Dict[str, Any]]] = None
        self.top_image: Optional[List[Dict[str, Any]]] = None
        self.top_action: Optional[List[Dict[str, Any]]] = None


class Notifications:
    def __init__(self):
        self.id: Optional[int] = None
        self.type: Optional[int] = None
        self.title: Optional[str] = None
        self.message: Optional[str] = None
        self.link: Optional[str] = None
        self.start_at: Optional[datetime] = None
        self.end_at: Optional[datetime] = None
        self.global_flag: Optional[bool] = None
        self.image_url: Optional[str] = None
        self.layout_type: Optional[int] = None
        self.news_stream_type: Optional[NewsType] = None
        self.actions: Optional[Any] = None
        self.persistent: Optional[bool] = None
        self.favourite: Optional[bool] = None


class TopicList:
    def __init__(self):
        self.type: Optional[str] = None
        self.title: Optional[str] = None
        self.layout: Optional[str] = None
        self.limit: Optional[int] = None
        self.language: Optional[int] = None
        self.recipe_id: Optional[str] = None
        self.links: Optional[List[Dict[str, str]]] = None
