# Example Python CLI commands using the YellowDog Python SDK

## Overview

This is a set of Python CLI commands for interacting with the YellowDog Platform, providing examples of usage of the [YellowDog Python SDK](https://docs.yellowdog.ai/sdk/python/index.html).

The commands support:

- **Aborting** running Tasks with the **`yd-abort`** command
- **Boosting** Allowances with the **`yd-boost`** command
- **Cancelling** Work Requirements with the **`yd-cancel`** command
- **Comparing** whether worker pools are a match for task groups with the **`yd-compare`** command
- **Creating, Updating and Removing** Compute Source Templates, Compute Requirement Templates, Keyrings, Credentials, Storage Configurations, Image Families, Allowances, Configured Worker Pools, User Attributes, Namespace Policies, Groups, and Applications with the **`yd-create`** and **`yd-remove`** commands
- **Deleting** objects in the YellowDog Object Store with the **`yd-delete`** command
- **Downloading** Results from the YellowDog Object Store with the **`yd-download`** command
- **Finishing** Work Requirements with the **`yd-finish`** command
- **Following Event Streams** for Work Requirements, Worker Pools and Compute Requirements with the **`yd-follow`** command
- **Instantiating** Compute Requirements with the **`yd-instantiate`** command
- **Listing** YellowDog items using the **`yd-list`** command
- **Provisioning** Worker Pools with the **`yd-provision`** command
- **Resizing** Worker Pools and Compute Requirements with the **`yd-resize`** command
- **Showing** the details of any YellowDog entity using its YellowDog ID with the **`yd-show`** command
- **Shutting Down** Worker Pools and Nodes with the **`yd-shutdown`** command
- **Starting** HELD Work Requirements and **Holding** (or pausing) RUNNING Work Requirements with the **`yd-start`** and **`yd-hold`** commands
- **Submitting** Work Requirements with the **`yd-submit`** command
- **Terminating** Compute Requirements with the **`yd-terminate`** command
- **Uploading** files to the YellowDog Object Store with the **`yd-upload`** command

Please see the documentation in the [GitHub repository](https://github.com/yellowdog/python-examples) for more details.
