# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from yeying.api.asset import asset_pb2 as yeying_dot_api_dot_asset_dot_asset__pb2

GRPC_GENERATED_VERSION = '1.68.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in yeying/api/asset/asset_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class AssetStub(object):
    """*

    整个资产仓库基于分布式数字身份和资产内容哈希驱动，并能够在不同资产仓库间转移

    开放的分散式仓库网络的接口设计，参考了现实世界中的仓库，逻辑如下：
    1、数字资产有两个标识，一个是数字资产的身份标识，可以是分布式数字身份，也可以是用户自定义的身份ID，另一个是数字资产内容的哈希值；
    2、数字资产入库，发送到指定存储网络中的节点，可以指定副本数量，一方面保证内容不会因为单个节点故障而丢失，另外也保证内容的可访问性；
    3、存储复用，如果两份资产哈希值一样，分两种情况来看，如果资产的所有者一样，则仓库会主动告知身份持有者存在重复，如果资产的所有者不同，会增加引用；
    4、授权数字资产，所有者和使用者立交易关系，确保使用者根据指定的策略访问数据，仓库会统计数字资产的使用情况，比如统计内容取（浏览）的次数评估内容热度
    ，或者统计内容存的次数（收藏）评估内容质量，目的是更好的分配存储资源；

    仓库使用场景：
    1、创作场景，知识产权证明
    2、代码包分发场景，比如软件包，模型包等
    3、数字资产，类似nft等

    资产定位逻辑：

    采用三元组唯一定位，(用户身份、命名空间、哈希值)
    命名空间的定位逻辑：某个用户下面是唯一的，命名空间所有者，可以指定多个参与者，用于存储完成某项工作生成资产数据，这些资产数据属于命名空间所有者
    资产的定位逻辑：每个命名空间是隔离的，同一个所有者，同一个命名空间，资产哈希值必须唯一
    资产块的定位逻辑：每个命名空间是隔离的，用一个所有者，同一个命名空间，资产块是唯一的，资产块维持一个引用计数，其逻辑如下：
    - 当有一个新资产放入命名空间，则引用计数加1；
    - 当有一个老资产移出命名空间，则引用计数减1；
    当某个资产块的引用计数为0，表示没有和资产仓库服务签约，只是临时存储，通常分块上传完成以后就会立即签约，但是考虑委托第三方服务生成的数据直接放到命名
    空间，第三方服务没有命名空间所有者的私钥，无法和资产仓库完成签约，只能先上传，事后由命名空间所有者完成签名；

    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Search = channel.unary_unary(
                '/yeying.api.asset.Asset/Search',
                request_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetRequest.SerializeToString,
                response_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetResponse.FromString,
                _registered_method=True)
        self.Sign = channel.unary_unary(
                '/yeying.api.asset.Asset/Sign',
                request_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetRequest.SerializeToString,
                response_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetResponse.FromString,
                _registered_method=True)
        self.Update = channel.unary_unary(
                '/yeying.api.asset.Asset/Update',
                request_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetRequest.SerializeToString,
                response_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetResponse.FromString,
                _registered_method=True)
        self.Detail = channel.unary_unary(
                '/yeying.api.asset.Asset/Detail',
                request_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailRequest.SerializeToString,
                response_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailResponse.FromString,
                _registered_method=True)
        self.Delete = channel.unary_unary(
                '/yeying.api.asset.Asset/Delete',
                request_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetRequest.SerializeToString,
                response_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetResponse.FromString,
                _registered_method=True)


class AssetServicer(object):
    """*

    整个资产仓库基于分布式数字身份和资产内容哈希驱动，并能够在不同资产仓库间转移

    开放的分散式仓库网络的接口设计，参考了现实世界中的仓库，逻辑如下：
    1、数字资产有两个标识，一个是数字资产的身份标识，可以是分布式数字身份，也可以是用户自定义的身份ID，另一个是数字资产内容的哈希值；
    2、数字资产入库，发送到指定存储网络中的节点，可以指定副本数量，一方面保证内容不会因为单个节点故障而丢失，另外也保证内容的可访问性；
    3、存储复用，如果两份资产哈希值一样，分两种情况来看，如果资产的所有者一样，则仓库会主动告知身份持有者存在重复，如果资产的所有者不同，会增加引用；
    4、授权数字资产，所有者和使用者立交易关系，确保使用者根据指定的策略访问数据，仓库会统计数字资产的使用情况，比如统计内容取（浏览）的次数评估内容热度
    ，或者统计内容存的次数（收藏）评估内容质量，目的是更好的分配存储资源；

    仓库使用场景：
    1、创作场景，知识产权证明
    2、代码包分发场景，比如软件包，模型包等
    3、数字资产，类似nft等

    资产定位逻辑：

    采用三元组唯一定位，(用户身份、命名空间、哈希值)
    命名空间的定位逻辑：某个用户下面是唯一的，命名空间所有者，可以指定多个参与者，用于存储完成某项工作生成资产数据，这些资产数据属于命名空间所有者
    资产的定位逻辑：每个命名空间是隔离的，同一个所有者，同一个命名空间，资产哈希值必须唯一
    资产块的定位逻辑：每个命名空间是隔离的，用一个所有者，同一个命名空间，资产块是唯一的，资产块维持一个引用计数，其逻辑如下：
    - 当有一个新资产放入命名空间，则引用计数加1；
    - 当有一个老资产移出命名空间，则引用计数减1；
    当某个资产块的引用计数为0，表示没有和资产仓库服务签约，只是临时存储，通常分块上传完成以后就会立即签约，但是考虑委托第三方服务生成的数据直接放到命名
    空间，第三方服务没有命名空间所有者的私钥，无法和资产仓库完成签约，只能先上传，事后由命名空间所有者完成签名；

    """

    def Search(self, request, context):
        """*
        检索数字内容，基于数字内容的元信息检索，比如哈希值、时间、类型、名称等, 如果什么条件都不传入，则按照默认的排序顺序，返回第一个10条记录。
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Sign(self, request, context):
        """*
        以事务的形式和存储供应商签订协议并入库，当所有资产块入库成功后，资产的信息发送到后端服务签字确认，涵盖了新的资产和新的版本入库；
        1、根据规则，自动生成新的版本，资产身份不变，但是资产内容的哈希值会变
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """*
        更新资产元信息
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Detail(self, request, context):
        """*
        获得资产详细信息，提供该接口是为了更灵活处理资产信息，资产信息的复杂主要是几个方面：
        1、资产分块，资产的块信息可能会很大
        2、多版本，资产描述信息也会很大
        3、分散存储，如果资产过大，可能会被存储到不同的供应商
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """*
        删除资产，不回立即删除，而是放入回收站；资产支持多版本，在删除的时候，采取头或者尾部删除，不能从中间删除，确保版本的链条能够正常工作；
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_AssetServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Search': grpc.unary_unary_rpc_method_handler(
                    servicer.Search,
                    request_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetRequest.FromString,
                    response_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetResponse.SerializeToString,
            ),
            'Sign': grpc.unary_unary_rpc_method_handler(
                    servicer.Sign,
                    request_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetRequest.FromString,
                    response_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetRequest.FromString,
                    response_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetResponse.SerializeToString,
            ),
            'Detail': grpc.unary_unary_rpc_method_handler(
                    servicer.Detail,
                    request_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailRequest.FromString,
                    response_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetRequest.FromString,
                    response_serializer=yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'yeying.api.asset.Asset', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('yeying.api.asset.Asset', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Asset(object):
    """*

    整个资产仓库基于分布式数字身份和资产内容哈希驱动，并能够在不同资产仓库间转移

    开放的分散式仓库网络的接口设计，参考了现实世界中的仓库，逻辑如下：
    1、数字资产有两个标识，一个是数字资产的身份标识，可以是分布式数字身份，也可以是用户自定义的身份ID，另一个是数字资产内容的哈希值；
    2、数字资产入库，发送到指定存储网络中的节点，可以指定副本数量，一方面保证内容不会因为单个节点故障而丢失，另外也保证内容的可访问性；
    3、存储复用，如果两份资产哈希值一样，分两种情况来看，如果资产的所有者一样，则仓库会主动告知身份持有者存在重复，如果资产的所有者不同，会增加引用；
    4、授权数字资产，所有者和使用者立交易关系，确保使用者根据指定的策略访问数据，仓库会统计数字资产的使用情况，比如统计内容取（浏览）的次数评估内容热度
    ，或者统计内容存的次数（收藏）评估内容质量，目的是更好的分配存储资源；

    仓库使用场景：
    1、创作场景，知识产权证明
    2、代码包分发场景，比如软件包，模型包等
    3、数字资产，类似nft等

    资产定位逻辑：

    采用三元组唯一定位，(用户身份、命名空间、哈希值)
    命名空间的定位逻辑：某个用户下面是唯一的，命名空间所有者，可以指定多个参与者，用于存储完成某项工作生成资产数据，这些资产数据属于命名空间所有者
    资产的定位逻辑：每个命名空间是隔离的，同一个所有者，同一个命名空间，资产哈希值必须唯一
    资产块的定位逻辑：每个命名空间是隔离的，用一个所有者，同一个命名空间，资产块是唯一的，资产块维持一个引用计数，其逻辑如下：
    - 当有一个新资产放入命名空间，则引用计数加1；
    - 当有一个老资产移出命名空间，则引用计数减1；
    当某个资产块的引用计数为0，表示没有和资产仓库服务签约，只是临时存储，通常分块上传完成以后就会立即签约，但是考虑委托第三方服务生成的数据直接放到命名
    空间，第三方服务没有命名空间所有者的私钥，无法和资产仓库完成签约，只能先上传，事后由命名空间所有者完成签名；

    """

    @staticmethod
    def Search(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/yeying.api.asset.Asset/Search',
            yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetRequest.SerializeToString,
            yeying_dot_api_dot_asset_dot_asset__pb2.SearchAssetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Sign(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/yeying.api.asset.Asset/Sign',
            yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetRequest.SerializeToString,
            yeying_dot_api_dot_asset_dot_asset__pb2.SignAssetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/yeying.api.asset.Asset/Update',
            yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetRequest.SerializeToString,
            yeying_dot_api_dot_asset_dot_asset__pb2.UpdateAssetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Detail(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/yeying.api.asset.Asset/Detail',
            yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailRequest.SerializeToString,
            yeying_dot_api_dot_asset_dot_asset__pb2.AssetDetailResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/yeying.api.asset.Asset/Delete',
            yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetRequest.SerializeToString,
            yeying_dot_api_dot_asset_dot_asset__pb2.DeleteAssetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
