"""Custom colormaps for yieldplotlib."""

import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap

# Define colors that can be accessed as variables
ypl_colors = {
    "ypl_red": "#fe393c",
    "ypl_yellow": "#fdc171",
    "ypl_green": "#37b800",
    "ypl_cyan": "#03c5c2",
    "ypl_blue": "#035cd6",
    "ypl_magenta": "#ba23fb",
    "ypl_dark_gray": "#555555",
    "ypl_light_gray": "#aaaaaa",
}

# Define cycler objects
ypl_cycler = plt.cycler(
    "color",
    ["#000000", "#fe393c", "#035cd6", "#37b800", "#fdc171", "#03c5c2", "#ba23fb"],
)

ypl_rainbow = plt.cycler(
    "color",
    [
        "#f74d50",
        "#fc5b12",
        "#cc7601",
        "#939205",
        "#38bc01",
        "#00ca68",
        "#00c4c1",
        "#1bb7fd",
        "#60a4fe",
        "#9495fe",
        "#d781fc",
        "#fd82bd",
    ],
)


# Create the colormap
ypl_cmap_data = [
    (0.0000, 0.0000, 0.0000),
    (0.0043, 0.0044, 0.0001),
    (0.0084, 0.0088, 0.0002),
    (0.0123, 0.0133, 0.0005),
    (0.0160, 0.0179, 0.0000),
    (0.0195, 0.0226, 0.0000),
    (0.0228, 0.0273, 0.0003),
    (0.0260, 0.0320, 0.0009),
    (0.0289, 0.0369, 0.0011),
    (0.0316, 0.0418, 0.0015),
    (0.0341, 0.0468, 0.0020),
    (0.0363, 0.0519, 0.0021),
    (0.0384, 0.0571, 0.0026),
    (0.0395, 0.0630, 0.0004),
    (0.0410, 0.0684, 0.0010),
    (0.0423, 0.0738, 0.0018),
    (0.0433, 0.0793, 0.0028),
    (0.0436, 0.0852, 0.0025),
    (0.0427, 0.0920, 0.0002),
    (0.0428, 0.0978, 0.0014),
    (0.0426, 0.1037, 0.0029),
    (0.0402, 0.1110, 0.0007),
    (0.0394, 0.1171, 0.0025),
    (0.0372, 0.1240, 0.0026),
    (0.0330, 0.1319, 0.0007),
    (0.0311, 0.1383, 0.0031),
    (0.0257, 0.1467, 0.0016),
    (0.0196, 0.1553, 0.0003),
    (0.0164, 0.1621, 0.0036),
    (0.0070, 0.1723, 0.0007),
    (0.0028, 0.1794, 0.0045),
    (0.0030, 0.1841, 0.0129),
    (0.0036, 0.1887, 0.0217),
    (0.0047, 0.1930, 0.0307),
    (0.0007, 0.1999, 0.0358),
    (0.0045, 0.2029, 0.0468),
    (0.0005, 0.2096, 0.0525),
    (0.0029, 0.2133, 0.0623),
    (0.0059, 0.2168, 0.0722),
    (0.0022, 0.2233, 0.0787),
    (0.0060, 0.2264, 0.0889),
    (0.0046, 0.2319, 0.0967),
    (0.0011, 0.2382, 0.1038),
    (0.0061, 0.2409, 0.1141),
    (0.0028, 0.2471, 0.1217),
    (0.0088, 0.2493, 0.1320),
    (0.0058, 0.2554, 0.1398),
    (0.0048, 0.2606, 0.1484),
    (0.0018, 0.2666, 0.1567),
    (0.0095, 0.2682, 0.1668),
    (0.0068, 0.2741, 0.1754),
    (0.0040, 0.2799, 0.1842),
    (0.0013, 0.2857, 0.1932),
    (0.0008, 0.2906, 0.2025),
    (0.0107, 0.2914, 0.2120),
    (0.0084, 0.2970, 0.2213),
    (0.0062, 0.3026, 0.2309),
    (0.0040, 0.3081, 0.2406),
    (0.0019, 0.3135, 0.2505),
    (0.0019, 0.3181, 0.2604),
    (0.0147, 0.3180, 0.2686),
    (0.0131, 0.3232, 0.2787),
    (0.0116, 0.3284, 0.2889),
    (0.0102, 0.3335, 0.2993),
    (0.0088, 0.3385, 0.3099),
    (0.0097, 0.3427, 0.3202),
    (0.0085, 0.3477, 0.3310),
    (0.0075, 0.3525, 0.3421),
    (0.0066, 0.3573, 0.3532),
    (0.0058, 0.3620, 0.3646),
    (0.0051, 0.3667, 0.3760),
    (0.0066, 0.3706, 0.3868),
    (0.0063, 0.3751, 0.3985),
    (0.0060, 0.3796, 0.4103),
    (0.0059, 0.3839, 0.4222),
    (0.0060, 0.3882, 0.4342),
    (0.0062, 0.3924, 0.4463),
    (0.0087, 0.3959, 0.4575),
    (0.0093, 0.3999, 0.4697),
    (0.0101, 0.4039, 0.4821),
    (0.0110, 0.4078, 0.4945),
    (0.0122, 0.4116, 0.5070),
    (0.0135, 0.4153, 0.5196),
    (0.0171, 0.4183, 0.5308),
    (0.0189, 0.4218, 0.5434),
    (0.0209, 0.4253, 0.5561),
    (0.0021, 0.4346, 0.5841),
    (0.0044, 0.4378, 0.5974),
    (0.0070, 0.4410, 0.6108),
    (0.0119, 0.4434, 0.6224),
    (0.0150, 0.4463, 0.6357),
    (0.0184, 0.4492, 0.6490),
    (0.0008, 0.4575, 0.6810),
    (0.0047, 0.4600, 0.6949),
    (0.0089, 0.4624, 0.7086),
    (0.0154, 0.4642, 0.7204),
    (0.0202, 0.4664, 0.7341),
    (0.0043, 0.4737, 0.7692),
    (0.0098, 0.4755, 0.7833),
    (0.0156, 0.4773, 0.7972),
    (0.0010, 0.4837, 0.8343),
    (0.0098, 0.4846, 0.8463),
    (0.0167, 0.4859, 0.8604),
    (0.0039, 0.4914, 0.8992),
    (0.0118, 0.4923, 0.9136),
    (0.0004, 0.4970, 0.9536),
    (0.0093, 0.4975, 0.9682),
    (0.0206, 0.4974, 0.9798),
    (0.0303, 0.4977, 0.9940),
    (0.0589, 0.4945, 0.9804),
    (0.0690, 0.4947, 0.9936),
    (0.0975, 0.4918, 0.9782),
    (0.1081, 0.4919, 0.9905),
    (0.1206, 0.4917, 1.0000),
    (0.1486, 0.4894, 0.9822),
    (0.1599, 0.4894, 0.9934),
    (0.1873, 0.4875, 0.9739),
    (0.1989, 0.4876, 0.9842),
    (0.2107, 0.4875, 0.9942),
    (0.2384, 0.4862, 0.9702),
    (0.2504, 0.4863, 0.9794),
    (0.2627, 0.4862, 0.9883),
    (0.2752, 0.4861, 0.9970),
    (0.3004, 0.4858, 0.9728),
    (0.3129, 0.4858, 0.9806),
    (0.3265, 0.4858, 0.9860),
    (0.3396, 0.4857, 0.9933),
    (0.3536, 0.4855, 0.9981),
    (0.3690, 0.4855, 0.9984),
    (0.3843, 0.4856, 0.9984),
    (0.3995, 0.4857, 0.9982),
    (0.4143, 0.4857, 0.9998),
    (0.4296, 0.4859, 0.9991),
    (0.4448, 0.4861, 0.9982),
    (0.4597, 0.4863, 0.9991),
    (0.4746, 0.4864, 0.9997),
    (0.4899, 0.4870, 0.9960),
    (0.5050, 0.4876, 0.9921),
    (0.5200, 0.4884, 0.9881),
    (0.5348, 0.4893, 0.9838),
    (0.5494, 0.4902, 0.9795),
    (0.5638, 0.4913, 0.9749),
    (0.5793, 0.4880, 0.9977),
    (0.5940, 0.4891, 0.9923),
    (0.6085, 0.4903, 0.9868),
    (0.6230, 0.4912, 0.9831),
    (0.6370, 0.4926, 0.9774),
    (0.6553, 0.4888, 0.9961),
    (0.6695, 0.4902, 0.9895),
    (0.6834, 0.4918, 0.9828),
    (0.7033, 0.4878, 0.9987),
    (0.7172, 0.4894, 0.9913),
    (0.7309, 0.4912, 0.9837),
    (0.7521, 0.4871, 0.9969),
    (0.7656, 0.4890, 0.9887),
    (0.7797, 0.4905, 0.9824),
    (0.8021, 0.4863, 0.9930),
    (0.8152, 0.4885, 0.9839),
    (0.8382, 0.4843, 0.9926),
    (0.8617, 0.4801, 0.9999),
    (0.8746, 0.4826, 0.9896),
    (0.8985, 0.4785, 0.9951),
    (0.9229, 0.4744, 0.9993),
    (0.9352, 0.4772, 0.9879),
    (0.9598, 0.4734, 0.9903),
    (0.9865, 0.4685, 0.9936),
    (0.9982, 0.4717, 0.9811),
    (0.9960, 0.4821, 0.9568),
    (0.9928, 0.4927, 0.9338),
    (0.9886, 0.5035, 0.9122),
    (0.9978, 0.5074, 0.9021),
    (0.9921, 0.5184, 0.8826),
    (0.9857, 0.5296, 0.8645),
    (0.9933, 0.5338, 0.8561),
    (0.9856, 0.5452, 0.8400),
    (0.9944, 0.5487, 0.8335),
    (0.9855, 0.5603, 0.8194),
    (0.9915, 0.5649, 0.8127),
    (0.9972, 0.5697, 0.8062),
    (0.9869, 0.5813, 0.7949),
    (0.9920, 0.5862, 0.7893),
    (0.9967, 0.5912, 0.7839),
    (0.9853, 0.6029, 0.7753),
    (0.9895, 0.6080, 0.7708),
    (0.9933, 0.6131, 0.7665),
    (0.9990, 0.6175, 0.7627),
    (0.9865, 0.6292, 0.7571),
    (0.9897, 0.6344, 0.7539),
    (0.9927, 0.6398, 0.7508),
    (0.9954, 0.6451, 0.7479),
    (0.9979, 0.6506, 0.7453),
    (0.9846, 0.6621, 0.7434),
    (0.9868, 0.6675, 0.7416),
    (0.9888, 0.6730, 0.7399),
    (0.9906, 0.6785, 0.7385),
    (0.9922, 0.6841, 0.7373),
    (0.9957, 0.6890, 0.7360),
    (0.9970, 0.6946, 0.7352),
    (0.9981, 0.7003, 0.7346),
    (0.9991, 0.7061, 0.7342),
    (0.9999, 0.7118, 0.7340),
    (0.9984, 0.7183, 0.7347),
    (0.9989, 0.7241, 0.7350),
    (0.9993, 0.7299, 0.7356),
    (0.9995, 0.7358, 0.7364),
    (0.9996, 0.7416, 0.7374),
    (0.9996, 0.7475, 0.7386),
    (0.9995, 0.7533, 0.7401),
    (0.9993, 0.7592, 0.7418),
    (0.9989, 0.7651, 0.7437),
    (0.9985, 0.7710, 0.7458),
    (0.9980, 0.7769, 0.7482),
    (0.9996, 0.7821, 0.7497),
    (0.9989, 0.7880, 0.7524),
    (0.9982, 0.7939, 0.7554),
    (0.9995, 0.7991, 0.7574),
    (0.9987, 0.8050, 0.7607),
    (0.9999, 0.8103, 0.7630),
    (0.9990, 0.8161, 0.7668),
    (0.9980, 0.8220, 0.7707),
    (0.9971, 0.8278, 0.7749),
    (0.9961, 0.8336, 0.7792),
    (0.9951, 0.8393, 0.7838),
    (0.9941, 0.8451, 0.7885),
    (0.9931, 0.8508, 0.7935),
    (0.9992, 0.8546, 0.7928),
    (1.0000, 0.8598, 0.7965),
    (0.9987, 0.8655, 0.8020),
    (0.9975, 0.8712, 0.8078),
    (0.9962, 0.8769, 0.8137),
    (0.9951, 0.8825, 0.8198),
    (0.9993, 0.8867, 0.8209),
    (0.9979, 0.8924, 0.8275),
    (0.9966, 0.8979, 0.8343),
    (0.9998, 0.9024, 0.8365),
    # (0.9984, 0.9080, 0.8438),
    # (0.9990, 0.9130, 0.8490),
    # (0.9978, 0.9184, 0.8566),
    # (1.0000, 0.9231, 0.8603),
    # (0.9986, 0.9285, 0.8684),
    # (0.9975, 0.9338, 0.8766),
    # (0.9990, 0.9385, 0.8816),
    # (0.9978, 0.9438, 0.8904),
    # (0.9989, 0.9485, 0.8964),
    # (0.9996, 0.9533, 0.9030),
    # (0.9988, 0.9583, 0.9120),
    # (0.9995, 0.9631, 0.9193),
    # (1.0000, 0.9678, 0.9271),
    # (0.9992, 0.9727, 0.9373),
    # (0.9995, 0.9773, 0.9461),
    # (0.9997, 0.9820, 0.9556),
    # (0.9998, 0.9865, 0.9657),
    # (0.9998, 0.9910, 0.9764),
    # (0.9998, 0.9954, 0.9876),
    # (0.9998, 0.9998, 0.9998),
    # (1.0000, 1.0000, 1.0000),
]

ypl_cmap = ListedColormap(ypl_cmap_data, name="ypl_cmap")
# Register the colormap with matplotlib
plt.colormaps.register(ypl_cmap)
