# Introduction

## What are yield calculators?

Yield calculators are complex mission simulators and exposure time
calculators (ETCs) that are designed to determine the expected number (the
"yield") of exoplanets for a given set of input mission, instrument, and
astrophysical parameters. Currently, there are two main yield codes in use,
[The Altruistic Yield Optimizer](https://ui.adsabs.harvard.edu/abs/2014ApJ...795..122S/abstract) (AYO)
and [EXOSIMS](https://ui.adsabs.harvard.edu/abs/2016SPIE.9911E..19D/abstract).

## yieldplotlib

`yieldplotlib` is a yield code visualization library, allowing for easy
comparisons between EXOSIMS and AYO. It was developed by the Visualizations
Task Group of the Exoplanet Science Yields Working Group (ESYWG), which was
formed before the start of the Habitable Worlds Observatory (HWO) Project
Office. It is designed to be able to compare the inputs and outputs of
differing yield codes like EXOSIMS and AYO to identify discrepancies,
differences of assumptions/inputs, and ultimately produce publication quality
plots for one or both of these yield codes with easy extensibility to add new
codes in the future.

This package is also a part of a broader cross-calibration effort that
started with an exposure time calculation comparison done as part of the
ESYWG that focused on the underlying ETCs of these codes ([Stark et.
al. 2025](https://ui.adsabs.harvard.edu/abs/2025arXiv250218556S/abstract)).
While that study was incredibly illuminating, it became clear that a tool to
perform higher fidelity comparisons beyond just ETCs was needed.

## Required Inputs

`yieldplotlib` can generate visualizations for three different types of inputs.
The first two are folders containing the outputs of a
singular AYO or EXOSIMS run (see the tutorials/sample_data directory for
examples). Alternatively, `yieldplotlib` can also ingest "yield input
packages" (YIPs) which are folders containing coronagraph performance metrics,
generated by coronagraph designers, and packaged by the Coronagraph Design
Survey (CDS) Pipeline which is to be made publicly available soon. These
packages are used as critical inputs to EXOSIMS and AYO and so visualizing
their contents can also be enlightening for understanding final differences
in yields.

## Issues with the code

If you encounter any problems while using the code, please make an issue on the
[yieldplotlib](https://github.com/HWO-Yield-Visualizations/yieldplotlib) repository.
