# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError as core_api_error_ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..types.api_error import ApiError as types_api_error_ApiError
from ..types.fact_rating_instruction import FactRatingInstruction
from ..types.fact_response import FactResponse
from ..types.memory import Memory
from ..types.message import Message
from ..types.message_list_response import MessageListResponse
from ..types.search_scope import SearchScope
from ..types.search_type import SearchType
from ..types.session import Session
from ..types.session_list_response import SessionListResponse
from ..types.session_search_response import SessionSearchResponse
from ..types.success_response import SuccessResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MemoryClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_fact(self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None) -> FactResponse:
        """
        get fact by uuid

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactResponse
            The fact with the specified UUID.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_fact(
            fact_uuid="factUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FactResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete_fact(self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        delete a fact

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Deleted

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.delete_fact(
            fact_uuid="factUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add_session(
        self,
        *,
        session_id: str,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Create New Session

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            The metadata associated with the session.

        user_id : typing.Optional[str]
            The unique identifier of the user associated with the session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The added session.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.add_session(
            session_id="session_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "fact_rating_instruction": fact_rating_instruction,
                "metadata": metadata,
                "session_id": session_id,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def list_sessions(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        order_by: typing.Optional[str] = None,
        asc: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionListResponse:
        """
        Get all sessions with optional page number, page size, order by field and order direction for pagination.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of sessions to retrieve per page

        order_by : typing.Optional[str]
            Field to order the results by: created_at, updated_at, user_id, session_id

        asc : typing.Optional[bool]
            Order direction: true for ascending, false for descending

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionListResponse
            List of sessions

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.list_sessions()
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions-ordered",
            method="GET",
            params={"page_number": page_number, "page_size": page_size, "order_by": order_by, "asc": asc},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SessionListResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def search_sessions(
        self,
        *,
        limit: typing.Optional[int] = None,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        record_filter: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        session_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        text: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionSearchResponse:
        """
        Search sessions for the specified query.

        Parameters
        ----------
        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        min_fact_rating : typing.Optional[float]
            The minimum fact rating to filter on. Only supported on cloud. Will be ignored on Community Edition.

        min_score : typing.Optional[float]
            The minimum score for search results. Only supported on cloud. Will be ignored on Community Edition.

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm. Only supported on cloud. Will be ignored on Community Edition.

        record_filter : typing.Optional[typing.Dict[str, typing.Any]]
            Record filter on the metadata. Only supported on cloud. Will be ignored on Community Edition.

        search_scope : typing.Optional[SearchScope]
            Search scope. Only supported on cloud. On Community Edition the search scope is always "facts".

        search_type : typing.Optional[SearchType]
            Search type. Only supported on cloud. Will be ignored on Community Edition.

        session_ids : typing.Optional[typing.Sequence[str]]
            the session ids to search

        text : typing.Optional[str]
            The search text.

        user_id : typing.Optional[str]
            User ID used to determine which sessions to search. Required on Community Edition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionSearchResponse
            A SessionSearchResponse object representing the search results.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.search_sessions()
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions/search",
            method="POST",
            params={"limit": limit},
            json={
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "record_filter": record_filter,
                "search_scope": search_scope,
                "search_type": search_type,
                "session_ids": session_ids,
                "text": text,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SessionSearchResponse, _response.json())  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Session:
        """
        get session by id

        Parameters
        ----------
        session_id : str
            Session ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The session with the specified ID.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def update_session(
        self,
        session_id: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Update Session Metadata

        Parameters
        ----------
        session_id : str
            Session ID

        metadata : typing.Dict[str, typing.Any]
            The metadata to update

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.
            Fact rating instructions can not be unset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The updated session.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.update_session(
            session_id="sessionId",
            metadata={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}",
            method="PATCH",
            json={"fact_rating_instruction": fact_rating_instruction, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 409:
            raise ConflictError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self,
        session_id: str,
        *,
        lastn: typing.Optional[int] = None,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Memory:
        """
        Returns a memory (latest summary, list of messages and facts) for a given session

        Parameters
        ----------
        session_id : str
            The ID of the session for which to retrieve memory.

        lastn : typing.Optional[int]
            The number of most recent memory entries to retrieve.

        min_rating : typing.Optional[float]
            The minimum rating by which to filter facts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Memory
            OK

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="GET",
            params={"lastn": lastn, "minRating": min_rating},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Memory, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add(
        self,
        session_id: str,
        *,
        messages: typing.Sequence[Message],
        fact_instruction: typing.Optional[str] = OMIT,
        summary_instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Add memory to the specified session.

        Parameters
        ----------
        session_id : str
            The ID of the session to which memory should be added.

        messages : typing.Sequence[Message]
            A list of message objects, where each message contains a role and content.

        fact_instruction : typing.Optional[str]
            Additional instruction for generating the facts.

        summary_instruction : typing.Optional[str]
            Additional instruction for generating the summary.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_python import Message
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.add(
            session_id="sessionId",
            messages=[Message()],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="POST",
            json={
                "fact_instruction": fact_instruction,
                "messages": messages,
                "summary_instruction": summary_instruction,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        delete memory messages by session id

        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.delete(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session_messages(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageListResponse:
        """
        Lists messages for a session, specified by limit and cursor.

        Parameters
        ----------
        session_id : str
            Session ID

        limit : typing.Optional[int]
            Limit the number of results returned

        cursor : typing.Optional[int]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageListResponse
            OK

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session_messages(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages",
            method="GET",
            params={"limit": limit, "cursor": cursor},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(MessageListResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session_message(
        self, session_id: str, message_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Gets a specific message from a session

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The message.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session_message(
            session_id="sessionId",
            message_uuid="messageUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="GET",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def update_message_metadata(
        self,
        session_id: str,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates the metadata of a message.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Any]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        from zep_python.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.update_message_metadata(
            session_id="sessionId",
            message_uuid="messageUUID",
            metadata={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="PATCH",
            json={"metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)


class AsyncMemoryClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_fact(
        self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FactResponse:
        """
        get fact by uuid

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactResponse
            The fact with the specified UUID.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.get_fact(
            fact_uuid="factUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FactResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_fact(self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        delete a fact

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Deleted

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.delete_fact(
            fact_uuid="factUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(str, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add_session(
        self,
        *,
        session_id: str,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Create New Session

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            The metadata associated with the session.

        user_id : typing.Optional[str]
            The unique identifier of the user associated with the session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The added session.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.add_session(
            session_id="session_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "fact_rating_instruction": fact_rating_instruction,
                "metadata": metadata,
                "session_id": session_id,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def list_sessions(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        order_by: typing.Optional[str] = None,
        asc: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionListResponse:
        """
        Get all sessions with optional page number, page size, order by field and order direction for pagination.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of sessions to retrieve per page

        order_by : typing.Optional[str]
            Field to order the results by: created_at, updated_at, user_id, session_id

        asc : typing.Optional[bool]
            Order direction: true for ascending, false for descending

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionListResponse
            List of sessions

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.list_sessions()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions-ordered",
            method="GET",
            params={"page_number": page_number, "page_size": page_size, "order_by": order_by, "asc": asc},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SessionListResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def search_sessions(
        self,
        *,
        limit: typing.Optional[int] = None,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        record_filter: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        session_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        text: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionSearchResponse:
        """
        Search sessions for the specified query.

        Parameters
        ----------
        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        min_fact_rating : typing.Optional[float]
            The minimum fact rating to filter on. Only supported on cloud. Will be ignored on Community Edition.

        min_score : typing.Optional[float]
            The minimum score for search results. Only supported on cloud. Will be ignored on Community Edition.

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm. Only supported on cloud. Will be ignored on Community Edition.

        record_filter : typing.Optional[typing.Dict[str, typing.Any]]
            Record filter on the metadata. Only supported on cloud. Will be ignored on Community Edition.

        search_scope : typing.Optional[SearchScope]
            Search scope. Only supported on cloud. On Community Edition the search scope is always "facts".

        search_type : typing.Optional[SearchType]
            Search type. Only supported on cloud. Will be ignored on Community Edition.

        session_ids : typing.Optional[typing.Sequence[str]]
            the session ids to search

        text : typing.Optional[str]
            The search text.

        user_id : typing.Optional[str]
            User ID used to determine which sessions to search. Required on Community Edition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionSearchResponse
            A SessionSearchResponse object representing the search results.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.search_sessions()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions/search",
            method="POST",
            params={"limit": limit},
            json={
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "record_filter": record_filter,
                "search_scope": search_scope,
                "search_type": search_type,
                "session_ids": session_ids,
                "text": text,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SessionSearchResponse, _response.json())  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Session:
        """
        get session by id

        Parameters
        ----------
        session_id : str
            Session ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The session with the specified ID.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.get_session(
            session_id="sessionId",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def update_session(
        self,
        session_id: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Update Session Metadata

        Parameters
        ----------
        session_id : str
            Session ID

        metadata : typing.Dict[str, typing.Any]
            The metadata to update

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.
            Fact rating instructions can not be unset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The updated session.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.update_session(
            session_id="sessionId",
            metadata={"key": "value"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}",
            method="PATCH",
            json={"fact_rating_instruction": fact_rating_instruction, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 409:
            raise ConflictError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self,
        session_id: str,
        *,
        lastn: typing.Optional[int] = None,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Memory:
        """
        Returns a memory (latest summary, list of messages and facts) for a given session

        Parameters
        ----------
        session_id : str
            The ID of the session for which to retrieve memory.

        lastn : typing.Optional[int]
            The number of most recent memory entries to retrieve.

        min_rating : typing.Optional[float]
            The minimum rating by which to filter facts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Memory
            OK

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.get(
            session_id="sessionId",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="GET",
            params={"lastn": lastn, "minRating": min_rating},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Memory, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add(
        self,
        session_id: str,
        *,
        messages: typing.Sequence[Message],
        fact_instruction: typing.Optional[str] = OMIT,
        summary_instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Add memory to the specified session.

        Parameters
        ----------
        session_id : str
            The ID of the session to which memory should be added.

        messages : typing.Sequence[Message]
            A list of message objects, where each message contains a role and content.

        fact_instruction : typing.Optional[str]
            Additional instruction for generating the facts.

        summary_instruction : typing.Optional[str]
            Additional instruction for generating the summary.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_python import Message
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.add(
            session_id="sessionId",
            messages=[Message()],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="POST",
            json={
                "fact_instruction": fact_instruction,
                "messages": messages,
                "summary_instruction": summary_instruction,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        delete memory messages by session id

        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.delete(
            session_id="sessionId",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session_messages(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageListResponse:
        """
        Lists messages for a session, specified by limit and cursor.

        Parameters
        ----------
        session_id : str
            Session ID

        limit : typing.Optional[int]
            Limit the number of results returned

        cursor : typing.Optional[int]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageListResponse
            OK

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.get_session_messages(
            session_id="sessionId",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages",
            method="GET",
            params={"limit": limit, "cursor": cursor},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(MessageListResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session_message(
        self, session_id: str, message_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Gets a specific message from a session

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The message.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.get_session_message(
            session_id="sessionId",
            message_uuid="messageUUID",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="GET",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def update_message_metadata(
        self,
        session_id: str,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates the metadata of a message.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Any]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        from zep_python.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )
        await client.memory.update_message_metadata(
            session_id="sessionId",
            message_uuid="messageUUID",
            metadata={"key": "value"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="PATCH",
            json={"metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(
                pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)
