from zig_codeblocks.styling import Color, Style, Theme

KEYWORDS = frozenset(
    {
        "addrspace",
        "align",
        "allowzero",
        "and",
        "anyframe",
        "anytype",
        "asm",
        "async",
        "await",
        "break",
        "callconv",
        "catch",
        "comptime",
        "const",
        "continue",
        "defer",
        "else",
        "enum",
        "errdefer",
        "error",
        "export",
        "extern",
        "fn",
        "for",
        "if",
        "inline",
        "linksection",
        "noalias",
        "noinline",
        "nosuspend",
        "opaque",
        "or",
        "orelse",
        "packed",
        "pub",
        "resume",
        "return",
        "struct",
        "suspend",
        "switch",
        "test",
        "threadlocal",
        "try",
        "union",
        "unreachable",
        "usingnamespace",
        "var",
        "volatile",
        "while",
    }
)
IDENTIFIERS = frozenset({"identifier", "c"})
NUMERIC_LITERALS = frozenset({"integer", "float"})
PRIMITIVE_VALUES = frozenset({"true", "false", "null", "undefined"})
TYPES = frozenset(
    {
        "anyerror",
        "anyopaque",
        "bool",
        "builtin_type",
        "c_char",
        "c_int",
        "c_long",
        "c_longdouble",
        "c_longlong",
        "c_short",
        "c_uint",
        "c_ulong",
        "c_ulonglong",
        "c_ushort",
        "comptime_float",
        "comptime_int",
        "f128",
        "f16",
        "f32",
        "f64",
        "f80",
        "isize",
        "noreturn",
        "type",
        "usize",
        "void",
    }
)
STRINGLIKE = frozenset(
    {"string_content", "multiline_string", '"', "'", "character_content"}
)

DEFAULT_THEME = Theme(
    builtin_identifiers=Style(Color.BLUE, bold=True),
    calls=Style(Color.BLUE),
    comments=Style(Color.GRAY),
    keywords=Style(Color.MAGENTA),
    numeric=Style(Color.CYAN),
    primitive_values=Style(Color.CYAN),
    strings=Style(Color.GREEN),
    types=Style(Color.ORANGE),
)
