try:
	from zohosdk.src.com.zoho.exception import SDKException
	from zohosdk.src.com.zoho.util import StreamWrapper, Constants
except Exception:
	from ...exception import SDKException
	from ...util import StreamWrapper, Constants


class WatermarkParameters(object):
	def __init__(self):
		"""Creates an instance of WatermarkParameters"""

		self.__url = None
		self.__document = None
		self.__watermark_settings = None
		self.__key_modified = dict()

	def get_url(self):
		"""
		The method to get the url

		Returns:
			string: A string representing the url
		"""

		return self.__url

	def set_url(self, url):
		"""
		The method to set the value to url

		Parameters:
			url (string) : A string representing the url
		"""

		if url is not None and not isinstance(url, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: url EXPECTED TYPE: str', None, None)
		
		self.__url = url
		self.__key_modified['url'] = 1

	def get_document(self):
		"""
		The method to get the document

		Returns:
			StreamWrapper: An instance of StreamWrapper
		"""

		return self.__document

	def set_document(self, document):
		"""
		The method to set the value to document

		Parameters:
			document (StreamWrapper) : An instance of StreamWrapper
		"""

		if document is not None and not isinstance(document, StreamWrapper):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: document EXPECTED TYPE: StreamWrapper', None, None)
		
		self.__document = document
		self.__key_modified['document'] = 1

	def get_watermark_settings(self):
		"""
		The method to get the watermark_settings

		Returns:
			WatermarkSettings: An instance of WatermarkSettings
		"""

		return self.__watermark_settings

	def set_watermark_settings(self, watermark_settings):
		"""
		The method to set the value to watermark_settings

		Parameters:
			watermark_settings (WatermarkSettings) : An instance of WatermarkSettings
		"""

		try:
			from zohosdk.src.com.zoho.officeintegrator.v1.watermark_settings import WatermarkSettings
		except Exception:
			from .watermark_settings import WatermarkSettings

		if watermark_settings is not None and not isinstance(watermark_settings, WatermarkSettings):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: watermark_settings EXPECTED TYPE: WatermarkSettings', None, None)
		
		self.__watermark_settings = watermark_settings
		self.__key_modified['watermark_settings'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string representing the key

		Returns:
			int: An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string representing the key
			modification (int) : An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if modification is not None and not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
