"""
Copyright (c) 2023, Zscaler Inc.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
"""

from zscaler.oneapi_object import ZscalerObject
from zscaler.oneapi_collection import ZscalerCollection
from zscaler.zia.models import common
from zscaler.zia.models import rule_labels as labels


class CasbMalwareRules(ZscalerObject):
    """
    A class for CasbMalwareRules objects.
    """

    def __init__(self, config=None):
        """
        Initialize the CasbMalwareRules model based on API response.

        Args:
            config (dict): A dictionary representing the configuration.
        """
        super().__init__(config)

        if config:
            self.type = config["type"] \
                if "type" in config else None
            self.id = config["id"] \
                if "id" in config else None
            self.order = config["order"] \
                if "order" in config else None
            self.name = config["name"] \
                if "name" in config else None
            self.state = config["state"] \
                if "state" in config else None
            self.action = config["action"] \
                if "action" in config else None
            self.quarantine_location = config["quarantineLocation"] \
                if "quarantineLocation" in config else None
            self.scan_inbound_email_link = config["scanInboundEmailLink"] \
                if "scanInboundEmailLink" in config else None
            self.last_modified_time = config["lastModifiedTime"] \
                if "lastModifiedTime" in config else None
            self.access_control = config["accessControl"] \
                if "accessControl" in config else None

            self.buckets = ZscalerCollection.form_list(
                config["buckets"] if "buckets" in config else [], common.CommonIDName
            )
            self.cloud_app_tenants = ZscalerCollection.form_list(
                config["cloudAppTenants"] if "cloudAppTenants" in config else [], common.CommonIDName
            )
            self.labels = ZscalerCollection.form_list(
                config["labels"] if "labels" in config else [], labels.RuleLabels
            )

            if "lastModifiedBy" in config:
                if isinstance(config["lastModifiedBy"], common.CommonBlocks):
                    self.last_modified_by = config["lastModifiedBy"]
                elif config["lastModifiedBy"] is not None:
                    self.last_modified_by = common.CommonBlocks(config["lastModifiedBy"])
                else:
                    self.last_modified_by = None
            else:
                self.last_modified_by = None

            if "casbEmailLabel" in config:
                if isinstance(config["casbEmailLabel"], common.CommonBlocks):
                    self.casb_email_label = config["casbEmailLabel"]
                elif config["casbEmailLabel"] is not None:
                    self.casb_email_label = common.CommonBlocks(config["casbEmailLabel"])
                else:
                    self.casb_email_label = None
            else:
                self.casb_email_label = None

            if "casbTombstoneTemplate" in config:
                if isinstance(config["casbTombstoneTemplate"], common.CommonBlocks):
                    self.casb_tombstone_template = config["casbTombstoneTemplate"]
                elif config["casbTombstoneTemplate"] is not None:
                    self.casb_tombstone_template = common.CommonBlocks(config["casbTombstoneTemplate"])
                else:
                    self.casb_tombstone_template = None
            else:
                self.casb_tombstone_template = None
        else:
            self.type = None
            self.id = None
            self.order = None
            self.name = None
            self.cloud_app_tenants = []
            self.state = None
            self.action = None
            self.quarantine_location = None
            self.scan_inbound_email_link = None
            self.last_modified_time = None
            self.last_modified_by = None
            self.access_control = None
            self.casb_email_label = None
            self.buckets = []
            self.labels = []
            self.casb_tombstone_template = None

    def request_format(self):
        """
        Return the object as a dictionary in the format expected for API requests.
        """
        parent_req_format = super().request_format()
        current_obj_format = {
            "type": self.type,
            "id": self.id,
            "order": self.order,
            "name": self.name,
            "cloudAppTenants": self.cloud_app_tenants,
            "state": self.state,
            "action": self.action,
            "quarantineLocation": self.quarantine_location,
            "scanInboundEmailLink": self.scan_inbound_email_link,
            "lastModifiedTime": self.last_modified_time,
            "lastModifiedBy": self.last_modified_by,
            "accessControl": self.access_control,
            "casbEmailLabel": self.casb_email_label,
            "buckets": self.buckets,
            "labels": self.labels,
            "casbTombstoneTemplate": self.casb_tombstone_template
        }
        parent_req_format.update(current_obj_format)
        return parent_req_format
